/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.common.geometry;

import com.google.appengine.repackaged.com.google.common.annotations.GwtCompatible;
import com.google.appengine.repackaged.com.google.common.annotations.VisibleForTesting;
import com.google.appengine.repackaged.com.google.common.base.Objects;
import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.repackaged.com.google.common.base.Predicate;
import com.google.appengine.repackaged.com.google.common.collect.HashMultiset;
import com.google.appengine.repackaged.com.google.common.collect.Iterables;
import com.google.appengine.repackaged.com.google.common.collect.Lists;
import com.google.appengine.repackaged.com.google.common.geometry.LittleEndianInput;
import com.google.appengine.repackaged.com.google.common.geometry.LittleEndianOutput;
import com.google.appengine.repackaged.com.google.common.geometry.Matrix3x3;
import com.google.appengine.repackaged.com.google.common.geometry.R1Interval;
import com.google.appengine.repackaged.com.google.common.geometry.R2Rect;
import com.google.appengine.repackaged.com.google.common.geometry.R2Vector;
import com.google.appengine.repackaged.com.google.common.geometry.S1Angle;
import com.google.appengine.repackaged.com.google.common.geometry.S1Interval;
import com.google.appengine.repackaged.com.google.common.geometry.S2;
import com.google.appengine.repackaged.com.google.common.geometry.S2AreaCentroid;
import com.google.appengine.repackaged.com.google.common.geometry.S2Cap;
import com.google.appengine.repackaged.com.google.common.geometry.S2Cell;
import com.google.appengine.repackaged.com.google.common.geometry.S2CellId;
import com.google.appengine.repackaged.com.google.common.geometry.S2EdgeQuery;
import com.google.appengine.repackaged.com.google.common.geometry.S2EdgeUtil;
import com.google.appengine.repackaged.com.google.common.geometry.S2Error;
import com.google.appengine.repackaged.com.google.common.geometry.S2Iterator;
import com.google.appengine.repackaged.com.google.common.geometry.S2LatLngRect;
import com.google.appengine.repackaged.com.google.common.geometry.S2PaddedCell;
import com.google.appengine.repackaged.com.google.common.geometry.S2Point;
import com.google.appengine.repackaged.com.google.common.geometry.S2PointCompression;
import com.google.appengine.repackaged.com.google.common.geometry.S2Polyline;
import com.google.appengine.repackaged.com.google.common.geometry.S2Predicates;
import com.google.appengine.repackaged.com.google.common.geometry.S2Region;
import com.google.appengine.repackaged.com.google.common.geometry.S2Shape;
import com.google.appengine.repackaged.com.google.common.geometry.S2ShapeIndex;
import com.google.appengine.repackaged.com.google.common.geometry.S2ShapeUtil;
import com.google.appengine.repackaged.com.google.common.primitives.UnsignedLongs;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;

@GwtCompatible(serializable=true)
public strictfp final class S2Loop
implements S2Region,
Comparable<S2Loop>,
Serializable,
S2Shape {
    @VisibleForTesting
    static final byte LOSSLESS_ENCODING_VERSION = 1;
    public static final double MAX_INTERSECTION_ERROR = 1.0E-15;
    static final S2Point EMPTY_VERTEX = S2Point.Z_POS;
    static final S2Point FULL_VERTEX = S2Point.Z_NEG;
    @VisibleForTesting
    transient S2ShapeIndex index;
    private final AtomicInteger unindexedContainsCalls = new AtomicInteger();
    private final S2Point[] vertices;
    private final int numVertices;
    private S2LatLngRect bound;
    private S2LatLngRect subregionBound;
    private boolean originInside;
    private int depth;

    public S2Loop(List<S2Point> vertices) {
        this.initIndex();
        this.numVertices = vertices.size();
        this.vertices = new S2Point[this.numVertices];
        vertices.toArray(this.vertices);
        this.depth = 0;
        this.initOriginAndBound();
    }

    public static S2Loop newLoopWithTrustedDetails(List<S2Point> vertices, boolean originInside, S2LatLngRect bound) {
        return new S2Loop(vertices, originInside, bound);
    }

    public static S2Loop makeRegularLoop(S2Point center, S1Angle radius, int numVertices) {
        return new S2Loop(S2Loop.makeRegularVertices(center, radius, numVertices));
    }

    public static List<S2Point> makeRegularVertices(S2Point center, S1Angle radius, int numVertices) {
        Matrix3x3 m = S2.getFrame(center);
        ArrayList vertices = Lists.newArrayList();
        double z = Math.cos(radius.radians());
        double r = Math.sin(radius.radians());
        double radianStep = Math.PI * 2 / (double)numVertices;
        for (int i = 0; i < numVertices; ++i) {
            double angle = (double)i * radianStep;
            S2Point p = new S2Point(r * Math.cos(angle), r * Math.sin(angle), z);
            vertices.add(S2Point.normalize(S2.fromFrame(m, p)));
        }
        return vertices;
    }

    private S2Loop(List<S2Point> vertices, boolean originInside, S2LatLngRect bound) {
        this.initIndex();
        this.numVertices = vertices.size();
        this.vertices = new S2Point[this.numVertices];
        this.bound = bound;
        this.subregionBound = S2EdgeUtil.RectBounder.expandForSubregions(bound);
        this.depth = 0;
        this.originInside = originInside;
        vertices.toArray(this.vertices);
    }

    public S2Loop(S2Cell cell) {
        this.initIndex();
        this.numVertices = 4;
        this.vertices = new S2Point[this.numVertices];
        this.depth = 0;
        for (int i = 0; i < 4; ++i) {
            this.vertices[i] = cell.getVertex(i);
        }
        this.initOriginAndBound();
    }

    public S2Loop(S2Loop src) {
        this.initIndex();
        this.numVertices = src.numVertices;
        this.vertices = new S2Point[this.numVertices];
        for (int i = 0; i < this.numVertices; ++i) {
            this.vertices[i] = src.vertices[i];
        }
        this.bound = src.getRectBound();
        this.subregionBound = src.subregionBound;
        this.originInside = src.originInside;
        this.depth = src.depth();
    }

    private void initIndex() {
        int maxUnindexedContainsCalls = this.numVertices <= 8 ? 10 : (this.numVertices <= 8192 ? 50 : (this.numVertices <= 50000 ? 10 : 2));
        this.unindexedContainsCalls.set(maxUnindexedContainsCalls);
        this.index = new S2ShapeIndex();
        this.index.add(this);
    }

    private Object readResolve() {
        this.initIndex();
        return this;
    }

    public static final S2Loop empty() {
        return new S2Loop(Collections.singletonList(EMPTY_VERTEX));
    }

    public static final S2Loop full() {
        return new S2Loop(Collections.singletonList(FULL_VERTEX));
    }

    public boolean equals(Object obj) {
        if (obj instanceof S2Loop) {
            S2Loop that = (S2Loop)obj;
            return Arrays.equals(this.vertices, that.vertices) && Objects.equal((Object)this.originInside, (Object)that.originInside) && Objects.equal((Object)this.bound, (Object)that.bound);
        }
        return false;
    }

    public int hashCode() {
        return this.bound.hashCode();
    }

    public int depth() {
        return this.depth;
    }

    public void setDepth(int depth) {
        this.depth = depth;
    }

    public boolean isHole() {
        return (this.depth & 1) != 0;
    }

    public int sign() {
        return this.isHole() ? -1 : 1;
    }

    public int numVertices() {
        return this.numVertices;
    }

    public S2Point vertex(int i) {
        try {
            return this.vertices[i >= this.vertices.length ? i - this.vertices.length : i];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new IllegalStateException("Invalid vertex index");
        }
    }

    public S2Point orientedVertex(int i) {
        if (this.isHole()) {
            i = 2 * this.numVertices() - 1 - i;
        }
        return this.vertex(i);
    }

    public boolean isEmpty() {
        return this.isEmptyOrFull() && !this.originInside;
    }

    public boolean isFull() {
        return this.isEmptyOrFull() && this.originInside;
    }

    public boolean isEmptyOrFull() {
        return this.numVertices == 1;
    }

    @Override
    public int numEdges() {
        return this.isEmptyOrFull() ? 0 : this.numVertices;
    }

    @Override
    public void getEdge(int index, S2Shape.MutableEdge result) {
        result.set(this.vertex(index), this.vertex(index + 1));
    }

    @Override
    public boolean hasInterior() {
        return !this.isEmpty();
    }

    @Override
    public boolean containsOrigin() {
        return this.originInside;
    }

    @Override
    public int compareTo(S2Loop other) {
        if (this.numVertices != other.numVertices) {
            return this.numVertices - other.numVertices;
        }
        if (this.numVertices == 0) {
            return 0;
        }
        int maxVertices = this.numVertices;
        int iThis = this.getCanonicalFirstVertex() % this.numVertices;
        int iOther = other.getCanonicalFirstVertex() % other.numVertices;
        int i = 0;
        while (i < maxVertices) {
            int compare = this.vertex(iThis).compareTo(other.vertex(iOther));
            if (compare != 0) {
                return compare;
            }
            ++i;
            ++iThis;
            ++iOther;
        }
        return 0;
    }

    private int getCanonicalFirstVertex() {
        int first = 0;
        for (int i = 1; i < this.numVertices; ++i) {
            if (this.vertex(i).compareTo(this.vertex(first)) >= 0) continue;
            first = i;
        }
        if (this.numVertices > 0 && this.vertex(first + 1).compareTo(this.vertex(first + this.numVertices - 1)) >= 0) {
            first += this.numVertices;
        }
        return first;
    }

    public boolean isNormalized() {
        if (this.bound.lng().getLength() < Math.PI) {
            return true;
        }
        return this.getTurningAngle() >= -this.getTurningAngleMaxError();
    }

    public void normalize() {
        if (!this.isNormalized()) {
            this.invert();
        }
    }

    public void invert() {
        this.initIndex();
        int last = this.numVertices - 1;
        if (this.isEmptyOrFull()) {
            this.vertices[0] = this.isFull() ? EMPTY_VERTEX : FULL_VERTEX;
        } else {
            for (int i = (last - 1) / 2; i >= 0; --i) {
                S2Point t = this.vertices[i];
                this.vertices[i] = this.vertices[last - i];
                this.vertices[last - i] = t;
            }
        }
        this.originInside ^= true;
        if (this.bound.lat().lo() > -1.5707963267948966 && this.bound.lat().hi() < 1.5707963267948966) {
            this.subregionBound = this.bound = S2LatLngRect.full();
        } else {
            this.bound = null;
            this.initBound();
        }
    }

    public double getArea() {
        if (this.isEmptyOrFull()) {
            return this.originInside ? Math.PI * 4 : 0.0;
        }
        if (this.numVertices < 3) {
            return 0.0;
        }
        AreaMeasure area = new AreaMeasure();
        this.visitSurfaceIntegral(area);
        return area.value();
    }

    public S2Point getCentroid() {
        if (this.numVertices < 3) {
            return null;
        }
        CentroidMeasure centroid = new CentroidMeasure(this);
        this.visitSurfaceIntegral(centroid);
        return centroid.value();
    }

    public S2AreaCentroid getAreaAndCentroid() {
        if (this.numVertices < 3) {
            return new S2AreaCentroid(this.getArea(), this.getCentroid());
        }
        AreaCentroidMeasure areaCentroid = new AreaCentroidMeasure();
        this.visitSurfaceIntegral(areaCentroid);
        return areaCentroid.value();
    }

    public double getTurningAngle() {
        if (this.isEmptyOrFull()) {
            return this.originInside ? Math.PI * -2 : Math.PI * 2;
        }
        if (this.numVertices < 3) {
            return 0.0;
        }
        int n = this.numVertices();
        int i = this.getCanonicalFirstVertex();
        int dir = i < this.numVertices ? 1 : -1;
        double sum = S2.turnAngle(this.vertex((i + n - dir) % n), this.vertex(i), this.vertex((i + dir) % n));
        double compensation = 0.0;
        while (--n > 0) {
            double angle = S2.turnAngle(this.vertex((i += dir) - dir), this.vertex(i), this.vertex(i + dir));
            double oldSum = sum;
            compensation = oldSum - (sum += (angle += compensation)) + angle;
        }
        return (double)dir * (sum + compensation);
    }

    public double getTurningAngleMaxError() {
        double maxErrorPerVertex = 9.73 * S2.DBL_EPSILON;
        return maxErrorPerVertex * (double)this.numVertices;
    }

    public boolean contains(S2Loop b) {
        if (!this.subregionBound.contains(b.bound)) {
            return false;
        }
        if (this.isEmptyOrFull() || b.isEmptyOrFull()) {
            return this.isFull() || b.isEmpty();
        }
        ContainsRelation relation = new ContainsRelation();
        if (S2Loop.hasCrossingRelation(this, b, relation)) {
            return false;
        }
        if (relation.foundSharedVertex()) {
            return true;
        }
        if (!this.contains(b.vertex(0))) {
            return false;
        }
        return !b.subregionBound.contains(this.bound) && !b.bound.union(this.bound).isFull() || !b.contains(this.vertex(0));
    }

    public boolean intersects(S2Loop b) {
        if (!this.bound.intersects(b.bound)) {
            return false;
        }
        IntersectsRelation relation = new IntersectsRelation();
        if (S2Loop.hasCrossingRelation(this, b, relation)) {
            return true;
        }
        if (relation.foundSharedVertex()) {
            return false;
        }
        if ((this.subregionBound.contains(b.bound) || this.bound.union(b.bound).isFull()) && this.contains(b.vertex(0))) {
            return true;
        }
        return b.subregionBound.contains(this.bound) && b.contains(this.vertex(0));
    }

    private static boolean wedgeContainsSemiwedge(S2Point a0, S2Point ab1, S2Point a2, S2Point b2, boolean bReversed) {
        boolean b2EqualsA0 = b2.equalsPoint(a0);
        if (b2EqualsA0 || b2.equalsPoint(a2)) {
            return b2EqualsA0 == bReversed;
        }
        return S2Predicates.orderedCCW(a0, a2, b2, ab1);
    }

    public boolean containsNested(S2Loop b) {
        if (!this.subregionBound.contains(b.bound)) {
            return false;
        }
        if (this.isEmptyOrFull() || b.numVertices() < 2) {
            return this.isFull() || b.isEmpty();
        }
        int m = this.findVertex(b.vertex(1));
        if (m < 0) {
            return this.contains(b.vertex(1));
        }
        return new S2EdgeUtil.WedgeContains().test(this.vertex(m - 1), this.vertex(m), this.vertex(m + 1), b.vertex(0), b.vertex(2)) > 0;
    }

    public int compareBoundary(S2Loop b) {
        Preconditions.checkArgument((!this.isEmpty() && !b.isEmpty() ? 1 : 0) != 0);
        Preconditions.checkArgument((!b.isFull() || !b.isHole() ? 1 : 0) != 0);
        if (!this.bound.intersects(b.bound)) {
            return -1;
        }
        if (this.isFull()) {
            return 1;
        }
        if (b.isFull()) {
            return -1;
        }
        CompareBoundaryRelation relation = new CompareBoundaryRelation(b.isHole());
        if (S2Loop.hasCrossingRelation(this, b, relation)) {
            return 0;
        }
        if (relation.foundSharedVertex()) {
            return relation.containsEdge() ? 1 : -1;
        }
        return this.contains(b.vertex(0)) ? 1 : -1;
    }

    public boolean containsNonCrossingBoundary(S2Loop b, boolean bReverse) {
        assert (!this.isEmpty() && !b.isEmpty());
        assert (!b.isFull() || !bReverse);
        if (!this.bound.intersects(b.bound)) {
            return false;
        }
        if (this.isFull()) {
            return true;
        }
        if (b.isFull()) {
            return false;
        }
        int m = this.findVertex(b.vertex(0));
        if (m < 0) {
            return this.contains(b.vertex(0));
        }
        return S2Loop.wedgeContainsSemiwedge(this.vertex(m - 1), this.vertex(m), this.vertex(m + 1), b.vertex(1), bReverse);
    }

    boolean boundaryEquals(S2Loop b) {
        if (this.numVertices != b.numVertices) {
            return false;
        }
        if (this.isEmptyOrFull()) {
            return this.isEmpty() == b.isEmpty();
        }
        for (int offset = 0; offset < this.numVertices; ++offset) {
            if (!this.vertex(offset).equalsPoint(b.vertex(0))) continue;
            for (int i = 0; i < this.numVertices; ++i) {
                if (this.vertex(i + offset).equalsPoint(b.vertex(i))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    boolean boundaryApproxEquals(S2Loop b, double maxError) {
        S2Loop a = this;
        if (a.numVertices != b.numVertices) {
            return false;
        }
        if (this.isEmptyOrFull()) {
            return this.isEmpty() == b.isEmpty();
        }
        for (int offset = 0; offset < a.numVertices; ++offset) {
            if (!S2.approxEquals(a.vertex(offset), b.vertex(0), maxError)) continue;
            boolean success = true;
            for (int i = 0; i < a.numVertices; ++i) {
                if (S2.approxEquals(a.vertex(i + offset), b.vertex(i), maxError)) continue;
                success = false;
                break;
            }
            if (!success) continue;
            return true;
        }
        return false;
    }

    boolean boundaryApproxEquals(S2Loop loop) {
        return this.boundaryApproxEquals(loop, 1.0E-15);
    }

    boolean matchBoundaries(S2Loop b, int aOffset, double maxError) {
        S2Loop a = this;
        ArrayList pending = Lists.newArrayList();
        HashMultiset done = HashMultiset.create();
        pending.add(new LoopOffsets(0, 0));
        while (!pending.isEmpty()) {
            LoopOffsets last = (LoopOffsets)pending.remove(pending.size() - 1);
            int i = last.first;
            int j = last.second;
            if (i == a.numVertices && j == b.numVertices) {
                return true;
            }
            done.add((Object)new LoopOffsets(i, j));
            int io = i + aOffset;
            if (io >= a.numVertices) {
                io -= a.numVertices;
            }
            if (i < a.numVertices && done.count((Object)new LoopOffsets(i + 1, j)) == 0 && S2EdgeUtil.getDistance(a.vertex(io + 1), b.vertex(j), b.vertex(j + 1)).radians() <= maxError) {
                pending.add(new LoopOffsets(i + 1, j));
            }
            if (j >= b.numVertices || done.count((Object)new LoopOffsets(i, j + 1)) != 0 || !(S2EdgeUtil.getDistance(b.vertex(j + 1), a.vertex(io), a.vertex(io + 1)).radians() <= maxError)) continue;
            pending.add(new LoopOffsets(i, j + 1));
        }
        return false;
    }

    boolean boundaryNear(S2Loop b, double maxError) {
        if (this.isEmptyOrFull() || b.isEmptyOrFull()) {
            return this.isEmpty() && b.isEmpty() || this.isFull() && b.isFull();
        }
        for (int aOffset = 0; aOffset < this.numVertices; ++aOffset) {
            if (!this.matchBoundaries(b, aOffset, maxError)) continue;
            return true;
        }
        return false;
    }

    boolean boundaryNear(S2Loop loop) {
        return this.boundaryNear(loop, 1.0E-15);
    }

    @Override
    public S2Cap getCapBound() {
        return this.bound.getCapBound();
    }

    @Override
    public S2LatLngRect getRectBound() {
        return this.bound;
    }

    public S2LatLngRect getSubregionBound() {
        return this.subregionBound;
    }

    @Override
    public boolean contains(S2Cell target) {
        S2Iterator<S2ShapeIndex.Cell> it = this.index.iterator();
        S2ShapeIndex.CellRelation relation = it.locate(target.id());
        if (relation != S2ShapeIndex.CellRelation.INDEXED) {
            return false;
        }
        if (this.boundaryApproxIntersects(it, target)) {
            return false;
        }
        return this.contains(it, target.getCenter());
    }

    @Override
    public boolean mayIntersect(S2Cell target) {
        S2Iterator<S2ShapeIndex.Cell> it = this.index.iterator();
        S2ShapeIndex.CellRelation relation = it.locate(target.id());
        if (relation == S2ShapeIndex.CellRelation.DISJOINT) {
            return false;
        }
        if (relation == S2ShapeIndex.CellRelation.SUBDIVIDED) {
            return true;
        }
        if (it.compareTo(target.id()) == 0) {
            return true;
        }
        if (this.boundaryApproxIntersects(it, target)) {
            return true;
        }
        return this.contains(it, target.getCenter());
    }

    private boolean boundaryApproxIntersects(S2Iterator<S2ShapeIndex.Cell> it, S2Cell target) {
        S2ShapeIndex.S2ClippedShape aClipped = it.entry().clipped(0);
        int aNumClipped = aClipped.numEdges();
        if (aNumClipped == 0) {
            return false;
        }
        if (it.compareTo(target.id()) == 0) {
            return true;
        }
        R2Rect bound = target.getBoundUV().expanded(S2EdgeUtil.MAX_CELL_EDGE_ERROR);
        R2Vector v0 = new R2Vector();
        R2Vector v1 = new R2Vector();
        for (int i = 0; i < aNumClipped; ++i) {
            int ai = aClipped.edge(i);
            if (!S2EdgeUtil.clipToPaddedFace(this.vertex(ai), this.vertex(ai + 1), target.face(), S2EdgeUtil.MAX_CELL_EDGE_ERROR, v0, v1) || !S2EdgeUtil.intersectsRect(v0, v1, bound)) continue;
            return true;
        }
        return false;
    }

    public S2Loop simplify(S1Angle tolerance, Predicate<S2Point> vertexFilter) {
        if (this.vertices.length < 2) {
            return this;
        }
        ArrayList points = Lists.newArrayListWithCapacity((int)(this.vertices.length + 1));
        Collections.addAll(points, this.vertices);
        points.add(this.vertices[0]);
        S2Polyline line = new S2Polyline(points);
        ArrayList simplified = line.subsampleVertices(tolerance).vertices();
        if (simplified.get(0).equalsPoint((S2Point)Iterables.getLast(simplified))) {
            simplified = simplified.subList(0, simplified.size() - 1);
        }
        if (vertexFilter != null) {
            ArrayList toKeep = Lists.newArrayList();
            int j = 0;
            for (int i = 0; i < this.numVertices(); ++i) {
                S2Point p = this.vertex(i);
                if (((S2Point)simplified.get(j)).equalsPoint(p)) {
                    ++j;
                    toKeep.add(p);
                    continue;
                }
                if (!vertexFilter.apply((Object)p)) continue;
                toKeep.add(p);
            }
            simplified = toKeep;
        }
        return simplified.size() <= 2 ? null : new S2Loop(simplified);
    }

    @Override
    public boolean contains(S2Point p) {
        if (!this.index.isFresh() && this.bound != null && !this.bound.contains(p)) {
            return false;
        }
        int maxBruteForceVertices = 32;
        if (this.numVertices <= maxBruteForceVertices || !this.index.isFresh() && this.unindexedContainsCalls.decrementAndGet() > 0) {
            return this.bruteForceContains(p);
        }
        S2Iterator<S2ShapeIndex.Cell> it = this.index.iterator();
        if (!it.locate(p)) {
            return false;
        }
        return this.contains(it, p);
    }

    @VisibleForTesting
    boolean bruteForceContains(S2Point p) {
        if (this.numVertices < 3) {
            return this.originInside;
        }
        S2Point origin = S2.origin();
        S2EdgeUtil.EdgeCrosser crosser = new S2EdgeUtil.EdgeCrosser(origin, p, this.vertex(0));
        boolean inside = this.originInside;
        for (int i = 1; i <= this.numVertices; ++i) {
            inside ^= crosser.edgeOrVertexCrossing(this.vertex(i));
        }
        return inside;
    }

    private boolean contains(S2Iterator<S2ShapeIndex.Cell> it, S2Point p) {
        S2ShapeIndex.S2ClippedShape aClipped = it.entry().clipped(0);
        boolean inside = aClipped.containsCenter();
        int aNumClipped = aClipped.numEdges();
        if (aNumClipped > 0) {
            S2Point center = it.center();
            S2EdgeUtil.EdgeCrosser crosser = new S2EdgeUtil.EdgeCrosser(center, p);
            int aiPrev = -2;
            for (int i = 0; i < aNumClipped; ++i) {
                int ai = aClipped.edge(i);
                if (ai != aiPrev + 1) {
                    crosser.restartAt(this.vertex(ai));
                }
                aiPrev = ai;
                inside ^= crosser.edgeOrVertexCrossing(this.vertex(ai + 1));
            }
        }
        return inside;
    }

    public S1Angle getDistance(S2Point p) {
        S2Point normalized = S2Point.normalize(p);
        S1Angle minDistance = S1Angle.radians(Math.PI);
        for (int i = 0; i < this.numVertices; ++i) {
            minDistance = S1Angle.min(minDistance, S2EdgeUtil.getDistance(normalized, this.vertex(i), this.vertex(i + 1)));
        }
        return minDistance;
    }

    public boolean isOriginInside() {
        return this.originInside;
    }

    public boolean isValid() {
        return !this.findValidationError(new S2Error());
    }

    public static boolean isValid(List<S2Point> vertices) {
        return new S2Loop(vertices).isValid();
    }

    public boolean findValidationError(S2Error error) {
        return this.findValidationErrorNoIndex(error) || S2ShapeUtil.findSelfIntersection(this.index, this, error);
    }

    public boolean findValidationErrorNoIndex(S2Error error) {
        int i;
        for (i = 0; i < this.numVertices; ++i) {
            if (S2.isUnitLength(this.vertex(i))) continue;
            int n = i;
            error.init(S2Error.Code.NOT_UNIT_LENGTH, new StringBuilder(38).append("Vertex ").append(n).append(" is not unit length.").toString(), new Object[0]);
            return true;
        }
        if (this.numVertices < 3) {
            if (this.isEmptyOrFull()) {
                return false;
            }
            error.init(S2Error.Code.LOOP_NOT_ENOUGH_VERTICES, "Non-empty, non-full loops must have at least 3 vertices", new Object[0]);
            return true;
        }
        for (i = 0; i < this.numVertices; ++i) {
            if (!this.vertex(i).equalsPoint(this.vertex(i + 1))) continue;
            int n = i;
            error.init(S2Error.Code.DUPLICATE_VERTICES, new StringBuilder(50).append("Edge ").append(n).append(" is degenerate (duplicate vertex).").toString(), new Object[0]);
            return true;
        }
        return false;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("S2Loop, ");
        builder.append(this.vertices.length).append(" points. [");
        for (S2Point v : this.vertices) {
            builder.append(v.toDegreesString()).append(" ");
        }
        builder.append("]");
        return builder.toString();
    }

    private void initOriginAndBound() {
        if (this.numVertices < 3) {
            this.originInside = this.isEmptyOrFull() ? this.vertex((int)0).z < 0.0 : false;
        } else {
            this.originInside = false;
            boolean v1Inside = S2Predicates.orderedCCW(S2.ortho(this.vertex(1)), this.vertex(0), this.vertex(2), this.vertex(1));
            if (v1Inside != this.contains(this.vertex(1))) {
                this.originInside = true;
            }
        }
        this.initBound();
    }

    private void initBound() {
        if (this.numVertices < 3) {
            this.subregionBound = this.isFull() ? (this.bound = S2LatLngRect.full()) : (this.bound = S2LatLngRect.empty());
            return;
        }
        S2EdgeUtil.RectBounder bounder = new S2EdgeUtil.RectBounder();
        for (int i = 0; i <= this.numVertices; ++i) {
            bounder.addPoint(this.vertex(i));
        }
        S2LatLngRect b = bounder.getBound();
        if (this.contains(S2Point.Z_POS)) {
            b = new S2LatLngRect(new R1Interval(b.lat().lo(), 1.5707963267948966), S1Interval.full());
        }
        if (b.lng().isFull() && this.contains(S2Point.Z_NEG)) {
            b = new S2LatLngRect(new R1Interval(-1.5707963267948966, b.lat().hi()), b.lng());
        }
        this.bound = b;
        this.subregionBound = S2EdgeUtil.RectBounder.expandForSubregions(this.bound);
    }

    @VisibleForTesting
    int findVertex(S2Point p) {
        if (this.numVertices < 10) {
            for (int i = 1; i <= this.numVertices; ++i) {
                if (!this.vertex(i).equalsPoint(p)) continue;
                return i;
            }
            return -1;
        }
        S2Iterator<S2ShapeIndex.Cell> it = this.index.iterator();
        if (!it.locate(p)) {
            return -1;
        }
        S2ShapeIndex.S2ClippedShape aClipped = it.entry().clipped(0);
        for (int i = aClipped.numEdges() - 1; i >= 0; --i) {
            int ai = aClipped.edge(i);
            if (this.vertex(ai).equalsPoint(p)) {
                return ai == 0 ? this.numVertices : ai;
            }
            if (!this.vertex(ai + 1).equalsPoint(p)) continue;
            return ai + 1;
        }
        return -1;
    }

    private void visitSurfaceIntegral(TriangleConsumer consumer) {
        S2Point v0;
        double maxLength = 3.141582653589793;
        S2Point origin = v0 = this.vertex(0);
        int i = 1;
        while (i + 1 < this.numVertices) {
            assert (i == 1 || origin.angle(this.vertex(i)) < 3.141582653589793);
            assert (origin.equals(v0) || Math.abs(origin.dotProd(v0)) < 1.0E-15);
            S2Point v1 = this.vertex(i);
            S2Point v2 = this.vertex(i + 1);
            if (v2.angle(origin) > 3.141582653589793) {
                S2Point oldOrigin = origin;
                if (origin.equalsPoint(v0)) {
                    origin = S2Point.normalize(S2.robustCrossProd(v0, v1));
                } else if (v1.angle(v0) < 3.141582653589793) {
                    origin = v0;
                } else {
                    origin = S2Point.crossProd(v0, oldOrigin);
                    consumer.accept(v0, oldOrigin, origin);
                }
                consumer.accept(oldOrigin, v1, origin);
            }
            consumer.accept(origin, v1, v2);
            ++i;
        }
        if (!origin.equalsPoint(v0)) {
            consumer.accept(origin, this.vertex(this.numVertices - 1), v0);
        }
    }

    void encodeCompressed(int level, LittleEndianOutput encoder) throws IOException {
        encoder.writeVarint32(this.numVertices());
        S2PointCompression.encodePointsCompressed(Arrays.asList(this.vertices), level, encoder);
        CompressedEncodingProperties properties = new CompressedEncodingProperties(this);
        encoder.writeVarint64(properties.asLong());
        encoder.writeVarint32(this.depth());
        if (properties.hasProperty(CompressedEncodingProperties.Property.BOUND_ENCODED)) {
            this.getRectBound().encode(encoder);
        }
    }

    static S2Loop decodeCompressed(int level, LittleEndianInput decoder) throws IOException {
        int numVertices = decoder.readVarint32();
        List<S2Point> vertices = S2PointCompression.decodePointsCompressed(numVertices, level, decoder);
        CompressedEncodingProperties properties = new CompressedEncodingProperties(decoder.readVarint64());
        int depth = decoder.readVarint32();
        S2Loop loop = null;
        if (properties.hasProperty(CompressedEncodingProperties.Property.BOUND_ENCODED)) {
            boolean originInside = properties.hasProperty(CompressedEncodingProperties.Property.ORIGIN_INSIDE);
            S2LatLngRect bound = S2LatLngRect.decode(decoder);
            loop = S2Loop.newLoopWithTrustedDetails(vertices, originInside, bound);
        } else {
            loop = new S2Loop(vertices);
        }
        loop.setDepth(depth);
        return loop;
    }

    private static S2Loop decodeInternal(LittleEndianInput decoder) throws IOException {
        int numVertices = decoder.readInt();
        Preconditions.checkState((numVertices >= 0 ? 1 : 0) != 0, (Object)"Loops with more than 2^31 - 1 vertices not supported.");
        ArrayList<S2Point> vertices = new ArrayList<S2Point>(numVertices);
        for (int i = 0; i < numVertices; ++i) {
            vertices.add(S2Point.decode(decoder));
        }
        boolean originInside = decoder.readByte() != 0;
        int depth = decoder.readInt();
        S2LatLngRect bound = S2LatLngRect.decode(decoder);
        S2Loop loop = S2Loop.newLoopWithTrustedDetails(vertices, originInside, bound);
        loop.setDepth(depth);
        if (numVertices > 0) {
            loop.initIndex();
        }
        return loop;
    }

    private void encodeInternal(LittleEndianOutput encoder) throws IOException {
        encoder.writeInt(this.numVertices);
        for (int i = 0; i < this.numVertices; ++i) {
            this.vertex(i).encode(encoder);
        }
        encoder.writeByte(this.isOriginInside() ? (byte)1 : 0);
        encoder.writeInt(this.depth);
        this.bound.encode(encoder);
    }

    void encode(LittleEndianOutput encoder) throws IOException {
        encoder.writeByte((byte)1);
        this.encodeInternal(encoder);
    }

    static S2Loop decode(LittleEndianInput decoder) throws IOException {
        byte version = decoder.readByte();
        switch (version) {
            case 1: {
                return S2Loop.decodeInternal(decoder);
            }
        }
        throw new IOException(new StringBuilder(65).append("Unknown S2Loop encoding version encountered during decoding: ").append(version).toString());
    }

    private static boolean hasCrossingRelation(S2Loop a, S2Loop b, LoopRelation relation) {
        S2ShapeIndex.RangeIterator ai = new S2ShapeIndex.RangeIterator(a.index);
        S2ShapeIndex.RangeIterator bi = new S2ShapeIndex.RangeIterator(b.index);
        LoopCrosser ab = new LoopCrosser(a, b, relation, false);
        LoopCrosser ba = new LoopCrosser(b, a, relation, true);
        while (!ai.done() || !bi.done()) {
            if (ai.rangeMax().lessThan(bi.rangeMin())) {
                ai.seekTo(bi);
                continue;
            }
            if (bi.rangeMax().lessThan(ai.rangeMin())) {
                bi.seekTo(ai);
                continue;
            }
            long abRelation = UnsignedLongs.compare((long)ai.id().lowestOnBit(), (long)bi.id().lowestOnBit());
            if (abRelation > 0L) {
                if (!ab.hasCrossingRelation(ai, bi)) continue;
                return true;
            }
            if (abRelation < 0L) {
                if (!ba.hasCrossingRelation(bi, ai)) continue;
                return true;
            }
            if (ab.aCrossingTarget() == (ai.containsCenter() ? 1 : 0) && ab.bCrossingTarget() == (bi.containsCenter() ? 1 : 0)) {
                return true;
            }
            if (ai.numEdges() > 0 && bi.numEdges() > 0 && ab.cellCrossesCell(ai.clipped(), bi.clipped())) {
                return true;
            }
            ai.next();
            bi.next();
        }
        return false;
    }

    private strictfp static final class CompareBoundaryRelation
    implements LoopRelation {
        private final boolean bReversed;
        private boolean foundSharedVertex = false;
        private boolean containsEdge = false;
        private boolean excludesEdge = false;

        public CompareBoundaryRelation(boolean reverseB) {
            this.bReversed = reverseB;
        }

        public boolean foundSharedVertex() {
            return this.foundSharedVertex;
        }

        public boolean containsEdge() {
            return this.containsEdge;
        }

        @Override
        public int aCrossingTarget() {
            return -1;
        }

        @Override
        public int bCrossingTarget() {
            return -1;
        }

        @Override
        public boolean wedgesCross(S2Point a0, S2Point ab1, S2Point a2, S2Point b0, S2Point b2) {
            this.foundSharedVertex = true;
            if (S2Loop.wedgeContainsSemiwedge(a0, ab1, a2, b2, this.bReversed)) {
                this.containsEdge = true;
            } else {
                this.excludesEdge = true;
            }
            return this.containsEdge && this.excludesEdge;
        }
    }

    private strictfp static final class IntersectsRelation
    implements LoopRelation {
        private boolean foundSharedVertex = false;

        private IntersectsRelation() {
        }

        public boolean foundSharedVertex() {
            return this.foundSharedVertex;
        }

        @Override
        public int aCrossingTarget() {
            return 1;
        }

        @Override
        public int bCrossingTarget() {
            return 1;
        }

        @Override
        public boolean wedgesCross(S2Point a0, S2Point ab1, S2Point a2, S2Point b0, S2Point b2) {
            this.foundSharedVertex = true;
            return new S2EdgeUtil.WedgeIntersects().test(a0, ab1, a2, b0, b2) == -1;
        }
    }

    private strictfp static final class ContainsRelation
    implements LoopRelation {
        private boolean foundSharedVertex = false;

        private ContainsRelation() {
        }

        public boolean foundSharedVertex() {
            return this.foundSharedVertex;
        }

        @Override
        public int aCrossingTarget() {
            return 0;
        }

        @Override
        public int bCrossingTarget() {
            return 1;
        }

        @Override
        public boolean wedgesCross(S2Point a0, S2Point ab1, S2Point a2, S2Point b0, S2Point b2) {
            this.foundSharedVertex = true;
            return new S2EdgeUtil.WedgeContains().test(a0, ab1, a2, b0, b2) != 1;
        }
    }

    private static interface LoopRelation {
        public int aCrossingTarget();

        public int bCrossingTarget();

        public boolean wedgesCross(S2Point var1, S2Point var2, S2Point var3, S2Point var4, S2Point var5);
    }

    private strictfp static final class LoopCrosser {
        private final S2Loop a;
        private final S2Loop b;
        private final LoopRelation relation;
        private final boolean swapped;
        private final int aCrossingTarget;
        private final int bCrossingTarget;
        private S2EdgeUtil.EdgeCrosser crosser;
        private int aj;
        private int bjPrev;
        private final S2EdgeQuery bQuery;
        private final List<S2ShapeIndex.Cell> bCells;

        public LoopCrosser(S2Loop a, S2Loop b, LoopRelation relation, boolean swapped) {
            this.a = a;
            this.b = b;
            this.relation = relation;
            this.swapped = swapped;
            this.aCrossingTarget = swapped ? relation.bCrossingTarget() : relation.aCrossingTarget();
            this.bCrossingTarget = swapped ? relation.aCrossingTarget() : relation.bCrossingTarget();
            this.bQuery = new S2EdgeQuery(b.index);
            this.bCells = Lists.newArrayList();
        }

        public int aCrossingTarget() {
            return this.aCrossingTarget;
        }

        public int bCrossingTarget() {
            return this.bCrossingTarget;
        }

        public boolean hasCrossingRelation(S2ShapeIndex.RangeIterator ai, S2ShapeIndex.RangeIterator bi) {
            if (ai.numEdges() == 0) {
                if (this.aCrossingTarget == (ai.containsCenter() ? 1 : 0)) {
                    S2CellId maxRange = ai.rangeMax();
                    do {
                        if (this.bCrossingTarget == (bi.containsCenter() ? 1 : 0)) {
                            return true;
                        }
                        bi.next();
                    } while (bi.id().lessOrEquals(maxRange));
                } else {
                    bi.seekBeyond(ai);
                }
            } else if (this.hasCrossing(ai, bi)) {
                return true;
            }
            ai.next();
            return false;
        }

        public boolean cellCrossesCell(S2ShapeIndex.S2ClippedShape aClipped, S2ShapeIndex.S2ClippedShape bClipped) {
            int aNumClipped = aClipped.numEdges();
            for (int i = 0; i < aNumClipped; ++i) {
                this.startEdge(aClipped.edge(i));
                if (!this.edgeCrossesCell(bClipped)) continue;
                return true;
            }
            return false;
        }

        private boolean hasCrossing(S2ShapeIndex.RangeIterator ai, S2ShapeIndex.RangeIterator bi) {
            int edgeQueryMinEdges = 40;
            int totalEdges = 0;
            this.bCells.clear();
            S2CellId maxRange = ai.rangeMax();
            do {
                if (bi.numEdges() > 0) {
                    if ((totalEdges += bi.numEdges()) >= 40) {
                        if (this.cellCrossesAnySubcell(ai.clipped(), ai.id())) {
                            return true;
                        }
                        bi.seekBeyond(ai);
                        return false;
                    }
                    this.bCells.add(bi.cell());
                }
                bi.next();
            } while (bi.id().lessOrEquals(maxRange));
            for (int c = 0; c < this.bCells.size(); ++c) {
                if (!this.cellCrossesCell(ai.clipped(), this.bCells.get(c).clipped(0))) continue;
                return true;
            }
            return false;
        }

        private boolean cellCrossesAnySubcell(S2ShapeIndex.S2ClippedShape aClipped, S2CellId bId) {
            S2PaddedCell bRoot = new S2PaddedCell(bId, 0.0);
            int aNumClipped = aClipped.numEdges();
            for (int i = 0; i < aNumClipped; ++i) {
                int aj = aClipped.edge(i);
                if (!this.bQuery.getCells(this.a.vertex(aj), this.a.vertex(aj + 1), bRoot, this.bCells)) continue;
                this.startEdge(aj);
                for (int c = 0; c < this.bCells.size(); ++c) {
                    if (!this.edgeCrossesCell(this.bCells.get(c).clipped(0))) continue;
                    return true;
                }
            }
            return false;
        }

        private void startEdge(int aj) {
            this.crosser = new S2EdgeUtil.EdgeCrosser(this.a.vertex(aj), this.a.vertex(aj + 1));
            this.aj = aj;
            this.bjPrev = -2;
        }

        private boolean edgeCrossesCell(S2ShapeIndex.S2ClippedShape bClipped) {
            int bNumClipped = bClipped.numEdges();
            for (int j = 0; j < bNumClipped; ++j) {
                int bj = bClipped.edge(j);
                if (bj != this.bjPrev + 1) {
                    this.crosser.restartAt(this.b.vertex(bj));
                }
                this.bjPrev = bj;
                int crossing = this.crosser.robustCrossing(this.b.vertex(bj + 1));
                if (crossing < 0) continue;
                if (crossing > 0) {
                    return true;
                }
                if (!this.a.vertex(this.aj + 1).equalsPoint(this.b.vertex(bj + 1)) || !(this.swapped ? this.relation.wedgesCross(this.b.vertex(bj), this.b.vertex(bj + 1), this.b.vertex(bj + 2), this.a.vertex(this.aj), this.a.vertex(this.aj + 2)) : this.relation.wedgesCross(this.a.vertex(this.aj), this.a.vertex(this.aj + 1), this.a.vertex(this.aj + 2), this.b.vertex(bj), this.b.vertex(bj + 2)))) continue;
                return true;
            }
            return false;
        }
    }

    private strictfp static class CompressedEncodingProperties {
        private static final int MIN_LOOP_VERTICES_FOR_BOUND = 64;
        private long bits = 0L;

        public CompressedEncodingProperties(S2Loop loop) {
            if (loop.containsOrigin()) {
                this.setProperty(Property.ORIGIN_INSIDE);
            }
            if (loop.numVertices() >= 64) {
                this.setProperty(Property.BOUND_ENCODED);
            }
        }

        public CompressedEncodingProperties(long bits) {
            this.bits = bits;
        }

        public void setProperty(Property property) {
            this.bits ^= property.bitValue;
        }

        public boolean hasProperty(Property property) {
            return (this.bits & property.bitValue) != 0L;
        }

        public long asLong() {
            return this.bits;
        }

        public strictfp static enum Property {
            ORIGIN_INSIDE(1L),
            BOUND_ENCODED(2L);

            public long bitValue;

            private Property(long bitValue) {
                this.bitValue = bitValue;
            }
        }
    }

    private strictfp final class AreaCentroidMeasure
    implements TriangleConsumer {
        private final AreaMeasure area;
        private final CentroidMeasure centroid;

        private AreaCentroidMeasure() {
            this.area = new AreaMeasure();
            this.centroid = new CentroidMeasure(S2Loop.this);
        }

        @Override
        public void accept(S2Point a, S2Point b, S2Point c) {
            this.area.accept(a, b, c);
            this.centroid.accept(a, b, c);
        }

        public S2AreaCentroid value() {
            return new S2AreaCentroid(this.area.value(), this.centroid.value());
        }
    }

    private strictfp final class CentroidMeasure
    implements TriangleConsumer {
        private final double[] sum = new double[3];

        private CentroidMeasure(S2Loop s2Loop) {
        }

        @Override
        public void accept(S2Point a, S2Point b, S2Point c) {
            S2Point centroid = S2.trueCentroid(a, b, c);
            this.sum[0] = this.sum[0] + centroid.x;
            this.sum[1] = this.sum[1] + centroid.y;
            this.sum[2] = this.sum[2] + centroid.z;
        }

        public S2Point value() {
            return new S2Point(this.sum[0], this.sum[1], this.sum[2]);
        }
    }

    private strictfp final class AreaMeasure
    implements TriangleConsumer {
        private double area;

        private AreaMeasure() {
        }

        @Override
        public void accept(S2Point a, S2Point b, S2Point c) {
            this.area += S2.signedArea(a, b, c);
        }

        public double value() {
            double maxError = S2Loop.this.getTurningAngleMaxError();
            assert (Math.abs(this.area) <= Math.PI * 4 + maxError);
            if (this.area < 0.0) {
                this.area += Math.PI * 4;
            }
            this.area = Math.max(0.0, Math.min(Math.PI * 4, this.area));
            if (this.area < maxError && !S2Loop.this.isNormalized()) {
                return Math.PI * 4;
            }
            if (this.area > Math.PI * 4 - maxError && S2Loop.this.isNormalized()) {
                return 0.0;
            }
            return this.area;
        }
    }

    private static interface TriangleConsumer {
        public void accept(S2Point var1, S2Point var2, S2Point var3);
    }

    private strictfp static final class LoopOffsets {
        public final int first;
        public final int second;

        public LoopOffsets(int first, int second) {
            this.first = first;
            this.second = second;
        }

        public int hashCode() {
            return this.first * 517 + this.second;
        }

        public boolean equals(Object o) {
            if (o instanceof LoopOffsets) {
                LoopOffsets that = (LoopOffsets)o;
                return this.first == that.first && this.second == that.second;
            }
            return false;
        }
    }
}

