/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.common.geometry;

import com.google.appengine.repackaged.com.google.common.annotations.GwtCompatible;
import com.google.appengine.repackaged.com.google.common.geometry.BigPoint;
import com.google.appengine.repackaged.com.google.common.geometry.Platform;
import com.google.appengine.repackaged.com.google.common.geometry.S2;
import com.google.appengine.repackaged.com.google.common.geometry.S2Point;
import java.math.BigDecimal;

@GwtCompatible
public strictfp final class S2Predicates {
    public static int triageSign(S2Point a, S2Point b, S2Point c) {
        double kMaxDetError = 1.6E-15;
        double det = S2Point.scalarTripleProduct(c, a, b);
        if (det >= 1.6E-15) {
            return 1;
        }
        if (det <= -1.6E-15) {
            return -1;
        }
        return 0;
    }

    public static int triageSign(S2Point ab, S2Point c) {
        double maxDetError = 1.8274 * S2.DBL_EPSILON;
        double det = ab.dotProd(c);
        if (det >= maxDetError) {
            return 1;
        }
        if (det <= -maxDetError) {
            return -1;
        }
        return 0;
    }

    public static int sign(S2Point a, S2Point b, S2Point c) {
        int ccw = S2Predicates.triageSign(a, b, c);
        if (ccw == 0) {
            ccw = S2Predicates.expensiveSign(a, b, c);
        }
        return ccw;
    }

    public static int sign(S2Point a, S2Point b, S2Point c, S2Point aCrossB) {
        int ccw = S2Predicates.triageSign(aCrossB, c);
        if (ccw == 0) {
            ccw = S2Predicates.expensiveSign(a, b, c);
        }
        return ccw;
    }

    static int expensiveSign(S2Point a, S2Point b, S2Point c) {
        if (a.equalsPoint(b) || b.equalsPoint(c) || c.equalsPoint(a)) {
            return 0;
        }
        int sign = S2Predicates.stableSign(a, b, c);
        if (sign != 0) {
            return sign;
        }
        return S2Predicates.exactSign(a, b, c);
    }

    static final int stableSign(S2Point a, S2Point b, S2Point c) {
        double maxError;
        double det;
        S2Point ab = S2Point.sub(b, a);
        S2Point bc = S2Point.sub(c, b);
        S2Point ca = S2Point.sub(a, c);
        double ab2 = ab.norm2();
        double bc2 = bc.norm2();
        double ca2 = ca.norm2();
        double detErrorMultiplier = 3.2321 * S2.DBL_EPSILON;
        if (ab2 >= bc2 && ab2 >= ca2) {
            det = -S2Point.scalarTripleProduct(c, ca, bc);
            maxError = detErrorMultiplier * Math.sqrt(ca2 * bc2);
        } else if (bc2 >= ca2) {
            det = -S2Point.scalarTripleProduct(a, ab, ca);
            maxError = detErrorMultiplier * Math.sqrt(ab2 * ca2);
        } else {
            det = -S2Point.scalarTripleProduct(b, bc, ab);
            maxError = detErrorMultiplier * Math.sqrt(bc2 * ab2);
        }
        return Math.abs(det) <= maxError ? 0 : (det > 0.0 ? 1 : -1);
    }

    static final int exactSign(S2Point a, S2Point b, S2Point c) {
        BigPoint bc;
        S2Point t;
        int sign = Platform.sign(a, b, c);
        if (sign != 0) {
            return sign;
        }
        int permSign = 1;
        if (a.compareTo(b) > 0) {
            t = a;
            a = b;
            b = t;
            permSign = -permSign;
        }
        if (b.compareTo(c) > 0) {
            t = b;
            b = c;
            c = t;
            permSign = -permSign;
        }
        if (a.compareTo(b) > 0) {
            t = a;
            a = b;
            b = t;
            permSign = -permSign;
        }
        if ((sign = (bc = new BigPoint(b).crossProd(new BigPoint(c))).dotProd(a).signum()) != 0) {
            return permSign * sign;
        }
        sign = S2Predicates.symbolicallyPerturbedSign(a, b, c, bc.x.signum(), bc.y.signum(), bc.z.signum());
        return permSign * sign;
    }

    static int symbolicallyPerturbedSign(S2Point a, S2Point b, S2Point c, int bcx, int bcy, int bcz) {
        int sign = bcz;
        if (sign != 0) {
            return sign;
        }
        sign = bcy;
        if (sign != 0) {
            return sign;
        }
        sign = bcx;
        if (sign != 0) {
            return sign;
        }
        BigDecimal ax = new BigDecimal(a.x);
        BigDecimal ay = new BigDecimal(a.y);
        BigDecimal cx = new BigDecimal(c.x);
        BigDecimal cy = new BigDecimal(c.y);
        sign = cx.multiply(ay).subtract(cy.multiply(ax)).signum();
        if (sign != 0) {
            return sign;
        }
        sign = Double.compare(c.x, 0.0);
        if (sign != 0) {
            return sign;
        }
        sign = Double.compare(0.0, c.y);
        if (sign != 0) {
            return sign;
        }
        BigDecimal az = new BigDecimal(a.z);
        BigDecimal cz = new BigDecimal(c.z);
        sign = cz.multiply(ax).subtract(cx.multiply(az)).signum();
        if (sign != 0) {
            return sign;
        }
        sign = Double.compare(c.z, 0.0);
        if (sign != 0) {
            return sign;
        }
        BigDecimal bx = new BigDecimal(b.x);
        BigDecimal by = new BigDecimal(b.y);
        sign = ax.multiply(by).subtract(ay.multiply(bx)).signum();
        if (sign != 0) {
            return sign;
        }
        sign = Double.compare(0.0, b.x);
        if (sign != 0) {
            return sign;
        }
        sign = Double.compare(b.y, 0.0);
        if (sign != 0) {
            return sign;
        }
        sign = Double.compare(a.x, 0.0);
        if (sign != 0) {
            return sign;
        }
        return 1;
    }

    public static boolean orderedCCW(S2Point a, S2Point b, S2Point c, S2Point o) {
        int sum = 0;
        if (S2Predicates.sign(b, o, a) >= 0) {
            ++sum;
        }
        if (S2Predicates.sign(c, o, b) >= 0) {
            ++sum;
        }
        if (S2Predicates.sign(a, o, c) > 0) {
            ++sum;
        }
        return sum >= 2;
    }

    private S2Predicates() {
    }
}

