/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.core.rep;

import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.storage.onestore.v3.OnestoreEntity;
import java.util.Arrays;
import java.util.Iterator;
import javax.annotation.CheckReturnValue;

public class V3Paths {
    protected V3Paths() {
    }

    public static String kind(OnestoreEntity.Reference key) {
        return V3Paths.lastElement(key).getType();
    }

    public static String kind(OnestoreEntity.Path path) {
        return V3Paths.lastElement(path).getType();
    }

    public static String name(OnestoreEntity.Reference key) {
        return V3Paths.lastElement(key).getName();
    }

    public static long id(OnestoreEntity.Reference key) {
        return V3Paths.lastElement(key).getId();
    }

    public static OnestoreEntity.Path.Element lastElement(OnestoreEntity.Reference key) {
        return V3Paths.lastElement(key.getPath());
    }

    public static OnestoreEntity.Path.Element lastElement(OnestoreEntity.Path path) {
        Preconditions.checkArgument((path.elementSize() >= 1 ? 1 : 0) != 0, (Object)"empty path");
        return path.getElement(path.elementSize() - 1);
    }

    public static boolean hasIdOrName(OnestoreEntity.Reference key) {
        return V3Paths.hasIdOrName(key.getPath());
    }

    public static boolean hasIdOrName(OnestoreEntity.Path path) {
        return V3Paths.hasIdOrName(V3Paths.lastElement(path));
    }

    public static boolean hasIdOrName(OnestoreEntity.Path.Element element) {
        return element.hasId() && element.getId() != 0L || element.hasName() && !element.getName().isEmpty();
    }

    public static boolean hasIncompleteLastElement(OnestoreEntity.Reference key) {
        if (key.getPath().elementSize() == 0) {
            return false;
        }
        return !V3Paths.hasIdOrName(key);
    }

    public static OnestoreEntity.PropertyValue toReferenceProperty(OnestoreEntity.Reference key) {
        OnestoreEntity.PropertyValue prop = new OnestoreEntity.PropertyValue();
        OnestoreEntity.PropertyValue.ReferenceValue ref = prop.getMutableReferenceValue();
        if (key.hasApp()) {
            ref.setAppAsBytes(key.getAppAsBytes());
        }
        if (key.hasDatabaseId()) {
            ref.setDatabaseIdAsBytes(key.getDatabaseIdAsBytes());
        }
        if (key.hasNameSpace()) {
            ref.setNameSpaceAsBytes(key.getNameSpaceAsBytes());
        }
        for (OnestoreEntity.Path.Element keyElem : key.getPath().elements()) {
            OnestoreEntity.PropertyValue.ReferenceValuePathElement refElem = ref.addPathElement();
            if (keyElem.hasType()) {
                refElem.setTypeAsBytes(keyElem.getTypeAsBytes());
            }
            if (keyElem.hasId()) {
                refElem.setId(keyElem.getId());
            }
            if (!keyElem.hasName()) continue;
            refElem.setNameAsBytes(keyElem.getNameAsBytes());
        }
        return prop;
    }

    public static OnestoreEntity.Path.Element pop(OnestoreEntity.Path path) {
        return path.removeElement(path.elementSize() - 1);
    }

    @CheckReturnValue
    public static OnestoreEntity.Path truncatePath(OnestoreEntity.Path path, int newLength) {
        if (newLength >= path.elementSize()) {
            return path;
        }
        OnestoreEntity.Path truncated = (OnestoreEntity.Path)path.clone();
        truncated.mutableElements().subList(newLength, path.elementSize()).clear();
        return truncated;
    }

    public static OnestoreEntity.Path createPath(Object ... elms) {
        Preconditions.checkArgument((elms.length > 0 && elms.length % 2 == 0 ? 1 : 0) != 0, (String)"Bad path: wrong number of elements %s", (Object)Arrays.toString(elms));
        OnestoreEntity.Path p = new OnestoreEntity.Path();
        for (int i = 0; i < elms.length; i += 2) {
            Preconditions.checkArgument((boolean)(elms[i] instanceof String), (String)"Bad path: type should be String: %s", (Object)elms[i]);
            String type = (String)elms[i];
            if (elms[i + 1] instanceof Long || elms[i + 1] instanceof Integer) {
                long id = ((Number)elms[i + 1]).longValue();
                Preconditions.checkArgument((id != 0L || i + 2 == elms.length ? 1 : 0) != 0, (Object)"Bad path: id can be 0 only for the last element");
                p.addElement().setType(type).setId(id);
                continue;
            }
            Preconditions.checkArgument((boolean)(elms[i + 1] instanceof String), (String)"Bad path: type should be String, int or long: %s", (Object)elms[i + 1]);
            String name = (String)elms[i + 1];
            p.addElement().setType(type).setName(name);
        }
        return p;
    }

    public static OnestoreEntity.Reference toReference(OnestoreEntity.PropertyValue.ReferenceValue ref) {
        OnestoreEntity.Reference key = new OnestoreEntity.Reference();
        if (ref.hasApp()) {
            key.setAppAsBytes(ref.getAppAsBytes());
        }
        if (ref.hasDatabaseId()) {
            key.setDatabaseIdAsBytes(ref.getDatabaseIdAsBytes());
        }
        if (ref.hasNameSpace()) {
            key.setNameSpaceAsBytes(ref.getNameSpaceAsBytes());
        }
        for (OnestoreEntity.PropertyValue.ReferenceValuePathElement refElem : ref.pathElements()) {
            OnestoreEntity.Path.Element keyElem = key.getMutablePath().addElement();
            if (refElem.hasType()) {
                keyElem.setTypeAsBytes(refElem.getTypeAsBytes());
            }
            if (refElem.hasId()) {
                keyElem.setId(refElem.getId());
            }
            if (!refElem.hasName()) continue;
            keyElem.setNameAsBytes(refElem.getNameAsBytes());
        }
        return key;
    }

    public static OnestoreEntity.Reference toParentReference(OnestoreEntity.Reference key) {
        OnestoreEntity.Reference parentKey = (OnestoreEntity.Reference)key.clone();
        V3Paths.pop(parentKey.getPath());
        return parentKey;
    }

    public static OnestoreEntity.Path entityGroup(OnestoreEntity.Reference key) {
        return V3Paths.entityGroup(key.getPath());
    }

    public static OnestoreEntity.Path entityGroup(OnestoreEntity.Path path) {
        Preconditions.checkArgument((path.elementSize() >= 1 ? 1 : 0) != 0, (Object)"empty path");
        OnestoreEntity.Path group = new OnestoreEntity.Path();
        group.addElement(path.getElement(0));
        return group;
    }

    public static OnestoreEntity.Reference entityGroupReference(OnestoreEntity.Reference key) {
        OnestoreEntity.Reference egKey = (OnestoreEntity.Reference)key.clone();
        return egKey.setPath(V3Paths.entityGroup(key));
    }

    public static boolean descendsFrom(OnestoreEntity.Reference key, OnestoreEntity.Reference ancestor) {
        if (!ancestor.getApp().equals(key.getApp())) {
            return false;
        }
        return V3Paths.descendsFrom(key.getPath(), ancestor.getPath());
    }

    public static boolean descendsFrom(OnestoreEntity.Path path, OnestoreEntity.Path ancestor) {
        Iterator ai = ancestor.elementIterator();
        Iterator ki = path.elementIterator();
        while (ai.hasNext()) {
            if (ki.hasNext() && ((OnestoreEntity.Path.Element)ai.next()).equals((OnestoreEntity.Path.Element)ki.next())) continue;
            return false;
        }
        return true;
    }

    public static OnestoreEntity.Reference toReference(OnestoreEntity.PropertyValue value) {
        Preconditions.checkArgument((boolean)value.hasReferenceValue());
        return V3Paths.toReference(value.getReferenceValue());
    }

    public static String toPathString(OnestoreEntity.Reference key) {
        if (key.getPath().elementSize() == 0) {
            return "[]";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[");
        for (OnestoreEntity.Path.Element element : key.getPath().elements()) {
            String kind = element.getType();
            stringBuilder.append(kind);
            stringBuilder.append(": ");
            if (element.hasId()) {
                stringBuilder.append(element.getId());
            } else if (element.hasName()) {
                stringBuilder.append(element.getName());
            }
            stringBuilder.append(", ");
        }
        int stringBuilderLength = stringBuilder.length();
        stringBuilder.delete(stringBuilderLength - 2, stringBuilderLength);
        stringBuilder.append("]");
        return stringBuilder.toString();
    }
}

