/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.common.geometry;

import com.google.appengine.repackaged.com.google.common.annotations.GwtCompatible;
import com.google.appengine.repackaged.com.google.common.geometry.S2Point;

@GwtCompatible
public interface S2Shape {
    public int numEdges();

    public void getEdge(int var1, MutableEdge var2);

    public boolean hasInterior();

    public boolean containsOrigin();

    public int numChains();

    public int getChainStart(int var1);

    public int getChainLength(int var1);

    public void getChainEdge(int var1, int var2, MutableEdge var3);

    public int dimension();

    public static final class MutableEdge {
        S2Point a;
        S2Point b;

        public S2Point getStart() {
            return this.a;
        }

        public S2Point getEnd() {
            return this.b;
        }

        public boolean isEndpoint(S2Point point) {
            return this.a.equalsPoint(point) || this.b.equalsPoint(point);
        }

        public void set(S2Point start, S2Point end) {
            this.a = start;
            this.b = end;
        }
    }
}

