/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.common.geometry.stlib;

import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.repackaged.com.google.common.geometry.LittleEndianInput;
import com.google.appengine.repackaged.com.google.common.geometry.LittleEndianOutput;
import com.google.appengine.repackaged.com.google.common.geometry.S2CellId;
import com.google.appengine.repackaged.com.google.common.geometry.S2CellUnion;
import com.google.appengine.repackaged.com.google.common.geometry.S2Point;
import com.google.appengine.repackaged.com.google.common.geometry.S2Polygon;
import com.google.appengine.repackaged.com.google.common.geometry.S2Polyline;
import com.google.appengine.repackaged.com.google.common.geometry.stlib.STGeography;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class STGeographyCoder {
    private static final byte ENCODING_MAGIC_STRING_0 = 83;
    private static final int LONG_BYTES = 8;

    private STGeographyCoder() {
    }

    public static void encode(STGeography geo, OutputStream out) throws IOException {
        Preconditions.checkNotNull((Object)geo);
        LittleEndianOutput encoder = new LittleEndianOutput(out);
        encoder.writeByte((byte)83);
        encoder.writeVarint32(geo.numPoints());
        encoder.writeVarint32(geo.numLines());
        encoder.writeVarint32(geo.numPolygons());
        for (S2Point point : geo.points()) {
            point.encode(out);
        }
        for (S2Polyline line : geo.lines()) {
            line.encode(out);
        }
        for (S2Polygon polygon : geo.polygons()) {
            polygon.encode(out);
        }
    }

    public static void encodeCovering(S2CellUnion covering, OutputStream out) throws IOException {
        Preconditions.checkNotNull((Object)covering);
        LittleEndianOutput encoder = new LittleEndianOutput(out);
        for (S2CellId cellId : covering.cellIds()) {
            encoder.writeLong(cellId.id());
        }
    }

    public static STGeography decode(InputStream in) throws IOException {
        int i;
        LittleEndianInput decoder = new LittleEndianInput(in);
        byte version = decoder.readByte();
        if (version != 83) {
            throw new IOException(new StringBuilder(45).append("Unsupported STGeography encoding version ").append(version).toString());
        }
        int numPoints = decoder.readVarint32();
        int numLines = decoder.readVarint32();
        int numPolygons = decoder.readVarint32();
        Preconditions.checkState((numPoints >= 0 ? 1 : 0) != 0, (String)"Invalid number of points %s", (int)numPoints);
        Preconditions.checkState((numLines >= 0 ? 1 : 0) != 0, (String)"Invalid number of lines %s", (int)numPoints);
        Preconditions.checkState((numPolygons >= 0 ? 1 : 0) != 0, (String)"Invalid number of polygons %s", (int)numPoints);
        STGeography.Builder builder = new STGeography.Builder();
        for (i = 0; i < numPoints; ++i) {
            S2Point point = S2Point.decode(in);
            builder.addPoint(point);
        }
        for (i = 0; i < numLines; ++i) {
            S2Polyline line = S2Polyline.decode(in);
            builder.addLine(line);
        }
        for (i = 0; i < numPolygons; ++i) {
            S2Polygon p = S2Polygon.decode(in);
            builder.addPolygon(p);
        }
        return builder.build();
    }

    public static S2CellUnion decodeCovering(ByteBuffer buffer) throws IOException {
        if (buffer.remaining() % 8 != 0) {
            throw new IOException("Invalid covering data");
        }
        S2CellUnion result = new S2CellUnion();
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        while (buffer.hasRemaining()) {
            result.cellIds().add(new S2CellId(buffer.getLong()));
        }
        return result;
    }
}

