/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.org.apache.lucene.analysis.fa;

import com.google.appengine.repackaged.org.apache.lucene.analysis.Analyzer;
import com.google.appengine.repackaged.org.apache.lucene.analysis.LowerCaseFilter;
import com.google.appengine.repackaged.org.apache.lucene.analysis.StopFilter;
import com.google.appengine.repackaged.org.apache.lucene.analysis.TokenStream;
import com.google.appengine.repackaged.org.apache.lucene.analysis.Tokenizer;
import com.google.appengine.repackaged.org.apache.lucene.analysis.WordlistLoader;
import com.google.appengine.repackaged.org.apache.lucene.analysis.ar.ArabicLetterTokenizer;
import com.google.appengine.repackaged.org.apache.lucene.analysis.ar.ArabicNormalizationFilter;
import com.google.appengine.repackaged.org.apache.lucene.analysis.fa.PersianNormalizationFilter;
import com.google.appengine.repackaged.org.apache.lucene.util.Version;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Set;

public final class PersianAnalyzer
extends Analyzer {
    public static final String DEFAULT_STOPWORD_FILE = "stopwords.txt";
    private Set stoptable = new HashSet();
    public static final String STOPWORDS_COMMENT = "#";
    private final Version matchVersion;

    public PersianAnalyzer() {
        this(Version.LUCENE_24);
    }

    public PersianAnalyzer(Version matchVersion) {
        this.matchVersion = matchVersion;
        try {
            InputStream stream = PersianAnalyzer.class.getResourceAsStream(DEFAULT_STOPWORD_FILE);
            InputStreamReader reader = new InputStreamReader(stream, "UTF-8");
            this.stoptable = WordlistLoader.getWordSet(reader, STOPWORDS_COMMENT);
            reader.close();
            stream.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public PersianAnalyzer(String[] stopwords) {
        this(Version.LUCENE_24, stopwords);
    }

    public PersianAnalyzer(Version matchVersion, String[] stopwords) {
        this.stoptable = StopFilter.makeStopSet(stopwords);
        this.matchVersion = matchVersion;
    }

    public PersianAnalyzer(Hashtable stopwords) {
        this(Version.LUCENE_24, stopwords);
    }

    public PersianAnalyzer(Version matchVersion, Hashtable stopwords) {
        this.stoptable = new HashSet(stopwords.keySet());
        this.matchVersion = matchVersion;
    }

    public PersianAnalyzer(File stopwords) throws IOException {
        this(Version.LUCENE_24, stopwords);
    }

    public PersianAnalyzer(Version matchVersion, File stopwords) throws IOException {
        this.stoptable = WordlistLoader.getWordSet(stopwords, STOPWORDS_COMMENT);
        this.matchVersion = matchVersion;
    }

    public TokenStream tokenStream(String fieldName, Reader reader) {
        TokenStream result = new ArabicLetterTokenizer(reader);
        result = new LowerCaseFilter(result);
        result = new ArabicNormalizationFilter(result);
        result = new PersianNormalizationFilter(result);
        result = new StopFilter(StopFilter.getEnablePositionIncrementsVersionDefault(this.matchVersion), result, this.stoptable);
        return result;
    }

    public TokenStream reusableTokenStream(String fieldName, Reader reader) throws IOException {
        SavedStreams streams = (SavedStreams)this.getPreviousTokenStream();
        if (streams == null) {
            streams = new SavedStreams();
            streams.source = new ArabicLetterTokenizer(reader);
            streams.result = new LowerCaseFilter(streams.source);
            streams.result = new ArabicNormalizationFilter(streams.result);
            streams.result = new PersianNormalizationFilter(streams.result);
            streams.result = new StopFilter(StopFilter.getEnablePositionIncrementsVersionDefault(this.matchVersion), streams.result, this.stoptable);
            this.setPreviousTokenStream(streams);
        } else {
            streams.source.reset(reader);
        }
        return streams.result;
    }

    private class SavedStreams {
        Tokenizer source;
        TokenStream result;

        private SavedStreams() {
        }
    }
}

