/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.common.geometry;

import com.google.appengine.repackaged.com.google.common.annotations.GwtIncompatible;
import com.google.appengine.repackaged.com.google.common.geometry.EncodedUintVector;
import com.google.appengine.repackaged.com.google.common.math.IntMath;
import com.google.appengine.repackaged.com.google.common.primitives.ImmutableLongArray;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.AbstractList;

@GwtIncompatible(value="Uses ByteBuffer")
class EncodedByteArrayVector
extends AbstractList<ByteBuffer> {
    private final ByteBuffer data;
    private final int offset;
    private final EncodedUintVector offsets;

    public EncodedByteArrayVector(ByteBuffer buffer) throws IOException {
        this.data = buffer.order() == ByteOrder.LITTLE_ENDIAN ? buffer : buffer.duplicate().order(ByteOrder.LITTLE_ENDIAN);
        this.offsets = EncodedUintVector.createEncodedUint64Vector(this.data);
        this.offset = this.data.position();
        buffer.position(IntMath.checkedAdd((int)this.offset, (int)(this.offsets.size() > 0 ? this.offsets.getInt(this.offsets.size() - 1) : 0)));
    }

    @Override
    public ByteBuffer get(int i) {
        int start = this.offset + (i == 0 ? 0 : this.offsets.getInt(i - 1));
        int limit = this.offset + this.offsets.getInt(i);
        return (ByteBuffer)this.data.asReadOnlyBuffer().position(start).limit(limit);
    }

    @Override
    public int size() {
        return this.offsets.size();
    }

    static class Encoder {
        private ImmutableLongArray.Builder offsetsBuilder;
        private final ByteArrayOutputStream data = new ByteArrayOutputStream();

        public Encoder() {
            this.reset();
        }

        public void reset() {
            this.offsetsBuilder = ImmutableLongArray.builder();
            this.data.reset();
        }

        public OutputStream addViaOutputStream() {
            this.offsetsBuilder.add((long)this.data.size());
            return this.data;
        }

        public void encode(OutputStream output) throws IOException {
            this.offsetsBuilder.add((long)this.data.size());
            ImmutableLongArray offsets = this.offsetsBuilder.build();
            EncodedUintVector.encodeUint64Vector(offsets.subArray(1, offsets.length()), output);
            this.data.writeTo(output);
            this.reset();
        }
    }
}

