/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.common.geometry;

import com.google.appengine.repackaged.com.google.common.annotations.GwtCompatible;
import com.google.appengine.repackaged.com.google.common.annotations.VisibleForTesting;
import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.repackaged.com.google.common.collect.Iterables;
import com.google.appengine.repackaged.com.google.common.geometry.BitInterleave;
import com.google.appengine.repackaged.com.google.common.geometry.EncodedInts;
import com.google.appengine.repackaged.com.google.common.geometry.LittleEndianInput;
import com.google.appengine.repackaged.com.google.common.geometry.LittleEndianOutput;
import com.google.appengine.repackaged.com.google.common.geometry.S2Point;
import com.google.appengine.repackaged.com.google.common.geometry.S2Projections;
import com.google.appengine.repackaged.com.google.common.primitives.Longs;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

@GwtCompatible
public strictfp final class S2PointCompression {
    private static final int DERIVATIVE_ENCODING_ORDER = 2;

    private S2PointCompression() {
    }

    public static void encodePointsCompressed(List<S2Point> points, int level, OutputStream output) throws IOException {
        S2PointCompression.encodePointsCompressed(points, level, new LittleEndianOutput(output));
    }

    static void encodePointsCompressed(List<S2Point> points, int level, LittleEndianOutput encoder) throws IOException {
        FaceRunCoder faces = new FaceRunCoder();
        int[] verticesPi = new int[points.size()];
        int[] verticesQi = new int[points.size()];
        ArrayList<Integer> offCenter = new ArrayList<Integer>();
        for (int i = 0; i < points.size(); ++i) {
            S2Projections.FaceSiTi faceSiTi = S2Projections.PROJ.xyzToFaceSiTi(points.get(i));
            faces.addFace(faceSiTi.face);
            verticesPi[i] = S2PointCompression.siTiToPiQi(faceSiTi.si, level);
            verticesQi[i] = S2PointCompression.siTiToPiQi(faceSiTi.ti, level);
            if (S2Projections.PROJ.levelIfCenter(faceSiTi, points.get(i)) == level) continue;
            offCenter.add(i);
        }
        faces.encode(encoder);
        NthDerivativeCoder piCoder = new NthDerivativeCoder(2);
        NthDerivativeCoder qiCoder = new NthDerivativeCoder(2);
        for (int i = 0; i < verticesPi.length; ++i) {
            int pi = piCoder.encode(verticesPi[i]);
            int qi = qiCoder.encode(verticesQi[i]);
            if (i == 0) {
                long interleavedPiQi = BitInterleave.interleaveInteger(pi, qi);
                int bytesRequired = (level + 7) / 8 * 2;
                byte[] littleEndianInterleavedPiQiBytes = Arrays.copyOf(Longs.toByteArray((long)Long.reverseBytes(interleavedPiQi)), bytesRequired);
                encoder.writeBytes(littleEndianInterleavedPiQiBytes);
                continue;
            }
            int zigZagEncodedPi = EncodedInts.encodeZigZag32(pi);
            int zigZagEncodedQi = EncodedInts.encodeZigZag32(qi);
            long interleavedPiQi = BitInterleave.interleaveInteger(zigZagEncodedPi, zigZagEncodedQi);
            encoder.writeVarint64(interleavedPiQi);
        }
        encoder.writeVarint32(offCenter.size());
        Iterator iterator = offCenter.iterator();
        while (iterator.hasNext()) {
            int index = (Integer)iterator.next();
            encoder.writeVarint32(index);
            points.get(index).encode(encoder);
        }
    }

    public static List<S2Point> decodePointsCompressed(int numVertices, int level, InputStream input) throws IOException {
        return S2PointCompression.decodePointsCompressed(numVertices, level, new LittleEndianInput(input));
    }

    static List<S2Point> decodePointsCompressed(int numVertices, int level, LittleEndianInput decoder) throws IOException {
        ArrayList<S2Point> vertices = new ArrayList<S2Point>(numVertices);
        FaceRunCoder faces = new FaceRunCoder();
        faces.decode(numVertices, decoder);
        Iterator<Integer> faceIterator = faces.getFaceIterator();
        NthDerivativeCoder piCoder = new NthDerivativeCoder(2);
        NthDerivativeCoder qiCoder = new NthDerivativeCoder(2);
        for (int i = 0; i < numVertices; ++i) {
            int qi;
            int pi;
            if (i == 0) {
                int bytesRequired = (level + 7) / 8 * 2;
                byte[] littleEndianBytes = decoder.readBytes(bytesRequired);
                long interleavedPiQi = Long.reverseBytes(Longs.fromByteArray((byte[])Arrays.copyOf(littleEndianBytes, 8)));
                int[] split = BitInterleave.deinterleaveInteger(interleavedPiQi);
                pi = piCoder.decode(split[0]);
                qi = qiCoder.decode(split[1]);
            } else {
                long interleavedPiQi = decoder.readVarint64();
                int[] split = BitInterleave.deinterleaveInteger(interleavedPiQi);
                pi = piCoder.decode(EncodedInts.decodeZigZag32(split[0]));
                qi = qiCoder.decode(EncodedInts.decodeZigZag32(split[1]));
            }
            int face = faceIterator.next();
            vertices.add(S2PointCompression.facePiQiToXyz(face, pi, qi, level));
        }
        int numOffCenter = decoder.readVarint32();
        if (numOffCenter > numVertices) {
            return null;
        }
        for (int i = 0; i < numOffCenter; ++i) {
            int index = decoder.readVarint32();
            double x = decoder.readDouble();
            double y = decoder.readDouble();
            double z = decoder.readDouble();
            vertices.set(index, new S2Point(x, y, z));
        }
        return vertices;
    }

    private static int siTiToPiQi(long si, int level) {
        si = Math.min(si, Integer.MAX_VALUE);
        return (int)(si >>> 31 - level);
    }

    private static double piQiToST(int pi, int level) {
        return ((double)pi + 0.5) / (double)(1 << level);
    }

    private static S2Point facePiQiToXyz(int face, int pi, int qi, int level) {
        return S2Point.normalize(S2Projections.faceUvToXyz(face, S2Projections.PROJ.stToUV(S2PointCompression.piQiToST(pi, level)), S2Projections.PROJ.stToUV(S2PointCompression.piQiToST(qi, level))));
    }

    @VisibleForTesting
    strictfp static final class NthDerivativeCoder {
        public static final int N_MIN = 0;
        public static final int N_MAX = 10;
        private final int n;
        private int m;
        private final int[] memory;

        public NthDerivativeCoder(int n) {
            Preconditions.checkArgument((0 <= n && n <= 10 ? 1 : 0) != 0, (String)"Unsupported N: %s", (int)n);
            this.n = n;
            this.memory = new int[10];
            this.reset();
        }

        public int getN() {
            return this.n;
        }

        public int encode(int k) {
            for (int i = 0; i < this.m; ++i) {
                int delta = k - this.memory[i];
                this.memory[i] = k;
                k = delta;
            }
            if (this.m < this.n) {
                this.memory[this.m] = k;
                ++this.m;
            }
            return k;
        }

        public int decode(int k) {
            if (this.m < this.n) {
                ++this.m;
            }
            for (int i = this.m - 1; i >= 0; --i) {
                int n = i;
                this.memory[n] = this.memory[n] + k;
                k = this.memory[i];
            }
            return k;
        }

        public void reset() {
            Arrays.fill(this.memory, 0, this.n, 0);
            this.m = 0;
        }
    }

    private strictfp static class FaceRunCoder {
        private final List<FaceRun> faces = new ArrayList<FaceRun>();

        private FaceRunCoder() {
        }

        public void addFace(int face) {
            FaceRun lastRun;
            FaceRun faceRun = lastRun = !this.faces.isEmpty() ? (FaceRun)Iterables.getLast(this.faces) : null;
            if (lastRun != null && lastRun.face == face) {
                ++lastRun.count;
            } else {
                this.faces.add(new FaceRun(face, 1));
            }
        }

        public void encode(LittleEndianOutput encoder) throws IOException {
            for (FaceRun run : this.faces) {
                encoder.writeVarint64(6 * run.count + run.face);
            }
        }

        public void decode(int vertices, LittleEndianInput decoder) throws IOException {
            FaceRun run;
            for (int facesParsed = 0; facesParsed < vertices; facesParsed += run.count) {
                long faceAndCount = decoder.readVarint64();
                run = new FaceRun((int)(faceAndCount % 6L), (int)(faceAndCount / 6L));
                this.faces.add(run);
            }
        }

        public Iterator<Integer> getFaceIterator() {
            final Iterator<FaceRun> faceRunIterator = this.faces.iterator();
            if (!faceRunIterator.hasNext()) {
                return Collections.emptyIterator();
            }
            return new Iterator<Integer>(this){
                private FaceRun currentFaceRun;
                private int usedCountForCurrentFaceRun;
                {
                    this.currentFaceRun = (FaceRun)faceRunIterator.next();
                    this.usedCountForCurrentFaceRun = 0;
                }

                @Override
                public boolean hasNext() {
                    return this.usedCountForCurrentFaceRun < this.currentFaceRun.count || faceRunIterator.hasNext();
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }

                @Override
                public Integer next() {
                    if (this.usedCountForCurrentFaceRun < this.currentFaceRun.count) {
                        ++this.usedCountForCurrentFaceRun;
                    } else {
                        this.usedCountForCurrentFaceRun = 1;
                        this.currentFaceRun = (FaceRun)faceRunIterator.next();
                    }
                    return this.currentFaceRun.face;
                }
            };
        }

        private strictfp static class FaceRun {
            public int face;
            public int count;

            public FaceRun(int face, int count) {
                this.face = face;
                this.count = count;
            }
        }
    }
}

