/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.common.geometry;

import com.google.appengine.repackaged.com.google.common.annotations.GwtIncompatible;
import com.google.appengine.repackaged.com.google.common.base.Function;
import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableList;
import com.google.appengine.repackaged.com.google.common.geometry.ByteBuffers;
import com.google.appengine.repackaged.com.google.common.geometry.EncodedByteArrayVector;
import com.google.appengine.repackaged.com.google.common.geometry.EncodedInts;
import com.google.appengine.repackaged.com.google.common.geometry.EncodedS2CellIdVector;
import com.google.appengine.repackaged.com.google.common.geometry.S2CellId;
import com.google.appengine.repackaged.com.google.common.geometry.S2Iterator;
import com.google.appengine.repackaged.com.google.common.geometry.S2Shape;
import com.google.appengine.repackaged.com.google.common.geometry.S2ShapeIndex;
import com.google.appengine.repackaged.com.google.common.geometry.S2ShapeUtil;
import com.google.appengine.repackaged.com.google.common.primitives.Ints;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.List;

@GwtIncompatible(value="Uses ByteBuffer")
class EncodedS2ShapeIndex
extends S2ShapeIndex {
    private static final S2Shape UNDECODED_SHAPE = new S2ShapeUtil.S2EdgeVectorShape();
    private final S2ShapeIndex.Options options;
    private final S2Shape[] cachedShapes;
    private final EncodedS2CellIdVector encodedCellIds;
    private final EncodedByteArrayVector encodedCells;
    private final List<S2ShapeIndex.Cell> cells;

    public EncodedS2ShapeIndex(ByteBuffer buffer, final AbstractList<S2Shape> shapeFactory) throws IOException {
        buffer = buffer.duplicate().order(ByteOrder.LITTLE_ENDIAN);
        long maxEdgesVersion = EncodedInts.readVarint64(ByteBuffers.asInputStream(buffer));
        int version = (int)maxEdgesVersion & 3;
        Preconditions.checkArgument((version == 0 ? 1 : 0) != 0, (Object)"Unknown encoding.");
        this.options = new S2ShapeIndex.Options();
        this.options.setMaxEdgesPerCell(Ints.checkedCast((long)(maxEdgesVersion >> 2)));
        this.cachedShapes = new S2Shape[shapeFactory.size()];
        Arrays.fill(this.cachedShapes, UNDECODED_SHAPE);
        this.shapes = new AbstractList<S2Shape>(){

            @Override
            public S2Shape get(int i) {
                return EncodedS2ShapeIndex.this.cachedShapes[i] == UNDECODED_SHAPE ? (((EncodedS2ShapeIndex)EncodedS2ShapeIndex.this).cachedShapes[i] = (S2Shape)shapeFactory.get(i)) : EncodedS2ShapeIndex.this.cachedShapes[i];
            }

            @Override
            public int size() {
                return EncodedS2ShapeIndex.this.cachedShapes.length;
            }
        };
        this.encodedCellIds = new EncodedS2CellIdVector(buffer);
        this.encodedCells = new EncodedByteArrayVector(buffer);
        ImmutableList.Builder cellsBuilder = ImmutableList.builder();
        for (int i = 0; i < this.encodedCellIds.size(); ++i) {
            cellsBuilder.add((Object)new LazyCell(i));
        }
        this.cells = cellsBuilder.build();
    }

    @Override
    public S2ShapeIndex.Options options() {
        return this.options;
    }

    @Override
    public void add(S2Shape shape) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void remove(S2Shape shape) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void reset() {
        throw new UnsupportedOperationException();
    }

    @Override
    public S2Iterator<S2ShapeIndex.Cell> iterator() {
        return S2Iterator.create(this.cells, (Function<S2CellId, Integer>)((Function)this.encodedCellIds::lowerBound));
    }

    @Override
    public boolean isFresh() {
        return true;
    }

    @Override
    void applyUpdates() {
        throw new UnsupportedOperationException();
    }

    private final class LazyCell
    extends S2ShapeIndex.Cell {
        private final int i;
        private S2CellId cachedCellId = null;
        private S2ShapeIndex.S2ClippedShape[] cachedClippedShapes;

        LazyCell(int i) {
            this.i = i;
        }

        private S2ShapeIndex.S2ClippedShape[] loadClippedShapesFromCache() {
            if (this.cachedClippedShapes == null) {
                ByteBuffer buffer = EncodedS2ShapeIndex.this.encodedCells.get(this.i);
                try {
                    InputStream input = ByteBuffers.asInputStream(buffer);
                    this.cachedClippedShapes = LazyCell.decodeClippedShapes(EncodedS2ShapeIndex.this.shapes, null, input);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            return this.cachedClippedShapes;
        }

        @Override
        public long id() {
            if (this.cachedCellId == null) {
                this.cachedCellId = EncodedS2ShapeIndex.this.encodedCellIds.get(this.i);
            }
            return this.cachedCellId.id();
        }

        @Override
        public int numShapes() {
            return this.loadClippedShapesFromCache().length;
        }

        @Override
        public S2ShapeIndex.S2ClippedShape clipped(int i) {
            return this.loadClippedShapesFromCache()[i];
        }
    }
}

