/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.common.geometry;

import com.google.appengine.repackaged.com.google.common.annotations.GwtCompatible;
import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.repackaged.com.google.common.collect.Ordering;
import com.google.appengine.repackaged.com.google.common.geometry.R1Interval;
import com.google.appengine.repackaged.com.google.common.geometry.R2Rect;
import com.google.appengine.repackaged.com.google.common.geometry.R2Vector;
import com.google.appengine.repackaged.com.google.common.geometry.S1ChordAngle;
import com.google.appengine.repackaged.com.google.common.geometry.S1Interval;
import com.google.appengine.repackaged.com.google.common.geometry.S2;
import com.google.appengine.repackaged.com.google.common.geometry.S2Cap;
import com.google.appengine.repackaged.com.google.common.geometry.S2CellId;
import com.google.appengine.repackaged.com.google.common.geometry.S2EdgeUtil;
import com.google.appengine.repackaged.com.google.common.geometry.S2LatLng;
import com.google.appengine.repackaged.com.google.common.geometry.S2LatLngRect;
import com.google.appengine.repackaged.com.google.common.geometry.S2Point;
import com.google.appengine.repackaged.com.google.common.geometry.S2Projections;
import com.google.appengine.repackaged.com.google.common.geometry.S2Region;
import com.google.appengine.repackaged.com.google.common.primitives.Doubles;
import java.io.Serializable;

@GwtCompatible(serializable=true)
public strictfp final class S2Cell
implements S2Region,
Serializable {
    byte face;
    byte level;
    byte orientation;
    S2CellId cellId;
    double uMin;
    double uMax;
    double vMin;
    double vMax;
    public static final double STERADIAN_TO_M2 = 4.0538689E13;
    public static final double STERADIAN_TO_KM2 = 4.0538689E7;
    private static final double POLE_MIN_LAT = Math.asin(Math.sqrt(0.3333333333333333)) - 0.5 * S2.DBL_EPSILON;

    S2Cell() {
    }

    public S2Cell(S2CellId id) {
        this.init(id);
    }

    public static S2Cell fromFace(int face) {
        return new S2Cell(S2CellId.fromFace(face));
    }

    public static S2Cell fromFacePosLevel(int face, long pos, int level) {
        return new S2Cell(S2CellId.fromFacePosLevel(face, pos, level));
    }

    public S2Cell(S2Point p) {
        this.init(S2CellId.fromPoint(p));
    }

    public S2Cell(S2LatLng ll) {
        this.init(S2CellId.fromLatLng(ll));
    }

    public S2CellId id() {
        return this.cellId;
    }

    public int face() {
        return this.face;
    }

    public byte level() {
        return this.level;
    }

    public byte orientation() {
        return this.orientation;
    }

    public boolean isLeaf() {
        return this.level == 30;
    }

    public S2Point getVertex(int k) {
        return S2Point.normalize(this.getVertexRaw(k));
    }

    public S2Point getVertexRaw(int k) {
        return S2Projections.faceUvToXyz(this.face, (k >> 1 ^ k & 1) == 0 ? this.uMin : this.uMax, k >> 1 == 0 ? this.vMin : this.vMax);
    }

    public S2Point getEdge(int k) {
        return S2Point.normalize(this.getEdgeRaw(k));
    }

    public S2Point getEdgeRaw(int k) {
        switch (k) {
            case 0: {
                return S2Projections.getVNorm(this.face, this.vMin);
            }
            case 1: {
                return S2Projections.getUNorm(this.face, this.uMax);
            }
            case 2: {
                return S2Point.neg(S2Projections.getVNorm(this.face, this.vMax));
            }
        }
        return S2Point.neg(S2Projections.getUNorm(this.face, this.uMin));
    }

    public int getSizeIJ() {
        return S2CellId.getSizeIJ(this.level());
    }

    public boolean subdivide(S2Cell[] children) {
        if (this.cellId.isLeaf()) {
            return false;
        }
        S2CellId id = this.cellId.childBegin();
        R2Vector mid = this.getCenterUV();
        double uMid = mid.x();
        double vMid = mid.y();
        int pos = 0;
        while (pos < 4) {
            S2Cell child = children[pos];
            child.face = this.face;
            child.level = (byte)(this.level + 1);
            child.orientation = (byte)(this.orientation ^ S2.posToOrientation(pos));
            child.cellId = id;
            int ij = S2.posToIJ(this.orientation, pos);
            if ((ij & 2) != 0) {
                child.uMin = uMid;
                child.uMax = this.uMax;
            } else {
                child.uMin = this.uMin;
                child.uMax = uMid;
            }
            if ((ij & 1) != 0) {
                child.vMin = vMid;
                child.vMax = this.vMax;
            } else {
                child.vMin = this.vMin;
                child.vMax = vMid;
            }
            ++pos;
            id = id.next();
        }
        return true;
    }

    public S2Point getCenter() {
        return S2Point.normalize(this.getCenterRaw());
    }

    public S2Point getCenterRaw() {
        return this.cellId.toPointRaw();
    }

    public R2Rect getBoundUV() {
        R2Rect rect = new R2Rect();
        this.setBoundUV(rect);
        return rect;
    }

    void setBoundUV(R2Rect bound) {
        bound.x().set(this.uMin, this.uMax);
        bound.y().set(this.vMin, this.vMax);
    }

    public R2Vector getCenterUV() {
        return this.cellId.getCenterUV();
    }

    public static double averageArea(int level) {
        return S2Projections.PROJ.avgArea.getValue(level);
    }

    public static double averageAreaKm2(int level) {
        return S2Cell.averageArea(level) * 4.0538689E7;
    }

    public double averageAreaKm2() {
        return this.averageArea() * 4.0538689E7;
    }

    public static double averageAreaM2(int level) {
        return S2Cell.averageArea(level) * 4.0538689E13;
    }

    public double averageAreaM2() {
        return this.averageArea() * 4.0538689E13;
    }

    public double averageArea() {
        return S2Cell.averageArea(this.level);
    }

    public double approxArea() {
        if (this.level < 2) {
            return S2Cell.averageArea(this.level);
        }
        double flatArea = 0.5 * S2Point.crossProd(S2Point.sub(this.getVertex(2), this.getVertex(0)), S2Point.sub(this.getVertex(3), this.getVertex(1))).norm();
        return flatArea * 2.0 / (1.0 + Math.sqrt(1.0 - Math.min(0.3183098861837907 * flatArea, 1.0)));
    }

    public double approxAreaKm2() {
        return this.approxArea() * 4.0538689E7;
    }

    public double approxAreaM2() {
        return this.approxArea() * 4.0538689E13;
    }

    public double exactArea() {
        S2Point v0 = this.getVertex(0);
        S2Point v1 = this.getVertex(1);
        S2Point v2 = this.getVertex(2);
        S2Point v3 = this.getVertex(3);
        return S2.area(v0, v1, v2) + S2.area(v0, v2, v3);
    }

    public double exactAreaKm2() {
        return this.exactArea() * 4.0538689E7;
    }

    public double exactAreaM2() {
        return this.exactArea() * 4.0538689E13;
    }

    public S2Region clone() {
        S2Cell clone = new S2Cell();
        clone.face = this.face;
        clone.level = this.level;
        clone.orientation = this.orientation;
        clone.uMin = this.uMin;
        clone.uMax = this.uMax;
        clone.vMin = this.vMin;
        clone.vMax = this.vMax;
        return clone;
    }

    @Override
    public S2Cap getCapBound() {
        S2Point center = S2Point.normalize(S2Projections.faceUvToXyz(this.face, this.getCenterUV()));
        S2Cap cap = S2Cap.fromAxisHeight(center, 0.0);
        for (int k = 0; k < 4; ++k) {
            cap = cap.addPoint(this.getVertex(k));
        }
        return cap;
    }

    @Override
    public S2LatLngRect getRectBound() {
        S2LatLngRect bound;
        if (this.level > 0) {
            int i;
            double u = this.uMin + this.uMax;
            double v = this.vMin + this.vMax;
            int n = (S2Projections.getUAxis((int)this.face).z == 0.0 ? u < 0.0 : u > 0.0) ? 1 : (i = 0);
            int j = (S2Projections.getVAxis((int)this.face).z == 0.0 ? v < 0.0 : v > 0.0) ? 1 : 0;
            R1Interval lat = R1Interval.fromPointPair(S2LatLng.latitude(this.getPoint(i, j)).radians(), S2LatLng.latitude(this.getPoint(1 - i, 1 - j)).radians());
            S1Interval lng = S1Interval.fromPointPair(S2LatLng.longitude(this.getPoint(i, 1 - j)).radians(), S2LatLng.longitude(this.getPoint(1 - i, j)).radians());
            return new S2LatLngRect(lat, lng).expanded(S2LatLng.fromRadians(2.0 * S2.DBL_EPSILON, 2.0 * S2.DBL_EPSILON)).polarClosure();
        }
        switch (this.face) {
            case 0: {
                bound = new S2LatLngRect(new R1Interval(-0.7853981633974483, 0.7853981633974483), new S1Interval(-0.7853981633974483, 0.7853981633974483));
                break;
            }
            case 1: {
                bound = new S2LatLngRect(new R1Interval(-0.7853981633974483, 0.7853981633974483), new S1Interval(0.7853981633974483, 2.356194490192345));
                break;
            }
            case 2: {
                bound = new S2LatLngRect(new R1Interval(POLE_MIN_LAT, 1.5707963267948966), S1Interval.full());
                break;
            }
            case 3: {
                bound = new S2LatLngRect(new R1Interval(-0.7853981633974483, 0.7853981633974483), new S1Interval(2.356194490192345, -2.356194490192345));
                break;
            }
            case 4: {
                bound = new S2LatLngRect(new R1Interval(-0.7853981633974483, 0.7853981633974483), new S1Interval(-2.356194490192345, -0.7853981633974483));
                break;
            }
            default: {
                bound = new S2LatLngRect(new R1Interval(-1.5707963267948966, -POLE_MIN_LAT), S1Interval.full());
            }
        }
        return bound.expanded(S2LatLng.fromRadians(S2.DBL_EPSILON, 0.0));
    }

    @Override
    public boolean mayIntersect(S2Cell cell) {
        return this.cellId.intersects(cell.cellId);
    }

    @Override
    public boolean contains(S2Point p) {
        R2Vector uvPoint = S2Projections.faceXyzToUv(this.face, p);
        if (uvPoint == null) {
            return false;
        }
        return uvPoint.x() >= this.uMin && uvPoint.x() <= this.uMax && uvPoint.y() >= this.vMin && uvPoint.y() <= this.vMax;
    }

    @Override
    public boolean contains(S2Cell cell) {
        return this.cellId.contains(cell.cellId);
    }

    private double vertexChordDist2(S2Point p, boolean i, boolean j) {
        S2Point vertex = S2Point.normalize(new S2Point(i ? this.uMax : this.uMin, j ? this.vMax : this.vMin, 1.0));
        return p.getDistance2(vertex);
    }

    private boolean uEdgeIsClosest(S2Point p, boolean vEnd) {
        double v = vEnd ? this.vMax : this.vMin;
        S2Point dir0 = new S2Point(v * v + 1.0, -this.uMin * v, -this.uMin);
        S2Point dir1 = new S2Point(v * v + 1.0, -this.uMax * v, -this.uMax);
        return p.dotProd(dir0) > 0.0 && p.dotProd(dir1) < 0.0;
    }

    private boolean vEdgeIsClosest(S2Point p, boolean uEnd) {
        double u = uEnd ? this.uMax : this.uMin;
        S2Point dir0 = new S2Point(-u * this.vMin, u * u + 1.0, -this.vMin);
        S2Point dir1 = new S2Point(-u * this.vMax, u * u + 1.0, -this.vMax);
        return p.dotProd(dir0) > 0.0 && p.dotProd(dir1) < 0.0;
    }

    private static S1ChordAngle edgeDistance(double dirIJ, double uv) {
        Preconditions.checkArgument((dirIJ >= 0.0 ? 1 : 0) != 0);
        double pq2 = dirIJ * dirIJ / (1.0 + uv * uv);
        double qr = 1.0 - Math.sqrt(1.0 - pq2);
        return S1ChordAngle.fromLength2(pq2 + qr * qr);
    }

    public S1ChordAngle getDistance(S2Point targetXyz) {
        S2Point targetUvw = S2Projections.faceXyzToUvw(this.face, targetXyz);
        double dir00 = targetUvw.x - targetUvw.z * this.uMin;
        double dir01 = targetUvw.x - targetUvw.z * this.uMax;
        double dir10 = targetUvw.y - targetUvw.z * this.vMin;
        double dir11 = targetUvw.y - targetUvw.z * this.vMax;
        boolean inside = true;
        if (dir00 < 0.0) {
            inside = false;
            if (this.vEdgeIsClosest(targetUvw, false)) {
                return S2Cell.edgeDistance(-dir00, this.uMin);
            }
        }
        if (dir01 > 0.0) {
            inside = false;
            if (this.vEdgeIsClosest(targetUvw, true)) {
                return S2Cell.edgeDistance(dir01, this.uMax);
            }
        }
        if (dir10 < 0.0) {
            inside = false;
            if (this.uEdgeIsClosest(targetUvw, false)) {
                return S2Cell.edgeDistance(-dir10, this.vMin);
            }
        }
        if (dir11 > 0.0) {
            inside = false;
            if (this.uEdgeIsClosest(targetUvw, true)) {
                return S2Cell.edgeDistance(dir11, this.vMax);
            }
        }
        if (inside) {
            return S1ChordAngle.ZERO;
        }
        double chordDist2 = Math.min(Math.min(this.vertexChordDist2(targetUvw, false, false), this.vertexChordDist2(targetUvw, true, false)), Math.min(this.vertexChordDist2(targetUvw, false, true), this.vertexChordDist2(targetUvw, true, true)));
        return S1ChordAngle.fromLength2(chordDist2);
    }

    public S1ChordAngle getMaxDistance(S2Point target) {
        S2Point targetUvw = S2Projections.faceXyzToUvw(this.face, target);
        S1ChordAngle maxDist = S1ChordAngle.fromLength2(Doubles.max((double[])new double[]{this.vertexChordDist2(targetUvw, false, false), this.vertexChordDist2(targetUvw, true, false), this.vertexChordDist2(targetUvw, false, true), this.vertexChordDist2(targetUvw, true, true)}));
        if (maxDist.compareTo(S1ChordAngle.RIGHT) <= 0) {
            return maxDist;
        }
        return S1ChordAngle.sub(S1ChordAngle.STRAIGHT, this.getDistance(target.neg()));
    }

    public S1ChordAngle getDistanceToEdge(S2Point a, S2Point b) {
        int i;
        S1ChordAngle minDist = (S1ChordAngle)Ordering.natural().min((Object)this.getDistance(a), (Object)this.getDistance(b));
        if (minDist.isZero()) {
            return minDist;
        }
        S2Point[] v = new S2Point[4];
        for (int i2 = 0; i2 < 4; ++i2) {
            v[i2] = this.getVertex(i2);
        }
        S2EdgeUtil.EdgeCrosser crosser = new S2EdgeUtil.EdgeCrosser(a, b, v[3]);
        for (i = 0; i < 4; ++i) {
            if (crosser.robustCrossing(v[i]) < 0) continue;
            return S1ChordAngle.ZERO;
        }
        for (i = 0; i < 4; ++i) {
            minDist = S2EdgeUtil.updateMinDistance(v[i], a, b, minDist);
        }
        return minDist;
    }

    private void init(S2CellId id) {
        this.cellId = id;
        this.face = (byte)id.face();
        long ijo = id.toIJOrientation();
        this.orientation = (byte)S2CellId.getOrientation(ijo);
        this.level = (byte)id.level();
        int i = S2CellId.getI(ijo);
        int j = S2CellId.getJ(ijo);
        int cellSize = id.getSizeIJ();
        this.uMin = S2Projections.PROJ.ijToUV(i, cellSize);
        this.uMax = S2Projections.PROJ.ijToUV(i + cellSize, cellSize);
        this.vMin = S2Projections.PROJ.ijToUV(j, cellSize);
        this.vMax = S2Projections.PROJ.ijToUV(j + cellSize, cellSize);
    }

    private S2Point getPoint(int i, int j) {
        return S2Projections.faceUvToXyz(this.face, i == 0 ? this.uMin : this.uMax, j == 0 ? this.vMin : this.vMax);
    }

    public String toString() {
        byte by = this.face;
        byte by2 = this.level;
        byte by3 = this.orientation;
        String string = String.valueOf(this.cellId);
        return new StringBuilder(20 + String.valueOf(string).length()).append("[").append(by).append(", ").append(by2).append(", ").append(by3).append(", ").append(string).append("]").toString();
    }

    public int hashCode() {
        int value = 17;
        value = 37 * (37 * (37 * value + this.face) + this.orientation) + this.level;
        return 37 * value + this.id().hashCode();
    }

    public boolean equals(Object that) {
        if (that instanceof S2Cell) {
            S2Cell thatCell = (S2Cell)that;
            return this.face == thatCell.face && this.level == thatCell.level && this.orientation == thatCell.orientation && this.cellId.equals(thatCell.cellId);
        }
        return false;
    }
}

