/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.common.geometry;

import com.google.appengine.repackaged.com.google.common.annotations.GwtCompatible;
import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableList;
import com.google.appengine.repackaged.com.google.common.geometry.S2Point;
import com.google.appengine.repackaged.com.google.common.geometry.S2Polyline;
import com.google.appengine.repackaged.com.google.common.geometry.S2Shape;

@GwtCompatible(serializable=false)
public class S2LaxPolylineShape
implements S2Shape {
    private final ImmutableList<S2Point> vertices;

    public S2LaxPolylineShape(ImmutableList<S2Point> vertices) {
        this.vertices = vertices;
    }

    public S2LaxPolylineShape(Iterable<S2Point> vertices) {
        this((ImmutableList<S2Point>)ImmutableList.copyOf(vertices));
    }

    public S2LaxPolylineShape(S2Polyline polyline) {
        this(polyline.vertices());
    }

    public int numVertices() {
        return this.vertices.size();
    }

    public S2Point vertex(int index) {
        return (S2Point)this.vertices.get(index);
    }

    @Override
    public int dimension() {
        return 1;
    }

    public boolean isEmpty() {
        return this.numEdges() == 0;
    }

    public boolean isFull() {
        return false;
    }

    @Override
    public int numEdges() {
        return Math.max(0, this.numVertices() - 1);
    }

    @Override
    public int numChains() {
        return Math.min(1, this.numEdges());
    }

    @Override
    public void getEdge(int index, S2Shape.MutableEdge result) {
        result.set((S2Point)this.vertices.get(index), (S2Point)this.vertices.get(index + 1));
    }

    @Override
    public boolean hasInterior() {
        return false;
    }

    @Override
    public boolean containsOrigin() {
        return false;
    }

    @Override
    public int getChainStart(int chainId) {
        Preconditions.checkElementIndex((int)chainId, (int)1);
        return 0;
    }

    @Override
    public int getChainLength(int chainId) {
        Preconditions.checkElementIndex((int)chainId, (int)1);
        return this.numEdges();
    }

    @Override
    public void getChainEdge(int chainId, int offset, S2Shape.MutableEdge result) {
        Preconditions.checkElementIndex((int)chainId, (int)1);
        this.getEdge(offset, result);
    }
}

