/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.common.geometry;

import com.google.appengine.repackaged.com.google.common.annotations.GwtCompatible;
import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.repackaged.com.google.common.collect.Lists;
import com.google.appengine.repackaged.com.google.common.geometry.S2ContainsVertexQuery;
import com.google.appengine.repackaged.com.google.common.geometry.S2Edge;
import com.google.appengine.repackaged.com.google.common.geometry.S2EdgeUtil;
import com.google.appengine.repackaged.com.google.common.geometry.S2Error;
import com.google.appengine.repackaged.com.google.common.geometry.S2Iterator;
import com.google.appengine.repackaged.com.google.common.geometry.S2Loop;
import com.google.appengine.repackaged.com.google.common.geometry.S2Point;
import com.google.appengine.repackaged.com.google.common.geometry.S2Shape;
import com.google.appengine.repackaged.com.google.common.geometry.S2ShapeIndex;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

@GwtCompatible
strictfp class S2ShapeUtil {
    private static final Comparator<S2Edge> EDGE_ORDER = (e1, e2) -> {
        int result = e1.getStart().compareTo(e2.getStart());
        if (result != 0) {
            return result;
        }
        return e1.getEnd().compareTo(e2.getEnd());
    };

    private S2ShapeUtil() {
    }

    static boolean findSelfIntersection(S2ShapeIndex index, S2Loop loop, S2Error error) {
        Preconditions.checkArgument((1 == index.shapes.size() ? 1 : 0) != 0);
        S2Iterator<S2ShapeIndex.Cell> it = index.iterator();
        while (!it.done()) {
            if (S2ShapeUtil.findSelfIntersection(it.entry().clipped(0), loop, error)) {
                return true;
            }
            it.next();
        }
        return false;
    }

    static boolean findAnyCrossing(S2ShapeIndex index, List<S2Loop> loops, S2Error error) {
        S2Iterator<S2ShapeIndex.Cell> it = index.iterator();
        while (!it.done()) {
            if (S2ShapeUtil.findSelfIntersection(loops, it.entry(), error)) {
                return true;
            }
            if (it.entry().numShapes() >= 2 && S2ShapeUtil.findLoopCrossing(loops, it.entry(), error)) {
                return true;
            }
            it.next();
        }
        return false;
    }

    static boolean findSelfIntersection(S2ShapeIndex.S2ClippedShape aClipped, S2Loop aLoop, S2Error error) {
        int aNumClipped = aClipped.numEdges();
        for (int i = 0; i < aNumClipped - 1; ++i) {
            int aj;
            int ai = aClipped.edge(i);
            int j = i + 1;
            if (aClipped.edge(j) == ai + 1 && ++j >= aNumClipped) continue;
            S2EdgeUtil.EdgeCrosser crosser = new S2EdgeUtil.EdgeCrosser(aLoop.vertex(ai), aLoop.vertex(ai + 1));
            int ajPrev = -2;
            while (j < aNumClipped && (aj = aClipped.edge(j)) - ai != aLoop.numVertices() - 1) {
                if (aj != ajPrev + 1) {
                    crosser.restartAt(aLoop.vertex(aj));
                }
                ajPrev = aj;
                int crossing = crosser.robustCrossing(aLoop.vertex(aj + 1));
                if (crossing >= 0) {
                    if (crossing == 0) {
                        error.init(S2Error.Code.DUPLICATE_VERTICES, "Edge %d has duplicate vertex with edge %d", ai, aj);
                    } else {
                        error.init(S2Error.Code.LOOP_SELF_INTERSECTION, "Edge %d crosses edge %d", ai, aj);
                    }
                    return true;
                }
                ++j;
            }
        }
        return false;
    }

    static int indexOf(List<? extends S2Shape> shapes, S2Shape shape) {
        for (int i = 0; i < shapes.size(); ++i) {
            if (shapes.get(i) != shape) continue;
            return i;
        }
        return -1;
    }

    static boolean findSelfIntersection(List<S2Loop> loops, S2ShapeIndex.Cell cell, S2Error error) {
        for (int a = 0; a < cell.numShapes(); ++a) {
            S2Loop loop;
            S2ShapeIndex.S2ClippedShape aClipped = cell.clipped(a);
            if (!S2ShapeUtil.findSelfIntersection(aClipped, loop = (S2Loop)aClipped.shape(), error)) continue;
            error.init(error.code(), "Loop %d: %s", S2ShapeUtil.indexOf(loops, loop), error.text());
            return true;
        }
        return false;
    }

    static boolean getCrossingError(List<S2Loop> loops, S2Loop aLoop, int ai, S2Loop bLoop, int bj, int crossing, S2Error error) {
        if (crossing > 0) {
            error.init(S2Error.Code.POLYGON_LOOPS_CROSS, "Loop %d edge %d crosses loop %d edge %d", S2ShapeUtil.indexOf(loops, aLoop), ai, S2ShapeUtil.indexOf(loops, bLoop), bj);
            return true;
        }
        if (aLoop.vertex(ai + 1).equalsPoint(bLoop.vertex(bj + 1))) {
            if (aLoop.vertex(ai).equalsPoint(bLoop.vertex(bj)) || aLoop.vertex(ai).equalsPoint(bLoop.vertex(bj + 2))) {
                error.init(S2Error.Code.POLYGON_LOOPS_SHARE_EDGE, "Loop %d edge %d has duplicate near loop %d edge %d", S2ShapeUtil.indexOf(loops, aLoop), ai, S2ShapeUtil.indexOf(loops, bLoop), bj);
                return true;
            }
            if (S2EdgeUtil.WedgeRelation.WEDGE_PROPERLY_OVERLAPS == S2EdgeUtil.getWedgeRelation(aLoop.vertex(ai), aLoop.vertex(ai + 1), aLoop.vertex(ai + 2), bLoop.vertex(bj), bLoop.vertex(bj + 2))) {
                error.init(S2Error.Code.POLYGON_LOOPS_CROSS, "Loop %d edge %d crosses loop %d edge %d", S2ShapeUtil.indexOf(loops, aLoop), ai, S2ShapeUtil.indexOf(loops, bLoop), bj);
                return true;
            }
        }
        return false;
    }

    static boolean findLoopCrossing(List<S2Loop> loops, S2ShapeIndex.Cell cell, S2Error error) {
        for (int a = 0; a < cell.numShapes() - 1; ++a) {
            S2ShapeIndex.S2ClippedShape aClipped = cell.clipped(a);
            S2Loop aLoop = (S2Loop)aClipped.shape();
            int aNumClipped = aClipped.numEdges();
            for (int i = 0; i < aNumClipped; ++i) {
                int ai = aClipped.edge(i);
                S2EdgeUtil.EdgeCrosser crosser = new S2EdgeUtil.EdgeCrosser(aLoop.vertex(ai), aLoop.vertex(ai + 1));
                for (int b = a + 1; b < cell.numShapes(); ++b) {
                    S2ShapeIndex.S2ClippedShape bClipped = cell.clipped(b);
                    S2Loop bLoop = (S2Loop)bClipped.shape();
                    int bjPrev = -2;
                    int bNumClipped = bClipped.numEdges();
                    for (int j = 0; j < bNumClipped; ++j) {
                        int bj = bClipped.edge(j);
                        if (bj != bjPrev + 1) {
                            crosser.restartAt(bLoop.vertex(bj));
                        }
                        bjPrev = bj;
                        int crossing = crosser.robustCrossing(bLoop.vertex(bj + 1));
                        if (crossing < 0 || !S2ShapeUtil.getCrossingError(loops, aLoop, ai, bLoop, bj, crossing, error)) continue;
                        return true;
                    }
                }
            }
        }
        return false;
    }

    public static boolean equals(S2Shape a, S2Shape b) {
        if (a == null) {
            return b == null;
        }
        if (b == null) {
            return a == null;
        }
        if (a.hasInterior() != b.hasInterior()) {
            return false;
        }
        if (a.hasInterior() && a.containsOrigin() != b.containsOrigin()) {
            return false;
        }
        if (a.dimension() != b.dimension()) {
            return false;
        }
        if (a.numChains() != b.numChains()) {
            return false;
        }
        for (int i = 0; i < a.numChains(); ++i) {
            if (a.getChainStart(i) != b.getChainStart(i)) {
                return false;
            }
            if (a.getChainLength(i) == b.getChainLength(i)) continue;
            return false;
        }
        if (a.numEdges() != b.numEdges()) {
            return false;
        }
        S2Shape.MutableEdge edge = new S2Shape.MutableEdge();
        for (int i = 0; i < a.numEdges(); ++i) {
            a.getEdge(i, edge);
            S2Point p = edge.a;
            S2Point q = edge.b;
            b.getEdge(i, edge);
            if (p.equalsPoint(edge.a) && q.equalsPoint(edge.b)) continue;
            return false;
        }
        return true;
    }

    public static boolean equals(List<S2Shape> a, List<S2Shape> b) {
        if (a.size() != b.size()) {
            return false;
        }
        for (int i = 0; i < a.size(); ++i) {
            if (S2ShapeUtil.equals(a.get(i), b.get(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean equals(S2ShapeIndex.S2ClippedShape a, S2ShapeIndex.S2ClippedShape b) {
        if (a.containsCenter() != b.containsCenter()) {
            return false;
        }
        if (a.numEdges() != b.numEdges()) {
            return false;
        }
        for (int i = 0; i < a.numEdges(); ++i) {
            if (a.edge(i) == b.edge(i)) continue;
            return false;
        }
        return true;
    }

    public static boolean equals(S2ShapeIndex.Cell a, S2ShapeIndex.Cell b) {
        if (a.id() != b.id()) {
            return false;
        }
        if (a.numShapes() != b.numShapes()) {
            return false;
        }
        for (int i = 0; i < a.numShapes(); ++i) {
            if (S2ShapeUtil.equals(a.clipped(i), b.clipped(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean equals(S2ShapeIndex a, S2ShapeIndex b) {
        if (!S2ShapeUtil.equals(a.getShapes(), b.getShapes())) {
            return false;
        }
        S2Iterator<S2ShapeIndex.Cell> aIt = a.iterator();
        S2Iterator<S2ShapeIndex.Cell> bIt = b.iterator();
        while (!aIt.done()) {
            if (bIt.done()) {
                return false;
            }
            if (!S2ShapeUtil.equals(aIt.entry(), bIt.entry())) {
                return false;
            }
            aIt.next();
            bIt.next();
        }
        return bIt.done();
    }

    public static boolean containsBruteForce(S2Shape shape, S2Point point) {
        if (shape.dimension() < 2) {
            return false;
        }
        S2Shape.ReferencePoint refPoint = shape.getReferencePoint();
        if (refPoint.equalsPoint(point)) {
            return refPoint.contained();
        }
        S2EdgeUtil.EdgeCrosser crosser = new S2EdgeUtil.EdgeCrosser(refPoint, point);
        boolean inside = refPoint.contained();
        S2Shape.MutableEdge edge = new S2Shape.MutableEdge();
        for (int i = 0; i < shape.numEdges(); ++i) {
            shape.getEdge(i, edge);
            inside ^= crosser.edgeOrVertexCrossing(edge.getStart(), edge.getEnd());
        }
        return inside;
    }

    public static S2Shape.ReferencePoint getReferencePoint(S2Shape shape) {
        int i;
        assert (shape.dimension() == 2);
        if (shape.numEdges() == 0) {
            return S2Shape.ReferencePoint.create(shape.numChains() > 0);
        }
        S2Shape.MutableEdge edge = new S2Shape.MutableEdge();
        shape.getEdge(0, edge);
        Boolean result = S2ShapeUtil.getReferencePointAtVertex(shape, edge.a);
        if (null != result) {
            return S2Shape.ReferencePoint.create(edge.a, result);
        }
        int n = shape.numEdges();
        ArrayList<S2Edge> fwdEdges = new ArrayList<S2Edge>(n);
        ArrayList<S2Edge> revEdges = new ArrayList<S2Edge>(n);
        for (i = 0; i < n; ++i) {
            shape.getEdge(i, edge);
            fwdEdges.add(new S2Edge(edge.a, edge.b));
            revEdges.add(new S2Edge(edge.b, edge.a));
        }
        Collections.sort(fwdEdges, EDGE_ORDER);
        Collections.sort(revEdges, EDGE_ORDER);
        for (i = 0; i < n; ++i) {
            S2Point v;
            S2Edge rev;
            S2Edge fwd = (S2Edge)fwdEdges.get(i);
            int cmp = EDGE_ORDER.compare(fwd, rev = (S2Edge)revEdges.get(i));
            if (cmp < 0) {
                v = fwd.getStart();
            } else {
                if (cmp <= 0) continue;
                v = rev.getStart();
            }
            return S2Shape.ReferencePoint.create(v, S2ShapeUtil.getReferencePointAtVertex(shape, v));
        }
        for (i = 0; i < shape.numChains(); ++i) {
            if (shape.getChainLength(i) != 0) continue;
            return S2Shape.ReferencePoint.create(true);
        }
        return S2Shape.ReferencePoint.create(false);
    }

    private static Boolean getReferencePointAtVertex(S2Shape shape, S2Point vtest) {
        S2ContainsVertexQuery query = new S2ContainsVertexQuery(vtest);
        S2Shape.MutableEdge edge = new S2Shape.MutableEdge();
        int n = shape.numEdges();
        for (int e = 0; e < n; ++e) {
            shape.getEdge(e, edge);
            if (vtest.equalsPoint(edge.a)) {
                query.addOutgoing(edge.b);
            }
            if (!vtest.equalsPoint(edge.b)) continue;
            query.addIncoming(edge.a);
        }
        int containsSign = query.containsSign();
        if (containsSign == 0) {
            return null;
        }
        return containsSign > 0;
    }

    strictfp static class S2EdgeVectorShape
    extends AbstractList<S2Edge>
    implements S2Shape {
        private final List<S2Edge> edges = Lists.newArrayList();

        public S2EdgeVectorShape() {
        }

        public S2EdgeVectorShape(S2Point a, S2Point b) {
            this.add(a, b);
        }

        public void add(S2Point a, S2Point b) {
            Preconditions.checkArgument((!a.equalsPoint(b) ? 1 : 0) != 0);
            this.edges.add(new S2Edge(a, b));
        }

        @Override
        public void getEdge(int index, S2Shape.MutableEdge result) {
            S2Edge edge = this.edges.get(index);
            result.set(edge.getStart(), edge.getEnd());
        }

        @Override
        public boolean hasInterior() {
            return false;
        }

        @Override
        public boolean containsOrigin() {
            return false;
        }

        @Override
        public int numEdges() {
            return this.edges.size();
        }

        @Override
        public int numChains() {
            return this.edges.size();
        }

        @Override
        public int getChainStart(int chainId) {
            Preconditions.checkElementIndex((int)chainId, (int)this.numChains());
            return chainId;
        }

        @Override
        public int getChainLength(int chainId) {
            Preconditions.checkElementIndex((int)chainId, (int)this.numChains());
            return 1;
        }

        @Override
        public void getChainEdge(int chainId, int offset, S2Shape.MutableEdge result) {
            Preconditions.checkElementIndex((int)offset, (int)this.getChainLength(chainId));
            this.getEdge(chainId, result);
        }

        @Override
        public int dimension() {
            return 1;
        }

        @Override
        public S2Edge get(int index) {
            return this.edges.get(index);
        }

        @Override
        public int size() {
            return this.edges.size();
        }
    }
}

