/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.common.geometry;

import com.google.appengine.repackaged.com.google.common.annotations.GwtIncompatible;
import com.google.appengine.repackaged.com.google.common.geometry.ByteBuffers;
import com.google.appengine.repackaged.com.google.common.geometry.EncodedInts;
import com.google.appengine.repackaged.com.google.common.math.IntMath;
import com.google.appengine.repackaged.com.google.common.primitives.ImmutableIntArray;
import com.google.appengine.repackaged.com.google.common.primitives.ImmutableLongArray;
import com.google.appengine.repackaged.com.google.common.primitives.Ints;
import com.google.appengine.repackaged.com.google.common.primitives.UnsignedLongs;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

@GwtIncompatible(value="Uses ByteBuffer")
class EncodedUintVector {
    private final ByteBuffer data;
    private final InputStream input;
    private final int offset;
    private final int size;
    private final int bytesPerWord;

    public static EncodedUintVector createEncodedUint64Vector(ByteBuffer buffer) throws IOException {
        return new EncodedUintVector(buffer, 8);
    }

    public static EncodedUintVector createEncodedUint32Vector(ByteBuffer buffer) throws IOException {
        return new EncodedUintVector(buffer, 4);
    }

    private EncodedUintVector(ByteBuffer buffer, int typeBytes) throws IOException {
        this.data = buffer.order() == ByteOrder.LITTLE_ENDIAN ? buffer : buffer.duplicate().order(ByteOrder.LITTLE_ENDIAN);
        this.input = ByteBuffers.asInputStream(this.data);
        int totalBytes = Ints.checkedCast((long)EncodedInts.readVarint64(this.input));
        this.offset = this.data.position();
        this.size = totalBytes / typeBytes;
        this.bytesPerWord = (totalBytes & typeBytes - 1) + 1;
        buffer.position(IntMath.checkedAdd((int)this.offset, (int)(this.size * this.bytesPerWord)));
    }

    public static void encodeUint64Vector(ImmutableLongArray v, OutputStream output) throws IOException {
        long oneBits = 1L;
        for (int i = 0; i < v.length(); ++i) {
            oneBits |= v.get(i);
        }
        int bytesPerWord = (63 - Long.numberOfLeadingZeros(oneBits) >>> 3) + 1;
        long totalBytes = (long)v.length() * 8L | (long)(bytesPerWord - 1);
        EncodedInts.writeVarint64(output, totalBytes);
        for (int i = 0; i < v.length(); ++i) {
            EncodedInts.encodeUintWithLength(output, v.get(i), bytesPerWord);
        }
    }

    public static void encodeUint32Vector(ImmutableIntArray v, OutputStream output) throws IOException {
        int oneBits = 1;
        for (int i = 0; i < v.length(); ++i) {
            oneBits |= v.get(i);
        }
        int bytesPerWord = (31 - Integer.numberOfLeadingZeros(oneBits) >>> 3) + 1;
        long totalBytes = (long)v.length() * 4L | (long)(bytesPerWord - 1);
        EncodedInts.writeVarint64(output, totalBytes);
        for (int i = 0; i < v.length(); ++i) {
            EncodedInts.encodeUintWithLength(output, (long)v.get(i) & 0xFFFFFFFFL, bytesPerWord);
        }
    }

    public long get(int i) {
        this.data.position(this.offset + i * this.bytesPerWord);
        try {
            return EncodedInts.decodeUintWithLength(this.input, this.bytesPerWord);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public int getInt(int i) {
        return Ints.checkedCast((long)this.get(i));
    }

    public int lowerBound(long target) {
        int low = 0;
        int high = this.size;
        while (low < high) {
            int mid = low + high >> 1;
            long value = this.get(mid);
            if (UnsignedLongs.compare((long)value, (long)target) < 0) {
                low = mid + 1;
                continue;
            }
            high = mid;
        }
        return low;
    }

    public int size() {
        return this.size;
    }

    public int[] toIntArray() {
        int[] result = new int[this.size()];
        for (int i = 0; i < this.size(); ++i) {
            result[i] = this.getInt(i);
        }
        return result;
    }
}

