/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.common.geometry;

import com.google.appengine.repackaged.com.google.common.annotations.GwtCompatible;
import com.google.appengine.repackaged.com.google.common.annotations.GwtIncompatible;
import com.google.appengine.repackaged.com.google.common.annotations.VisibleForTesting;
import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableList;
import com.google.appengine.repackaged.com.google.common.collect.ListMultimap;
import com.google.appengine.repackaged.com.google.common.collect.Lists;
import com.google.appengine.repackaged.com.google.common.collect.Maps;
import com.google.appengine.repackaged.com.google.common.collect.Multimap;
import com.google.appengine.repackaged.com.google.common.collect.Multimaps;
import com.google.appengine.repackaged.com.google.common.geometry.EncodedByteArrayVector;
import com.google.appengine.repackaged.com.google.common.geometry.EncodedInts;
import com.google.appengine.repackaged.com.google.common.geometry.EncodedS2CellIdVector;
import com.google.appengine.repackaged.com.google.common.geometry.R1Interval;
import com.google.appengine.repackaged.com.google.common.geometry.R2Rect;
import com.google.appengine.repackaged.com.google.common.geometry.R2Vector;
import com.google.appengine.repackaged.com.google.common.geometry.S2;
import com.google.appengine.repackaged.com.google.common.geometry.S2CellId;
import com.google.appengine.repackaged.com.google.common.geometry.S2CellUnion;
import com.google.appengine.repackaged.com.google.common.geometry.S2EdgeUtil;
import com.google.appengine.repackaged.com.google.common.geometry.S2Iterator;
import com.google.appengine.repackaged.com.google.common.geometry.S2PaddedCell;
import com.google.appengine.repackaged.com.google.common.geometry.S2Point;
import com.google.appengine.repackaged.com.google.common.geometry.S2Projections;
import com.google.appengine.repackaged.com.google.common.geometry.S2Shape;
import com.google.appengine.repackaged.com.google.common.primitives.Ints;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.RandomAccess;
import javax.annotation.Nullable;

@GwtCompatible
public strictfp class S2ShapeIndex
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final double CELL_PADDING = 2.0 * (S2EdgeUtil.FACE_CLIP_ERROR_UV_COORD + S2EdgeUtil.EDGE_CLIP_ERROR_UV_COORD);
    public static final int CURRENT_ENCODING_VERSION = 0;
    private final Options options;
    protected List<S2Shape> shapes;
    private List<Cell> cells = Collections.emptyList();
    private int pendingInsertionsBegin = 0;
    private final List<S2Shape> pendingRemovals = Lists.newArrayList();
    private volatile boolean isIndexFresh = true;

    public S2ShapeIndex() {
        this(new Options());
    }

    public S2ShapeIndex(Options options) {
        this.options = options;
        this.shapes = new ArrayList<S2Shape>();
    }

    public Options options() {
        return this.options;
    }

    public List<S2Shape> getShapes() {
        return Collections.unmodifiableList(this.shapes);
    }

    public void add(S2Shape shape) {
        this.shapes.add(shape);
        this.isIndexFresh = false;
    }

    public void remove(S2Shape shape) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public void reset() {
        this.cells = Collections.emptyList();
        this.pendingRemovals.clear();
        this.shapes.clear();
        this.isIndexFresh = false;
        this.pendingInsertionsBegin = 0;
    }

    public S2Iterator<Cell> iterator() {
        this.applyUpdates();
        return S2Iterator.create(this.cells);
    }

    public boolean isFresh() {
        return this.isIndexFresh;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    void applyUpdates() {
        if (this.isIndexFresh) {
            return;
        }
        S2ShapeIndex s2ShapeIndex = this;
        synchronized (s2ShapeIndex) {
            if (!this.isIndexFresh) {
                Preconditions.checkState((boolean)this.cells.isEmpty(), (Object)"Incremental updates not supported yet");
                int numEdges = 0;
                for (int i = this.pendingInsertionsBegin; i < this.shapes.size(); ++i) {
                    numEdges += this.shapes.get(i).numEdges();
                }
                this.cells = S2ShapeIndex.createList(3 * numEdges / this.options.maxEdgesPerCell / 4);
                List<List<FaceEdge>> allEdges = S2ShapeIndex.createList(6);
                for (int face = 0; face < 6; ++face) {
                    List edges = S2ShapeIndex.createList(numEdges);
                    allEdges.add(edges);
                }
                InteriorTracker tracker = new InteriorTracker(this, this.shapes.size() - this.pendingInsertionsBegin);
                for (int i = this.pendingInsertionsBegin; i < this.shapes.size(); ++i) {
                    this.addShapeEdges(i, allEdges, tracker);
                }
                for (int face = 0; face < 6; ++face) {
                    this.updateFaceEdges(face, allEdges.get(face), tracker);
                    allEdges.set(face, null);
                }
                this.pendingInsertionsBegin = this.shapes.size();
                this.isIndexFresh = true;
            }
        }
    }

    @GwtIncompatible(value="Uses ByteBuffer")
    public void encode(OutputStream output) throws IOException {
        long maxEdges = this.options().getMaxEdgesPerCell();
        EncodedInts.writeVarint64(output, maxEdges << 2 | 0L);
        ArrayList<S2CellId> cellIds = new ArrayList<S2CellId>();
        EncodedByteArrayVector.Encoder encodedCells = new EncodedByteArrayVector.Encoder();
        ListMultimap shapeIds = Multimaps.newListMultimap((Map)Maps.newIdentityHashMap(), Lists::newArrayList);
        for (S2Shape shape : this.shapes) {
            shapeIds.put((Object)shape, (Object)shapeIds.size());
        }
        S2Iterator<Cell> it = this.iterator();
        while (!it.done()) {
            cellIds.add(it.id());
            it.entry().encode((Multimap<S2Shape, Integer>)shapeIds, encodedCells.addViaOutputStream());
            it.next();
        }
        EncodedS2CellIdVector.encode(cellIds, output);
        encodedCells.encode(output);
    }

    private void reserveSpace(int numEdges, List<List<FaceEdge>> allEdges) {
        int maxCheapMemoryBytes = 0xA00000;
        int faceEdgeSize = 140;
        int maxCheapNumEdges = 12483;
        if (numEdges <= 12483) {
            for (int face = 0; face < 6; ++face) {
                SimpleList edges = new SimpleList(numEdges);
                allEdges.add(edges);
            }
            return;
        }
        int desiredSampleSize = 10000;
        int sampleInterval = Math.max(1, numEdges / 10000);
        int edgeId = sampleInterval / 2;
        S2Shape.MutableEdge edge = new S2Shape.MutableEdge();
        int actualSampleSize = (numEdges + edgeId) / sampleInterval;
        int[] faceCount = new int[]{0, 0, 0, 0, 0, 0};
        for (int i = this.pendingInsertionsBegin; i < this.shapes.size(); ++i) {
            S2Shape shape = this.shapes.get(i);
            edgeId += shape.numEdges();
            while (edgeId >= sampleInterval) {
                shape.getEdge(edgeId -= sampleInterval, edge);
                int n = S2Projections.xyzToFace(edge.a);
                faceCount[n] = faceCount[n] + 1;
            }
        }
        double maxSemiWidth = 0.02;
        double sampleRatio = 1.0 / (double)actualSampleSize;
        for (int face = 0; face < 6; ++face) {
            SimpleList edges;
            if (faceCount[face] > 0) {
                int fraction = (int)(sampleRatio * (double)faceCount[face] + 0.02);
                edges = new SimpleList(1 + fraction * numEdges);
            } else {
                edges = new SimpleList(1);
            }
            allEdges.add(edges);
        }
    }

    private void addShapeEdges(int shapeId, List<List<FaceEdge>> allEdges, InteriorTracker tracker) {
        S2Shape shape = this.shapes.get(shapeId);
        boolean hasInterior = shape.hasInterior();
        if (hasInterior) {
            tracker.addShape(shapeId, shape);
        }
        int numEdges = shape.numEdges();
        S2Shape.MutableEdge edge = new S2Shape.MutableEdge();
        R2Vector a = new R2Vector();
        R2Vector b = new R2Vector();
        double ratio = this.options.getCellSizeToLongEdgeRatio();
        for (int e = 0; e < numEdges; ++e) {
            int aFace;
            shape.getEdge(e, edge);
            if (hasInterior) {
                tracker.testEdge(shapeId, edge.a, edge.b);
            }
            if ((aFace = S2Projections.xyzToFace(edge.a)) == S2Projections.xyzToFace(edge.b)) {
                S2Projections.validFaceXyzToUv(aFace, edge.a, a);
                S2Projections.validFaceXyzToUv(aFace, edge.b, b);
                double kMaxUV = 1.0 - CELL_PADDING;
                if (Math.abs(a.x) <= kMaxUV && Math.abs(a.y) <= kMaxUV && Math.abs(b.x) <= kMaxUV && Math.abs(b.y) <= kMaxUV) {
                    allEdges.get(aFace).add(new FaceEdge(shapeId, e, edge.a, edge.b, a, b, ratio));
                    continue;
                }
            }
            for (int face = 0; face < 6; ++face) {
                if (!S2EdgeUtil.clipToPaddedFace(edge.a, edge.b, face, CELL_PADDING, a, b)) continue;
                allEdges.get(face).add(new FaceEdge(shapeId, e, edge.a, edge.b, a, b, ratio));
            }
        }
    }

    private void updateFaceEdges(int face, List<FaceEdge> faceEdges, InteriorTracker tracker) {
        S2CellId shrunkId;
        int numEdges = faceEdges.size();
        if (numEdges == 0 && tracker.focusCount == 0) {
            return;
        }
        List<ClippedEdge> clippedEdges = S2ShapeIndex.createList(numEdges);
        R2Rect bound = R2Rect.empty();
        for (int i = 0; i < numEdges; ++i) {
            FaceEdge edge = faceEdges.get(i);
            ClippedEdge clipped = new ClippedEdge();
            clipped.orig = edge;
            clipped.bound.x().initFromPointPair(edge.ax, edge.bx);
            clipped.bound.y().initFromPointPair(edge.ay, edge.by);
            clippedEdges.add(clipped);
            bound.addRect(clipped.bound);
        }
        S2CellId faceId = S2CellId.fromFace(face);
        S2PaddedCell pcell = new S2PaddedCell(faceId, CELL_PADDING);
        EdgeAllocator alloc = new EdgeAllocator(clippedEdges.size());
        if (numEdges > 0 && (shrunkId = pcell.shrinkToFit(bound)).id() != pcell.id().id()) {
            this.skipCellRange(faceId.rangeMin(), shrunkId.rangeMin(), tracker);
            pcell = new S2PaddedCell(shrunkId, CELL_PADDING);
            this.updateEdges(pcell, clippedEdges, tracker, alloc);
            this.skipCellRange(shrunkId.rangeMax().next(), faceId.rangeMax().next(), tracker);
            return;
        }
        this.updateEdges(pcell, clippedEdges, tracker, alloc);
    }

    private void skipCellRange(S2CellId begin, S2CellId end, InteriorTracker tracker) {
        if (tracker.focusCount > 0) {
            S2CellUnion skipped = new S2CellUnion();
            skipped.initFromBeginEnd(begin, end);
            List<ClippedEdge> clippedEdges = Collections.emptyList();
            for (int i = 0; i < skipped.size(); ++i) {
                this.makeLeafCell(new S2PaddedCell(skipped.cellId(i), CELL_PADDING), clippedEdges, tracker);
            }
        }
    }

    void updateEdges(S2PaddedCell pcell, List<ClippedEdge> edges, InteriorTracker tracker, EdgeAllocator alloc) {
        int numEdges = edges.size();
        int count = 0;
        boolean isLeaf = true;
        for (int i = 0; i < numEdges; ++i) {
            ClippedEdge edge = edges.get(i);
            if ((count += pcell.level() < edge.orig.maxLevel ? 1 : 0) <= this.options.getMaxEdgesPerCell()) continue;
            isLeaf = false;
            break;
        }
        if (isLeaf) {
            this.makeLeafCell(pcell, edges, tracker);
            return;
        }
        List<ClippedEdge> edges00 = S2ShapeIndex.createList(numEdges);
        List<ClippedEdge> edges01 = S2ShapeIndex.createList(numEdges);
        List<ClippedEdge> edges10 = S2ShapeIndex.createList(numEdges);
        List<ClippedEdge> edges11 = S2ShapeIndex.createList(numEdges);
        ImmutableList ijEdges = ImmutableList.of(edges00, edges01, edges10, edges11);
        int allocSize = alloc.size();
        R2Rect middle = pcell.middle();
        for (int i = 0; i < numEdges; ++i) {
            ClippedEdge edge = edges.get(i);
            if (edge.bound.x().hi() <= middle.x().lo()) {
                S2ShapeIndex.clipVAxis(edge, middle.y(), edges00, edges01, alloc);
                continue;
            }
            if (edge.bound.x().lo() >= middle.x().hi()) {
                S2ShapeIndex.clipVAxis(edge, middle.y(), edges10, edges11, alloc);
                continue;
            }
            if (edge.bound.y().hi() <= middle.y().lo()) {
                edges00.add(S2ShapeIndex.clipUBound(edge, true, middle.x().hi(), alloc));
                edges10.add(S2ShapeIndex.clipUBound(edge, false, middle.x().lo(), alloc));
                continue;
            }
            if (edge.bound.y().lo() >= middle.y().hi()) {
                edges01.add(S2ShapeIndex.clipUBound(edge, true, middle.x().hi(), alloc));
                edges11.add(S2ShapeIndex.clipUBound(edge, false, middle.x().lo(), alloc));
                continue;
            }
            ClippedEdge left = S2ShapeIndex.clipUBound(edge, true, middle.x().hi(), alloc);
            S2ShapeIndex.clipVAxis(left, middle.y(), edges00, edges01, alloc);
            ClippedEdge right = S2ShapeIndex.clipUBound(edge, false, middle.x().lo(), alloc);
            S2ShapeIndex.clipVAxis(right, middle.y(), edges10, edges11, alloc);
        }
        for (int pos = 0; pos < 4; ++pos) {
            List childEdges = (List)ijEdges.get(S2.posToIJ(pcell.orientation(), pos));
            if (childEdges.isEmpty() && tracker.focusCount <= 0) continue;
            S2PaddedCell childCell = pcell.childAtPos(pos);
            this.updateEdges(childCell, childEdges, tracker, alloc);
        }
        alloc.reset(allocSize);
    }

    private void makeLeafCell(S2PaddedCell pcell, List<ClippedEdge> edges, InteriorTracker tracker) {
        int numEdges = edges.size();
        if (tracker.isActive() && numEdges > 0) {
            if (!tracker.atCellId(pcell.id())) {
                tracker.moveTo(pcell.getEntryVertex());
            }
            tracker.drawTo(pcell.getCenter());
            for (int i = 0; i < numEdges; ++i) {
                ClippedEdge edge = edges.get(i);
                FaceEdge orig = edge.orig;
                if (!this.shapes.get(orig.shapeId).hasInterior()) continue;
                tracker.testEdge(orig.shapeId, orig.va, orig.vb);
            }
        }
        S2CellId cellId = pcell.id();
        int numShapes = 0;
        int edgesIndex = 0;
        int trackerIndex = 0;
        int nextShapeId = this.shapes.size();
        while (edgesIndex < numEdges || trackerIndex < tracker.focusCount) {
            S2ClippedShape clipped;
            int edgeId = edgesIndex < numEdges ? edges.get(edgesIndex).orig.shapeId : nextShapeId;
            int trackerId = trackerIndex < tracker.focusCount ? tracker.focusedShapes[trackerIndex] : nextShapeId;
            if (trackerId < edgeId) {
                clipped = S2ClippedShape.Contained.create(cellId, this.shapes.get(trackerId));
                cellId = null;
                ++trackerIndex;
            } else {
                int firstEdge = edgesIndex;
                while (edgesIndex < numEdges && edges.get(edgesIndex).orig.shapeId == edgeId) {
                    ++edgesIndex;
                }
                boolean containsCenter = trackerId == edgeId;
                clipped = S2ClippedShape.create(cellId, this.shapes.get(edgeId), containsCenter, edges, firstEdge, edgesIndex);
                cellId = null;
                if (containsCenter) {
                    ++trackerIndex;
                }
            }
            ((InteriorTracker)tracker).tempClippedShapes[numShapes++] = clipped;
        }
        this.cells.add(Cell.create(numShapes, tracker.tempClippedShapes));
        if (tracker.isActive() && !edges.isEmpty()) {
            tracker.drawTo(pcell.getExitVertex());
            for (int i = 0; i < numEdges; ++i) {
                ClippedEdge edge = edges.get(i);
                FaceEdge orig = edge.orig;
                if (!this.shapes.get(orig.shapeId).hasInterior()) continue;
                tracker.testEdge(orig.shapeId, orig.va, orig.vb);
            }
            tracker.doneCellId(pcell.id());
        }
    }

    private static ClippedEdge updateBound(ClippedEdge edge, boolean uEnd, double u, boolean vEnd, double v, EdgeAllocator alloc) {
        ClippedEdge clipped = alloc.create();
        clipped.orig = edge.orig;
        if (uEnd) {
            clipped.bound.x().set(edge.bound.x().lo(), u);
        } else {
            clipped.bound.x().set(u, edge.bound.x().hi());
        }
        if (vEnd) {
            clipped.bound.y().set(edge.bound.y().lo(), v);
        } else {
            clipped.bound.y().set(v, edge.bound.y().hi());
        }
        return clipped;
    }

    private static ClippedEdge clipUBound(ClippedEdge edge, boolean uEnd, double u, EdgeAllocator alloc) {
        if (!uEnd ? edge.bound.x().lo() >= u : edge.bound.x().hi() <= u) {
            return edge;
        }
        FaceEdge e = edge.orig;
        double v = edge.bound.y().clampPoint(S2EdgeUtil.interpolateDouble(u, e.ax, e.bx, e.ay, e.by));
        boolean vEnd = e.ax > e.bx != e.ay > e.by ^ uEnd;
        return S2ShapeIndex.updateBound(edge, uEnd, u, vEnd, v, alloc);
    }

    private static ClippedEdge clipVBound(ClippedEdge edge, boolean vEnd, double v, EdgeAllocator alloc) {
        if (!vEnd ? edge.bound.y().lo() >= v : edge.bound.y().hi() <= v) {
            return edge;
        }
        FaceEdge e = edge.orig;
        double u = edge.bound.x().clampPoint(S2EdgeUtil.interpolateDouble(v, e.ay, e.by, e.ax, e.bx));
        boolean uEnd = e.ax > e.bx != e.ay > e.by ^ vEnd;
        return S2ShapeIndex.updateBound(edge, uEnd, u, vEnd, v, alloc);
    }

    private static void clipVAxis(ClippedEdge edge, R1Interval middle, List<ClippedEdge> edges0, List<ClippedEdge> edges1, EdgeAllocator alloc) {
        if (edge.bound.y().hi() <= middle.lo()) {
            edges0.add(edge);
        } else if (edge.bound.y().lo() >= middle.hi()) {
            edges1.add(edge);
        } else {
            edges0.add(S2ShapeIndex.clipVBound(edge, true, middle.hi(), alloc));
            edges1.add(S2ShapeIndex.clipVBound(edge, false, middle.lo(), alloc));
        }
    }

    @VisibleForTesting
    static final int getEdgeMaxLevel(S2Point va, S2Point vb, double cellSizeToLongEdgeRatio) {
        double cellSize = va.getDistance(vb) * cellSizeToLongEdgeRatio;
        return S2Projections.PROJ.avgEdge.getMinLevel(cellSize);
    }

    static final <T> List<T> createList(int maxSize) {
        if (maxSize < 256) {
            return new SimpleList(maxSize);
        }
        return new ShardedList(maxSize);
    }

    private strictfp static final class ShardedList<T>
    extends AbstractList<T>
    implements RandomAccess,
    Serializable {
        private static final long serialVersionUID = 1L;
        private Object[][] elements;
        private int size;

        public ShardedList(int maxItems) {
            this.elements = new Object[1 + (maxItems >> 8)][];
        }

        @Override
        public int size() {
            return this.size;
        }

        @Override
        public boolean add(T item) {
            int shard = this.size >> 8;
            if (shard == this.elements.length) {
                this.elements = (Object[][])Arrays.copyOf(this.elements, shard * 2);
                this.elements[shard] = new Object[256];
            } else if (this.elements[shard] == null) {
                this.elements[shard] = new Object[256];
            }
            this.elements[shard][this.size & 0xFF] = item;
            ++this.size;
            return true;
        }

        @Override
        public T get(int index) {
            Object result = this.elements[index >> 8][index & 0xFF];
            return (T)result;
        }

        @Override
        public T set(int index, T value) {
            Object[] result = this.elements[index];
            this.elements[index >> 8][index & 0xFF] = value;
            return (T)result;
        }
    }

    private strictfp static final class SimpleList<T>
    extends AbstractList<T>
    implements RandomAccess,
    Serializable {
        private static final long serialVersionUID = 1L;
        private Object[] elements;
        private int size;

        public SimpleList(int maxSize) {
            this.elements = new Object[Math.max(1, maxSize)];
        }

        @Override
        public T get(int index) {
            Object result = this.elements[index];
            return (T)result;
        }

        @Override
        public T set(int index, T value) {
            Object old = this.elements[index];
            this.elements[index] = value;
            return (T)old;
        }

        @Override
        public int size() {
            return this.size;
        }

        @Override
        public boolean add(T item) {
            if (this.size == this.elements.length) {
                this.elements = Arrays.copyOf(this.elements, this.size * 2);
            }
            this.elements[this.size++] = item;
            return true;
        }
    }

    strictfp final class InteriorTracker {
        private boolean isActive;
        private S2Point oldFocus;
        private S2Point newFocus;
        private S2Point lastEnd;
        private S2CellId nextCellId;
        private S2EdgeUtil.EdgeCrosser crosser;
        private final int[] focusedShapes;
        private int focusCount;
        private final S2ClippedShape[] tempClippedShapes;

        public InteriorTracker(S2ShapeIndex this$0, int numShapes) {
            this.tempClippedShapes = new S2ClippedShape[numShapes];
            this.focusedShapes = new int[numShapes];
            this.isActive = false;
            this.nextCellId = S2CellId.begin(30);
            this.newFocus = S2.origin();
            this.drawTo(S2Point.normalize(S2Projections.faceUvToXyz(0, -1.0, -1.0)));
        }

        public boolean isActive() {
            return this.isActive;
        }

        public void addShape(int shapeId, S2Shape shape) {
            this.isActive = true;
            if (shape.containsOrigin()) {
                this.toggleShape(shapeId);
            }
        }

        public void moveTo(S2Point b) {
            this.newFocus = b;
        }

        public void drawTo(S2Point focus) {
            this.oldFocus = this.newFocus;
            this.newFocus = focus;
            this.crosser = new S2EdgeUtil.EdgeCrosser(this.oldFocus, this.newFocus);
            this.lastEnd = null;
        }

        public void testEdge(int shapeId, S2Point start, S2Point end) {
            if (start != this.lastEnd) {
                this.crosser.restartAt(start);
            }
            if (this.crosser.edgeOrVertexCrossing(end)) {
                this.toggleShape(shapeId);
            }
            this.lastEnd = end;
        }

        public void doneCellId(S2CellId cellid) {
            this.nextCellId = cellid.rangeMax().next();
        }

        public boolean atCellId(S2CellId cellid) {
            return cellid.rangeMin().id() == this.nextCellId.id();
        }

        private void toggleShape(int shapeId) {
            if (this.focusCount == 0) {
                this.focusedShapes[0] = shapeId;
                ++this.focusCount;
            } else if (this.focusedShapes[0] == shapeId) {
                if (this.focusCount-- > 1) {
                    System.arraycopy(this.focusedShapes, 1, this.focusedShapes, 0, this.focusCount);
                }
            } else {
                int pos = 0;
                while (this.focusedShapes[pos] < shapeId) {
                    if (++pos != this.focusCount) continue;
                    this.focusedShapes[this.focusCount++] = shapeId;
                    return;
                }
                if (this.focusedShapes[pos] == shapeId) {
                    --this.focusCount;
                    System.arraycopy(this.focusedShapes, pos + 1, this.focusedShapes, pos, this.focusCount - pos);
                } else {
                    System.arraycopy(this.focusedShapes, pos, this.focusedShapes, pos + 1, this.focusCount - pos);
                    this.focusedShapes[pos] = shapeId;
                    ++this.focusCount;
                }
            }
        }
    }

    private strictfp static final class EdgeAllocator {
        private int size;
        private final List<ClippedEdge> edges;

        public EdgeAllocator(int maxEdges) {
            this.edges = S2ShapeIndex.createList(maxEdges);
        }

        public ClippedEdge create() {
            if (this.size == this.edges.size()) {
                this.edges.add(new ClippedEdge());
            }
            return this.edges.get(this.size++);
        }

        public int size() {
            return this.size;
        }

        public void reset(int size) {
            this.size = size;
        }
    }

    private strictfp static class ClippedEdge {
        private FaceEdge orig;
        private final R2Rect bound = new R2Rect();

        private ClippedEdge() {
        }
    }

    private strictfp static final class FaceEdge {
        private final int shapeId;
        private final int edgeId;
        private final int maxLevel;
        private final double ax;
        private final double ay;
        private final double bx;
        private final double by;
        private final S2Point va;
        private final S2Point vb;

        private FaceEdge(int shapeId, int edgeId, S2Point va, S2Point vb, R2Vector a, R2Vector b, double cellSizeToLongEdgeRatio) {
            this.shapeId = shapeId;
            this.edgeId = edgeId;
            this.ax = a.x;
            this.ay = a.y;
            this.bx = b.x;
            this.by = b.y;
            this.va = va;
            this.vb = vb;
            this.maxLevel = S2ShapeIndex.getEdgeMaxLevel(va, vb, cellSizeToLongEdgeRatio);
        }

        public String toString() {
            int n = this.shapeId;
            int n2 = this.edgeId;
            return new StringBuilder(34).append("shape ").append(n).append(" edge ").append(n2).toString();
        }
    }

    public strictfp static final class RangeIterator {
        private static final S2CellId END = S2CellId.end(0);
        private S2Iterator<Cell> it;
        private S2CellId id;
        private S2CellId rangeMin;
        private S2CellId rangeMax;
        private S2ClippedShape clipped;

        public RangeIterator(S2ShapeIndex index) {
            this.it = index.iterator();
            this.refresh();
        }

        public S2CellId id() {
            return this.id;
        }

        public Cell cell() {
            return this.it.entry();
        }

        public S2CellId rangeMin() {
            return this.rangeMin;
        }

        public S2CellId rangeMax() {
            return this.rangeMax;
        }

        public S2ClippedShape clipped() {
            return this.clipped;
        }

        public int numEdges() {
            return this.clipped().numEdges();
        }

        public boolean containsCenter() {
            return this.clipped().containsCenter();
        }

        public void next() {
            this.it.next();
            this.refresh();
        }

        public boolean done() {
            return this.id().equals(END);
        }

        public void seekTo(RangeIterator target) {
            this.it.seek(target.rangeMin());
            if (this.it.done() || this.it.id().rangeMin().greaterThan(target.rangeMax())) {
                this.it.prev();
                if (this.it.id().rangeMax().lessThan(target.id())) {
                    this.it.next();
                }
            }
            this.refresh();
        }

        public void seekBeyond(RangeIterator target) {
            this.it.seek(target.rangeMax().next());
            if (!this.it.done() && this.it.id().rangeMin().lessOrEquals(target.rangeMax())) {
                this.it.next();
            }
            this.refresh();
        }

        private void refresh() {
            if (this.it.done()) {
                this.id = END;
                this.clipped = null;
            } else {
                this.id = this.it.id();
                this.clipped = this.it.entry().clipped(0);
            }
            this.rangeMin = this.id.rangeMin();
            this.rangeMax = this.id.rangeMax();
        }
    }

    public strictfp static abstract class S2ClippedShape
    extends Cell {
        private final S2Shape shape;

        static S2ClippedShape create(S2CellId cellId, S2Shape shape, boolean containsCenter, List<ClippedEdge> edges, int start, int end) {
            int numEdges = end - start;
            if (numEdges == 1) {
                return OneEdge.create(cellId, shape, containsCenter, edges.get(start));
            }
            int edge = edges.get(start).orig.edgeId;
            for (int i = 1; i < numEdges; ++i) {
                if (edge + i == edges.get(start + i).orig.edgeId) continue;
                return ManyEdges.create(cellId, shape, containsCenter, edges, start, end);
            }
            return EdgeRange.create(cellId, shape, containsCenter, edge, numEdges);
        }

        private S2ClippedShape(S2Shape shape) {
            this.shape = shape;
        }

        public final S2Shape shape() {
            return this.shape;
        }

        public abstract boolean containsCenter();

        public abstract int numEdges();

        public abstract int edge(int var1);

        public final boolean containsEdge(int edgeId) {
            for (int e = 0; e < this.numEdges(); ++e) {
                if (this.edge(e) != edgeId) continue;
                return true;
            }
            return false;
        }

        @Override
        public final int numShapes() {
            return 1;
        }

        @Override
        public final S2ClippedShape clipped(int i) {
            return this;
        }

        private strictfp static abstract class EdgeRange
        extends S2ClippedShape {
            private final int offset;
            private final int count;

            static EdgeRange create(@Nullable S2CellId cellId, S2Shape shape, boolean containsCenter, int offset, int count) {
                if (cellId != null) {
                    final long id = cellId.id();
                    if (containsCenter) {
                        return new EdgeRange(shape, offset, count){

                            @Override
                            public long id() {
                                return id;
                            }

                            @Override
                            public boolean containsCenter() {
                                return true;
                            }
                        };
                    }
                    return new EdgeRange(shape, offset, count){

                        @Override
                        public long id() {
                            return id;
                        }

                        @Override
                        public boolean containsCenter() {
                            return false;
                        }
                    };
                }
                if (containsCenter) {
                    return new EdgeRange(shape, offset, count){

                        @Override
                        public long id() {
                            throw new UnsupportedOperationException();
                        }

                        @Override
                        public boolean containsCenter() {
                            return true;
                        }
                    };
                }
                return new EdgeRange(shape, offset, count){

                    @Override
                    public long id() {
                        throw new UnsupportedOperationException();
                    }

                    @Override
                    public boolean containsCenter() {
                        return false;
                    }
                };
            }

            private EdgeRange(S2Shape shape, int offset, int count) {
                super(shape);
                this.offset = offset;
                this.count = count;
            }

            @Override
            public final int numEdges() {
                return this.count;
            }

            @Override
            public final int edge(int i) {
                return this.offset + i;
            }
        }

        private strictfp static abstract class ManyEdges
        extends S2ClippedShape {
            private final int[] edges;

            static ManyEdges create(@Nullable S2CellId cellId, S2Shape shape, boolean containsCenter, List<ClippedEdge> edges, int start, int end) {
                if (cellId != null) {
                    final long id = cellId.id();
                    if (containsCenter) {
                        return new ManyEdges(shape, edges, start, end){

                            @Override
                            public long id() {
                                return id;
                            }

                            @Override
                            public boolean containsCenter() {
                                return true;
                            }
                        };
                    }
                    return new ManyEdges(shape, edges, start, end){

                        @Override
                        public long id() {
                            return id;
                        }

                        @Override
                        public boolean containsCenter() {
                            return false;
                        }
                    };
                }
                if (containsCenter) {
                    return new ManyEdges(shape, (List)edges, start, end){

                        @Override
                        public long id() {
                            throw new UnsupportedOperationException();
                        }

                        @Override
                        public boolean containsCenter() {
                            return true;
                        }
                    };
                }
                return new ManyEdges(shape, (List)edges, start, end){

                    @Override
                    public long id() {
                        throw new UnsupportedOperationException();
                    }

                    @Override
                    public boolean containsCenter() {
                        return false;
                    }
                };
            }

            static ManyEdges create(@Nullable S2CellId cellId, S2Shape shape, boolean containsCenter, int[] edges) {
                if (cellId != null) {
                    final long id = cellId.id();
                    if (containsCenter) {
                        return new ManyEdges(shape, edges){

                            @Override
                            public long id() {
                                return id;
                            }

                            @Override
                            public boolean containsCenter() {
                                return true;
                            }
                        };
                    }
                    return new ManyEdges(shape, edges){

                        @Override
                        public long id() {
                            return id;
                        }

                        @Override
                        public boolean containsCenter() {
                            return false;
                        }
                    };
                }
                if (containsCenter) {
                    return new ManyEdges(shape, edges){

                        @Override
                        public long id() {
                            throw new UnsupportedOperationException();
                        }

                        @Override
                        public boolean containsCenter() {
                            return true;
                        }
                    };
                }
                return new ManyEdges(shape, edges){

                    @Override
                    public long id() {
                        throw new UnsupportedOperationException();
                    }

                    @Override
                    public boolean containsCenter() {
                        return false;
                    }
                };
            }

            private ManyEdges(S2Shape shape, List<ClippedEdge> edges, int start, int end) {
                super(shape);
                this.edges = new int[end - start];
                for (int i = 0; i < this.edges.length; ++i) {
                    this.edges[i] = edges.get(i + start).orig.edgeId;
                }
            }

            private ManyEdges(S2Shape shape, int[] edges) {
                super(shape);
                this.edges = edges;
            }

            @Override
            public final int numEdges() {
                return this.edges.length;
            }

            @Override
            public final int edge(int i) {
                return this.edges[i];
            }
        }

        private strictfp static abstract class OneEdge
        extends S2ClippedShape {
            private final int edge;

            static final OneEdge create(@Nullable S2CellId cellId, S2Shape shape, boolean containsCenter, ClippedEdge clippedEdge) {
                if (cellId != null) {
                    final long id = cellId.id();
                    if (containsCenter) {
                        return new OneEdge(shape, clippedEdge){

                            @Override
                            public long id() {
                                return id;
                            }

                            @Override
                            public boolean containsCenter() {
                                return true;
                            }
                        };
                    }
                    return new OneEdge(shape, clippedEdge){

                        @Override
                        public long id() {
                            return id;
                        }

                        @Override
                        public boolean containsCenter() {
                            return false;
                        }
                    };
                }
                if (containsCenter) {
                    return new OneEdge(shape, clippedEdge){

                        @Override
                        public long id() {
                            throw new UnsupportedOperationException();
                        }

                        @Override
                        public boolean containsCenter() {
                            return true;
                        }
                    };
                }
                return new OneEdge(shape, clippedEdge){

                    @Override
                    public long id() {
                        throw new UnsupportedOperationException();
                    }

                    @Override
                    public boolean containsCenter() {
                        return false;
                    }
                };
            }

            private OneEdge(S2Shape shape, ClippedEdge clippedEdge) {
                super(shape);
                this.edge = clippedEdge.orig.edgeId;
            }

            @Override
            public final int numEdges() {
                return 1;
            }

            @Override
            public final int edge(int i) {
                return this.edge;
            }
        }

        private strictfp static abstract class Contained
        extends S2ClippedShape {
            static Contained create(@Nullable S2CellId cellId, S2Shape shape) {
                if (cellId != null) {
                    final long id = cellId.id();
                    return new Contained(shape){

                        @Override
                        public long id() {
                            return id;
                        }
                    };
                }
                return new Contained(shape){

                    @Override
                    public long id() {
                        throw new UnsupportedOperationException();
                    }
                };
            }

            private Contained(S2Shape shape) {
                super(shape);
            }

            @Override
            public final boolean containsCenter() {
                return true;
            }

            @Override
            public final int numEdges() {
                return 0;
            }

            @Override
            public final int edge(int i) {
                throw new ArrayIndexOutOfBoundsException();
            }
        }
    }

    public strictfp static enum CellRelation {
        INDEXED,
        SUBDIVIDED,
        DISJOINT;

    }

    public strictfp static abstract class Cell
    implements S2Iterator.Entry,
    Serializable {
        private static final long serialVersionUID = 1L;

        static Cell create(int size, S2ClippedShape[] tempClippedShapes) {
            switch (size) {
                case 1: {
                    return tempClippedShapes[0];
                }
                case 2: {
                    return new BinaryCell(tempClippedShapes[0], tempClippedShapes[1]);
                }
            }
            return new MultiCell(Arrays.copyOf(tempClippedShapes, size));
        }

        @Override
        public long id() {
            return this.clipped(0).id();
        }

        public abstract int numShapes();

        public abstract S2ClippedShape clipped(int var1);

        S2ClippedShape findClipped(S2Shape shape) {
            for (int i = 0; i < this.numShapes(); ++i) {
                S2ClippedShape clipped = this.clipped(i);
                if (clipped.shape != shape) continue;
                return clipped;
            }
            return null;
        }

        void encode(Multimap<S2Shape, Integer> shapeIds, OutputStream output) throws IOException {
            Preconditions.checkArgument((this.numShapes() < 0x10000000 ? 1 : 0) != 0, (Object)"Too many shapes.");
            if (shapeIds.size() == 1) {
                int containsCenter;
                S2ClippedShape clipped = this.clipped(0);
                int n = clipped.numEdges();
                Preconditions.checkArgument((n < 0x20000000 ? 1 : 0) != 0, (Object)"Too many edges.");
                int n2 = containsCenter = clipped.containsCenter() ? 1 : 0;
                if (n >= 2 && n <= 17 && clipped.edge(n - 1) - clipped.edge(0) == n - 1) {
                    EncodedInts.writeVarint64(output, clipped.edge(0) << 6 | n - 2 << 2 | containsCenter << 1);
                } else if (n == 1) {
                    EncodedInts.writeVarint64(output, clipped.edge(0) << 3 | containsCenter << 2 | 1);
                } else {
                    EncodedInts.writeVarint64(output, n << 3 | containsCenter << 2 | 3);
                    this.encodeEdges(clipped, output);
                }
            } else {
                if (this.numShapes() > 1) {
                    EncodedInts.writeVarint64(output, this.numShapes() << 3 | 3);
                }
                int shapeIdBase = 0;
                for (int i = 0; i < this.numShapes(); ++i) {
                    S2ClippedShape clipped = this.clipped(i);
                    int containsCenter = clipped.containsCenter() ? 1 : 0;
                    int clippedShapeId = -1;
                    Collection clippedShapeIds = shapeIds.get((Object)clipped.shape());
                    Iterator iterator = clippedShapeIds.iterator();
                    while (iterator.hasNext()) {
                        int id = (Integer)iterator.next();
                        if (id < shapeIdBase) continue;
                        clippedShapeId = id;
                        break;
                    }
                    assert (clippedShapeId >= shapeIdBase);
                    int shapeDelta = clippedShapeId - shapeIdBase;
                    shapeIdBase = clippedShapeId + 1;
                    int n = clipped.numEdges();
                    Preconditions.checkArgument((n < 0x20000000 ? 1 : 0) != 0, (Object)"Too many edges.");
                    if (n >= 1 && n <= 16 && clipped.edge(n - 1) - clipped.edge(0) == n - 1) {
                        EncodedInts.writeVarint64(output, clipped.edge(0) << 2 | containsCenter << 1);
                        EncodedInts.writeVarint64(output, shapeDelta << 4 | n - 1);
                        continue;
                    }
                    if (n == 0) {
                        EncodedInts.writeVarint64(output, shapeDelta << 4 | containsCenter << 3 | 7);
                        continue;
                    }
                    EncodedInts.writeVarint64(output, n - 1 << 3 | containsCenter << 2 | 1);
                    EncodedInts.writeVarint64(output, shapeDelta);
                    this.encodeEdges(clipped, output);
                }
            }
        }

        private void encodeEdges(S2ClippedShape clipped, OutputStream output) throws IOException {
            int edgeIdBase = 0;
            int numEdges = clipped.numEdges();
            for (int i = 0; i < numEdges; ++i) {
                int edgeId = clipped.edge(i);
                assert (edgeId >= edgeIdBase);
                int delta = edgeId - edgeIdBase;
                if (i + 1 == numEdges) {
                    EncodedInts.writeVarint64(output, delta);
                    continue;
                }
                int count = 1;
                while (i + 1 < numEdges && clipped.edge(i + 1) == edgeId + count) {
                    ++count;
                    ++i;
                }
                if (count < 8) {
                    EncodedInts.writeVarint64(output, delta << 3 | count - 1);
                } else {
                    EncodedInts.writeVarint64(output, count - 8 << 3 | 7);
                    EncodedInts.writeVarint64(output, delta);
                }
                edgeIdBase = edgeId + count;
            }
        }

        static S2ClippedShape[] decodeClippedShapes(List<S2Shape> shapes, S2CellId cellId, InputStream input) throws IOException {
            if (shapes.size() == 1) {
                S2ClippedShape[] clippedShapes = new S2ClippedShape[1];
                long header = EncodedInts.readVarint64(input);
                if ((header & 1L) == 0L) {
                    int numEdges = Ints.checkedCast((long)((header >>> 2 & 0xFL) + 2L));
                    clippedShapes[0] = S2ClippedShape.EdgeRange.create(cellId, shapes.get(0), (header & 2L) != 0L, Ints.checkedCast((long)(header >>> 6)), numEdges);
                } else if ((header & 2L) == 0L) {
                    clippedShapes[0] = S2ClippedShape.EdgeRange.create(cellId, shapes.get(0), (header & 4L) != 0L, Ints.checkedCast((long)(header >>> 3)), 1);
                } else {
                    int numEdges = Ints.checkedCast((long)(header >> 3));
                    int[] edges = Cell.decodeEdges(numEdges, input);
                    clippedShapes[0] = S2ClippedShape.ManyEdges.create(cellId, shapes.get(0), (header & 4L) != 0L, edges);
                }
                return clippedShapes;
            }
            long header = EncodedInts.readVarint64(input);
            int numClipped = 1;
            if ((header & 7L) == 3L) {
                numClipped = Ints.checkedCast((long)(header >>> 3));
                header = EncodedInts.readVarint64(input);
            }
            S2ClippedShape[] clippedShapes = new S2ClippedShape[numClipped];
            long shapeId = 0L;
            int j = 0;
            while (j < numClipped) {
                int numEdges;
                if (j > 0) {
                    header = EncodedInts.readVarint64(input);
                }
                if ((header & 1L) == 0L) {
                    long shapeIdCount = EncodedInts.readVarint64(input);
                    numEdges = Ints.checkedCast((long)((shapeIdCount & 0xFL) + 1L));
                    clippedShapes[j] = S2ClippedShape.EdgeRange.create(j == 0 ? cellId : null, shapes.get(Ints.checkedCast((long)(shapeId += shapeIdCount >> 4))), (header & 2L) != 0L, Ints.checkedCast((long)(header >>> 2)), numEdges);
                } else if ((header & 7L) == 7L) {
                    clippedShapes[j] = S2ClippedShape.EdgeRange.create(j == 0 ? cellId : null, shapes.get(Ints.checkedCast((long)(shapeId += header >> 4))), (header & 8L) != 0L, 0, 0);
                } else {
                    assert ((header & 3L) == 1L);
                    long shapeDelta = EncodedInts.readVarint64(input);
                    shapeId += shapeDelta;
                    numEdges = Ints.checkedCast((long)((header >>> 3) + 1L));
                    int[] edges = Cell.decodeEdges(numEdges, input);
                    clippedShapes[j] = S2ClippedShape.ManyEdges.create(j == 0 ? cellId : null, shapes.get(0), (header & 4L) != 0L, edges);
                }
                ++j;
                ++shapeId;
            }
            return clippedShapes;
        }

        private static int[] decodeEdges(int numEdges, InputStream input) throws IOException {
            int[] edges = new int[numEdges];
            int edgeId = 0;
            int i = 0;
            while (i < numEdges) {
                long delta = EncodedInts.readVarint64(input);
                if (i + 1 == numEdges) {
                    edges[i++] = Ints.checkedCast((long)((long)edgeId + delta));
                    continue;
                }
                long count = (delta & 7L) + 1L;
                delta >>>= 3;
                if (count == 8L) {
                    count = delta + 8L;
                    delta = EncodedInts.readVarint64(input);
                }
                edgeId += Ints.checkedCast((long)delta);
                while (count > 0L) {
                    edges[i] = edgeId++;
                    --count;
                    ++i;
                }
            }
            return edges;
        }

        private strictfp static final class MultiCell
        extends Cell {
            private final S2ClippedShape[] clippedShapes;

            MultiCell(S2ClippedShape[] shapes) {
                this.clippedShapes = shapes;
            }

            @Override
            public int numShapes() {
                return this.clippedShapes.length;
            }

            @Override
            public S2ClippedShape clipped(int i) {
                return this.clippedShapes[i];
            }
        }

        private strictfp static final class BinaryCell
        extends Cell {
            private static final long serialVersionUID = 1L;
            private final S2ClippedShape shape1;
            private final S2ClippedShape shape2;

            BinaryCell(S2ClippedShape shape1, S2ClippedShape shape2) {
                this.shape1 = shape1;
                this.shape2 = shape2;
            }

            @Override
            public int numShapes() {
                return 2;
            }

            @Override
            public S2ClippedShape clipped(int i) {
                switch (i) {
                    case 0: {
                        return this.shape1;
                    }
                    case 1: {
                        return this.shape2;
                    }
                }
                throw new ArrayIndexOutOfBoundsException();
            }
        }
    }

    public strictfp static class Options
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private int maxEdgesPerCell = 10;
        private double cellSizeToLongEdgeRatio = 1.0;

        public int getMaxEdgesPerCell() {
            return this.maxEdgesPerCell;
        }

        public void setMaxEdgesPerCell(int maxEdgesPerCell) {
            this.maxEdgesPerCell = maxEdgesPerCell;
        }

        public double getCellSizeToLongEdgeRatio() {
            return this.cellSizeToLongEdgeRatio;
        }

        public void setCellSizeToLongEdgeRatio(double cellSizeToLongEdgeRatio) {
            this.cellSizeToLongEdgeRatio = cellSizeToLongEdgeRatio;
        }
    }
}

