/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.common.geometry.stlib;

import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.repackaged.com.google.common.geometry.S2Point;
import com.google.appengine.repackaged.com.google.common.geometry.S2Polygon;
import com.google.appengine.repackaged.com.google.common.geometry.S2Polyline;
import com.google.appengine.repackaged.com.google.common.geometry.S2Shape;
import com.google.appengine.repackaged.com.google.common.geometry.S2ShapeIndex;
import com.google.appengine.repackaged.com.google.common.geometry.stlib.S2ShapeConversionUtil;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.List;

public class STGeography {
    private final S2ShapeIndex index;
    private final int numPoints;
    private final int numLines;
    private final int numPolygons;

    STGeography(S2ShapeIndex index, int numPoints, int numLines, int numPolygons) {
        this.index = index;
        this.numPoints = numPoints;
        this.numLines = numLines;
        this.numPolygons = numPolygons;
    }

    @Deprecated
    public List<S2Point> points() {
        final S2Shape.MutableEdge mutableEdge = new S2Shape.MutableEdge();
        return new AbstractList<S2Point>(){

            @Override
            public int size() {
                return STGeography.this.numPoints();
            }

            @Override
            public S2Point get(int i) {
                Preconditions.checkArgument((i < STGeography.this.numPoints() ? 1 : 0) != 0);
                STGeography.this.index().getShapes().get(0).getEdge(i, mutableEdge);
                return mutableEdge.getStart();
            }
        };
    }

    @Deprecated
    public List<S2Polyline> lines() {
        return new AbstractList<S2Polyline>(){

            @Override
            public int size() {
                return STGeography.this.numLines();
            }

            @Override
            public S2Polyline get(int i) {
                Preconditions.checkArgument((i < STGeography.this.numLines() ? 1 : 0) != 0);
                S2Shape shape = STGeography.this.index.getShapes().get((STGeography.this.numPoints() > 0 ? 1 : 0) + i);
                return S2ShapeConversionUtil.shapeToS2Polyline(shape);
            }
        };
    }

    @Deprecated
    public List<S2Polygon> polygons() {
        return new AbstractList<S2Polygon>(){

            @Override
            public int size() {
                return STGeography.this.numPolygons();
            }

            @Override
            public S2Polygon get(int i) {
                Preconditions.checkArgument((i < STGeography.this.numPolygons() ? 1 : 0) != 0);
                S2Shape shape = STGeography.this.index.getShapes().get((STGeography.this.numPoints() > 0 ? 1 : 0) + STGeography.this.numLines() + i);
                return S2ShapeConversionUtil.shapeToS2Polygon(shape);
            }
        };
    }

    public int numPoints() {
        return this.numPoints;
    }

    public int numLines() {
        return this.numLines;
    }

    public int numPolygons() {
        return this.numPolygons;
    }

    public boolean isEmpty() {
        return this.numPoints() == 0 && this.numLines() == 0 && this.numPolygons() == 0;
    }

    public int dimension() {
        if (this.numPolygons() > 0) {
            return 2;
        }
        if (this.numLines() > 0) {
            return 1;
        }
        if (this.numPoints() > 0) {
            return 0;
        }
        return -1;
    }

    public S2ShapeIndex index() {
        return this.index;
    }

    public static class Builder {
        private final List<S2Point> points = new ArrayList<S2Point>();
        private final List<S2Polyline> lines = new ArrayList<S2Polyline>();
        private final List<S2Polygon> polygons = new ArrayList<S2Polygon>();

        public Builder addPoint(S2Point point) {
            if (point != null) {
                this.points.add(point);
            }
            return this;
        }

        public Builder addLine(S2Polyline line) {
            if (line != null && line.numVertices() > 0) {
                this.lines.add(line);
            }
            return this;
        }

        public Builder addPolygon(S2Polygon polygon) {
            if (polygon != null && polygon.getNumVertices() > 0) {
                this.polygons.add(polygon);
            }
            return this;
        }

        public void clear() {
            this.points.clear();
            this.lines.clear();
            this.polygons.clear();
        }

        public STGeography build() {
            S2ShapeIndex index = new S2ShapeIndex();
            if (!this.points.isEmpty()) {
                index.add(S2Point.Shape.fromList(new ArrayList<S2Point>(this.points)));
            }
            for (S2Polyline line : this.lines) {
                index.add(line);
            }
            for (S2Polygon polygon : this.polygons) {
                index.add(polygon.shape());
            }
            STGeography result = new STGeography(index, this.points.size(), this.lines.size(), this.polygons.size());
            this.clear();
            return result;
        }
    }
}

