/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.common.geometry;

import com.google.appengine.repackaged.com.google.common.annotations.GwtCompatible;
import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.repackaged.com.google.common.geometry.EncodedUintVector;
import com.google.appengine.repackaged.com.google.common.geometry.PrimitiveArrays;
import com.google.appengine.repackaged.com.google.common.primitives.ImmutableLongArray;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.AbstractList;

@GwtCompatible
class EncodedByteArrayVector
extends AbstractList<PrimitiveArrays.Bytes> {
    private final PrimitiveArrays.Bytes data;
    private final long offset;
    private final EncodedUintVector offsets;
    private final long sizeBytes;

    public EncodedByteArrayVector(PrimitiveArrays.Bytes data, long offset) {
        this.data = data;
        this.offsets = EncodedUintVector.createEncodedUint64Vector(data, offset);
        this.offset = offset + this.offsets.sizeBytes();
        this.sizeBytes = this.offsets.sizeBytes() + (long)(this.offsets.size() > 0 ? this.offsets.getInt(this.offsets.size() - 1) : 0);
    }

    @Override
    public PrimitiveArrays.Bytes get(int i) {
        return this.data.subArray(this.offset + (long)(i == 0 ? 0 : this.offsets.getInt(i - 1)), this.offset + (long)this.offsets.getInt(i));
    }

    @Override
    public int size() {
        return this.offsets.size();
    }

    long sizeBytes() {
        return this.sizeBytes;
    }

    static class Encoder {
        private ImmutableLongArray.Builder offsetsBuilder;
        private final ByteArrayOutput data = new ByteArrayOutput();

        public Encoder() {
            this.reset();
        }

        public void reset() {
            this.offsetsBuilder = ImmutableLongArray.builder();
            this.data.reset();
        }

        public ByteArrayOutput addViaOutputStream() {
            this.offsetsBuilder.add((long)this.data.size());
            return this.data;
        }

        public void encode(OutputStream output) throws IOException {
            this.offsetsBuilder.add((long)this.data.size());
            ImmutableLongArray offsets = this.offsetsBuilder.build();
            EncodedUintVector.encodeUint64Vector(offsets.subArray(1, offsets.length()), output);
            this.data.writeTo(output);
            this.reset();
        }
    }

    static class ByteArrayOutput
    extends ByteArrayOutputStream {
        ByteArrayOutput() {
        }

        int removeLast() {
            Preconditions.checkArgument((this.count > 0 ? 1 : 0) != 0);
            return this.buf[--this.count];
        }
    }
}

