/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.common.geometry;

import com.google.appengine.repackaged.com.google.common.annotations.GwtCompatible;
import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.repackaged.com.google.common.collect.Lists;
import com.google.appengine.repackaged.com.google.common.geometry.EncodedByteArrayVector;
import com.google.appengine.repackaged.com.google.common.geometry.EncodedInts;
import com.google.appengine.repackaged.com.google.common.geometry.PrimitiveArrays;
import com.google.appengine.repackaged.com.google.common.geometry.S2CellId;
import com.google.appengine.repackaged.com.google.common.geometry.S2Point;
import com.google.appengine.repackaged.com.google.common.geometry.S2Projections;
import com.google.appengine.repackaged.com.google.common.primitives.ImmutableLongArray;
import com.google.appengine.repackaged.com.google.common.primitives.Ints;
import com.google.appengine.repackaged.com.google.common.primitives.UnsignedInts;
import com.google.appengine.repackaged.com.google.common.primitives.UnsignedLongs;
import java.io.IOException;
import java.io.OutputStream;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.List;

@GwtCompatible
abstract class EncodedS2PointVector
extends AbstractList<S2Point> {
    private static final int FORMAT_FAST = 0;
    private static final int FORMAT_COMPACT = 1;
    private static final int ENCODING_FORMAT_BITS = 3;
    private static final byte ENCODING_FORMAT_MASK = 7;
    private static final int SIZEOF_S2POINT = 24;

    EncodedS2PointVector() {
    }

    static EncodedS2PointVector create(PrimitiveArrays.Bytes data, long offset) {
        EncodedS2PointVector vector;
        int format = data.get(offset) & 7;
        switch (format) {
            case 0: {
                vector = new FastEncodedS2PointVector(data, offset);
                break;
            }
            case 1: {
                vector = new CompactEncodedS2PointVector(data, offset);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown encoding.");
            }
        }
        return vector;
    }

    public static void encode(List<S2Point> v, CodingHint hint, OutputStream output) throws IOException {
        switch (hint) {
            case FAST: {
                FastEncodedS2PointVector.encode(v, output);
                break;
            }
            case COMPACT: {
                CompactEncodedS2PointVector.encode(v, output);
            }
        }
    }

    abstract long sizeBytes();

    private static class CompactEncodedS2PointVector
    extends EncodedS2PointVector {
        private static final int BLOCK_SHIFT = 4;
        private static final int BLOCK_SIZE = 16;
        private static final long EXCEPTION = S2CellId.sentinel().id();
        private final int size;
        private final long sizeBytes;
        private final EncodedByteArrayVector blocks;
        private final long base;
        private final int level;
        private final boolean haveExceptions;

        CompactEncodedS2PointVector(PrimitiveArrays.Bytes data, long offset) {
            int header1 = data.get(offset++) & 0xFF;
            int header2 = data.get(offset++) & 0xFF;
            Preconditions.checkArgument(((header1 & 7) == 1 ? 1 : 0) != 0);
            this.haveExceptions = (header1 & 8) != 0;
            int lastBlockCount = (header1 >> 4) + 1;
            int baseBytes = header2 & 7;
            this.level = header2 >> 3;
            long tmpBase = data.readUintWithLength(offset, baseBytes);
            this.base = tmpBase << CompactEncodedS2PointVector.baseShift(this.level, baseBytes << 3);
            this.blocks = new EncodedByteArrayVector(data, offset += (long)baseBytes);
            this.size = 16 * (this.blocks.size() - 1) + lastBlockCount;
            this.sizeBytes = (long)(2 + baseBytes) + this.blocks.sizeBytes();
        }

        @Override
        public S2Point get(int i) {
            long delta;
            long offset;
            PrimitiveArrays.Bytes data = this.blocks.get(i >> 4);
            long position = 0L;
            int header = data.get(position++) & 0xFF;
            int overlapNibbles = header >> 3 & 1;
            int offsetBytes = (header & 7) + overlapNibbles;
            int deltaNibbles = (header >> 4) + 1;
            int offsetShift = deltaNibbles - overlapNibbles << 2;
            try {
                offset = data.readUintWithLength(position, offsetBytes) << offsetShift;
                long exceptionPosition = position += (long)offsetBytes;
                int deltaNibbleOffset = (i & 0xF) * deltaNibbles;
                int deltaBytes = deltaNibbles + 1 >> 1;
                delta = data.readUintWithLength(position += (long)(deltaNibbleOffset >> 1), deltaBytes);
                delta >>>= (deltaNibbleOffset & 1) << 2;
                delta &= CompactEncodedS2PointVector.bitMask(deltaNibbles << 2);
                if (this.haveExceptions) {
                    if (delta < 16L) {
                        int blockSize = Math.min(16, this.size - (i & 0xFFFFFFF0));
                        exceptionPosition += (long)(blockSize * deltaNibbles + 1 >> 1);
                        return S2Point.decode(data.toInputStream(exceptionPosition += delta * 24L));
                    }
                    delta -= 16L;
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            long value = this.base + offset + delta;
            int shift = 30 - this.level;
            int sj = CompactEncodedS2PointVector.deinterleave1(value);
            int tj = CompactEncodedS2PointVector.deinterleave2(value);
            int si = (sj << 1 | 1) << shift & Integer.MAX_VALUE;
            int ti = (tj << 1 | 1) << shift & Integer.MAX_VALUE;
            int face = sj << shift >>> 30 | tj << shift + 1 >>> 29 & 4;
            return S2Projections.faceUvToXyz(face, S2Projections.PROJ.stToUV(S2Projections.siTiToSt(si)), S2Projections.PROJ.stToUV(S2Projections.siTiToSt(ti))).normalize();
        }

        @Override
        public int size() {
            return this.size;
        }

        @Override
        long sizeBytes() {
            return this.sizeBytes;
        }

        private static void encode(List<S2Point> points, OutputStream output) throws IOException {
            ArrayList cellPoints = Lists.newArrayListWithCapacity((int)points.size());
            int level = CompactEncodedS2PointVector.chooseBestLevel(points, cellPoints);
            if (level < 0) {
                CompactEncodedS2PointVector.encode(points, CodingHint.FAST, output);
                return;
            }
            ImmutableLongArray values = CompactEncodedS2PointVector.convertCellsToValues(cellPoints, level);
            boolean haveExceptions = values.contains(EXCEPTION);
            Base base = CompactEncodedS2PointVector.chooseBase(values, level, haveExceptions);
            int numBlocks = values.length() + 16 - 1 >> 4;
            int baseBytes = base.baseBits >> 3;
            int lastBlockCount = values.length() - 16 * (numBlocks - 1);
            Preconditions.checkArgument((lastBlockCount >= 0 ? 1 : 0) != 0);
            Preconditions.checkArgument((lastBlockCount <= 16 ? 1 : 0) != 0);
            Preconditions.checkArgument((baseBytes <= 7 ? 1 : 0) != 0);
            Preconditions.checkArgument((level <= 30 ? 1 : 0) != 0);
            output.write(1 | (haveExceptions ? 1 : 0) << 3 | lastBlockCount - 1 << 4);
            output.write(baseBytes | level << 3);
            int baseShift = CompactEncodedS2PointVector.baseShift(level, base.baseBits);
            EncodedInts.encodeUintWithLength(output, base.base >> baseShift, baseBytes);
            EncodedByteArrayVector.Encoder blocks = new EncodedByteArrayVector.Encoder();
            ArrayList<S2Point> exceptions = new ArrayList<S2Point>();
            MutableBlockCode code = new MutableBlockCode();
            for (int i = 0; i < values.length(); i += 16) {
                int offsetShift;
                int blockSize = Math.min(16, values.length() - i);
                CompactEncodedS2PointVector.getBlockCode(code, values.subArray(i, i + blockSize), base.base, haveExceptions);
                EncodedByteArrayVector.ByteArrayOutput block = blocks.addViaOutputStream();
                int offsetBytes = code.offsetBits >> 3;
                int deltaNibbles = code.deltaBits >> 2;
                int overlapNibbles = code.overlapBits >> 2;
                Preconditions.checkArgument((offsetBytes - overlapNibbles <= 7 ? 1 : 0) != 0);
                Preconditions.checkArgument((overlapNibbles <= 1 ? 1 : 0) != 0);
                Preconditions.checkArgument((deltaNibbles <= 16 ? 1 : 0) != 0);
                block.write(offsetBytes - overlapNibbles | overlapNibbles << 3 | deltaNibbles - 1 << 4);
                long offset = -1L;
                int numExceptions = 0;
                for (int j = 0; j < blockSize; ++j) {
                    if (values.get(i + j) == EXCEPTION) {
                        ++numExceptions;
                        continue;
                    }
                    Preconditions.checkArgument((values.get(i + j) >= base.base ? 1 : 0) != 0);
                    offset = UnsignedLongs.min((long[])new long[]{offset, values.get(i + j) - base.base});
                }
                if (numExceptions == blockSize) {
                    offset = 0L;
                }
                Preconditions.checkArgument(((offset &= CompactEncodedS2PointVector.bitMask(offsetShift = code.deltaBits - code.overlapBits) ^ 0xFFFFFFFFFFFFFFFFL) == 0L == (offsetBytes == 0) ? 1 : 0) != 0);
                if (offset > 0L) {
                    EncodedInts.encodeUintWithLength(block, offset >>> offsetShift, offsetBytes);
                }
                int deltaBytes = deltaNibbles + 1 >> 1;
                exceptions.clear();
                for (int j = 0; j < blockSize; ++j) {
                    long delta;
                    if (values.get(i + j) == EXCEPTION) {
                        delta = exceptions.size();
                        exceptions.add(points.get(i + j));
                    } else {
                        Preconditions.checkArgument((UnsignedLongs.compare((long)values.get(i + j), (long)(offset + base.base)) >= 0 ? 1 : 0) != 0);
                        delta = values.get(i + j) - (offset + base.base);
                        if (haveExceptions) {
                            Preconditions.checkArgument((UnsignedLongs.compare((long)delta, (long)-17L) <= 0 ? 1 : 0) != 0);
                            delta += 16L;
                        }
                    }
                    Preconditions.checkArgument((UnsignedLongs.compare((long)delta, (long)CompactEncodedS2PointVector.bitMask(code.deltaBits)) <= 0 ? 1 : 0) != 0);
                    if ((deltaNibbles & 1) != 0 && (j & 1) != 0) {
                        int lastByte = block.removeLast();
                        delta = delta << 4 | (long)(lastByte & 0xF);
                    }
                    EncodedInts.encodeUintWithLength(block, delta, deltaBytes);
                }
                if (numExceptions <= 0) continue;
                for (S2Point p : exceptions) {
                    p.encode(block);
                }
            }
            blocks.encode(output);
        }

        private static long bitMask(int n) {
            return n == 0 ? 0L : -1L >>> 64 - n;
        }

        private static int maxBitsForLevel(int level) {
            return 2 * level + 3;
        }

        private static int baseShift(int level, int baseBits) {
            return Math.max(0, CompactEncodedS2PointVector.maxBitsForLevel(level) - baseBits);
        }

        private static int chooseBestLevel(List<S2Point> points, List<CellPoint> cellPoints) {
            int[] levelCounts = new int[31];
            for (S2Point point : points) {
                S2Projections.FaceSiTi faceSiTi = S2Projections.PROJ.xyzToFaceSiTi(point);
                int level = S2Projections.PROJ.levelIfCenter(faceSiTi, point);
                cellPoints.add(new CellPoint(level, faceSiTi));
                if (level < 0) continue;
                int n = level;
                levelCounts[n] = levelCounts[n] + 1;
            }
            int bestLevel = 0;
            for (int level = 1; level <= 30; ++level) {
                if (levelCounts[level] <= levelCounts[bestLevel]) continue;
                bestLevel = level;
            }
            double minEncodableFraction = 0.05;
            if ((double)levelCounts[bestLevel] <= minEncodableFraction * (double)points.size()) {
                return -1;
            }
            return bestLevel;
        }

        private static ImmutableLongArray convertCellsToValues(List<CellPoint> cellPoints, int level) {
            ImmutableLongArray.Builder builder = ImmutableLongArray.builder((int)cellPoints.size());
            int shift = 30 - level;
            for (CellPoint cp : cellPoints) {
                if (cp.level != level) {
                    builder.add(EXCEPTION);
                    continue;
                }
                int sj = ((cp.face & 3) << 30 | cp.si >>> 1) >>> shift;
                int tj = ((cp.face & 4) << 29 | cp.ti) >>> shift + 1;
                long v = CompactEncodedS2PointVector.interleaveBitPairs(sj, tj);
                Preconditions.checkArgument((UnsignedLongs.compare((long)v, (long)CompactEncodedS2PointVector.bitMask(CompactEncodedS2PointVector.maxBitsForLevel(level))) <= 0 ? 1 : 0) != 0);
                builder.add(v);
            }
            return builder.build();
        }

        private static Base chooseBase(ImmutableLongArray values, int level, boolean haveExceptions) {
            long vMin = EXCEPTION;
            long vMax = 0L;
            for (int i = 0; i < values.length(); ++i) {
                long v = values.get(i);
                if (v == EXCEPTION) continue;
                vMin = UnsignedLongs.min((long[])new long[]{vMin, v});
                vMax = UnsignedLongs.max((long[])new long[]{vMax, v});
            }
            if (vMin == EXCEPTION) {
                return new Base(0L, 0);
            }
            int minDeltaBits = haveExceptions || values.length() == 1 ? 8 : 4;
            int excludedBits = Ints.max((int[])new int[]{63 - Long.numberOfLeadingZeros(vMin ^ vMax) + 1, minDeltaBits, CompactEncodedS2PointVector.baseShift(level, 56)});
            long base = vMin & (CompactEncodedS2PointVector.bitMask(excludedBits) ^ 0xFFFFFFFFFFFFFFFFL);
            int baseBits = 0;
            if (base != 0L) {
                int lowBit = Long.numberOfTrailingZeros(base);
                baseBits = CompactEncodedS2PointVector.maxBitsForLevel(level) - lowBit + 7 & 0xFFFFFFF8;
            }
            return new Base(vMin & (CompactEncodedS2PointVector.bitMask(CompactEncodedS2PointVector.baseShift(level, baseBits)) ^ 0xFFFFFFFFFFFFFFFFL), baseBits);
        }

        private static boolean canEncode(long dMin, long dMax, int deltaBits, int overlapBits, boolean haveExceptions) {
            dMin &= CompactEncodedS2PointVector.bitMask(deltaBits - overlapBits) ^ 0xFFFFFFFFFFFFFFFFL;
            long maxDelta = CompactEncodedS2PointVector.bitMask(deltaBits);
            if (haveExceptions) {
                if (UnsignedLongs.compare((long)maxDelta, (long)16L) < 0) {
                    return false;
                }
                maxDelta -= 16L;
            }
            return UnsignedLongs.compare((long)dMin, (long)(maxDelta ^ 0xFFFFFFFFFFFFFFFFL)) > 0 || UnsignedLongs.compare((long)(dMin + maxDelta), (long)dMax) >= 0;
        }

        private static void getBlockCode(MutableBlockCode code, ImmutableLongArray values, long base, boolean haveExceptions) {
            long bMin = EXCEPTION;
            long bMax = 0L;
            for (int i = 0; i < values.length(); ++i) {
                long v = values.get(i);
                if (v == EXCEPTION) continue;
                bMin = UnsignedLongs.min((long[])new long[]{bMin, v});
                bMax = UnsignedLongs.max((long[])new long[]{bMax, v});
            }
            if (bMin == EXCEPTION) {
                code.set(4, 0, 0);
                return;
            }
            int deltaBits = Math.max(1, 63 - Long.numberOfLeadingZeros((bMax -= base) - (bMin -= base))) + 3 & 0xFFFFFFFC;
            int overlapBits = 0;
            if (!CompactEncodedS2PointVector.canEncode(bMin, bMax, deltaBits, 0, haveExceptions)) {
                if (CompactEncodedS2PointVector.canEncode(bMin, bMax, deltaBits, 4, haveExceptions)) {
                    overlapBits = 4;
                } else {
                    Preconditions.checkArgument((deltaBits <= 60 ? 1 : 0) != 0);
                    if (!CompactEncodedS2PointVector.canEncode(bMin, bMax, deltaBits += 4, 0, haveExceptions)) {
                        Preconditions.checkArgument((boolean)CompactEncodedS2PointVector.canEncode(bMin, bMax, deltaBits, 4, haveExceptions));
                        overlapBits = 4;
                    }
                }
            }
            if (values.length() == 1) {
                Preconditions.checkArgument((deltaBits == 4 && overlapBits == 0 ? 1 : 0) != 0);
                deltaBits = 8;
            }
            long maxDelta = CompactEncodedS2PointVector.bitMask(deltaBits) - (long)(haveExceptions ? 16 : 0);
            int offsetBits = 0;
            if (UnsignedLongs.compare((long)bMax, (long)maxDelta) > 0) {
                int offsetShift = deltaBits - overlapBits;
                long mask = CompactEncodedS2PointVector.bitMask(offsetShift);
                long minOffset = bMax - maxDelta + mask & (mask ^ 0xFFFFFFFFFFFFFFFFL);
                Preconditions.checkArgument((minOffset != 0L ? 1 : 0) != 0);
                offsetBits = 63 - Long.numberOfLeadingZeros(minOffset) + 1 - offsetShift + 7 & 0xFFFFFFF8;
                if (offsetBits == 64) {
                    overlapBits = 4;
                }
            }
            code.set(deltaBits, offsetBits, overlapBits);
        }

        private static long interleaveBitPairs(int val0, int val1) {
            long v0 = UnsignedInts.toLong((int)val0);
            long v1 = UnsignedInts.toLong((int)val1);
            v0 = (v0 | v0 << 16) & 0xFFFF0000FFFFL;
            v1 = (v1 | v1 << 16) & 0xFFFF0000FFFFL;
            v0 = (v0 | v0 << 8) & 0xFF00FF00FF00FFL;
            v1 = (v1 | v1 << 8) & 0xFF00FF00FF00FFL;
            v0 = (v0 | v0 << 4) & 0xF0F0F0F0F0F0F0FL;
            v1 = (v1 | v1 << 4) & 0xF0F0F0F0F0F0F0FL;
            v0 = (v0 | v0 << 2) & 0x3333333333333333L;
            v1 = (v1 | v1 << 2) & 0x3333333333333333L;
            return v0 | v1 << 2;
        }

        private static int deinterleave1(long code) {
            long v0 = code;
            v0 &= 0x3333333333333333L;
            v0 |= v0 >>> 2;
            v0 &= 0xF0F0F0F0F0F0F0FL;
            v0 |= v0 >>> 4;
            v0 &= 0xFF00FF00FF00FFL;
            v0 |= v0 >>> 8;
            v0 &= 0xFFFF0000FFFFL;
            v0 |= v0 >>> 16;
            return (int)v0;
        }

        private static int deinterleave2(long code) {
            long v1 = code >>> 2;
            v1 &= 0x3333333333333333L;
            v1 |= v1 >>> 2;
            v1 &= 0xF0F0F0F0F0F0F0FL;
            v1 |= v1 >>> 4;
            v1 &= 0xFF00FF00FF00FFL;
            v1 |= v1 >>> 8;
            v1 &= 0xFFFF0000FFFFL;
            v1 |= v1 >>> 16;
            return (int)v1;
        }

        private static final class CellPoint {
            short level;
            short face;
            int si;
            int ti;

            CellPoint(int level, S2Projections.FaceSiTi faceSiTi) {
                this.level = (short)level;
                Preconditions.checkArgument((faceSiTi.face >> 8 == 0 ? 1 : 0) != 0);
                this.face = (byte)faceSiTi.face;
                this.si = UnsignedInts.checkedCast((long)faceSiTi.si);
                this.ti = UnsignedInts.checkedCast((long)faceSiTi.ti);
            }
        }

        private static final class Base {
            long base;
            int baseBits;

            Base(long base, int baseBits) {
                this.base = base;
                this.baseBits = baseBits;
            }
        }

        private static final class MutableBlockCode {
            int deltaBits;
            int offsetBits;
            int overlapBits;

            MutableBlockCode() {
            }

            public void set(int deltaBits, int offsetBits, int overlapBits) {
                this.deltaBits = deltaBits;
                this.offsetBits = offsetBits;
                this.overlapBits = overlapBits;
            }
        }
    }

    private static class FastEncodedS2PointVector
    extends EncodedS2PointVector {
        private final PrimitiveArrays.Bytes data;
        private final long offset;
        private final int size;
        private final long sizeBytes;

        FastEncodedS2PointVector(PrimitiveArrays.Bytes data, long offset) {
            this.data = data;
            PrimitiveArrays.Bytes.Varint64Cursor cursor = new PrimitiveArrays.Bytes.Varint64Cursor(offset);
            data.readVarint64(cursor);
            long tmpSize = cursor.value;
            this.offset = cursor.position;
            Preconditions.checkArgument(((tmpSize >>= 3) <= 0x5555555L ? 1 : 0) != 0, (String)"Too many points. At most 2**31/24 can be decoded, got %s.", (long)tmpSize);
            this.size = (int)tmpSize;
            int pointsBytes = this.size * 24;
            this.sizeBytes = cursor.position - offset + (long)pointsBytes;
        }

        @Override
        public S2Point get(int i) {
            long position = this.offset + (long)(i * 24);
            return new S2Point(this.data.readLittleEndianDouble(position), this.data.readLittleEndianDouble(position + 8L), this.data.readLittleEndianDouble(position + 16L));
        }

        @Override
        public int size() {
            return this.size;
        }

        @Override
        long sizeBytes() {
            return this.sizeBytes;
        }

        public static void encode(List<S2Point> points, OutputStream output) throws IOException {
            long sizeFormat = (long)points.size() << 3 | 0L;
            EncodedInts.writeVarint64(output, sizeFormat);
            for (S2Point p : points) {
                p.encode(output);
            }
        }
    }

    public static enum CodingHint {
        FAST,
        COMPACT;

    }
}

