/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.common.geometry;

import com.google.appengine.repackaged.com.google.common.annotations.GwtCompatible;
import com.google.appengine.repackaged.com.google.common.geometry.EncodedInts;
import com.google.appengine.repackaged.com.google.common.geometry.PrimitiveArrays;
import com.google.appengine.repackaged.com.google.common.primitives.ImmutableIntArray;
import com.google.appengine.repackaged.com.google.common.primitives.ImmutableLongArray;
import com.google.appengine.repackaged.com.google.common.primitives.Ints;
import com.google.appengine.repackaged.com.google.common.primitives.UnsignedLongs;
import java.io.IOException;
import java.io.OutputStream;

@GwtCompatible
class EncodedUintVector {
    private final PrimitiveArrays.Bytes data;
    private final long offset;
    private final int size;
    private final int bytesPerWord;
    private final long sizeBytes;

    public static EncodedUintVector createEncodedUint64Vector(PrimitiveArrays.Bytes data, long offset) {
        return new EncodedUintVector(8, data, offset);
    }

    public static EncodedUintVector createEncodedUint32Vector(PrimitiveArrays.Bytes data, long offset) {
        return new EncodedUintVector(4, data, offset);
    }

    private EncodedUintVector(int typeBytes, PrimitiveArrays.Bytes data, long offset) {
        this.data = data;
        PrimitiveArrays.Bytes.Varint64Cursor cursor = new PrimitiveArrays.Bytes.Varint64Cursor(offset);
        data.readVarint64(cursor);
        int totalBytes = Ints.checkedCast((long)cursor.value);
        this.offset = cursor.position;
        this.size = totalBytes / typeBytes;
        this.bytesPerWord = (totalBytes & typeBytes - 1) + 1;
        this.sizeBytes = cursor.position - offset + (long)this.size * (long)this.bytesPerWord;
    }

    public static void encodeUint64Vector(ImmutableLongArray v, OutputStream output) throws IOException {
        long oneBits = 1L;
        for (int i = 0; i < v.length(); ++i) {
            oneBits |= v.get(i);
        }
        int bytesPerWord = (63 - Long.numberOfLeadingZeros(oneBits) >>> 3) + 1;
        long totalBytes = (long)v.length() * 8L | (long)(bytesPerWord - 1);
        EncodedInts.writeVarint64(output, totalBytes);
        for (int i = 0; i < v.length(); ++i) {
            EncodedInts.encodeUintWithLength(output, v.get(i), bytesPerWord);
        }
    }

    public static void encodeUint32Vector(ImmutableIntArray v, OutputStream output) throws IOException {
        int oneBits = 1;
        for (int i = 0; i < v.length(); ++i) {
            oneBits |= v.get(i);
        }
        int bytesPerWord = (31 - Integer.numberOfLeadingZeros(oneBits) >>> 3) + 1;
        long totalBytes = (long)v.length() * 4L | (long)(bytesPerWord - 1);
        EncodedInts.writeVarint64(output, totalBytes);
        for (int i = 0; i < v.length(); ++i) {
            EncodedInts.encodeUintWithLength(output, (long)v.get(i) & 0xFFFFFFFFL, bytesPerWord);
        }
    }

    public long get(int i) {
        return this.data.readUintWithLength(this.offset + (long)(i * this.bytesPerWord), this.bytesPerWord);
    }

    public int getInt(int i) {
        return Ints.checkedCast((long)this.get(i));
    }

    public int lowerBound(long target) {
        int low = 0;
        int high = this.size;
        while (low < high) {
            int mid = low + high >> 1;
            long value = this.get(mid);
            if (UnsignedLongs.compare((long)value, (long)target) < 0) {
                low = mid + 1;
                continue;
            }
            high = mid;
        }
        return low;
    }

    public int size() {
        return this.size;
    }

    public long sizeBytes() {
        return this.sizeBytes;
    }

    public int[] toIntArray() {
        int[] result = new int[this.size()];
        for (int i = 0; i < this.size(); ++i) {
            result[i] = this.getInt(i);
        }
        return result;
    }
}

