/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.common.geometry;

import com.google.appengine.repackaged.com.google.common.annotations.GwtCompatible;
import com.google.appengine.repackaged.com.google.common.annotations.GwtIncompatible;
import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.repackaged.com.google.common.primitives.Ints;
import com.google.appengine.repackaged.com.google.common.primitives.Longs;
import java.io.InputStream;
import java.nio.ByteBuffer;

@GwtCompatible
final class PrimitiveArrays {
    PrimitiveArrays() {
    }

    static interface Bytes {
        public byte get(long var1);

        public long length();

        @GwtIncompatible(value="ByteBuffer")
        public static Bytes fromByteBuffer(final ByteBuffer buffer) {
            return new Bytes(){

                @Override
                public byte get(long position) {
                    return buffer.get(Ints.checkedCast((long)position));
                }

                @Override
                public long length() {
                    return buffer.limit();
                }
            };
        }

        public static Bytes fromByteArray(final byte[] bytes) {
            return new Bytes(){

                @Override
                public byte get(long position) {
                    return bytes[Ints.checkedCast((long)position)];
                }

                @Override
                public long length() {
                    return bytes.length;
                }
            };
        }

        default public InputStream toInputStream(final long offset) {
            Preconditions.checkArgument((offset >= 0L && offset <= this.length() ? 1 : 0) != 0);
            return new InputStream(){
                long position;
                {
                    this.position = offset;
                }

                @Override
                public int read() {
                    if (this.position == this.length()) {
                        return -1;
                    }
                    return this.get(this.position++) & 0xFF;
                }
            };
        }

        default public InputStream toInputStream() {
            return this.toInputStream(0L);
        }

        default public void readVarint64(Varint64Cursor cursor) {
            long result = 0L;
            for (int shift = 0; shift < 64; shift += 7) {
                byte b = this.get(cursor.position++);
                result |= (long)(b & 0x7F) << shift;
                if ((b & 0x80) != 0) continue;
                cursor.value = result;
                return;
            }
            throw new IllegalArgumentException("Malformed varint.");
        }

        default public long readUintWithLength(long position, int numBytes) {
            long x = 0L;
            for (int i = 0; i < numBytes; ++i) {
                x += ((long)this.get(position + (long)i) & 0xFFL) << 8 * i;
            }
            return x;
        }

        default public double readLittleEndianDouble(long position) {
            long bits = Longs.fromBytes((byte)this.get(position + 7L), (byte)this.get(position + 6L), (byte)this.get(position + 5L), (byte)this.get(position + 4L), (byte)this.get(position + 3L), (byte)this.get(position + 2L), (byte)this.get(position + 1L), (byte)this.get(position));
            return Double.longBitsToDouble(bits);
        }

        default public Bytes subArray(final long fromIndex, final long toIndex) {
            Preconditions.checkArgument((fromIndex >= 0L && fromIndex <= toIndex ? 1 : 0) != 0);
            Preconditions.checkArgument((toIndex <= this.length() ? 1 : 0) != 0);
            return new Bytes(){

                @Override
                public byte get(long position) {
                    return this.get(fromIndex + position);
                }

                @Override
                public long length() {
                    return toIndex - fromIndex;
                }
            };
        }

        public static final class Varint64Cursor {
            long position;
            long value;

            Varint64Cursor(long position) {
                this.position = position;
            }
        }
    }
}

