/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.common.geometry;

import com.google.appengine.repackaged.com.google.common.annotations.GwtIncompatible;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableList;
import com.google.appengine.repackaged.com.google.common.collect.Iterables;
import com.google.appengine.repackaged.com.google.common.collect.Lists;
import com.google.appengine.repackaged.com.google.common.geometry.EncodedInts;
import com.google.appengine.repackaged.com.google.common.geometry.EncodedS2PointVector;
import com.google.appengine.repackaged.com.google.common.geometry.EncodedUintVector;
import com.google.appengine.repackaged.com.google.common.geometry.PrimitiveArrays;
import com.google.appengine.repackaged.com.google.common.geometry.S2;
import com.google.appengine.repackaged.com.google.common.geometry.S2CellId;
import com.google.appengine.repackaged.com.google.common.geometry.S2Coder;
import com.google.appengine.repackaged.com.google.common.geometry.S2Point;
import com.google.appengine.repackaged.com.google.common.geometry.S2Polygon;
import com.google.appengine.repackaged.com.google.common.geometry.S2Shape;
import com.google.appengine.repackaged.com.google.common.geometry.S2ShapeAspect;
import com.google.appengine.repackaged.com.google.common.geometry.S2ShapeUtil;
import com.google.appengine.repackaged.com.google.common.primitives.ImmutableIntArray;
import java.io.IOException;
import java.io.OutputStream;

@GwtIncompatible(value="S2ShapeAspect incompatible")
public interface S2LaxPolygonShape
extends S2ShapeAspect.EdgeAspect.Closed {
    public static final byte CURRENT_ENCODING_VERSION = 1;
    public static final S2LaxPolygonShape EMPTY = new MultiArray((Iterable<? extends Iterable<S2Point>>)ImmutableList.of());
    public static final S2LaxPolygonShape FULL = new SimpleArray((Iterable<S2Point>)ImmutableList.of());

    public static S2LaxPolygonShape create(S2Polygon polygon) {
        if (polygon.isEmpty()) {
            return EMPTY;
        }
        if (polygon.isFull()) {
            return FULL;
        }
        return S2LaxPolygonShape.create(Lists.transform(polygon.getLoops(), x -> x.isFull() ? ImmutableList.of() : x.orientedVertices()));
    }

    public static S2LaxPolygonShape create(Iterable<? extends Iterable<S2Point>> loops) {
        if (Iterables.isEmpty(loops)) {
            return EMPTY;
        }
        if (Iterables.all(loops, Iterables::isEmpty)) {
            return FULL;
        }
        if (Iterables.size(loops) == 1) {
            return new SimpleArray((Iterable)Iterables.getOnlyElement(loops));
        }
        return new MultiArray(loops);
    }

    public static S2LaxPolygonShape createPacked(Iterable<? extends Iterable<S2Point>> loops) {
        if (Iterables.isEmpty(loops)) {
            return EMPTY;
        }
        if (Iterables.all(loops, Iterables::isEmpty)) {
            return FULL;
        }
        if (Iterables.size(loops) == 1) {
            return new SimplePacked((Iterable)Iterables.getOnlyElement(loops));
        }
        return new MultiPacked(loops);
    }

    public static S2LaxPolygonShape createSnapped(Iterable<? extends Iterable<S2CellId>> loops) {
        if (Iterables.isEmpty(loops)) {
            return EMPTY;
        }
        if (Iterables.all(loops, Iterables::isEmpty)) {
            return FULL;
        }
        if (Iterables.size(loops) == 1) {
            return new SimpleSnapped((Iterable)Iterables.getOnlyElement(loops));
        }
        return new MultiSnapped(loops);
    }

    default public Object readResolve() {
        int n = this.numChains();
        if (n == 0) {
            return EMPTY;
        }
        for (int i = 0; i < n; ++i) {
            if (this.getChainLength(i) == 0) continue;
            return this;
        }
        return FULL;
    }

    @Override
    default public int dimension() {
        return 2;
    }

    default public boolean isEmpty() {
        return this.numChains() == 0;
    }

    default public boolean isFull() {
        int n = this.numChains();
        for (int i = 0; i < n; ++i) {
            if (this.getChainLength(i) == 0) continue;
            return false;
        }
        return n > 0;
    }

    @Override
    default public boolean hasInterior() {
        return true;
    }

    @Override
    default public boolean containsOrigin() {
        if (this.isFull()) {
            return true;
        }
        if (this.isEmpty()) {
            return false;
        }
        return S2ShapeUtil.containsBruteForce(this, S2.origin());
    }

    @Override
    default public S2Shape.ReferencePoint getReferencePoint() {
        return S2ShapeUtil.getReferencePoint(this);
    }

    @GwtIncompatible(value="Uses ByteBuffer")
    public static class Coder
    implements S2Coder<S2LaxPolygonShape> {
        static final Coder FAST = new Coder(EncodedS2PointVector.CodingHint.FAST);
        static final Coder COMPACT = new Coder(EncodedS2PointVector.CodingHint.COMPACT);
        private final EncodedS2PointVector.CodingHint hint;

        private Coder(EncodedS2PointVector.CodingHint hint) {
            this.hint = hint;
        }

        @Override
        public void encode(S2LaxPolygonShape shape, OutputStream output) throws IOException {
            output.write(1);
            EncodedInts.writeVarint64(output, shape.numChains());
            EncodedS2PointVector.encode(shape.vertices(), this.hint, output);
            if (shape.numChains() > 1) {
                ImmutableIntArray.Builder builder = ImmutableIntArray.builder();
                for (int i = 0; i < shape.numChains(); ++i) {
                    builder.add(shape.getChainStart(i));
                }
                builder.add(shape.numVertices());
                EncodedUintVector.encodeUint32Vector(builder.build(), output);
            }
        }

        @Override
        public S2LaxPolygonShape decode(PrimitiveArrays.Bytes data, long offset) {
            byte version;
            if ((version = data.get(offset++)) != 1) {
                throw new IllegalArgumentException(String.format("Expected encoding version %s, got %s.", (byte)1, version));
            }
            PrimitiveArrays.Bytes.Varint64Cursor cursor = new PrimitiveArrays.Bytes.Varint64Cursor(offset);
            data.readVarint64(cursor);
            long numChains = cursor.value;
            offset = cursor.position;
            if (numChains == 0L) {
                return EMPTY;
            }
            EncodedS2PointVector vertices = EncodedS2PointVector.create(data, offset);
            if (numChains == 1L) {
                return new EncodedSimpleArray(vertices);
            }
            EncodedUintVector cumulativeVertices = EncodedUintVector.createEncodedUint32Vector(data, offset + vertices.sizeBytes());
            return new EncodedMultiArray(vertices, cumulativeVertices);
        }
    }

    public static class MultiSnapped
    extends S2ShapeAspect.ChainAspect.Multi.Snapped
    implements S2LaxPolygonShape {
        MultiSnapped(Iterable<? extends Iterable<S2CellId>> loops) {
            super(loops);
        }
    }

    public static class MultiPacked
    extends S2ShapeAspect.ChainAspect.Multi.Packed
    implements S2LaxPolygonShape {
        MultiPacked(Iterable<? extends Iterable<S2Point>> loops) {
            super(loops);
        }
    }

    public static class EncodedMultiArray
    extends S2ShapeAspect.ChainAspect.Multi
    implements S2LaxPolygonShape {
        private final EncodedS2PointVector vertices;

        private EncodedMultiArray(EncodedS2PointVector vertices, EncodedUintVector cumulativeEdges) {
            super(cumulativeEdges.toIntArray());
            this.vertices = vertices;
        }

        @Override
        public int numVertices() {
            return this.vertices.size();
        }

        @Override
        public S2Point vertex(int vertexId) {
            return (S2Point)this.vertices.get(vertexId);
        }
    }

    public static class MultiArray
    extends S2ShapeAspect.ChainAspect.Multi.Array
    implements S2LaxPolygonShape {
        MultiArray(Iterable<? extends Iterable<S2Point>> loops) {
            super(loops);
        }
    }

    public static class SimpleSnapped
    extends S2ShapeAspect.ChainAspect.Simple.Snapped
    implements S2LaxPolygonShape {
        SimpleSnapped(Iterable<S2CellId> vertices) {
            super(vertices);
        }
    }

    public static class SimplePacked
    extends S2ShapeAspect.ChainAspect.Simple.Packed
    implements S2LaxPolygonShape {
        SimplePacked(Iterable<S2Point> vertices) {
            super(vertices);
        }
    }

    public static class EncodedSimpleArray
    extends S2ShapeAspect.ChainAspect.Simple
    implements S2LaxPolygonShape {
        private final EncodedS2PointVector vertices;

        private EncodedSimpleArray(EncodedS2PointVector vertices) {
            this.vertices = vertices;
        }

        @Override
        public int numVertices() {
            return this.vertices.size();
        }

        @Override
        public S2Point vertex(int vertexId) {
            return (S2Point)this.vertices.get(vertexId);
        }
    }

    public static class SimpleArray
    extends S2ShapeAspect.ChainAspect.Simple.Array
    implements S2LaxPolygonShape {
        SimpleArray(Iterable<S2Point> vertices) {
            super(vertices);
        }
    }
}

