/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.common.geometry;

import com.google.appengine.repackaged.com.google.common.annotations.GwtIncompatible;
import com.google.appengine.repackaged.com.google.common.base.Predicate;
import com.google.appengine.repackaged.com.google.common.base.Predicates;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableList;
import com.google.appengine.repackaged.com.google.common.collect.Iterables;
import com.google.appengine.repackaged.com.google.common.geometry.EncodedS2PointVector;
import com.google.appengine.repackaged.com.google.common.geometry.PrimitiveArrays;
import com.google.appengine.repackaged.com.google.common.geometry.S2CellId;
import com.google.appengine.repackaged.com.google.common.geometry.S2Coder;
import com.google.appengine.repackaged.com.google.common.geometry.S2Point;
import com.google.appengine.repackaged.com.google.common.geometry.S2ShapeAspect;
import java.io.IOException;
import java.io.OutputStream;

@GwtIncompatible(value="S2ShapeAspect incompatible")
public interface S2LaxPolylineShape
extends S2ShapeAspect.EdgeAspect.Open {
    public static final S2LaxPolylineShape EMPTY = new MultiArray((Iterable)ImmutableList.of());

    public static S2LaxPolylineShape create(Iterable<S2Point> vertices) {
        return Iterables.isEmpty(vertices = S2LaxPolylineShape.filterLine(vertices)) ? EMPTY : new SimpleArray(vertices);
    }

    public static S2LaxPolylineShape createPacked(Iterable<S2Point> vertices) {
        return Iterables.isEmpty(vertices = S2LaxPolylineShape.filterLine(vertices)) ? EMPTY : new SimplePacked(vertices);
    }

    public static S2LaxPolylineShape createSnapped(Iterable<S2CellId> vertices) {
        return Iterables.isEmpty(vertices = S2LaxPolylineShape.filterLine(vertices)) ? EMPTY : new SimpleSnapped(vertices);
    }

    public static S2LaxPolylineShape createMulti(Iterable<? extends Iterable<S2Point>> lines) {
        if (Iterables.isEmpty(lines = S2LaxPolylineShape.filterLines(lines))) {
            return EMPTY;
        }
        if (Iterables.size(lines) == 1) {
            return new SimpleArray((Iterable)Iterables.getOnlyElement(lines));
        }
        return new MultiArray(lines);
    }

    public static S2LaxPolylineShape createMultiPacked(Iterable<? extends Iterable<S2Point>> lines) {
        if (Iterables.isEmpty(lines = S2LaxPolylineShape.filterLines(lines))) {
            return EMPTY;
        }
        if (Iterables.size(lines) == 1) {
            return new SimplePacked((Iterable)Iterables.getOnlyElement(lines));
        }
        return new MultiPacked((Iterable<? extends Iterable<S2Point>>)lines);
    }

    public static S2LaxPolylineShape createMultiSnapped(Iterable<? extends Iterable<S2CellId>> lines) {
        if (Iterables.isEmpty(lines = S2LaxPolylineShape.filterLines(lines))) {
            return EMPTY;
        }
        if (Iterables.size(lines) == 1) {
            return new SimpleSnapped((Iterable)Iterables.getOnlyElement(lines));
        }
        return new MultiSnapped((Iterable<? extends Iterable<S2CellId>>)lines);
    }

    public static <T> Iterable<T> filterLine(Iterable<T> input) {
        return Iterables.size(input) < 2 ? ImmutableList.of() : input;
    }

    public static <T> Iterable<? extends Iterable<T>> filterLines(Iterable<? extends Iterable<T>> input) {
        return Iterables.filter((Iterable)Iterables.transform(input, S2LaxPolylineShape::filterLine), (Predicate)Predicates.not(Iterables::isEmpty));
    }

    default public Object readResolve() {
        return this.numVertices() == 0 ? EMPTY : this;
    }

    @Override
    default public int dimension() {
        return 1;
    }

    @Override
    default public boolean hasInterior() {
        return false;
    }

    @Override
    default public boolean containsOrigin() {
        return false;
    }

    default public boolean isEmpty() {
        return this.numEdges() == 0;
    }

    default public boolean isFull() {
        return false;
    }

    @GwtIncompatible(value="Uses EncodedS2PointVector")
    public static class Coder
    implements S2Coder<S2LaxPolylineShape> {
        static final Coder FAST = new Coder(EncodedS2PointVector.CodingHint.FAST);
        static final Coder COMPACT = new Coder(EncodedS2PointVector.CodingHint.COMPACT);
        private final EncodedS2PointVector.CodingHint hint;

        private Coder(EncodedS2PointVector.CodingHint hint) {
            this.hint = hint;
        }

        @Override
        public void encode(S2LaxPolylineShape shape, OutputStream output) throws IOException {
            EncodedS2PointVector.encode(shape.vertices(), this.hint, output);
        }

        @Override
        public S2LaxPolylineShape decode(PrimitiveArrays.Bytes data, long offset) {
            return new EncodedSimpleArray(EncodedS2PointVector.create(data, offset));
        }
    }

    public static class MultiSnapped
    extends S2ShapeAspect.ChainAspect.Multi.Snapped
    implements S2LaxPolylineShape {
        MultiSnapped(Iterable<? extends Iterable<S2CellId>> chains) {
            super(chains);
        }
    }

    public static class MultiPacked
    extends S2ShapeAspect.ChainAspect.Multi.Packed
    implements S2LaxPolylineShape {
        MultiPacked(Iterable<? extends Iterable<S2Point>> chains) {
            super(chains);
        }
    }

    public static class MultiArray
    extends S2ShapeAspect.ChainAspect.Multi.Array
    implements S2LaxPolylineShape {
        private MultiArray(Iterable<? extends Iterable<S2Point>> chains) {
            super(chains);
        }
    }

    public static class SimpleSnapped
    extends S2ShapeAspect.ChainAspect.Simple.Snapped
    implements S2LaxPolylineShape {
        private SimpleSnapped(Iterable<S2CellId> vertices) {
            super(vertices);
        }
    }

    public static class SimplePacked
    extends S2ShapeAspect.ChainAspect.Simple.Packed
    implements S2LaxPolylineShape {
        private SimplePacked(Iterable<S2Point> vertices) {
            super(vertices);
        }
    }

    public static class EncodedSimpleArray
    extends S2ShapeAspect.ChainAspect.Simple
    implements S2LaxPolylineShape {
        private final EncodedS2PointVector vertices;

        private EncodedSimpleArray(EncodedS2PointVector vertices) {
            this.vertices = vertices;
        }

        @Override
        public int numVertices() {
            return this.vertices.size();
        }

        @Override
        public S2Point vertex(int vertexId) {
            return (S2Point)this.vertices.get(vertexId);
        }
    }

    public static class SimpleArray
    extends S2ShapeAspect.ChainAspect.Simple.Array
    implements S2LaxPolylineShape {
        private SimpleArray(Iterable<S2Point> vertices) {
            super(vertices);
        }
    }
}

