/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.common.geometry;

import com.google.appengine.repackaged.com.google.common.annotations.GwtIncompatible;
import com.google.appengine.repackaged.com.google.common.geometry.EncodedByteArrayVector;
import com.google.appengine.repackaged.com.google.common.geometry.EncodedInts;
import com.google.appengine.repackaged.com.google.common.geometry.LittleEndianOutput;
import com.google.appengine.repackaged.com.google.common.geometry.PrimitiveArrays;
import com.google.appengine.repackaged.com.google.common.geometry.S2Coder;
import com.google.appengine.repackaged.com.google.common.geometry.S2LaxPolygonShape;
import com.google.appengine.repackaged.com.google.common.geometry.S2LaxPolylineShape;
import com.google.appengine.repackaged.com.google.common.geometry.S2Point;
import com.google.appengine.repackaged.com.google.common.geometry.S2Polygon;
import com.google.appengine.repackaged.com.google.common.geometry.S2Polyline;
import com.google.appengine.repackaged.com.google.common.geometry.S2Shape;
import com.google.appengine.repackaged.com.google.common.primitives.Ints;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.AbstractList;
import java.util.List;

@GwtIncompatible(value="Uses ByteBuffer")
public class S2ShapeCodingUtil {
    private static final int POLYGON_TYPE_TAG = 1;
    private static final int POLYLINE_TYPE_TAG = 2;
    private static final int POINT_TYPE_TAG = 3;
    private static final int LAX_POLYLINE_TYPE_TAG = 4;
    private static final int LAX_POLYGON_TYPE_TAG = 5;
    private static final S2Coder<S2Shape> FAST_SHAPE_CODER = new S2Coder<S2Shape>(){

        @Override
        public void encode(S2Shape shape, OutputStream output) throws IOException {
            if (shape instanceof S2Polygon.Shape) {
                EncodedInts.writeVarint64(output, 1L);
                ((S2Polygon.Shape)shape).polygon().encodeUncompressed(new LittleEndianOutput(output));
            } else if (shape instanceof S2Polyline) {
                EncodedInts.writeVarint64(output, 2L);
                ((S2Polyline)shape).encode(output);
            } else if (shape instanceof S2Point.Shape) {
                EncodedInts.writeVarint64(output, 3L);
                S2Point.Shape.Coder.FAST.encode((S2Point.Shape)shape, output);
            } else if (shape instanceof S2LaxPolylineShape) {
                EncodedInts.writeVarint64(output, 4L);
                S2LaxPolylineShape.Coder.FAST.encode((S2LaxPolylineShape)shape, output);
            } else if (shape instanceof S2LaxPolygonShape) {
                EncodedInts.writeVarint64(output, 5L);
                S2LaxPolygonShape.Coder.FAST.encode((S2LaxPolygonShape)shape, output);
            } else {
                throw new IllegalArgumentException("Unexpected S2Shape type.");
            }
        }

        @Override
        public S2Shape decode(PrimitiveArrays.Bytes data, long offset) {
            return S2ShapeCodingUtil.decode(data, offset);
        }
    };
    private static final S2Coder<S2Shape> COMPACT_SHAPE_CODER = new S2Coder<S2Shape>(){

        @Override
        public void encode(S2Shape shape, OutputStream output) throws IOException {
            if (shape instanceof S2Polygon.Shape) {
                EncodedInts.writeVarint64(output, 1L);
                ((S2Polygon.Shape)shape).polygon().encode(output);
            } else if (shape instanceof S2Point.Shape) {
                EncodedInts.writeVarint64(output, 3L);
                S2Point.Shape.Coder.COMPACT.encode((S2Point.Shape)shape, output);
            } else if (shape instanceof S2LaxPolylineShape) {
                EncodedInts.writeVarint64(output, 4L);
                S2LaxPolylineShape.Coder.COMPACT.encode((S2LaxPolylineShape)shape, output);
            } else if (shape instanceof S2LaxPolygonShape) {
                EncodedInts.writeVarint64(output, 5L);
                S2LaxPolygonShape.Coder.COMPACT.encode((S2LaxPolygonShape)shape, output);
            } else {
                FAST_SHAPE_CODER.encode(shape, output);
            }
        }

        @Override
        public S2Shape decode(PrimitiveArrays.Bytes data, long offset) {
            return S2ShapeCodingUtil.decode(data, offset);
        }
    };

    public static void fastEncodeTaggedShapes(List<S2Shape> shapes, OutputStream output) throws IOException {
        S2ShapeCodingUtil.encodeTaggedShapes(shapes, FAST_SHAPE_CODER, output);
    }

    public static void compactEncodeTaggedShapes(List<S2Shape> shapes, OutputStream output) throws IOException {
        S2ShapeCodingUtil.encodeTaggedShapes(shapes, COMPACT_SHAPE_CODER, output);
    }

    private static void encodeTaggedShapes(List<S2Shape> shapes, S2Coder<S2Shape> coder, OutputStream output) throws IOException {
        EncodedByteArrayVector.Encoder shapeVector = new EncodedByteArrayVector.Encoder();
        for (S2Shape shape : shapes) {
            EncodedByteArrayVector.ByteArrayOutput os = shapeVector.addViaOutputStream();
            if (shape == null) continue;
            coder.encode(shape, os);
        }
        shapeVector.encode(output);
    }

    public static TaggedShapeFactory decodeTaggedShapeFactory(ByteBuffer buffer) throws IOException {
        return new TaggedShapeFactory(FAST_SHAPE_CODER, buffer);
    }

    private static S2Shape decode(PrimitiveArrays.Bytes data, long offset) {
        PrimitiveArrays.Bytes.Varint64Cursor cursor = new PrimitiveArrays.Bytes.Varint64Cursor(offset);
        data.readVarint64(cursor);
        int typeTag = Ints.checkedCast((long)cursor.value);
        offset = cursor.position;
        InputStream input = data.toInputStream(offset);
        switch (typeTag) {
            case 1: {
                try {
                    return S2Polygon.decode(input).shape();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            case 2: {
                try {
                    return S2Polyline.decode(input);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            case 3: {
                return S2Point.Shape.Coder.FAST.decode(data, offset);
            }
            case 4: {
                return S2LaxPolylineShape.Coder.FAST.decode(data, offset);
            }
            case 5: {
                return S2LaxPolygonShape.Coder.FAST.decode(data, offset);
            }
        }
        throw new IllegalArgumentException(String.format("Unexpected typeTag: %s", typeTag));
    }

    static class TaggedShapeFactory
    extends AbstractList<S2Shape> {
        private final S2Coder<S2Shape> coder;
        private final EncodedByteArrayVector encodedShapes;

        public TaggedShapeFactory(S2Coder<S2Shape> coder, ByteBuffer buffer) {
            this.coder = coder;
            this.encodedShapes = new EncodedByteArrayVector(PrimitiveArrays.Bytes.fromByteBuffer(buffer), buffer.position());
            buffer.position(Ints.checkedCast((long)((long)buffer.position() + this.encodedShapes.sizeBytes())));
        }

        @Override
        public S2Shape get(int shapeId) {
            PrimitiveArrays.Bytes data = this.encodedShapes.get(shapeId);
            if (data.length() == 0L) {
                return null;
            }
            return this.coder.decode(data, 0L);
        }

        @Override
        public int size() {
            return this.encodedShapes.size();
        }
    }
}

