/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.common.geometry.stlib;

import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.repackaged.com.google.common.geometry.S2LaxPolygonShape;
import com.google.appengine.repackaged.com.google.common.geometry.S2Loop;
import com.google.appengine.repackaged.com.google.common.geometry.S2Point;
import com.google.appengine.repackaged.com.google.common.geometry.S2Polygon;
import com.google.appengine.repackaged.com.google.common.geometry.S2Polyline;
import com.google.appengine.repackaged.com.google.common.geometry.S2Shape;
import java.util.ArrayList;
import java.util.List;

public final class S2ShapeConversionUtil {
    public static S2Polyline shapeToS2Polyline(S2Shape shape) {
        Preconditions.checkArgument((shape.dimension() == 1 && shape.numChains() == 1 && shape.numEdges() > 0 ? 1 : 0) != 0);
        return new S2Polyline(S2ShapeConversionUtil.getChainVertices(shape, 0, new S2Shape.MutableEdge()));
    }

    public static S2Polygon shapeToS2Polygon(S2Shape shape) {
        Preconditions.checkArgument((shape instanceof S2Polygon.Shape || shape instanceof S2LaxPolygonShape ? 1 : 0) != 0);
        ArrayList<S2Loop> loops = new ArrayList<S2Loop>();
        if (shape.numChains() > 0 && shape.numEdges() == 0) {
            loops.add(S2Loop.full());
            return new S2Polygon(loops);
        }
        S2Shape.MutableEdge mutableEdge = new S2Shape.MutableEdge();
        for (int i = 0; i < shape.numChains(); ++i) {
            loops.add(new S2Loop(S2ShapeConversionUtil.getChainVertices(shape, i, mutableEdge)));
        }
        S2Polygon polygon = new S2Polygon();
        polygon.initOriented(loops);
        return polygon;
    }

    private static List<S2Point> getChainVertices(S2Shape shape, int chainId, S2Shape.MutableEdge mutableEdge) {
        int i;
        int numVertices = shape.getChainLength(chainId) + (shape.dimension() == 1 ? 1 : 0);
        ArrayList<S2Point> vertices = new ArrayList<S2Point>(numVertices);
        shape.getChainEdge(chainId, 0, mutableEdge);
        vertices.add(mutableEdge.getStart());
        if ((numVertices & 1) == 1) {
            i = 1;
        } else {
            vertices.add(mutableEdge.getEnd());
            i = 2;
        }
        while (i < numVertices) {
            shape.getChainEdge(chainId, i, mutableEdge);
            vertices.add(mutableEdge.getStart());
            vertices.add(mutableEdge.getEnd());
            i += 2;
        }
        if (shape.dimension() == 2) {
            shape.getChainEdge(chainId, i - 1, mutableEdge);
            Preconditions.checkArgument((boolean)((S2Point)vertices.get(0)).equalsPoint(mutableEdge.getEnd()), (Object)"Unclosed polygon chain.");
        }
        return vertices;
    }
}

