/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.common.geometry.stlib;

import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.repackaged.com.google.common.geometry.EncodedS2ShapeIndex;
import com.google.appengine.repackaged.com.google.common.geometry.LittleEndianInput;
import com.google.appengine.repackaged.com.google.common.geometry.LittleEndianOutput;
import com.google.appengine.repackaged.com.google.common.geometry.S2CellId;
import com.google.appengine.repackaged.com.google.common.geometry.S2CellUnion;
import com.google.appengine.repackaged.com.google.common.geometry.S2Error;
import com.google.appengine.repackaged.com.google.common.geometry.S2Point;
import com.google.appengine.repackaged.com.google.common.geometry.S2Polygon;
import com.google.appengine.repackaged.com.google.common.geometry.S2Polyline;
import com.google.appengine.repackaged.com.google.common.geometry.S2Shape;
import com.google.appengine.repackaged.com.google.common.geometry.S2ShapeCodingUtil;
import com.google.appengine.repackaged.com.google.common.geometry.stlib.STGeography;
import com.google.appengine.repackaged.com.google.io.base.Buffers;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class STGeographyCoder {
    private static final byte ENCODING_MAGIC_STRING_0 = 83;
    private static final byte ENCODING_MAGIC_STRING_1 = 69;
    private static final byte ENCODING_NUM_VERTICES_MARKER = 86;
    private static final byte ENCODING_COVERING_MARKER = 67;
    private static final int LONG_BYTES = 8;

    private STGeographyCoder() {
    }

    public static void encodeV0(STGeography geo, OutputStream out) throws IOException {
        Preconditions.checkNotNull((Object)geo);
        LittleEndianOutput encoder = new LittleEndianOutput(out);
        encoder.writeByte((byte)83);
        encoder.writeVarint32(geo.numPoints());
        encoder.writeVarint32(geo.numLines());
        encoder.writeVarint32(geo.numPolygons());
        for (S2Point point : geo.points()) {
            point.encode(out);
        }
        for (S2Polyline line : geo.lines()) {
            line.encode(out);
        }
        for (S2Polygon polygon : geo.polygons()) {
            polygon.encode(out);
        }
    }

    public static void encodeV1(STGeography geo, OutputStream out) throws IOException {
        Preconditions.checkNotNull((Object)geo);
        LittleEndianOutput encoder = new LittleEndianOutput(out);
        encoder.writeByte((byte)69);
        S2ShapeCodingUtil.compactEncodeTaggedShapes(geo.index().getShapes(), out);
        geo.index().encode(out);
    }

    public static void encodeCovering(S2CellUnion covering, OutputStream out) throws IOException {
        Preconditions.checkNotNull((Object)covering);
        LittleEndianOutput encoder = new LittleEndianOutput(out);
        for (S2CellId cellId : covering.cellIds()) {
            encoder.writeLong(cellId.id());
        }
    }

    public static STGeography decode(ByteBuffer buffer) throws IOException {
        byte version = buffer.get();
        switch (version) {
            case 83: {
                return STGeographyCoder.decodeV0(Buffers.asInputStream((ByteBuffer)buffer));
            }
            case 69: {
                return STGeographyCoder.decodeV1(buffer);
            }
        }
        throw new IOException(new StringBuilder(45).append("Unsupported STGeography encoding version ").append(version).toString());
    }

    private static STGeography decodeV0(InputStream in) throws IOException {
        int i;
        LittleEndianInput decoder = new LittleEndianInput(in);
        int numPoints = decoder.readVarint32();
        int numLines = decoder.readVarint32();
        int numPolygons = decoder.readVarint32();
        Preconditions.checkState((numPoints >= 0 ? 1 : 0) != 0, (String)"Invalid number of points %s", (int)numPoints);
        Preconditions.checkState((numLines >= 0 ? 1 : 0) != 0, (String)"Invalid number of lines %s", (int)numPoints);
        Preconditions.checkState((numPolygons >= 0 ? 1 : 0) != 0, (String)"Invalid number of polygons %s", (int)numPoints);
        STGeography.Builder builder = new STGeography.Builder();
        for (i = 0; i < numPoints; ++i) {
            S2Point point = S2Point.decode(in);
            builder.addPoint(point);
        }
        for (i = 0; i < numLines; ++i) {
            S2Polyline line = S2Polyline.decode(in);
            builder.addLine(line);
        }
        for (i = 0; i < numPolygons; ++i) {
            S2Polygon p = S2Polygon.decode(in);
            builder.addPolygon(p);
        }
        return builder.build();
    }

    private static STGeography decodeV1(ByteBuffer buffer) throws IOException {
        EncodedS2ShapeIndex shapeIndex = new EncodedS2ShapeIndex(buffer, S2ShapeCodingUtil.decodeTaggedShapeFactory(buffer));
        int numPoints = 0;
        int[] counts = new int[3];
        int lastDimension = 0;
        for (int i = 0; i < shapeIndex.getShapes().size(); ++i) {
            S2Shape s = shapeIndex.getShapes().get(i);
            boolean isEmpty = s.numEdges() == 0 && (s.dimension() < 2 || s.numChains() == 0);
            Preconditions.checkArgument((!isEmpty ? 1 : 0) != 0, (Object)"S2ShapeIndex must not contain any empty shapes.");
            Preconditions.checkArgument((s.dimension() >= lastDimension ? 1 : 0) != 0, (Object)"S2ShapeIndex shapes must be sorted by dimension.");
            int n = lastDimension = s.dimension();
            counts[n] = counts[n] + 1;
            if (s.dimension() != 0) continue;
            numPoints = s.numEdges();
        }
        Preconditions.checkArgument((counts[0] <= 1 && counts[2] <= 1 ? 1 : 0) != 0, (Object)"At most one shape is allowed for dimensions 0 and 2");
        return new STGeography(shapeIndex, numPoints, counts[1], counts[2]);
    }

    /*
     * Unable to fully structure code
     */
    public static boolean findValidationError(InputStream in, S2Error error) throws IOException {
        try {
            decoder = new LittleEndianInput(in);
            hasNumVertices = false;
            hasCovering = false;
            block8: while (true) {
                magic = in.read();
                switch (magic) {
                    case 83: {
                        numPoints = decoder.readVarint32();
                        numLines = decoder.readVarint32();
                        numPolygons = decoder.readVarint32();
                        if (numPoints < 0) {
                            error.init(S2Error.Code.DATA_LOSS, new StringBuilder(36).append("Invalid number of points ").append(numPoints).toString(), new Object[0]);
                            return true;
                        }
                        if (numLines < 0) {
                            error.init(S2Error.Code.DATA_LOSS, new StringBuilder(35).append("Invalid number of lines ").append(numLines).toString(), new Object[0]);
                            return true;
                        }
                        if (numPolygons < 0) {
                            error.init(S2Error.Code.DATA_LOSS, new StringBuilder(38).append("Invalid number of polygons ").append(numPolygons).toString(), new Object[0]);
                            return true;
                        }
                        return false;
                    }
                    case 69: {
                        if (1L != in.skip(1L)) {
                            error.init(S2Error.Code.DATA_LOSS, "Missing encoded geograpy data", new Object[0]);
                            return true;
                        }
                        return false;
                    }
                    case 86: {
                        if (hasNumVertices) {
                            error.init(S2Error.Code.DATA_LOSS, "Multiple num vertices data", new Object[0]);
                            return true;
                        }
                        hasNumVertices = true;
                        numVertices = decoder.readVarint32();
                        if (numVertices >= 0) continue block8;
                        error.init(S2Error.Code.DATA_LOSS, new StringBuilder(38).append("Invalid number of vertices ").append(numVertices).toString(), new Object[0]);
                        return true;
                    }
                    case 67: {
                        if (hasCovering) {
                            error.init(S2Error.Code.DATA_LOSS, "Multiple covering data", new Object[0]);
                            return true;
                        }
                        hasCovering = true;
                        numCells = decoder.readVarint32();
                        if (numCells < 0) {
                            error.init(S2Error.Code.DATA_LOSS, new StringBuilder(35).append("Invalid number of cells ").append(numCells).toString(), new Object[0]);
                            return true;
                        }
                        expected = 8L * (long)numCells;
                        if (expected != in.skip(expected)) ** break;
                        continue block8;
                        error.init(S2Error.Code.DATA_LOSS, "Missing covering data", new Object[0]);
                        return true;
                    }
                    default: {
                        error.init(S2Error.Code.DATA_LOSS, new StringBuilder(32).append("Invalid magic number ").append(magic).toString(), new Object[0]);
                        return true;
                    }
                }
                break;
            }
        }
        catch (IOException ex) {
            if ("EOF".equals(ex.getMessage())) {
                error.init(S2Error.Code.DATA_LOSS, "Input terminated before expected end of data", new Object[0]);
                return true;
            }
            if ("Malformed varint.".equals(ex.getMessage())) {
                error.init(S2Error.Code.DATA_LOSS, "Malformed encoded Geography", new Object[0]);
                return true;
            }
            throw ex;
        }
    }

    public static S2CellUnion decodeCovering(ByteBuffer buffer) throws IOException {
        if (buffer.remaining() % 8 != 0) {
            throw new IOException("Invalid covering data");
        }
        S2CellUnion result = new S2CellUnion();
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        while (buffer.hasRemaining()) {
            result.cellIds().add(new S2CellId(buffer.getLong()));
        }
        return result;
    }
}

