/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.taskqueue.dev;

import com.google.appengine.api.taskqueue.InternalFailureException;
import com.google.appengine.api.taskqueue.QueueConstants;
import com.google.appengine.api.taskqueue.TaskQueuePb;
import com.google.appengine.api.taskqueue.dev.DevPullQueue;
import com.google.appengine.api.taskqueue.dev.DevPushQueue;
import com.google.appengine.api.taskqueue.dev.DevQueue;
import com.google.appengine.api.taskqueue.dev.LocalTaskQueueCallback;
import com.google.appengine.api.taskqueue.dev.QueueStateInfo;
import com.google.appengine.api.taskqueue.dev.UrlFetchJob;
import com.google.appengine.api.urlfetch.URLFetchServicePb;
import com.google.appengine.api.urlfetch.dev.LocalURLFetchService;
import com.google.appengine.repackaged.com.google.io.protocol.ProtocolMessage;
import com.google.appengine.tools.development.AbstractLocalRpcService;
import com.google.appengine.tools.development.ApiUtils;
import com.google.appengine.tools.development.Clock;
import com.google.appengine.tools.development.LatencyPercentiles;
import com.google.appengine.tools.development.LocalRpcService;
import com.google.appengine.tools.development.LocalServerEnvironment;
import com.google.appengine.tools.development.LocalServiceContext;
import com.google.apphosting.api.ApiProxy;
import com.google.apphosting.utils.config.ConfigurationException;
import com.google.apphosting.utils.config.QueueXml;
import com.google.apphosting.utils.config.QueueXmlReader;
import com.google.apphosting.utils.config.QueueYamlReader;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.nio.file.Paths;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.impl.StdSchedulerFactory;

public final class LocalTaskQueue
extends AbstractLocalRpcService {
    private static final Logger logger = Logger.getLogger(LocalTaskQueue.class.getName());
    public static final String PACKAGE = "taskqueue";
    public static final String DISABLE_AUTO_TASK_EXEC_PROP = "task_queue.disable_auto_task_execution";
    public static final String QUEUE_XML_PATH_PROP = "task_queue.queue_xml_path";
    public static final String CALLBACK_CLASS_PROP = "task_queue.callback_class";
    private final Map<String, DevQueue> queues = Collections.synchronizedMap(new TreeMap());
    private QueueXml queueConfig;
    private Scheduler scheduler;
    private boolean disableAutoTaskExecution = false;
    private LocalServerEnvironment localServerEnvironment;
    private Clock clock;
    private LocalURLFetchService fetchService;
    private LocalTaskQueueCallback callback;
    private Thread shutdownHook;
    private Random rng;

    public void init(LocalServiceContext context, Map<String, String> properties) {
        this.localServerEnvironment = context.getLocalServerEnvironment();
        this.clock = context.getClock();
        this.queueConfig = this.parseQueueConfiguration(this.localServerEnvironment.getAppDir().getPath(), properties.get(QUEUE_XML_PATH_PROP));
        logger.logp(Level.INFO, "com.google.appengine.api.taskqueue.dev.LocalTaskQueue", "init", "LocalTaskQueue is initialized");
        if (Boolean.parseBoolean(properties.get(DISABLE_AUTO_TASK_EXEC_PROP))) {
            this.disableAutoTaskExecution = true;
            logger.logp(Level.INFO, "com.google.appengine.api.taskqueue.dev.LocalTaskQueue", "init", "Automatic task execution is disabled.");
        }
        this.fetchService = new LocalURLFetchService();
        this.fetchService.init(null, new HashMap<String, String>());
        this.fetchService.setTimeoutInMs(600000);
        this.rng = new Random();
        this.initializeCallback(properties);
    }

    QueueXml parseQueueConfiguration(String appDir, final @Nullable String queueXmlPath) {
        QueueXmlReader xmlReader = queueXmlPath != null ? new QueueXmlReader(this, appDir){

            public String getFilename() {
                return queueXmlPath;
            }
        } : new QueueXmlReader(appDir);
        QueueXml resultFromXml = xmlReader.readQueueXml();
        QueueYamlReader yamlReader = new QueueYamlReader(Paths.get(appDir, "WEB-INF").toString());
        QueueXml resultFromYaml = yamlReader.parse();
        if (resultFromXml != null && resultFromYaml != null) {
            throw new ConfigurationException("Found both queue.xml and queue.yaml. Please use queue.yaml and remove queue.xml. For more information: https://cloud.google.com/appengine/docs/standard/java/config/queueref");
        }
        if (!ApiUtils.isPromotingYaml()) {
            return resultFromXml != null ? resultFromXml : resultFromYaml;
        }
        if (resultFromXml != null && resultFromYaml == null) {
            logger.logp(Level.WARNING, "com.google.appengine.api.taskqueue.dev.LocalTaskQueue", "parseQueueConfiguration", "Using queue.xml. Please migrate to queue.yaml. For more information: https://cloud.google.com/appengine/docs/standard/java/config/queueref");
        }
        return resultFromYaml != null ? resultFromYaml : resultFromXml;
    }

    private void initializeCallback(Map<String, String> properties) {
        String callbackOverrideClass = properties.get(CALLBACK_CLASS_PROP);
        if (callbackOverrideClass != null) {
            try {
                this.callback = (LocalTaskQueueCallback)LocalTaskQueue.newInstance(Class.forName(callbackOverrideClass));
            }
            catch (InstantiationException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        } else {
            this.callback = new UrlFetchServiceLocalTaskQueueCallback(this.fetchService);
        }
        this.callback.initialize(properties);
    }

    private static <E> E newInstance(Class<E> clazz) throws InstantiationException, IllegalAccessException {
        try {
            return clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            Constructor<E> defaultConstructor;
            try {
                defaultConstructor = clazz.getDeclaredConstructor(new Class[0]);
            }
            catch (NoSuchMethodException f) {
                throw new InstantiationException("No zero-arg constructor.");
            }
            defaultConstructor.setAccessible(true);
            try {
                return defaultConstructor.newInstance(new Object[0]);
            }
            catch (InvocationTargetException g) {
                throw new RuntimeException(g);
            }
        }
    }

    void setQueueXml(QueueXml queueXml) {
        this.queueConfig = queueXml;
    }

    public void start() {
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                LocalTaskQueue.this.start_();
                return null;
            }
        });
    }

    private void start_() {
        this.shutdownHook = new Thread(){

            @Override
            public void run() {
                LocalTaskQueue.this.stop_();
            }
        };
        Runtime.getRuntime().addShutdownHook(this.shutdownHook);
        this.fetchService.start();
        UrlFetchJob.initialize(this.localServerEnvironment, this.clock);
        this.scheduler = LocalTaskQueue.startScheduler(this.disableAutoTaskExecution);
        String baseUrl = LocalTaskQueue.getBaseUrl(this.localServerEnvironment);
        if (this.queueConfig != null) {
            for (QueueXml.Entry entry : this.queueConfig.getEntries()) {
                if ("pull".equals(entry.getMode())) {
                    this.queues.put(entry.getName(), new DevPullQueue(entry, this.clock));
                    continue;
                }
                this.queues.put(entry.getName(), new DevPushQueue(entry, this.scheduler, baseUrl, this.clock, this.callback));
            }
        }
        if (this.queues.get("default") == null) {
            QueueXml.Entry entry = QueueXml.defaultEntry();
            this.queues.put(entry.getName(), new DevPushQueue(entry, this.scheduler, baseUrl, this.clock, this.callback));
        }
        String string = String.valueOf(baseUrl);
        logger.logp(Level.INFO, "com.google.appengine.api.taskqueue.dev.LocalTaskQueue", "start_", string.length() != 0 ? "Local task queue initialized with base url ".concat(string) : new String("Local task queue initialized with base url "));
    }

    static String getBaseUrl(LocalServerEnvironment localServerEnvironment) {
        String destAddress = localServerEnvironment.getAddress();
        if ("0.0.0.0".equals(destAddress)) {
            boolean ipv6 = InetAddress.getLoopbackAddress() instanceof Inet6Address;
            destAddress = ipv6 ? "[::1]" : "127.0.0.1";
        }
        return String.format("http://%s:%d", destAddress, localServerEnvironment.getPort());
    }

    public void stop() {
        if (this.shutdownHook != null) {
            AccessController.doPrivileged(new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    Runtime.getRuntime().removeShutdownHook(LocalTaskQueue.this.shutdownHook);
                    return null;
                }
            });
            this.shutdownHook = null;
        }
        this.stop_();
    }

    private void stop_() {
        this.queues.clear();
        LocalTaskQueue.stopScheduler(this.scheduler);
        this.fetchService.stop();
    }

    public String getPackage() {
        return PACKAGE;
    }

    private long currentTimeMillis() {
        return this.clock.getCurrentTime();
    }

    private long currentTimeUsec() {
        return this.currentTimeMillis() * 1000L;
    }

    TaskQueuePb.TaskQueueServiceError.ErrorCode validateAddRequest(TaskQueuePb.TaskQueueAddRequest addRequest) {
        String taskName = addRequest.getTaskName();
        if (taskName != null && taskName.length() != 0 && !QueueConstants.TASK_NAME_PATTERN.matcher(taskName).matches()) {
            return TaskQueuePb.TaskQueueServiceError.ErrorCode.INVALID_TASK_NAME;
        }
        String queueName = addRequest.getQueueName();
        if (queueName == null || queueName.length() == 0 || !QueueConstants.QUEUE_NAME_PATTERN.matcher(queueName).matches()) {
            return TaskQueuePb.TaskQueueServiceError.ErrorCode.INVALID_QUEUE_NAME;
        }
        if (addRequest.getEtaUsec() < 0L) {
            return TaskQueuePb.TaskQueueServiceError.ErrorCode.INVALID_ETA;
        }
        if (addRequest.getEtaUsec() - this.currentTimeUsec() > LocalTaskQueue.getMaxEtaDeltaUsec()) {
            return TaskQueuePb.TaskQueueServiceError.ErrorCode.INVALID_ETA;
        }
        if (addRequest.getMode() == TaskQueuePb.TaskQueueMode.Mode.PULL.getValue()) {
            return this.validateAddPullRequest(addRequest);
        }
        return this.validateAddPushRequest(addRequest);
    }

    TaskQueuePb.TaskQueueServiceError.ErrorCode validateAddPullRequest(TaskQueuePb.TaskQueueAddRequest addRequest) {
        if (!addRequest.hasBody()) {
            return TaskQueuePb.TaskQueueServiceError.ErrorCode.INVALID_REQUEST;
        }
        return TaskQueuePb.TaskQueueServiceError.ErrorCode.OK;
    }

    TaskQueuePb.TaskQueueServiceError.ErrorCode validateAddPushRequest(TaskQueuePb.TaskQueueAddRequest addRequest) {
        String url = addRequest.getUrl();
        if (!addRequest.hasUrl() || url.length() == 0 || url.charAt(0) != '/' || url.length() > QueueConstants.maxUrlLength()) {
            return TaskQueuePb.TaskQueueServiceError.ErrorCode.INVALID_URL;
        }
        return TaskQueuePb.TaskQueueServiceError.ErrorCode.OK;
    }

    static long getMaxEtaDeltaUsec() {
        return QueueConstants.getMaxEtaDeltaMillis() * 1000L;
    }

    @LatencyPercentiles(latency50th=4)
    public TaskQueuePb.TaskQueueAddResponse add(LocalRpcService.Status status, TaskQueuePb.TaskQueueAddRequest addRequest) {
        TaskQueuePb.TaskQueueBulkAddRequest bulkRequest = new TaskQueuePb.TaskQueueBulkAddRequest();
        TaskQueuePb.TaskQueueAddResponse addResponse = new TaskQueuePb.TaskQueueAddResponse();
        bulkRequest.addAddRequest().copyFrom((ProtocolMessage)addRequest);
        TaskQueuePb.TaskQueueBulkAddResponse bulkResponse = this.bulkAdd(status, bulkRequest);
        if (bulkResponse.taskResultSize() != 1) {
            throw new InternalFailureException(String.format("expected 1 result from BulkAdd(), got %d", bulkResponse.taskResultSize()));
        }
        int result = bulkResponse.getTaskResult(0).getResult();
        if (result != TaskQueuePb.TaskQueueServiceError.ErrorCode.OK.getValue()) {
            throw new ApiProxy.ApplicationException(result);
        }
        if (bulkResponse.getTaskResult(0).hasChosenTaskName()) {
            addResponse.setChosenTaskName(bulkResponse.getTaskResult(0).getChosenTaskName());
        }
        return addResponse;
    }

    @LatencyPercentiles(latency50th=3)
    public TaskQueuePb.TaskQueueFetchQueueStatsResponse fetchQueueStats(LocalRpcService.Status status, TaskQueuePb.TaskQueueFetchQueueStatsRequest fetchQueueStatsRequest) {
        TaskQueuePb.TaskQueueFetchQueueStatsResponse fetchQueueStatsResponse = new TaskQueuePb.TaskQueueFetchQueueStatsResponse();
        for (String unused : fetchQueueStatsRequest.queueNames()) {
            TaskQueuePb.TaskQueueFetchQueueStatsResponse.QueueStats stats = new TaskQueuePb.TaskQueueFetchQueueStatsResponse.QueueStats();
            TaskQueuePb.TaskQueueScannerQueueInfo scannerInfo = new TaskQueuePb.TaskQueueScannerQueueInfo();
            scannerInfo.setEnforcedRate((double)(this.rng.nextInt(500) + 1));
            scannerInfo.setExecutedLastMinute((long)this.rng.nextInt(3000));
            scannerInfo.setRequestsInFlight(this.rng.nextInt(5));
            if (this.rng.nextBoolean()) {
                stats.setNumTasks(0);
                stats.setOldestEtaUsec(-1L);
            } else {
                stats.setNumTasks(this.rng.nextInt(2000) + 1);
                stats.setOldestEtaUsec(this.currentTimeMillis() * 1000L);
            }
            stats.setScannerInfo(scannerInfo);
            fetchQueueStatsResponse.addQueueStats(stats);
        }
        return fetchQueueStatsResponse;
    }

    @LatencyPercentiles(latency50th=3)
    public TaskQueuePb.TaskQueuePurgeQueueResponse purgeQueue(LocalRpcService.Status status, TaskQueuePb.TaskQueuePurgeQueueRequest purgeQueueRequest) {
        TaskQueuePb.TaskQueuePurgeQueueResponse purgeQueueResponse = new TaskQueuePb.TaskQueuePurgeQueueResponse();
        this.flushQueue(purgeQueueRequest.getQueueName());
        return purgeQueueResponse;
    }

    @LatencyPercentiles(latency50th=4)
    public TaskQueuePb.TaskQueueBulkAddResponse bulkAdd(LocalRpcService.Status status, TaskQueuePb.TaskQueueBulkAddRequest bulkAddRequest) {
        TaskQueuePb.TaskQueueBulkAddResponse.TaskResult taskResult;
        TaskQueuePb.TaskQueueBulkAddResponse bulkAddResponse = new TaskQueuePb.TaskQueueBulkAddResponse();
        if (bulkAddRequest.addRequestSize() == 0) {
            return bulkAddResponse;
        }
        bulkAddRequest = (TaskQueuePb.TaskQueueBulkAddRequest)bulkAddRequest.clone();
        DevQueue queue = this.getQueueByName(bulkAddRequest.getAddRequest(0).getQueueName());
        IdentityHashMap<TaskQueuePb.TaskQueueBulkAddResponse.TaskResult, String> chosenNames = new IdentityHashMap<TaskQueuePb.TaskQueueBulkAddResponse.TaskResult, String>();
        boolean errorFound = false;
        for (TaskQueuePb.TaskQueueAddRequest addRequest : bulkAddRequest.addRequests()) {
            taskResult = bulkAddResponse.addTaskResult();
            TaskQueuePb.TaskQueueServiceError.ErrorCode error = this.validateAddRequest(addRequest);
            if (error == TaskQueuePb.TaskQueueServiceError.ErrorCode.OK) {
                if (!addRequest.hasTaskName() || addRequest.getTaskName().isEmpty()) {
                    addRequest = addRequest.setTaskName(DevQueue.genTaskName());
                    chosenNames.put(taskResult, addRequest.getTaskName());
                }
                taskResult.setResult(TaskQueuePb.TaskQueueServiceError.ErrorCode.SKIPPED.getValue());
                continue;
            }
            taskResult.setResult(error.getValue());
            errorFound = true;
        }
        if (errorFound) {
            return bulkAddResponse;
        }
        if (bulkAddRequest.getAddRequest(0).hasTransaction() || bulkAddRequest.getAddRequest(0).hasDatastoreTransaction()) {
            try {
                ApiProxy.makeSyncCall((String)"datastore_v3", (String)"addActions", (byte[])bulkAddRequest.toByteArray());
            }
            catch (ApiProxy.ApplicationException exception) {
                throw new ApiProxy.ApplicationException(exception.getApplicationError() + TaskQueuePb.TaskQueueServiceError.ErrorCode.DATASTORE_ERROR.getValue(), exception.getErrorDetail());
            }
        } else {
            for (int i = 0; i < bulkAddRequest.addRequestSize(); ++i) {
                TaskQueuePb.TaskQueueAddRequest addRequest;
                addRequest = bulkAddRequest.getAddRequest(i);
                taskResult = bulkAddResponse.getTaskResult(i);
                try {
                    queue.add(addRequest);
                    continue;
                }
                catch (ApiProxy.ApplicationException exception) {
                    taskResult.setResult(exception.getApplicationError());
                }
            }
        }
        for (TaskQueuePb.TaskQueueBulkAddResponse.TaskResult taskResult2 : bulkAddResponse.taskResults()) {
            if (taskResult2.getResult() != TaskQueuePb.TaskQueueServiceError.ErrorCode.SKIPPED.getValue()) continue;
            taskResult2.setResult(TaskQueuePb.TaskQueueServiceError.ErrorCode.OK.getValue());
            if (!chosenNames.containsKey(taskResult2)) continue;
            taskResult2.setChosenTaskName((String)chosenNames.get(taskResult2));
        }
        return bulkAddResponse;
    }

    public TaskQueuePb.TaskQueueDeleteResponse delete(LocalRpcService.Status status, TaskQueuePb.TaskQueueDeleteRequest request) {
        String queueName = request.getQueueName();
        DevQueue queue = this.getQueueByName(queueName);
        TaskQueuePb.TaskQueueDeleteResponse response = new TaskQueuePb.TaskQueueDeleteResponse();
        for (String taskName : request.taskNames()) {
            try {
                if (!queue.deleteTask(taskName)) {
                    response.addResult(TaskQueuePb.TaskQueueServiceError.ErrorCode.UNKNOWN_TASK.getValue());
                    continue;
                }
                response.addResult(TaskQueuePb.TaskQueueServiceError.ErrorCode.OK.getValue());
            }
            catch (ApiProxy.ApplicationException e) {
                response.addResult(e.getApplicationError());
            }
        }
        return response;
    }

    @LatencyPercentiles(latency50th=8)
    public TaskQueuePb.TaskQueueQueryAndOwnTasksResponse queryAndOwnTasks(LocalRpcService.Status status, TaskQueuePb.TaskQueueQueryAndOwnTasksRequest request) {
        String queueName = request.getQueueName();
        LocalTaskQueue.validateQueueName(queueName);
        DevQueue queue = this.getQueueByName(queueName);
        if (queue.getMode() != TaskQueuePb.TaskQueueMode.Mode.PULL) {
            throw new ApiProxy.ApplicationException(TaskQueuePb.TaskQueueServiceError.ErrorCode.INVALID_QUEUE_MODE.getValue());
        }
        DevPullQueue pullQueue = (DevPullQueue)queue;
        List<TaskQueuePb.TaskQueueAddRequest> results = pullQueue.queryAndOwnTasks(request.getLeaseSeconds(), request.getMaxTasks(), request.isGroupByTag(), request.getTagAsBytes());
        TaskQueuePb.TaskQueueQueryAndOwnTasksResponse response = new TaskQueuePb.TaskQueueQueryAndOwnTasksResponse();
        for (TaskQueuePb.TaskQueueAddRequest task : results) {
            TaskQueuePb.TaskQueueQueryAndOwnTasksResponse.Task responseTask = response.addTask();
            responseTask.setTaskName(task.getTaskName());
            responseTask.setBodyAsBytes(task.getBodyAsBytes());
            responseTask.setEtaUsec(task.getEtaUsec());
            if (!task.hasTag()) continue;
            responseTask.setTagAsBytes(task.getTagAsBytes());
        }
        return response;
    }

    public TaskQueuePb.TaskQueueModifyTaskLeaseResponse modifyTaskLease(LocalRpcService.Status status, TaskQueuePb.TaskQueueModifyTaskLeaseRequest request) {
        String queueName = request.getQueueName();
        LocalTaskQueue.validateQueueName(queueName);
        String taskName = request.getTaskName();
        LocalTaskQueue.validateTaskName(taskName);
        DevQueue queue = this.getQueueByName(queueName);
        if (queue.getMode() != TaskQueuePb.TaskQueueMode.Mode.PULL) {
            throw new ApiProxy.ApplicationException(TaskQueuePb.TaskQueueServiceError.ErrorCode.INVALID_QUEUE_MODE.getValue());
        }
        DevPullQueue pullQueue = (DevPullQueue)queue;
        return pullQueue.modifyTaskLease(request);
    }

    public Map<String, QueueStateInfo> getQueueStateInfo() {
        return this.getQueueStateInfoInternal();
    }

    private Map<String, QueueStateInfo> getQueueStateInfoInternal() {
        TreeMap<String, QueueStateInfo> queueStateInfo = new TreeMap<String, QueueStateInfo>();
        for (Map.Entry<String, DevQueue> entry : this.queues.entrySet()) {
            String queueName = entry.getKey();
            queueStateInfo.put(queueName, entry.getValue().getStateInfo());
        }
        return queueStateInfo;
    }

    private DevQueue getQueueByName(String queueName) {
        DevQueue queue = this.queues.get(queueName);
        if (queue == null) {
            throw new ApiProxy.ApplicationException(TaskQueuePb.TaskQueueServiceError.ErrorCode.UNKNOWN_QUEUE.getValue(), queueName);
        }
        return queue;
    }

    @LatencyPercentiles(latency50th=4)
    public void flushQueue(String queueName) {
        DevQueue queue = this.getQueueByName(queueName);
        queue.flush();
    }

    public boolean deleteTask(String queueName, String taskName) {
        DevQueue queue = this.getQueueByName(queueName);
        return queue.deleteTask(taskName);
    }

    static Scheduler startScheduler(boolean disableAutoTaskExecution) {
        try {
            Scheduler scheduler = StdSchedulerFactory.getDefaultScheduler();
            if (!disableAutoTaskExecution) {
                scheduler.start();
            }
            return scheduler;
        }
        catch (SchedulerException e) {
            throw new RuntimeException(e);
        }
    }

    static void stopScheduler(Scheduler scheduler) {
        try {
            scheduler.shutdown(false);
        }
        catch (SchedulerException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean runTask(String queueName, String taskName) {
        DevQueue queue = this.getQueueByName(queueName);
        return queue.runTask(taskName);
    }

    public Double getMaximumDeadline(boolean isOfflineRequest) {
        return 30.0;
    }

    static final void validateQueueName(String queueName) throws ApiProxy.ApplicationException {
        if (queueName == null || queueName.length() == 0 || !QueueConstants.QUEUE_NAME_PATTERN.matcher(queueName).matches()) {
            throw new ApiProxy.ApplicationException(TaskQueuePb.TaskQueueServiceError.ErrorCode.INVALID_QUEUE_NAME.getValue());
        }
    }

    static final void validateTaskName(String taskName) throws ApiProxy.ApplicationException {
        if (taskName == null || taskName.length() == 0 || !QueueConstants.TASK_NAME_PATTERN.matcher(taskName).matches()) {
            throw new ApiProxy.ApplicationException(TaskQueuePb.TaskQueueServiceError.ErrorCode.INVALID_TASK_NAME.getValue());
        }
    }

    static final class UrlFetchServiceLocalTaskQueueCallback
    implements LocalTaskQueueCallback {
        private final LocalURLFetchService fetchService;

        UrlFetchServiceLocalTaskQueueCallback(LocalURLFetchService fetchService) {
            this.fetchService = fetchService;
        }

        @Override
        public int execute(URLFetchServicePb.URLFetchRequest fetchReq) {
            LocalRpcService.Status status = new LocalRpcService.Status();
            return this.fetchService.fetch(status, fetchReq).getStatusCode();
        }

        @Override
        public void initialize(Map<String, String> properties) {
        }
    }
}

