/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.common.geometry;

import com.google.appengine.repackaged.com.google.common.annotations.GwtCompatible;
import com.google.appengine.repackaged.com.google.common.annotations.VisibleForTesting;
import com.google.appengine.repackaged.com.google.common.geometry.S1Angle;
import com.google.appengine.repackaged.com.google.common.geometry.S2;
import com.google.appengine.repackaged.com.google.common.geometry.S2Point;
import com.google.appengine.repackaged.com.google.common.geometry.S2Shape;
import com.google.appengine.repackaged.com.google.common.geometry.S2ShapeUtil;
import java.util.AbstractList;
import java.util.List;

@GwtCompatible
final class S2ShapeMeasures {
    private S2ShapeMeasures() {
    }

    public static S1Angle length(S2Shape shape) {
        if (shape.dimension() != 1) {
            return S1Angle.ZERO;
        }
        S1Angle.Builder builder = new S1Angle.Builder();
        for (int chainId = 0; chainId < shape.numChains(); ++chainId) {
            builder.add(S2ShapeMeasures.polylineLength(shape, chainId));
        }
        return builder.build();
    }

    @VisibleForTesting
    static S1Angle polylineLength(S2Shape shape, int chainId) {
        S1Angle.Builder builder = new S1Angle.Builder();
        S2ShapeMeasures.forEachChainEdge(shape, chainId, (a, b) -> builder.add(a.angle((S2Point)b)));
        return builder.build();
    }

    public static S1Angle perimeter(S2Shape shape) {
        if (shape.dimension() != 2) {
            return S1Angle.ZERO;
        }
        S1Angle.Builder builder = new S1Angle.Builder();
        for (int chainId = 0; chainId < shape.numChains(); ++chainId) {
            builder.add(S2ShapeMeasures.loopPerimeter(shape, chainId));
        }
        return builder.build();
    }

    @VisibleForTesting
    static S1Angle loopPerimeter(S2Shape shape, int chainId) {
        if (shape.getChainLength(chainId) <= 1) {
            return S1Angle.ZERO;
        }
        S1Angle.Builder builder = new S1Angle.Builder();
        S2ShapeMeasures.forEachChainEdge(shape, chainId, (a, b) -> builder.add(a.angle((S2Point)b)));
        return builder.build();
    }

    public static S2Point centroid(S2Shape shape) {
        S2Point.Builder builder = new S2Point.Builder();
        int dimension = shape.dimension();
        int numChains = shape.numChains();
        switch (dimension) {
            case 0: {
                for (int chainId = 0; chainId < numChains; ++chainId) {
                    builder.add(shape.getChainVertex(chainId, 0));
                }
                break;
            }
            case 1: {
                for (int chainId = 0; chainId < numChains; ++chainId) {
                    builder.add(S2ShapeMeasures.polylineCentroid(shape, chainId));
                }
                break;
            }
            case 2: {
                for (int chainId = 0; chainId < numChains; ++chainId) {
                    builder.add(S2ShapeMeasures.loopCentroid(shape, chainId));
                }
                break;
            }
            default: {
                int n = shape.dimension();
                throw new IllegalArgumentException(new StringBuilder(41).append("Unexpected S2Shape dimension: ").append(n).toString());
            }
        }
        return builder.build();
    }

    @VisibleForTesting
    static S2Point polylineCentroid(S2Shape shape, int chainId) {
        S2Point.Builder builder = new S2Point.Builder();
        S2ShapeMeasures.forEachChainEdge(shape, chainId, (a, b) -> builder.add(S2.trueCentroid(a, b)));
        return builder.build();
    }

    @VisibleForTesting
    static S2Point loopCentroid(final S2Shape shape, final int chainId) {
        S2ShapeUtil.CentroidMeasure centroidMeasure = new S2ShapeUtil.CentroidMeasure();
        S2ShapeUtil.visitSurfaceIntegral((List<S2Point>)new AbstractList<S2Point>(){

            @Override
            public S2Point get(int i) {
                return shape.getChainVertex(chainId, i);
            }

            @Override
            public int size() {
                return shape.getChainLength(chainId);
            }
        }, centroidMeasure);
        return centroidMeasure.value();
    }

    private static void forEachChainEdge(S2Shape shape, int chainId, BiConsumer<S2Point, S2Point> edgeConsumer) {
        int chainLength = shape.getChainLength(chainId);
        if (chainLength == 0) {
            return;
        }
        S2Point prev = shape.getChainVertex(chainId, 0);
        for (int edgeOffset = 1; edgeOffset <= chainLength; ++edgeOffset) {
            S2Point next = shape.getChainVertex(chainId, edgeOffset);
            edgeConsumer.accept(prev, next);
            prev = next;
        }
    }

    private static interface BiConsumer<T, U> {
        public void accept(T var1, U var2);
    }
}

