/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.core.appengv3.converter;

import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.repackaged.com.google.common.base.Utf8;
import com.google.appengine.repackaged.com.google.common.collect.ArrayListMultimap;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableList;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableMap;
import com.google.appengine.repackaged.com.google.common.collect.ListMultimap;
import com.google.appengine.repackaged.com.google.io.protocol.ProtocolMessage;
import com.google.appengine.repackaged.com.google.protobuf.ByteString;
import com.google.appengine.repackaged.com.google.protobuf.InvalidProtocolBufferException;
import com.google.appengine.repackaged.com.google.protobuf.Timestamp;
import com.google.appengine.repackaged.com.google.protobuf.UnknownFieldSet;
import com.google.appengine.repackaged.com.google.type.LatLng;
import com.google.apphosting.datastore.shared.Config;
import com.google.cloud.datastore.core.appengv3.UserValueObfuscator;
import com.google.cloud.datastore.core.appengv3.converter.AppEngV3ResourceRefToRepConverter;
import com.google.cloud.datastore.core.config.DatastoreCustomizableConfigUtils;
import com.google.cloud.datastore.core.config.proto1api.DatastoreCustomizableConfigPb;
import com.google.cloud.datastore.core.exception.InvalidConversionException;
import com.google.cloud.datastore.core.rep.Entity;
import com.google.cloud.datastore.core.rep.EntityRef;
import com.google.cloud.datastore.core.rep.ReservedName;
import com.google.cloud.datastore.core.rep.Value;
import com.google.cloud.datastore.core.rep.converter.ConverterHelper;
import com.google.storage.onestore.v3.OnestoreEntity;
import java.util.List;
import javax.annotation.Nullable;

public class AppEngV3EntityToRepConverter {
    private final Config.DatastoreConfig config;
    private final UserValueObfuscator userValueObfuscator;
    private final AppEngV3ResourceRefToRepConverter appEngV3ResourceRefToRepConverter;

    public AppEngV3EntityToRepConverter(Config.DatastoreConfig config, UserValueObfuscator userValueObfuscator, AppEngV3ResourceRefToRepConverter appEngV3ResourceRefToRepConverter) {
        this.config = (Config.DatastoreConfig)Preconditions.checkNotNull((Object)config);
        this.userValueObfuscator = (UserValueObfuscator)Preconditions.checkNotNull((Object)userValueObfuscator);
        this.appEngV3ResourceRefToRepConverter = (AppEngV3ResourceRefToRepConverter)Preconditions.checkNotNull((Object)appEngV3ResourceRefToRepConverter);
    }

    public Entity convertEntityUnchecked(OnestoreEntity.EntityProto v3Entity, @Nullable DatastoreCustomizableConfigPb.DatastoreCustomizableConfig configOverrides) {
        try {
            return this.convertEntity(v3Entity, configOverrides);
        }
        catch (InvalidConversionException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public Entity convertEntity(OnestoreEntity.EntityProto v3Entity, @Nullable DatastoreCustomizableConfigPb.DatastoreCustomizableConfig configOverrides) throws InvalidConversionException {
        OnestoreEntity.Reference v3EntityRef = v3Entity.getKey();
        EntityRef ref = this.appEngV3ResourceRefToRepConverter.convertEntityRef(v3EntityRef, configOverrides);
        InvalidConversionException.checkConversion(this.entityDoesV3GroupMatchKey(v3Entity), "OnestoreEntity.EntityProto entity_group does not match key.", new Object[0]);
        this.checkForUnknownFields((ProtocolMessage)v3Entity, "OnestoreEntity.EntityProto contains unknown fields.", new Object[0]);
        ImmutableMap<String, Value> propertyMap = this.convertEntityPropertiesToMap(v3Entity.propertys(), v3Entity.rawPropertys(), configOverrides);
        return Entity.create(ref, propertyMap);
    }

    private boolean entityDoesV3GroupMatchKey(OnestoreEntity.EntityProto v3Entity) {
        if (v3Entity.getEntityGroup().elements().isEmpty()) {
            return true;
        }
        List v3GroupPathElements = v3Entity.getEntityGroup().elements();
        List v3KeyPathElements = v3Entity.getKey().getPath().elements();
        if (v3KeyPathElements.isEmpty()) {
            return false;
        }
        return ((OnestoreEntity.Path.Element)v3GroupPathElements.get(0)).equals((OnestoreEntity.Path.Element)v3KeyPathElements.get(0));
    }

    public ImmutableMap<String, Value> convertEntityPropertiesToMap(List<OnestoreEntity.Property> properties, List<OnestoreEntity.Property> rawProperties, @Nullable DatastoreCustomizableConfigPb.DatastoreCustomizableConfig configOverrides) throws InvalidConversionException {
        ArrayListMultimap propertyMultimap = ArrayListMultimap.create();
        for (OnestoreEntity.Property indexedPropertyV3 : properties) {
            this.addV3Property(true, indexedPropertyV3, (ListMultimap<String, Value>)propertyMultimap, configOverrides);
        }
        for (OnestoreEntity.Property unindexedPropertyV3 : rawProperties) {
            this.addV3Property(false, unindexedPropertyV3, (ListMultimap<String, Value>)propertyMultimap, configOverrides);
        }
        ImmutableMap.Builder propertyMapBuilder = ImmutableMap.builder();
        for (String propertyName : propertyMultimap.keySet()) {
            List valueList = propertyMultimap.get((Object)propertyName);
            Value value = valueList.size() > 1 ? this.finishConvertArrayValue(valueList) : (Value)valueList.get(0);
            propertyMapBuilder.put((Object)propertyName, (Object)value);
        }
        return propertyMapBuilder.build();
    }

    private Value finishConvertArrayValue(List<Value> valueList) {
        ImmutableList.Builder valueListBuilder = ImmutableList.builder();
        for (Value value : valueList) {
            if (value == null) continue;
            valueListBuilder.add((Object)value);
        }
        return Value.createArray((ImmutableList<Value>)valueListBuilder.build()).withDatastoreIndexing(Value.DatastoreIndexing.INCLUDE);
    }

    private void addV3Property(boolean isIndexed, OnestoreEntity.Property v3Property, ListMultimap<String, Value> propertyMultimap, @Nullable DatastoreCustomizableConfigPb.DatastoreCustomizableConfig configOverrides) throws InvalidConversionException {
        String name = ConverterHelper.convertUtf8("Property name", "", v3Property.getNameAsBytes());
        InvalidConversionException.checkConversion(!v3Property.hasStashed(), "Property \"%s\" sets stashed.", name);
        InvalidConversionException.checkConversion(!v3Property.hasComputed(), "Property \"%s\" sets computed.", name);
        this.checkForUnknownFields((ProtocolMessage)v3Property, "OnestoreEntity.Property contains unknown fields.", new Object[0]);
        Value value = this.convertValueForProperty(name, v3Property.getValue(), isIndexed, v3Property.getMeaningEnum(), v3Property.getMeaningUri(), configOverrides);
        if (!isIndexed && !value.equals(Value.EMPTY_ARRAY)) {
            value = value.withDatastoreIndexing(Value.DatastoreIndexing.EXCLUDE);
        }
        if (propertyMultimap.containsKey((Object)name)) {
            if (this.config.getEnableAppEngV3ConverterValidateMultipleTrue()) {
                InvalidConversionException.checkConversion(v3Property.isMultiple() && propertyMultimap.containsEntry((Object)name, null), "One of several properties \"%s\" set field multiple false.", name);
            }
        } else if (v3Property.isMultiple()) {
            propertyMultimap.put((Object)name, null);
        }
        propertyMultimap.put((Object)name, (Object)value);
    }

    public Value convertValue(OnestoreEntity.PropertyValue v3Value, boolean isIndexed, OnestoreEntity.Property.Meaning v3Meaning, String v3UriMeaning, boolean preserveMeaning, @Nullable DatastoreCustomizableConfigPb.DatastoreCustomizableConfig configOverrides) throws InvalidConversionException {
        return this.auxConvertValue(false, false, v3Value, isIndexed, v3Meaning, v3UriMeaning, preserveMeaning, configOverrides);
    }

    public Value convertValueForProperty(String propertyName, OnestoreEntity.PropertyValue v3Value, boolean isIndexed, OnestoreEntity.Property.Meaning v3Meaning, String v3UriMeaning, @Nullable DatastoreCustomizableConfigPb.DatastoreCustomizableConfig configOverrides) throws InvalidConversionException {
        boolean isScatterPropertyValue = propertyName.equals(ReservedName.SCATTER.asString());
        return this.auxConvertValue(false, isScatterPropertyValue, v3Value, isIndexed, v3Meaning, v3UriMeaning, true, configOverrides);
    }

    public Value convertValueForQueryCondition(OnestoreEntity.PropertyValue v3Value, @Nullable DatastoreCustomizableConfigPb.DatastoreCustomizableConfig configOverrides) throws InvalidConversionException {
        return this.auxConvertValue(true, false, v3Value, false, OnestoreEntity.Property.Meaning.NO_MEANING, "", false, configOverrides);
    }

    private Value auxConvertValue(boolean acceptInvalidUtf8StringBytes, boolean isScatterPropertyValue, OnestoreEntity.PropertyValue v3Value, boolean isIndexed, OnestoreEntity.Property.Meaning v3Meaning, String v3UriMeaning, boolean preserveMeaning, @Nullable DatastoreCustomizableConfigPb.DatastoreCustomizableConfig configOverrides) throws InvalidConversionException {
        Value value;
        int numSetValueFields = this.countSetValueFields(v3Value);
        InvalidConversionException.checkConversion(numSetValueFields <= 1, "OnestoreEntity.PropertyValue sets more than one value field.", new Object[0]);
        this.checkForUnknownFields((ProtocolMessage)v3Value, "OnestoreEntity.PropertyValue contains unknown fields.", new Object[0]);
        this.checkV3ValueMeaning(v3Value, v3Meaning, numSetValueFields);
        int v3MeaningNum = v3Meaning.getValue();
        Value.Meaning meaning = Value.Meaning.createFromOrdinal(v3MeaningNum);
        InvalidConversionException.checkConversion(meaning != null, "Unknown meaning %s.", v3Meaning);
        if (!v3UriMeaning.isEmpty()) {
            this.checkV3ValueUriMeaning(v3Value, v3UriMeaning, v3Meaning);
            meaning = Value.Meaning.URI_MEANING_ZLIB;
        }
        if (v3Value.hasBooleanValue()) {
            value = Value.createBoolean(v3Value.isBooleanValue());
        } else if (v3Value.hasInt64Value()) {
            if (v3Meaning == OnestoreEntity.Property.Meaning.GD_WHEN) {
                meaning = Value.Meaning.NONE;
                value = this.convertMicroseconds(v3Value.getInt64Value());
            } else {
                value = Value.createLong(v3Value.getInt64Value());
            }
        } else if (v3Value.hasDoubleValue()) {
            value = Value.createDouble(v3Value.getDoubleValue());
        } else if (v3Value.hasReferenceValue()) {
            value = Value.createEntityRef(this.appEngV3ResourceRefToRepConverter.convertEntityRefForValue(v3Value.getReferenceValue(), configOverrides));
        } else if (v3Value.hasStringValue()) {
            if (v3Meaning == OnestoreEntity.Property.Meaning.ENTITY_PROTO) {
                OnestoreEntity.EntityProto v3Entity = null;
                try {
                    v3Entity = (OnestoreEntity.EntityProto)OnestoreEntity.EntityProto.parser().parsePartialFrom(v3Value.getStringValueAsBytes());
                }
                catch (InvalidProtocolBufferException exception) {
                    InvalidConversionException.checkConversion(!this.config.getEnableAppEngV3ValidateUnindexedValueEntityProto(), "String value with meaning ENTITY_PROTO is not a serialized EntityProto.", new Object[0]);
                }
                if (v3Entity == null) {
                    value = Value.createBytes(ByteString.copyFrom((byte[])v3Value.getStringValueAsBytes()));
                } else {
                    meaning = Value.Meaning.NONE;
                    value = this.convertMapOrEntity(v3Entity, configOverrides);
                }
            } else if (v3Meaning == OnestoreEntity.Property.Meaning.BLOB || v3Meaning == OnestoreEntity.Property.Meaning.BYTESTRING) {
                InvalidConversionException.checkConversion(!isIndexed || v3Meaning != OnestoreEntity.Property.Meaning.BLOB, "A property with meaning BLOB cannot be indexed.", new Object[0]);
                value = Value.createBytes(ByteString.copyFrom((byte[])v3Value.getStringValueAsBytes()));
                if ((isIndexed || v3Meaning == OnestoreEntity.Property.Meaning.BLOB) && meaning != Value.Meaning.URI_MEANING_ZLIB) {
                    meaning = Value.Meaning.NONE;
                }
            } else {
                byte[] stringBytes = v3Value.getStringValueAsBytes();
                if (Utf8.isWellFormed((byte[])stringBytes)) {
                    value = Value.createString(v3Value.getStringValue());
                } else {
                    InvalidConversionException.checkConversion(acceptInvalidUtf8StringBytes || v3Meaning == OnestoreEntity.Property.Meaning.NO_MEANING || v3Meaning == OnestoreEntity.Property.Meaning.TEXT || !DatastoreCustomizableConfigUtils.getCustomizableConfig(this.config, configOverrides).getEnableAppEngV3ValidateValueStringUtf8() || isScatterPropertyValue && meaning == Value.Meaning.NONE, "Ordinary OnestoreEntity.PropertyValue.string_value is not UTF-8.", new Object[0]);
                    value = Value.createBytes(ByteString.copyFrom((byte[])stringBytes));
                    switch (v3Meaning) {
                        case NO_MEANING: {
                            meaning = Value.Meaning.NON_UTF8_BLOB_WITH_APP_ENG_V3_MEANING_NONE;
                            break;
                        }
                        case TEXT: {
                            meaning = Value.Meaning.NON_UTF8_BLOB_WITH_APP_ENG_V3_MEANING_TEXT;
                            break;
                        }
                        default: {
                            meaning = Value.Meaning.NONE;
                        }
                    }
                }
            }
        } else if (v3Value.hasPointValue()) {
            this.checkForUnknownFields((ProtocolMessage)v3Value.getPointValue(), "OnestoreEntity.PropertyValue.PointValue contains unknown fields.", new Object[0]);
            if (v3Meaning == OnestoreEntity.Property.Meaning.GEORSS_POINT) {
                meaning = Value.Meaning.NONE;
            } else if (v3Meaning == OnestoreEntity.Property.Meaning.NO_MEANING) {
                meaning = Value.Meaning.GEO_POINT_WITHOUT_APP_ENG_V3_MEANING;
            }
            OnestoreEntity.PropertyValue.PointValue v3GeoPoint = v3Value.getPointValue();
            LatLng geoPoint = LatLng.newBuilder().setLatitude(v3GeoPoint.getX()).setLongitude(v3GeoPoint.getY()).build();
            value = Value.createGeoPoint(geoPoint);
        } else if (v3Value.hasUserValue()) {
            this.checkForUnknownFields((ProtocolMessage)v3Value.getUserValue(), "OnestoreEntity.PropertyValue.UserValue contains unknown fields.", new Object[0]);
            value = this.convertUserValue(v3Value.getUserValue());
        } else if (v3Meaning == OnestoreEntity.Property.Meaning.EMPTY_LIST) {
            meaning = Value.Meaning.NONE;
            value = Value.EMPTY_ARRAY;
        } else {
            value = Value.NULL;
        }
        if (meaning != Value.Meaning.NONE && preserveMeaning) {
            value = value.withMeaning(meaning);
        }
        return value;
    }

    private int countSetValueFields(OnestoreEntity.PropertyValue v3Value) throws InvalidConversionException {
        int numSetValueFields = 0;
        if (v3Value.hasBooleanValue()) {
            ++numSetValueFields;
        }
        if (v3Value.hasInt64Value()) {
            ++numSetValueFields;
        }
        if (v3Value.hasDoubleValue()) {
            ++numSetValueFields;
        }
        if (v3Value.hasReferenceValue()) {
            ++numSetValueFields;
        }
        if (v3Value.hasStringValue()) {
            ++numSetValueFields;
        }
        if (v3Value.hasPointValue()) {
            ++numSetValueFields;
        }
        if (v3Value.hasUserValue()) {
            ++numSetValueFields;
        }
        return numSetValueFields;
    }

    private void checkV3ValueMeaning(OnestoreEntity.PropertyValue v3Value, OnestoreEntity.Property.Meaning v3Meaning, int numSetValueFields) throws InvalidConversionException {
        boolean predicate = true;
        switch (v3Meaning) {
            case NO_MEANING: 
            case INDEX_VALUE: {
                break;
            }
            case EMPTY_LIST: {
                predicate = numSetValueFields == 0;
                break;
            }
            case TEXT: 
            case BLOB: 
            case BYTESTRING: 
            case ATOM_CATEGORY: 
            case ATOM_LINK: 
            case ATOM_TITLE: 
            case ATOM_CONTENT: 
            case ATOM_SUMMARY: 
            case ATOM_AUTHOR: 
            case GD_EMAIL: 
            case GD_IM: 
            case GD_PHONENUMBER: 
            case GD_POSTALADDRESS: 
            case BLOBKEY: 
            case ENTITY_PROTO: {
                predicate = v3Value.hasStringValue();
                break;
            }
            case GD_WHEN: 
            case GD_RATING: {
                predicate = v3Value.hasInt64Value();
                break;
            }
            case GEORSS_POINT: {
                predicate = v3Value.hasPointValue();
            }
        }
        InvalidConversionException.checkConversion(predicate, "OnestoreEntity.PropertyValue meaning does not match value fields.", new Object[0]);
    }

    private void checkV3ValueUriMeaning(OnestoreEntity.PropertyValue v3Value, String v3UriMeaning, OnestoreEntity.Property.Meaning v3Meaning) throws InvalidConversionException {
        InvalidConversionException.checkConversion(v3UriMeaning.equals("ZLIB"), "OnestoreEntity.PropertyValue has unknown meaning_uri \"%s\".", v3UriMeaning);
        InvalidConversionException.checkConversion(v3Value.hasStringValue(), "OnestoreEntity.PropertyValue with meaning_uri does not set stringValue.", new Object[0]);
        InvalidConversionException.checkConversion(v3Meaning == OnestoreEntity.Property.Meaning.BLOB, "OnestoreEntity.PropertyValue with meaning_uri has meaning other than BLOB.", new Object[0]);
    }

    private Value convertMicroseconds(long microseconds) throws InvalidConversionException {
        try {
            Timestamp timestamp = ConverterHelper.microsecondsToTimestamp(microseconds);
            return Value.createTimestamp(timestamp);
        }
        catch (InvalidConversionException exception) {
            return Value.createLegacyTimestampMicroseconds(microseconds);
        }
    }

    private Value convertMapOrEntity(OnestoreEntity.EntityProto v3Entity, @Nullable DatastoreCustomizableConfigPb.DatastoreCustomizableConfig configOverrides) throws InvalidConversionException {
        UnknownFieldSet v3UnknownFieldSet = v3Entity.getUnknownFields();
        InvalidConversionException.checkConversion(!this.config.getEnableAppEngV3ValidateEntityNoUnknownFields() || v3UnknownFieldSet.asMap().isEmpty(), "Nested entity has unknown fields.", new Object[0]);
        ImmutableMap<String, Value> map = this.convertEntityPropertiesToMap(v3Entity.propertys(), v3Entity.rawPropertys(), configOverrides);
        if (!v3Entity.hasKey()) {
            return Value.createMap(map, v3UnknownFieldSet);
        }
        OnestoreEntity.Reference v3EntityRef = v3Entity.getKey();
        if (v3EntityRef.getApp().isEmpty()) {
            InvalidConversionException.checkConversion(!v3EntityRef.hasDatabaseId() && !v3EntityRef.hasNameSpace() && v3EntityRef.getPath().elements().isEmpty(), "OnestoreEntity.Reference does not set app.", new Object[0]);
            return Value.createMap(map, v3UnknownFieldSet);
        }
        EntityRef entityRef = this.appEngV3ResourceRefToRepConverter.convertEntityRef(v3EntityRef, configOverrides);
        Entity entity = Entity.create(entityRef, map);
        return Value.createEntity(entity, v3Entity.getUnknownFields());
    }

    private Value convertUserValue(OnestoreEntity.PropertyValue.UserValue v3UserValue) throws InvalidConversionException {
        Value.LegacyUser user;
        String email = v3UserValue.getEmail();
        String authDomain = v3UserValue.getAuthDomain();
        this.checkUserFieldBytesAreValidUtf8("OnestoreEntity.PropertyValue.UserValue.authDomain", v3UserValue.getAuthDomainAsBytes());
        String federatedIdentity = null;
        if (v3UserValue.hasFederatedIdentity()) {
            this.checkUserFieldBytesAreValidUtf8("OnestoreEntity.PropertyValue.UserValue.federatedIdentity", v3UserValue.getFederatedIdentityAsBytes());
            federatedIdentity = v3UserValue.getFederatedIdentity();
        }
        String federatedProvider = null;
        if (v3UserValue.hasFederatedProvider()) {
            this.checkUserFieldBytesAreValidUtf8("OnestoreEntity.PropertyValue.UserValue.federatedProvider", v3UserValue.getFederatedProviderAsBytes());
            federatedProvider = v3UserValue.getFederatedProvider();
        }
        if ((v3UserValue = (OnestoreEntity.PropertyValue.UserValue)v3UserValue.clone()).getGaiaid() != 0L) {
            long gaiaId = v3UserValue.getGaiaid();
            this.userValueObfuscator.obfuscateUserValue(v3UserValue);
            user = Value.LegacyUser.create(email, authDomain, gaiaId, v3UserValue.getObfuscatedGaiaid(), federatedIdentity, federatedProvider);
        } else {
            String obfuscatedGaiaId = v3UserValue.getObfuscatedGaiaid();
            if (!obfuscatedGaiaId.isEmpty()) {
                this.userValueObfuscator.unobfuscateUserValue(v3UserValue);
            }
            user = Value.LegacyUser.create(email, authDomain, v3UserValue.getGaiaid(), obfuscatedGaiaId, federatedIdentity, federatedProvider);
        }
        return Value.createLegacyUser(user);
    }

    private void checkUserFieldBytesAreValidUtf8(String fieldName, byte[] bytes) throws InvalidConversionException {
        InvalidConversionException.checkConversion(!this.config.getEnableAppEngV3ValidateUserFieldValuesUtf8() || Utf8.isWellFormed((byte[])bytes), "Non-UTF-8 bytes in string field %s.", fieldName);
    }

    private <T extends ProtocolMessage<T>> void checkForUnknownFields(ProtocolMessage<T> proto, String message, Object ... messageArgs) throws InvalidConversionException {
        if (!this.config.getEnableAppEngV3ValidateEntityNoUnknownFields()) {
            return;
        }
        InvalidConversionException.checkConversion(proto.getUnknownFields().asMap().isEmpty(), message, messageArgs);
    }
}

