/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.core.appengv3.converter;

import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.repackaged.com.google.common.base.Utf8;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableList;
import com.google.apphosting.datastore.shared.Config;
import com.google.cloud.datastore.core.appengv3.converter.base.AppEngV3ResourceRefToRepConverterInterface;
import com.google.cloud.datastore.core.config.DatastoreCustomizableConfigUtils;
import com.google.cloud.datastore.core.config.proto1api.DatastoreCustomizableConfigPb;
import com.google.cloud.datastore.core.exception.InvalidConversionException;
import com.google.cloud.datastore.core.rep.DatabaseRef;
import com.google.cloud.datastore.core.rep.EntityRef;
import com.google.cloud.datastore.core.rep.PartitionRef;
import com.google.cloud.datastore.core.rep.converter.ConverterHelper;
import com.google.storage.onestore.v3.OnestoreEntity;
import java.util.List;
import javax.annotation.Nullable;

public class AppEngV3ResourceRefToRepConverter
implements AppEngV3ResourceRefToRepConverterInterface {
    private static final AppEngV3ResourceRefToRepConverter LIBERAL_CONFIG_INSTANCE = AppEngV3ResourceRefToRepConverter.createLiberalConfigInstance();
    private final Config.DatastoreConfig config;

    private static AppEngV3ResourceRefToRepConverter createLiberalConfigInstance() {
        Config.DatastoreConfig config = Config.DatastoreConfig.newBuilder().setCustomizableConfig(DatastoreCustomizableConfigPb.DatastoreCustomizableConfig.newBuilder().setEnableAppEngV3ValidateKeyNameUtf8(false)).build();
        return new AppEngV3ResourceRefToRepConverter(config);
    }

    public static EntityRef convertValidEntityRef(OnestoreEntity.Reference v3EntityRef, @Nullable DatastoreCustomizableConfigPb.DatastoreCustomizableConfig configOverrides) {
        try {
            return LIBERAL_CONFIG_INSTANCE.convertEntityRef(v3EntityRef, true, configOverrides);
        }
        catch (InvalidConversionException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public AppEngV3ResourceRefToRepConverter(Config.DatastoreConfig config) {
        this.config = (Config.DatastoreConfig)Preconditions.checkNotNull((Object)config);
    }

    public EntityRef convertEntityRef(OnestoreEntity.Reference v3EntityRef, @Nullable DatastoreCustomizableConfigPb.DatastoreCustomizableConfig configOverrides) throws InvalidConversionException {
        return this.convertEntityRef(v3EntityRef, false, configOverrides);
    }

    public EntityRef convertEntityRef(OnestoreEntity.Reference v3EntityRef, boolean allowEmptyPath, @Nullable DatastoreCustomizableConfigPb.DatastoreCustomizableConfig configOverrides) throws InvalidConversionException {
        PartitionRef partitionRef = this.convertPartition("OnestoreEntity.Reference", v3EntityRef.getAppAsBytes(), v3EntityRef.getDatabaseIdAsBytes(), v3EntityRef.getNameSpaceAsBytes());
        List v3PathElements = v3EntityRef.getPath().elements();
        InvalidConversionException.checkConversion(!v3PathElements.isEmpty() || allowEmptyPath, "A OnestoreEntity.Path must have at least one Element.", new Object[0]);
        ImmutableList.Builder pathBuilder = ImmutableList.builder();
        EntityRef.PathElement previousPathElement = null;
        for (OnestoreEntity.Path.Element v3PathElement : v3PathElements) {
            if (previousPathElement != null) {
                InvalidConversionException.checkConversion(previousPathElement.resourceId() != null, "A OnestoreEntity.Path.Element must set either id or name unless it is the last element (in certain contexts).", new Object[0]);
            }
            byte[] collectionIdAsBytes = v3PathElement.getTypeAsBytes();
            InvalidConversionException.checkConversion(!DatastoreCustomizableConfigUtils.getCustomizableConfig(this.config, configOverrides).getEnableAppEngV3ValidateKindUtf8() || Utf8.isWellFormed((byte[])collectionIdAsBytes), "OnestoreEntity.Path.Element.kind is not valid UTF-8.", new Object[0]);
            String collectionId = ConverterHelper.convertBytesToString("OnestoreEntity.Path.Element.kind", collectionIdAsBytes);
            EntityRef.ResourceId resourceId = this.convertResourceId("OnestoreEntity.Path.Element", v3PathElement.hasName(), v3PathElement.getNameAsBytes(), v3PathElement.hasId(), v3PathElement.getId(), configOverrides);
            previousPathElement = EntityRef.PathElement.create(collectionId, resourceId);
            pathBuilder.add((Object)previousPathElement);
        }
        return EntityRef.create(partitionRef, (List<EntityRef.PathElement>)pathBuilder.build());
    }

    @Override
    public EntityRef convertEntityRefForValue(OnestoreEntity.PropertyValue.ReferenceValue v3EntityRef, @Nullable DatastoreCustomizableConfigPb.DatastoreCustomizableConfig configOverrides) throws InvalidConversionException {
        PartitionRef partitionRef = this.convertPartition("OnestoreEntity.PropertyValue.ReferenceValue", v3EntityRef.getAppAsBytes(), v3EntityRef.getDatabaseIdAsBytes(), v3EntityRef.getNameSpaceAsBytes());
        List v3PathElements = v3EntityRef.pathElements();
        InvalidConversionException.checkConversion(!v3PathElements.isEmpty(), "A OnestoreEntity.PropertyValue.ReferenceValue must have at least one PathElement.", new Object[0]);
        ImmutableList.Builder pathBuilder = ImmutableList.builder();
        EntityRef.PathElement previousPathElement = null;
        for (OnestoreEntity.PropertyValue.ReferenceValuePathElement v3PathElement : v3PathElements) {
            if (previousPathElement != null) {
                InvalidConversionException.checkConversion(previousPathElement.resourceId() != null, "A OnestoreEntity.PropertyValue.ReferenceValue.PathElement must set either id or name unless it is the last element.", new Object[0]);
            }
            byte[] collectionIdAsBytes = v3PathElement.getTypeAsBytes();
            InvalidConversionException.checkConversion(!DatastoreCustomizableConfigUtils.getCustomizableConfig(this.config, configOverrides).getEnableAppEngV3ValidateKindUtf8() || Utf8.isWellFormed((byte[])collectionIdAsBytes), "OnestoreEntity.PropertyValue.ReferenceValue.PathElement.kind is not valid UTF-8.", new Object[0]);
            String collectionId = ConverterHelper.convertBytesToString("OnestoreEntity.PropertyValue.ReferenceValue.PathElement", collectionIdAsBytes);
            EntityRef.ResourceId resourceId = this.convertResourceId("OnestoreEntity.PropertyValue.ReferenceValuePathElement", v3PathElement.hasName(), v3PathElement.getNameAsBytes(), v3PathElement.hasId(), v3PathElement.getId(), configOverrides);
            previousPathElement = EntityRef.PathElement.create(collectionId, resourceId);
            pathBuilder.add((Object)previousPathElement);
        }
        return EntityRef.create(partitionRef, (List<EntityRef.PathElement>)pathBuilder.build());
    }

    private PartitionRef convertPartition(String v3MessageName, byte[] appIdBytes, byte[] databaseIdBytes, byte[] namespaceIdBytes) throws InvalidConversionException {
        String appId = ConverterHelper.convertUtf8(v3MessageName, ".appId", appIdBytes);
        String databaseId = ConverterHelper.convertUtf8(v3MessageName, ".databaseId", databaseIdBytes);
        String namespaceId = ConverterHelper.convertUtf8(v3MessageName, ".namespaceId", namespaceIdBytes);
        InvalidConversionException.checkConversion(!appId.isEmpty(), "A %s must set app.", v3MessageName);
        DatabaseRef databaseRef = DatabaseRef.createForApp(appId, databaseId);
        PartitionRef partitionRef = PartitionRef.createFromDatabaseRefAndNamespace(databaseRef, namespaceId);
        return partitionRef;
    }

    @Nullable
    private EntityRef.ResourceId convertResourceId(String v3MessageName, boolean hasStringResourceId, byte[] stringResourceIdAsBytes, boolean hasIntResourceId, long intResourceId, @Nullable DatastoreCustomizableConfigPb.DatastoreCustomizableConfig configOverrides) throws InvalidConversionException {
        if (hasStringResourceId) {
            InvalidConversionException.checkConversion(!hasIntResourceId, "A %s must not set both id and name.", v3MessageName);
            InvalidConversionException.checkConversion(!DatastoreCustomizableConfigUtils.getCustomizableConfig(this.config, configOverrides).getEnableAppEngV3ValidateKeyNameUtf8() || Utf8.isWellFormed((byte[])stringResourceIdAsBytes), "%s.name is not valid UTF-8.", v3MessageName);
            String stringResourceId = ConverterHelper.convertBytesToString(v3MessageName, stringResourceIdAsBytes);
            return EntityRef.ResourceId.createString(stringResourceId);
        }
        if (hasIntResourceId) {
            if (intResourceId == 0L) {
                return null;
            }
            return EntityRef.ResourceId.createLong(intResourceId);
        }
        return null;
    }
}

