/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.core.appengv3.converter;

import com.google.appengine.repackaged.com.google.common.base.Utf8;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableList;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableMultiset;
import com.google.appengine.repackaged.com.google.protobuf.MessageLite;
import com.google.appengine.repackaged.com.google.protobuf.Timestamp;
import com.google.appengine.repackaged.com.google.protobuf.util.Timestamps;
import com.google.appengine.repackaged.com.google.storage.onestore.v3.proto2api.OnestoreEntity;
import com.google.cloud.datastore.admininternal.FinalizeIndexingRequest;
import com.google.cloud.datastore.admininternal.InitializeIndexingRequest;
import com.google.cloud.datastore.admininternal.InitializeIndexingViaUpdateIndexRequest;
import com.google.cloud.datastore.core.appengv3.AppEngV3DatabaseRefExtractor;
import com.google.cloud.datastore.core.exception.InvalidConversionException;
import com.google.cloud.datastore.core.rep.DatabaseIndexGroup;
import com.google.cloud.datastore.core.rep.DatabaseRef;
import com.google.cloud.datastore.core.rep.Direction;
import com.google.cloud.datastore.core.rep.Index;
import com.google.cloud.datastore.core.rep.IndexConfiguration;
import com.google.cloud.datastore.core.rep.IndexDef;
import com.google.cloud.datastore.core.rep.IndexFinalizationRequest;
import com.google.cloud.datastore.core.rep.IndexInitializationRequest;
import com.google.cloud.datastore.core.rep.IndexState;
import com.google.cloud.datastore.core.rep.PropertyPath;
import com.google.cloud.datastore.core.rep.PropertyPathSegment;
import com.google.cloud.datastore.core.rep.Query;
import com.google.cloud.datastore.core.rep.WorkflowState;
import com.google.cloud.datastore.core.rep.converter.EquivalentMessageConverter;
import com.google.cloud.datastore.core.rep.converter.GoogleSqlPropertyPathToRepConverter;
import com.google.storage.onestore.v3.OnestoreEntity;
import java.util.List;
import javax.annotation.Nullable;

public class IndexAppEngV3ToRepConverter {
    public static final IndexAppEngV3ToRepConverter INSTANCE = new IndexAppEngV3ToRepConverter();
    static final String ERROR_COLLECTION_ID_IS_REQUIRED = "collection id is required";
    static final String ERROR_MIN_INITIALIZE_TIME_IS_REQUIRED = "min initialize time is required";

    private IndexAppEngV3ToRepConverter() {
    }

    @Nullable
    public static Direction convertV3IndexDirectionToRep(OnestoreEntity.Index.Property.Direction direction) {
        switch (direction) {
            case ASCENDING: {
                return Direction.ASCENDING;
            }
            case DESCENDING: {
                return Direction.DESCENDING;
            }
            case DIRECTION_UNSPECIFIED: {
                return null;
            }
        }
        throw new IllegalArgumentException();
    }

    public DatabaseIndexGroup convertDatabaseIndexes(@Nullable DatabaseRef database, List<OnestoreEntity.CompositeIndex> v3Indexes, IndexConfiguration indexConfiguration) throws InvalidConversionException {
        ImmutableList<Index> indexes = this.convertIndexes(database, v3Indexes);
        return DatabaseIndexGroup.create((ImmutableMultiset<Index>)ImmutableMultiset.copyOf(indexes), indexConfiguration.datastoreBuiltinIndexes(), indexConfiguration.singleFieldIndexing());
    }

    public ImmutableList<Index> convertIndexes(@Nullable DatabaseRef database, List<OnestoreEntity.CompositeIndex> v3CompositeIndexes) throws InvalidConversionException {
        return this.internalConvertIndexes(database, v3CompositeIndexes);
    }

    public ImmutableList<Index> convertIndexes(List<OnestoreEntity.CompositeIndex> v3CompositeIndexes) throws InvalidConversionException {
        return this.internalConvertIndexes(null, v3CompositeIndexes);
    }

    private ImmutableList<Index> internalConvertIndexes(@Nullable DatabaseRef database, List<OnestoreEntity.CompositeIndex> v3CompositeIndexes) throws InvalidConversionException {
        ImmutableList.Builder compositeIndexesBuilder = ImmutableList.builder();
        for (OnestoreEntity.CompositeIndex v3CompositeIndex : v3CompositeIndexes) {
            Index index = this.internalConvertIndex(database, v3CompositeIndex);
            compositeIndexesBuilder.add((Object)index);
        }
        return compositeIndexesBuilder.build();
    }

    public Index convertIndexFromProto2CompositeIndex(OnestoreEntity.CompositeIndex v3CompositeIndex) throws InvalidConversionException {
        return this.convertIndex((OnestoreEntity.CompositeIndex)EquivalentMessageConverter.create(OnestoreEntity.CompositeIndex.parser()).apply(v3CompositeIndex));
    }

    public Index convertIndex(@Nullable DatabaseRef database, OnestoreEntity.CompositeIndex v3CompositeIndex) throws InvalidConversionException {
        return this.internalConvertIndex(database, v3CompositeIndex);
    }

    public Index convertIndex(OnestoreEntity.CompositeIndex v3CompositeIndex) throws InvalidConversionException {
        return this.internalConvertIndex(null, v3CompositeIndex);
    }

    private Index internalConvertIndex(@Nullable DatabaseRef database, OnestoreEntity.CompositeIndex v3CompositeIndex) throws InvalidConversionException {
        return this.internalConvertIndex(database, v3CompositeIndex, null);
    }

    private Index internalConvertIndex(@Nullable DatabaseRef database, OnestoreEntity.CompositeIndex v3CompositeIndex, @Nullable IndexDef.PropertyDef.Mode defaultPropertyMode) throws InvalidConversionException {
        DatabaseRef actualDatabase = (DatabaseRef)AppEngV3DatabaseRefExtractor.INSTANCE.extractValidated((MessageLite)v3CompositeIndex);
        String string = String.valueOf(actualDatabase);
        String string2 = String.valueOf(database);
        InvalidConversionException.checkConversion(database == null || actualDatabase.equals(database), new StringBuilder(50 + String.valueOf(string).length() + String.valueOf(string2).length()).append("the composite index specifies the wrong database:").append(string).append(",").append(string2).toString(), new Object[0]);
        InvalidConversionException.checkConversion(v3CompositeIndex.getStateEnum() != null, "a composite index must specify a state", new Object[0]);
        Index.Builder indexBuilder = Index.builder().definition(this.convertIndexDef(v3CompositeIndex.getDefinition(), defaultPropertyMode)).id(v3CompositeIndex.getId()).indexState(this.convertIndexState(v3CompositeIndex.getStateEnum()));
        return indexBuilder.build();
    }

    public IndexDef convertCreateIndexRequest(OnestoreEntity.CompositeIndex v3IndexDef) throws InvalidConversionException {
        return this.convertIndexDef(v3IndexDef.getDefinition(), null);
    }

    public IndexDef convertIndexDefFromProto2IndexDef(OnestoreEntity.Index v3IndexDef, @Nullable IndexDef.PropertyDef.Mode defaultPropertyMode) throws InvalidConversionException {
        return this.convertIndexDef((OnestoreEntity.Index)EquivalentMessageConverter.create(OnestoreEntity.Index.parser()).apply(v3IndexDef), defaultPropertyMode);
    }

    private IndexDef convertIndexDef(OnestoreEntity.Index v3IndexDef, @Nullable IndexDef.PropertyDef.Mode defaultPropertyMode) throws InvalidConversionException {
        Query.Semantics version = Query.Semantics.DATASTORE;
        if (v3IndexDef.getVersionEnum().equals((Object)OnestoreEntity.Index.Version.V2)) {
            version = Query.Semantics.FIRESTORE;
        }
        if (defaultPropertyMode == null) {
            defaultPropertyMode = this.computeDefaultPropertyMode(v3IndexDef);
        }
        ImmutableList.Builder propertiesBuilder = ImmutableList.builder();
        for (OnestoreEntity.Index.Property v3PropertyDef : v3IndexDef.propertys()) {
            propertiesBuilder.add((Object)this.convertIndexPropertyDef(defaultPropertyMode, v3PropertyDef, version.equals((Object)Query.Semantics.FIRESTORE)));
        }
        ImmutableList properties = propertiesBuilder.build();
        String kind = v3IndexDef.getEntityType();
        if (kind.isEmpty()) {
            kind = null;
        }
        IndexDef.IndexAncestor indexAncestor = IndexDef.IndexAncestor.NONE;
        if (v3IndexDef.isAncestor()) {
            indexAncestor = IndexDef.IndexAncestor.ANCESTOR;
        } else if (v3IndexDef.isParent()) {
            indexAncestor = IndexDef.IndexAncestor.PARENT;
        }
        return IndexDef.create(version, kind, indexAncestor, (ImmutableList<IndexDef.PropertyDef>)properties);
    }

    private IndexDef.PropertyDef.Mode computeDefaultPropertyMode(OnestoreEntity.Index v3IndexDef) throws InvalidConversionException {
        for (OnestoreEntity.Index.Property v3PropertyDef : v3IndexDef.propertys()) {
            if (v3PropertyDef.getModeEnum() != OnestoreEntity.Index.Property.Mode.GEOSPATIAL) continue;
            return IndexDef.PropertyDef.Mode.EQUALITY;
        }
        return IndexDef.PropertyDef.Mode.ORDERED;
    }

    private IndexDef.PropertyDef convertIndexPropertyDef(IndexDef.PropertyDef.Mode defaultPropertyMode, OnestoreEntity.Index.Property v3PropertyDef, boolean isFirestore) throws InvalidConversionException {
        PropertyPath path;
        IndexDef.PropertyDef.Mode propertyMode;
        switch (v3PropertyDef.getModeEnum()) {
            case MODE_UNSPECIFIED: {
                propertyMode = defaultPropertyMode;
                break;
            }
            case GEOSPATIAL: {
                propertyMode = IndexDef.PropertyDef.Mode.GEOSPATIAL;
                break;
            }
            case ARRAY_CONTAINS: {
                InvalidConversionException.checkConversion(isFirestore, "ARRAY_CONTAINS is not allowed in Cloud Datastore.", new Object[0]);
                propertyMode = IndexDef.PropertyDef.Mode.ORDERED;
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        Direction direction = IndexAppEngV3ToRepConverter.convertV3IndexDirectionToRep(v3PropertyDef.getDirectionEnum());
        if (direction == null && propertyMode == IndexDef.PropertyDef.Mode.ORDERED) {
            direction = Direction.ASCENDING;
        }
        InvalidConversionException.checkConversion(propertyMode == IndexDef.PropertyDef.Mode.ORDERED != (direction == null), "direction required", new Object[0]);
        InvalidConversionException.checkConversion(Utf8.isWellFormed((byte[])v3PropertyDef.getNameAsBytes()), "non-Utf-8 property path", new Object[0]);
        PropertyPath propertyPath = path = isFirestore ? GoogleSqlPropertyPathToRepConverter.NAME_INSTANCE.convertPropertyPath(v3PropertyDef.getName()) : PropertyPath.createFromAmbiguousPathString(v3PropertyDef.getName());
        if (isFirestore && OnestoreEntity.Index.Property.Mode.ARRAY_CONTAINS.equals((Object)v3PropertyDef.getModeEnum())) {
            path = PropertyPath.create(path, PropertyPathSegment.AllArrayElements.create());
        }
        return IndexDef.PropertyDef.create(path, propertyMode, direction);
    }

    public IndexState convertIndexState(OnestoreEntity.CompositeIndex.State v3IndexState) throws InvalidConversionException {
        switch (v3IndexState) {
            case WRITE_ONLY: {
                return IndexState.of(WorkflowState.ENABLING);
            }
            case READ_WRITE: {
                return IndexState.of(WorkflowState.SERVING);
            }
            case DELETED: {
                return IndexState.of(WorkflowState.DISABLING);
            }
            case ERROR: {
                return IndexState.create(WorkflowState.DISABLING, true);
            }
        }
        throw new InvalidConversionException("unknown v3 composite index state");
    }

    public IndexInitializationRequest convertInitializeIndexingRequest(InitializeIndexingViaUpdateIndexRequest envelope) throws InvalidConversionException {
        InitializeIndexingRequest request = envelope.getInitializeIndexingRequest();
        InvalidConversionException.checkConversion(!request.getCollectionId().isEmpty(), ERROR_COLLECTION_ID_IS_REQUIRED, new Object[0]);
        InvalidConversionException.checkConversion(request.hasMinInitializeTime() || envelope.hasMinInitializeTime(), ERROR_MIN_INITIALIZE_TIME_IS_REQUIRED, new Object[0]);
        Timestamp initializeTime = envelope.getMinInitializeTime();
        if (request.hasMinInitializeTime()) {
            initializeTime = request.getMinInitializeTime();
        }
        try {
            return IndexInitializationRequest.create(request.getCollectionId(), Timestamps.toMicros((Timestamp)initializeTime));
        }
        catch (IllegalArgumentException e) {
            throw new InvalidConversionException(e);
        }
    }

    public IndexFinalizationRequest convertFinalizeIndexingRequest(FinalizeIndexingRequest request) throws InvalidConversionException {
        try {
            return IndexFinalizationRequest.builder().kind(request.getCollectionId()).isError(request.getError()).minStartTimeMicros(Timestamps.toMicros((Timestamp)request.getMinStartTime())).build();
        }
        catch (IllegalArgumentException e) {
            throw new InvalidConversionException(e);
        }
    }
}

