/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.core.rep;

import com.google.appengine.repackaged.com.google.common.collect.ImmutableList;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableMap;
import com.google.cloud.datastore.core.rep.AutoValue_WriteResult;
import com.google.cloud.datastore.core.rep.MutationResult;
import com.google.cloud.datastore.core.rep.WriteResult;
import com.google.cloud.datastore.core.rep.WriteStats;
import javax.annotation.Nullable;

abstract class $AutoValue_WriteResult
extends WriteResult {
    private final long commitTimestamp;
    private final ImmutableList<MutationResult> collapsedMutationResults;
    private final ImmutableList<Integer> originalMutationsIndexes;
    private final ImmutableMap<Integer, Integer> originalTransformations;
    private final WriteStats stats;

    $AutoValue_WriteResult(long commitTimestamp, ImmutableList<MutationResult> collapsedMutationResults, ImmutableList<Integer> originalMutationsIndexes, @Nullable ImmutableMap<Integer, Integer> originalTransformations, WriteStats stats) {
        this.commitTimestamp = commitTimestamp;
        if (collapsedMutationResults == null) {
            throw new NullPointerException("Null collapsedMutationResults");
        }
        this.collapsedMutationResults = collapsedMutationResults;
        if (originalMutationsIndexes == null) {
            throw new NullPointerException("Null originalMutationsIndexes");
        }
        this.originalMutationsIndexes = originalMutationsIndexes;
        this.originalTransformations = originalTransformations;
        if (stats == null) {
            throw new NullPointerException("Null stats");
        }
        this.stats = stats;
    }

    @Override
    public long commitTimestamp() {
        return this.commitTimestamp;
    }

    @Override
    public ImmutableList<MutationResult> collapsedMutationResults() {
        return this.collapsedMutationResults;
    }

    @Override
    public ImmutableList<Integer> originalMutationsIndexes() {
        return this.originalMutationsIndexes;
    }

    @Override
    @Nullable
    public ImmutableMap<Integer, Integer> originalTransformations() {
        return this.originalTransformations;
    }

    @Override
    public WriteStats stats() {
        return this.stats;
    }

    public String toString() {
        long l = this.commitTimestamp;
        String string = String.valueOf(this.collapsedMutationResults);
        String string2 = String.valueOf(this.originalMutationsIndexes);
        String string3 = String.valueOf(this.originalTransformations);
        String string4 = String.valueOf(this.stats);
        return new StringBuilder(137 + String.valueOf(string).length() + String.valueOf(string2).length() + String.valueOf(string3).length() + String.valueOf(string4).length()).append("WriteResult{commitTimestamp=").append(l).append(", collapsedMutationResults=").append(string).append(", originalMutationsIndexes=").append(string2).append(", originalTransformations=").append(string3).append(", stats=").append(string4).append("}").toString();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof WriteResult) {
            WriteResult that = (WriteResult)o;
            return this.commitTimestamp == that.commitTimestamp() && this.collapsedMutationResults.equals(that.collapsedMutationResults()) && this.originalMutationsIndexes.equals(that.originalMutationsIndexes()) && (this.originalTransformations == null ? that.originalTransformations() == null : this.originalTransformations.equals(that.originalTransformations())) && this.stats.equals(that.stats());
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= (int)(this.commitTimestamp >>> 32 ^ this.commitTimestamp);
        h$ *= 1000003;
        h$ ^= this.collapsedMutationResults.hashCode();
        h$ *= 1000003;
        h$ ^= this.originalMutationsIndexes.hashCode();
        h$ *= 1000003;
        h$ ^= this.originalTransformations == null ? 0 : this.originalTransformations.hashCode();
        h$ *= 1000003;
        return h$ ^= this.stats.hashCode();
    }

    @Override
    public WriteResult.Builder toBuilder() {
        return new Builder(this);
    }

    static class Builder
    extends WriteResult.Builder {
        private Long commitTimestamp;
        private ImmutableList<MutationResult> collapsedMutationResults;
        private ImmutableList<Integer> originalMutationsIndexes;
        private ImmutableMap<Integer, Integer> originalTransformations;
        private WriteStats stats;

        Builder() {
        }

        private Builder(WriteResult source) {
            this.commitTimestamp = source.commitTimestamp();
            this.collapsedMutationResults = source.collapsedMutationResults();
            this.originalMutationsIndexes = source.originalMutationsIndexes();
            this.originalTransformations = source.originalTransformations();
            this.stats = source.stats();
        }

        @Override
        public WriteResult.Builder commitTimestamp(long commitTimestamp) {
            this.commitTimestamp = commitTimestamp;
            return this;
        }

        @Override
        public WriteResult.Builder collapsedMutationResults(Iterable<MutationResult> collapsedMutationResults) {
            this.collapsedMutationResults = ImmutableList.copyOf(collapsedMutationResults);
            return this;
        }

        @Override
        public WriteResult.Builder originalMutationsIndexes(@Nullable Iterable<Integer> originalMutationsIndexes) {
            this.originalMutationsIndexes = ImmutableList.copyOf(originalMutationsIndexes);
            return this;
        }

        @Override
        public WriteResult.Builder originalTransformations(@Nullable ImmutableMap<Integer, Integer> originalTransformations) {
            this.originalTransformations = originalTransformations;
            return this;
        }

        @Override
        public WriteResult.Builder stats(WriteStats stats) {
            if (stats == null) {
                throw new NullPointerException("Null stats");
            }
            this.stats = stats;
            return this;
        }

        @Override
        public WriteResult build() {
            String missing = "";
            if (this.commitTimestamp == null) {
                missing = String.valueOf(missing).concat(" commitTimestamp");
            }
            if (this.collapsedMutationResults == null) {
                missing = String.valueOf(missing).concat(" collapsedMutationResults");
            }
            if (this.originalMutationsIndexes == null) {
                missing = String.valueOf(missing).concat(" originalMutationsIndexes");
            }
            if (this.stats == null) {
                missing = String.valueOf(missing).concat(" stats");
            }
            if (!missing.isEmpty()) {
                String string = String.valueOf(missing);
                throw new IllegalStateException(string.length() != 0 ? "Missing required properties:".concat(string) : new String("Missing required properties:"));
            }
            return new AutoValue_WriteResult(this.commitTimestamp, this.collapsedMutationResults, this.originalMutationsIndexes, this.originalTransformations, this.stats);
        }
    }
}

