/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.core.rep;

import com.google.appengine.repackaged.com.google.common.collect.ImmutableList;
import com.google.apphosting.api.DatastorePb;
import com.google.cloud.datastore.core.rep.PartitionRef;
import com.google.cloud.datastore.core.rep.QueryScope;
import javax.annotation.Nullable;

final class AutoValue_QueryScope
extends QueryScope {
    private final PartitionRef partition;
    private final ImmutableList<String> safeReplicaNames;
    private final Long readTimestamp;
    private final boolean isStrong;
    private final boolean isVeryInconsistent;
    private final DatastorePb.Query.Hint hint;
    private final Integer batchSize;

    private AutoValue_QueryScope(PartitionRef partition, @Nullable ImmutableList<String> safeReplicaNames, @Nullable Long readTimestamp, boolean isStrong, boolean isVeryInconsistent, @Nullable DatastorePb.Query.Hint hint, @Nullable Integer batchSize) {
        this.partition = partition;
        this.safeReplicaNames = safeReplicaNames;
        this.readTimestamp = readTimestamp;
        this.isStrong = isStrong;
        this.isVeryInconsistent = isVeryInconsistent;
        this.hint = hint;
        this.batchSize = batchSize;
    }

    @Override
    @Deprecated
    public PartitionRef partition() {
        return this.partition;
    }

    @Override
    @Nullable
    public ImmutableList<String> safeReplicaNames() {
        return this.safeReplicaNames;
    }

    @Override
    @Nullable
    public Long readTimestamp() {
        return this.readTimestamp;
    }

    @Override
    public boolean isStrong() {
        return this.isStrong;
    }

    @Override
    public boolean isVeryInconsistent() {
        return this.isVeryInconsistent;
    }

    @Override
    @Nullable
    public DatastorePb.Query.Hint hint() {
        return this.hint;
    }

    @Override
    @Nullable
    public Integer batchSize() {
        return this.batchSize;
    }

    public String toString() {
        String string = String.valueOf(this.partition);
        String string2 = String.valueOf(this.safeReplicaNames);
        String string3 = String.valueOf(this.readTimestamp);
        boolean bl = this.isStrong;
        boolean bl2 = this.isVeryInconsistent;
        String string4 = String.valueOf(this.hint);
        String string5 = String.valueOf(this.batchSize);
        return new StringBuilder(118 + String.valueOf(string).length() + String.valueOf(string2).length() + String.valueOf(string3).length() + String.valueOf(string4).length() + String.valueOf(string5).length()).append("QueryScope{partition=").append(string).append(", safeReplicaNames=").append(string2).append(", readTimestamp=").append(string3).append(", isStrong=").append(bl).append(", isVeryInconsistent=").append(bl2).append(", hint=").append(string4).append(", batchSize=").append(string5).append("}").toString();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof QueryScope) {
            QueryScope that = (QueryScope)o;
            return this.partition.equals(that.partition()) && (this.safeReplicaNames == null ? that.safeReplicaNames() == null : this.safeReplicaNames.equals(that.safeReplicaNames())) && (this.readTimestamp == null ? that.readTimestamp() == null : this.readTimestamp.equals(that.readTimestamp())) && this.isStrong == that.isStrong() && this.isVeryInconsistent == that.isVeryInconsistent() && (this.hint == null ? that.hint() == null : this.hint.equals((Object)that.hint())) && (this.batchSize == null ? that.batchSize() == null : this.batchSize.equals(that.batchSize()));
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.partition.hashCode();
        h$ *= 1000003;
        h$ ^= this.safeReplicaNames == null ? 0 : this.safeReplicaNames.hashCode();
        h$ *= 1000003;
        h$ ^= this.readTimestamp == null ? 0 : this.readTimestamp.hashCode();
        h$ *= 1000003;
        h$ ^= this.isStrong ? 1231 : 1237;
        h$ *= 1000003;
        h$ ^= this.isVeryInconsistent ? 1231 : 1237;
        h$ *= 1000003;
        h$ ^= this.hint == null ? 0 : this.hint.hashCode();
        h$ *= 1000003;
        return h$ ^= this.batchSize == null ? 0 : this.batchSize.hashCode();
    }

    @Override
    public QueryScope.Builder toBuilder() {
        return new Builder(this);
    }

    static final class Builder
    extends QueryScope.Builder {
        private PartitionRef partition;
        private ImmutableList<String> safeReplicaNames;
        private Long readTimestamp;
        private Boolean isStrong;
        private Boolean isVeryInconsistent;
        private DatastorePb.Query.Hint hint;
        private Integer batchSize;

        Builder() {
        }

        private Builder(QueryScope source) {
            this.partition = source.partition();
            this.safeReplicaNames = source.safeReplicaNames();
            this.readTimestamp = source.readTimestamp();
            this.isStrong = source.isStrong();
            this.isVeryInconsistent = source.isVeryInconsistent();
            this.hint = source.hint();
            this.batchSize = source.batchSize();
        }

        @Override
        public QueryScope.Builder partition(PartitionRef partition) {
            if (partition == null) {
                throw new NullPointerException("Null partition");
            }
            this.partition = partition;
            return this;
        }

        @Override
        public QueryScope.Builder safeReplicaNames(@Nullable Iterable<String> safeReplicaNames) {
            this.safeReplicaNames = safeReplicaNames == null ? null : ImmutableList.copyOf(safeReplicaNames);
            return this;
        }

        @Override
        public QueryScope.Builder readTimestamp(@Nullable Long readTimestamp) {
            this.readTimestamp = readTimestamp;
            return this;
        }

        @Override
        public QueryScope.Builder isStrong(boolean isStrong) {
            this.isStrong = isStrong;
            return this;
        }

        @Override
        public QueryScope.Builder isVeryInconsistent(boolean isVeryInconsistent) {
            this.isVeryInconsistent = isVeryInconsistent;
            return this;
        }

        @Override
        public QueryScope.Builder hint(@Nullable DatastorePb.Query.Hint hint) {
            this.hint = hint;
            return this;
        }

        @Override
        public QueryScope.Builder batchSize(@Nullable Integer batchSize) {
            this.batchSize = batchSize;
            return this;
        }

        @Override
        public QueryScope build() {
            String missing = "";
            if (this.partition == null) {
                missing = String.valueOf(missing).concat(" partition");
            }
            if (this.isStrong == null) {
                missing = String.valueOf(missing).concat(" isStrong");
            }
            if (this.isVeryInconsistent == null) {
                missing = String.valueOf(missing).concat(" isVeryInconsistent");
            }
            if (!missing.isEmpty()) {
                String string = String.valueOf(missing);
                throw new IllegalStateException(string.length() != 0 ? "Missing required properties:".concat(string) : new String("Missing required properties:"));
            }
            return new AutoValue_QueryScope(this.partition, this.safeReplicaNames, this.readTimestamp, this.isStrong, this.isVeryInconsistent, this.hint, this.batchSize);
        }
    }
}

