/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.core.rep;

import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableMap;
import com.google.auto.value.AutoValue;
import com.google.cloud.datastore.core.rep.AutoValue_Entity;
import com.google.cloud.datastore.core.rep.EntityRef;
import com.google.cloud.datastore.core.rep.PropertyMask;
import com.google.cloud.datastore.core.rep.PropertyName;
import com.google.cloud.datastore.core.rep.PropertyPath;
import com.google.cloud.datastore.core.rep.PropertyPathSegment;
import com.google.cloud.datastore.core.rep.Value;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;

@AutoValue
public abstract class Entity {
    public static final long ENTITY_VERSION_NONE = -1L;

    public static Entity create(EntityRef entityRef, ImmutableMap<String, Value> propertyMap) {
        return new AutoValue_Entity(entityRef, propertyMap);
    }

    public static Entity create(EntityRef ref, Map<PropertyPath, Value> pathValueMap) {
        ImmutableMap<String, Value> properties = Entity.createEntityProperties(pathValueMap);
        return Entity.create(ref, properties);
    }

    public static Entity createFromRef(EntityRef entityRef) {
        return new AutoValue_Entity(entityRef, (ImmutableMap<String, Value>)ImmutableMap.of());
    }

    public abstract EntityRef ref();

    public abstract ImmutableMap<String, Value> propertyMap();

    @Nullable
    public Value get(PropertyPath propertyPath) {
        return propertyPath.getFrom(this.propertyMap());
    }

    public Entity maskCopy(PropertyMask mask) {
        return mask.entityMaskCopy(this);
    }

    private static ImmutableMap<String, Value> createEntityProperties(Map<PropertyPath, Value> pathValueMap) {
        ImmutableMap.Builder resultMap = ImmutableMap.builder();
        HashMap<PropertyName, Map> nestedPathValueMap = new HashMap<PropertyName, Map>();
        for (Map.Entry<PropertyPath, Value> entry : pathValueMap.entrySet()) {
            PropertyPath path = entry.getKey();
            Value value = entry.getValue();
            PropertyPathSegment segment = path.segment();
            Preconditions.checkArgument((boolean)(segment instanceof PropertyPathSegment.Member));
            PropertyName propertyName = ((PropertyPathSegment.Member)segment).name();
            PropertyPath next = path.next();
            if (next == null) {
                resultMap.put((Object)propertyName.string(), (Object)value);
                continue;
            }
            nestedPathValueMap.computeIfAbsent(propertyName, k -> new HashMap()).put(next, value);
        }
        for (Map.Entry<PropertyPath, Value> entry : nestedPathValueMap.entrySet()) {
            PropertyName propertyName = (PropertyName)((Object)entry.getKey());
            ImmutableMap<String, Value> nestedProperties = Entity.createEntityProperties((Map)((Object)entry.getValue()));
            resultMap.put((Object)propertyName.string(), (Object)Value.createMap(nestedProperties));
        }
        return resultMap.build();
    }
}

