/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.core.rep;

import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.auto.value.AutoValue;
import com.google.cloud.datastore.core.rep.AutoValue_EntityProtoChange;
import com.google.cloud.datastore.core.rep.EntityChange;
import com.google.cloud.datastore.core.rep.EntityV3Differ;
import com.google.storage.onestore.v3.OnestoreEntity;
import javax.annotation.Nullable;

@AutoValue
public abstract class EntityProtoChange {
    public static final long NO_CREATE_TIME = -1L;
    private EntityChange repChange;

    public static EntityProtoChange create(@Nullable OnestoreEntity.EntityProto newValue, @Nullable EntityV3Differ.EntityDelta entityDelta) {
        return EntityProtoChange.create(newValue, entityDelta, -1L);
    }

    public static EntityProtoChange create(@Nullable OnestoreEntity.EntityProto newValue, @Nullable EntityV3Differ.EntityDelta entityDelta, long createTimeMicros) {
        Preconditions.checkArgument((newValue != null || entityDelta != null && entityDelta.keyDelta() != null ? 1 : 0) != 0, (Object)"EntityProto and EntityDelta cannot both be null.");
        return new AutoValue_EntityProtoChange(newValue, entityDelta, createTimeMicros);
    }

    @Nullable
    public abstract OnestoreEntity.EntityProto newValue();

    @Nullable
    public abstract EntityV3Differ.EntityDelta entityDelta();

    public abstract long createTime();

    public OnestoreEntity.Reference key() {
        return this.isDelete() ? this.entityDelta().keyDelta().key() : this.newValue().getKey();
    }

    public boolean isDelete() {
        return this.newValue() == null;
    }

    public boolean isInsert() {
        return this.entityDelta() == null;
    }

    public boolean isUpdate() {
        return this.newValue() != null && this.entityDelta() != null;
    }

    public EntityProtoChange withRepChange(@Nullable EntityChange entityChange) {
        Preconditions.checkState((this.repChange == null ? 1 : 0) != 0);
        this.repChange = entityChange;
        return this;
    }

    @Nullable
    public final EntityChange repChange() {
        return this.repChange;
    }
}

