/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.core.rep;

import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableMap;
import com.google.cloud.datastore.core.rep.Entity;
import com.google.cloud.datastore.core.rep.EntityRef;
import com.google.cloud.datastore.core.rep.EntityTransformation;
import com.google.cloud.datastore.core.rep.PropertyPath;
import com.google.cloud.datastore.core.rep.Value;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class EntityUpdater {
    private final ValueBuilder builder;

    private EntityUpdater(Entity base) {
        this.builder = new ValueBuilder(Value.createEntity(base));
    }

    public static EntityUpdater create(Entity entity) {
        return new EntityUpdater(entity);
    }

    public static EntityUpdater create(EntityRef key) {
        return EntityUpdater.create(Entity.createFromRef(key));
    }

    @Nullable
    public Value get(PropertyPath path) {
        return this.builder.get(path);
    }

    public EntityUpdater set(PropertyPath path, @Nullable Value value) {
        this.builder.set(path, value);
        return this;
    }

    public Value apply(EntityTransformation.PropertyTransformation transform) {
        EntityTransformation.PropertyTransformationResult result = transform.apply(this.get(transform.propertyPath()));
        this.set(transform.propertyPath(), result.newPropertyValue());
        return result.writeResultValue();
    }

    public Entity toEntity() {
        return this.builder.build().asEntity();
    }

    @NotThreadSafe
    public static class ValueBuilder {
        @Nullable
        private Value base;
        @Nullable
        private Map<String, ValueBuilder> nestedBuilders;

        public ValueBuilder(@Nullable Value base) {
            this.base = base;
            this.nestedBuilders = null;
        }

        public Value get(PropertyPath path) {
            return this.getInternal((PropertyPath)Preconditions.checkNotNull((Object)path));
        }

        private Value getInternal(@Nullable PropertyPath path) {
            if (path == null) {
                return this.build();
            }
            if (this.hasBuilder(path.memberName())) {
                return this.getBuilder(path.memberName()).getInternal(path.next());
            }
            return this.base == null ? null : this.base.get(path);
        }

        public void set(PropertyPath path, @Nullable Value value) {
            this.setInternal((PropertyPath)Preconditions.checkNotNull((Object)path), value);
        }

        private boolean setInternal(@Nullable PropertyPath path, @Nullable Value value) {
            if (path == null) {
                this.base = value;
                this.nestedBuilders = null;
                return true;
            }
            String name = path.memberName();
            if (!this.hasBuilder(name) && Objects.equals(value, this.getInternal(path))) {
                return false;
            }
            ValueBuilder updater = this.getBuilder(name);
            if (updater.setInternal(path.next(), value) && Objects.equals(this.getBaseProperties().get((Object)name), updater.build())) {
                this.removeBuilder(name);
                return this.isBuilt();
            }
            return false;
        }

        @Nullable
        public Value build() {
            if (this.nestedBuilders != null) {
                ImmutableMap.Builder properties = ImmutableMap.builder();
                for (Map.Entry entry : this.getBaseProperties().entrySet()) {
                    if (this.nestedBuilders.containsKey(entry.getKey())) continue;
                    properties.put(entry);
                }
                for (Map.Entry entry : this.nestedBuilders.entrySet()) {
                    Value property = ((ValueBuilder)entry.getValue()).build();
                    if (property == null) continue;
                    properties.put((Object)((String)entry.getKey()), (Object)property);
                }
                this.nestedBuilders = null;
                this.base = this.base.type() == Value.Type.ENTITY ? Value.createEntity(Entity.create(this.base.asEntity().ref(), (ImmutableMap<String, Value>)properties.build()), this.base.datastoreIndexing()) : Value.createMap((ImmutableMap<String, Value>)properties.build(), this.base.datastoreIndexing());
            }
            return this.base;
        }

        private boolean isBuilt() {
            return this.nestedBuilders == null;
        }

        private boolean hasBuilder(String name) {
            return this.nestedBuilders != null && this.nestedBuilders.containsKey(name);
        }

        private void putBuilder(String name, ValueBuilder updater) {
            if (this.nestedBuilders == null) {
                this.nestedBuilders = new HashMap<String, ValueBuilder>();
            }
            this.nestedBuilders.put(name, (ValueBuilder)Preconditions.checkNotNull((Object)updater));
        }

        private ValueBuilder getBuilder(String name) {
            if (!this.hasBuilder(name)) {
                if (!this.isMapBuilder()) {
                    this.base = Value.EMPTY_MAP;
                }
                this.putBuilder(name, new ValueBuilder((Value)this.getBaseProperties().get((Object)name)));
            }
            return this.nestedBuilders.get(name);
        }

        private void removeBuilder(String name) {
            if (this.nestedBuilders != null) {
                this.nestedBuilders.remove(name);
                if (this.nestedBuilders.isEmpty()) {
                    this.nestedBuilders = null;
                }
            }
        }

        private boolean isMapBuilder() {
            return this.base != null && (this.base.type() == Value.Type.MAP || this.base.type() == Value.Type.ENTITY);
        }

        private ImmutableMap<String, Value> getBaseProperties() {
            if (this.base.type() == Value.Type.MAP) {
                return this.base.asMap();
            }
            return this.base.asEntity().propertyMap();
        }
    }
}

