/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.core.rep;

import com.google.appengine.repackaged.com.google.common.annotations.VisibleForTesting;
import com.google.appengine.repackaged.com.google.common.base.Optional;
import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableMultimap;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableSet;
import com.google.auto.value.AutoValue;
import com.google.cloud.datastore.admininternal.Filter;
import com.google.cloud.datastore.core.rep.$AutoValue_Index;
import com.google.cloud.datastore.core.rep.IndexDef;
import com.google.cloud.datastore.core.rep.IndexState;
import com.google.cloud.datastore.core.rep.WorkflowState;
import com.google.cloud.datastore.internal.StorageFormat;
import javax.annotation.Nullable;

@AutoValue
public abstract class Index {
    public static final ImmutableMultimap<Filter.StateFilter, WorkflowState> STATE_FILTER_VISIBILITY = new ImmutableMultimap.Builder().putAll((Object)Filter.StateFilter.USER_VISIBLE, (Object[])new WorkflowState[]{WorkflowState.CREATED, WorkflowState.ENABLING, WorkflowState.SERVING}).putAll((Object)Filter.StateFilter.SHOW_NON_SERVING, (Object[])new WorkflowState[]{WorkflowState.CREATED, WorkflowState.ENABLING, WorkflowState.SERVING, WorkflowState.NON_SERVING}).putAll((Object)Filter.StateFilter.ALL, (Object[])WorkflowState.values()).putAll((Object)Filter.StateFilter.STATE_FILTER_UNSPECIFIED, (Object[])WorkflowState.values()).build();
    private static final ImmutableSet<WorkflowState> WRITING_STATES = ImmutableSet.of((Object)((Object)WorkflowState.ENABLING), (Object)((Object)WorkflowState.SERVING), (Object)((Object)WorkflowState.NON_SERVING));

    public abstract IndexDef definition();

    public abstract long id();

    public abstract Optional<StorageFormat.BuiltinIndexId> builtinIndexId();

    @Nullable
    public abstract Long updateTimeMicros();

    public abstract WorkflowState workflowState();

    public abstract boolean error();

    public IndexState state() {
        return IndexState.create(this.workflowState(), this.error());
    }

    public boolean writing() {
        return WRITING_STATES.contains((Object)this.workflowState());
    }

    public abstract StorageVersion storageVersion();

    public boolean isFirestoreSingleField() {
        long indexId = this.id();
        return indexId == -6L || indexId == -9L || indexId == -7L || indexId == -10L || indexId == -12L || indexId == -13L;
    }

    public Index withState(IndexState indexState) {
        if (indexState.equals(this.state())) {
            return this;
        }
        if (!indexState.workflowState().equals((Object)this.state().workflowState())) {
            return this.toBuilder().indexState(indexState).updateTimeMicros(null).build();
        }
        return this.toBuilder().indexState(indexState).build();
    }

    public Index withId(long id) {
        return this.toBuilder().id(id).build();
    }

    @VisibleForTesting(productionVisibility=VisibleForTesting.Visibility.NONE)
    public Index withDefinition(IndexDef indexDef) {
        return this.toBuilder().definition(indexDef).build();
    }

    @VisibleForTesting(productionVisibility=VisibleForTesting.Visibility.NONE)
    public Index withStorageVersion(StorageVersion storageVersion) {
        return this.toBuilder().storageVersion(storageVersion).build();
    }

    public Index withUpdateTime(long updateTime) {
        return this.toBuilder().updateTimeMicros(updateTime).build();
    }

    @VisibleForTesting(productionVisibility=VisibleForTesting.Visibility.NONE)
    public Index withoutUpdateTime() {
        return this.toBuilder().updateTimeMicros(null).build();
    }

    protected abstract Builder toBuilder();

    public static Builder builder() {
        return new $AutoValue_Index.Builder().storageVersion(StorageVersion.V1).error(false);
    }

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder definition(IndexDef var1);

        public abstract Builder id(long var1);

        public abstract Builder builtinIndexId(StorageFormat.BuiltinIndexId var1);

        public abstract Builder builtinIndexId(Optional<StorageFormat.BuiltinIndexId> var1);

        protected abstract Builder error(boolean var1);

        protected abstract Builder workflowState(WorkflowState var1);

        public Builder workflowState(WorkflowState workflowState, boolean error) {
            return this.workflowState(workflowState).error(error);
        }

        public Builder indexState(IndexState indexState) {
            return this.workflowState(indexState.workflowState()).error(indexState.error());
        }

        public abstract Builder storageVersion(StorageVersion var1);

        public abstract Builder updateTimeMicros(@Nullable Long var1);

        abstract Index autoBuild();

        public Index build() {
            Index index = this.autoBuild();
            Preconditions.checkState((!index.error() || index.state().workflowState().finalizing() ? 1 : 0) != 0, (Object)"indexes must not have errors unless they are in a finalizing state");
            return index;
        }
    }

    public static enum StorageVersion {
        V1,
        V2;

    }

    @Deprecated
    public static enum State {
        ENABLING,
        ENABLED,
        DELETING,
        DISABLING,
        DISABLED,
        ERROR,
        CREATED,
        NON_SERVING;

    }
}

