/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.core.rep;

import com.google.appengine.repackaged.com.google.common.base.MoreObjects;
import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableList;
import com.google.appengine.repackaged.com.google.common.collect.Iterables;
import com.google.cloud.datastore.core.rep.EntityRef;
import com.google.cloud.datastore.core.rep.EntitySize;
import com.google.cloud.datastore.core.rep.Index;
import com.google.cloud.datastore.core.rep.IndexDef;
import com.google.cloud.datastore.core.rep.IndexValue;
import com.google.cloud.datastore.core.rep.IndexValueAndRemainder;
import com.google.cloud.datastore.core.rep.UnifiedIndexValue;
import com.google.storage.onestore.v3.OnestoreEntity;
import java.util.Collection;
import java.util.Objects;
import javax.annotation.Nullable;

public final class IndexEntry {
    private final Index index;
    private final ImmutableList<IndexValueAndRemainder> values;
    @Nullable
    private final EntityRef ref;
    @Nullable
    private final OnestoreEntity.CompositeProperty compositeProperty;

    public IndexEntry(Index index, ImmutableList<IndexValueAndRemainder> values, EntityRef ref) {
        this.index = (Index)Preconditions.checkNotNull((Object)index);
        this.values = (ImmutableList)Preconditions.checkNotNull(values);
        this.ref = (EntityRef)Preconditions.checkNotNull((Object)ref);
        this.compositeProperty = null;
    }

    @Deprecated
    public IndexEntry(Index index, ImmutableList<IndexValueAndRemainder> values, @Nullable EntityRef ref, @Nullable OnestoreEntity.CompositeProperty compositeProperty) {
        this.index = index;
        this.values = values;
        this.ref = ref;
        this.compositeProperty = compositeProperty;
    }

    public Index index() {
        return this.index;
    }

    public ImmutableList<IndexValueAndRemainder> values() {
        return this.values;
    }

    @Nullable
    public OnestoreEntity.CompositeProperty compositeProperty() {
        return this.compositeProperty;
    }

    @Nullable
    public EntityRef entityRef() {
        return this.ref;
    }

    @Deprecated
    @Nullable
    public ImmutableList<IndexValueAndRemainder> getSingleFieldIndexValue() {
        if (this.index.isFirestoreSingleField()) {
            return ImmutableList.of((Object)IndexEntry.dropContainsMark((IndexValueAndRemainder)this.values.get(1)), (Object)((IndexValueAndRemainder)this.values.get(3)), (Object)((IndexValueAndRemainder)this.values.get(4)));
        }
        return null;
    }

    private static IndexValueAndRemainder dropContainsMark(IndexValueAndRemainder value) {
        int lastIndexArrayElementIndex;
        IndexValue last;
        ImmutableList<IndexValue> indexArray;
        UnifiedIndexValue unifiedIndexValue = value.unifiedIndexValue();
        if (unifiedIndexValue.isAppEngV3()) {
            return value;
        }
        IndexValue indexValue = unifiedIndexValue.indexValue();
        if (indexValue.type() == IndexValue.Type.ARRAY && !(indexArray = indexValue.asArray()).isEmpty() && (last = (IndexValue)indexArray.get(lastIndexArrayElementIndex = indexArray.size() - 1)).equals(IndexValue.NULL)) {
            IndexValue newIndexValue = IndexValue.createArray(false, (ImmutableList<IndexValue>)ImmutableList.copyOf((Collection)indexArray.subList(0, lastIndexArrayElementIndex)));
            return IndexValueAndRemainder.createForFirestore(newIndexValue);
        }
        return value;
    }

    public int billedSize() {
        return this.billedSize(this.ref);
    }

    public int billedSize(EntityRef key) {
        Preconditions.checkNotNull((Object)key);
        switch (this.index.definition().form()) {
            case KEY_ASCENDING: {
                return 0;
            }
            case KIND_AND_KEY_ASCENDING: {
                return this.builtinKindNaturalSize(key);
            }
            case BUILTIN_SINGLE_PROPERTY: {
                return this.builtinPropertyNaturalSize(key);
            }
            case BUILTIN_FIRESTORE_COLLECTION_SINGLE_PROPERTY: {
                return this.firestoreCollectionNaturalSize(key, false, false, false);
            }
            case BUILTIN_FIRESTORE_COLLECTION_GROUP_SINGLE_PROPERTY: {
                return this.firestoreCollectionGroupNaturalSize(key, false, false, false);
            }
            case USER_DEFINED: {
                return this.userDefinedNaturalSize(key, true);
            }
        }
        throw new AssertionError((Object)"unreachable");
    }

    public int storageSize() {
        Preconditions.checkNotNull((Object)this.ref);
        switch (this.index.definition().form()) {
            case KEY_ASCENDING: {
                return 0;
            }
            case KIND_AND_KEY_ASCENDING: {
                return this.builtinKindNaturalSize(this.ref);
            }
            case BUILTIN_SINGLE_PROPERTY: {
                return this.builtinPropertyNaturalSize(this.ref);
            }
            case BUILTIN_FIRESTORE_COLLECTION_SINGLE_PROPERTY: {
                return this.firestoreCollectionNaturalSize(this.ref, true, true, true);
            }
            case BUILTIN_FIRESTORE_COLLECTION_GROUP_SINGLE_PROPERTY: {
                return this.firestoreCollectionGroupNaturalSize(this.ref, true, true, true);
            }
            case USER_DEFINED: {
                return this.userDefinedNaturalSize(this.ref, true);
            }
        }
        throw new AssertionError((Object)"unreachable");
    }

    private int builtinKindNaturalSize(EntityRef key) {
        Preconditions.checkState((boolean)this.index.definition().isKindAndKeyAscending());
        return 32 + EntitySize.entityRefSize(key) + EntitySize.stringSize(key.collectionId());
    }

    private int builtinPropertyNaturalSize(EntityRef key) {
        Preconditions.checkState((boolean)this.index.definition().isBuiltinSingleProperty());
        IndexDef.PropertyDef builtinPropertyDef = (IndexDef.PropertyDef)this.index.definition().propertyDefs().get(0);
        IndexValueAndRemainder builtinIndexValueAndRemainder = (IndexValueAndRemainder)this.values().get(0);
        return 32 + EntitySize.entityRefSize(key) + EntitySize.stringSize(key.collectionId()) + EntitySize.propertyPathSize(builtinPropertyDef.path()) + builtinIndexValueAndRemainder.naturalSize();
    }

    private int firestoreCollectionNaturalSize(EntityRef key, boolean includeCollectionId, boolean includeNamespace, boolean includeKeyDescending) {
        Preconditions.checkState((boolean)this.index.definition().isBuiltinFirestoreCollectionSingleProperty());
        ImmutableList<IndexDef.PropertyDef> propertyDefs = this.index.definition().propertyDefs();
        return 32 + (includeCollectionId ? EntitySize.stringSize(key.collectionId()) : 0) + (includeNamespace ? EntitySize.stringSize(key.partitionRef().namespace()) : 0) + EntitySize.entityRefSize(key) * (includeKeyDescending && propertyDefs.size() == 2 ? 2 : 1) + EntitySize.entityRefSize(key.parent()) + EntitySize.propertyPathSize(((IndexDef.PropertyDef)propertyDefs.get(0)).path()) + ((IndexValueAndRemainder)this.values().get(1)).naturalSize();
    }

    private int firestoreCollectionGroupNaturalSize(EntityRef key, boolean includeCollectionId, boolean includeNamespace, boolean includeKeyDescending) {
        Preconditions.checkState((boolean)this.index.definition().isBuiltinFirestoreCollectionGroupSingleProperty());
        int rootAncestorSize = EntitySize.entityRefSize(EntityRef.createEmpty(key.partitionRef()));
        ImmutableList<IndexDef.PropertyDef> propertyDefs = this.index.definition().propertyDefs();
        return 32 + (includeCollectionId ? EntitySize.stringSize(key.collectionId()) : 0) + (includeNamespace ? EntitySize.stringSize(key.partitionRef().namespace()) : 0) + EntitySize.entityRefSize(key) * (includeKeyDescending && propertyDefs.size() == 2 ? 2 : 1) + rootAncestorSize + EntitySize.propertyPathSize(((IndexDef.PropertyDef)propertyDefs.get(0)).path()) + ((IndexValueAndRemainder)this.values().get(0)).naturalSize();
    }

    private int userDefinedNaturalSize(EntityRef key, boolean includeKeyDescending) {
        Preconditions.checkState((boolean)this.index.definition().isUserDefined());
        int indexFieldValueSum = 0;
        boolean hasKeyDescending = IndexDef.PropertyDef.KEY_DESCENDING.equals(Iterables.getLast(this.index.definition().propertyDefs(), null));
        int numIndexValues = hasKeyDescending && !includeKeyDescending ? this.values().size() - 1 : this.values.size();
        for (IndexValueAndRemainder indexValueAndRemainder : this.values().subList(0, numIndexValues)) {
            indexFieldValueSum += indexValueAndRemainder.naturalSize();
        }
        return 32 + EntitySize.entityRefSize(key) + indexFieldValueSum;
    }

    @Deprecated
    public int naturalSize() {
        int resultSize = 0;
        ImmutableList<IndexValueAndRemainder> indexValueAndRemainders = this.getSingleFieldIndexValue();
        if (indexValueAndRemainders == null) {
            indexValueAndRemainders = this.values;
        }
        for (IndexValueAndRemainder indexValueAndRemainder : indexValueAndRemainders) {
            resultSize += indexValueAndRemainder.naturalSize();
        }
        return resultSize;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("values", this.values).toString();
    }

    public boolean equals(Object o) {
        if (!(o instanceof IndexEntry)) {
            return false;
        }
        IndexEntry that = (IndexEntry)o;
        return Objects.equals(this.index, that.index) && Objects.equals(this.values, that.values) && Objects.equals(this.ref, that.ref);
    }

    public int hashCode() {
        return Objects.hash(this.index, this.values, this.ref);
    }
}

