/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.core.rep;

import com.google.auto.value.AutoValue;
import com.google.cloud.datastore.core.rep.AutoValue_IndexValueAndRemainder;
import com.google.cloud.datastore.core.rep.EntitySize;
import com.google.cloud.datastore.core.rep.IndexValue;
import com.google.cloud.datastore.core.rep.UnifiedIndexValue;
import com.google.storage.onestore.v3.OnestoreEntity;

@AutoValue
public abstract class IndexValueAndRemainder {
    public static IndexValueAndRemainder createWithoutRemainder(IndexValue indexValue) {
        return new AutoValue_IndexValueAndRemainder(UnifiedIndexValue.create(indexValue), OnestoreEntity.Property.Meaning.NO_MEANING);
    }

    public static IndexValueAndRemainder createForDatastore(UnifiedIndexValue unifiedIndexValue, OnestoreEntity.Property.Meaning meaning) {
        return new AutoValue_IndexValueAndRemainder(unifiedIndexValue, meaning);
    }

    public static IndexValueAndRemainder createForFirestore(IndexValue indexValue) {
        return new AutoValue_IndexValueAndRemainder(UnifiedIndexValue.create(indexValue), OnestoreEntity.Property.Meaning.NO_MEANING);
    }

    public static IndexValueAndRemainder createStringForDatastore(String value) {
        OnestoreEntity.PropertyValue pvalue = new OnestoreEntity.PropertyValue().setStringValue(value);
        return new AutoValue_IndexValueAndRemainder(UnifiedIndexValue.create(pvalue), OnestoreEntity.Property.Meaning.NO_MEANING);
    }

    public abstract UnifiedIndexValue unifiedIndexValue();

    public abstract OnestoreEntity.Property.Meaning meaning();

    public int naturalSize() {
        UnifiedIndexValue unifiedIndexValue = this.unifiedIndexValue();
        if (unifiedIndexValue.isAppEngV3()) {
            return EntitySize.propertyValueSize(unifiedIndexValue.appEngV3IndexValue(), this.meaning());
        }
        return unifiedIndexValue.indexValue().naturalSize();
    }
}

