/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.core.rep;

import com.google.appengine.repackaged.com.google.common.base.Optional;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableCollection;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableList;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableMap;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableMultiset;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableSet;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableSetMultimap;
import com.google.auto.value.AutoValue;
import com.google.cloud.datastore.core.rep.AutoValue_KindIndexGroup;
import com.google.cloud.datastore.core.rep.DatastoreBuiltinIndex;
import com.google.cloud.datastore.core.rep.Index;
import com.google.cloud.datastore.core.rep.IndexDef;
import com.google.cloud.datastore.core.rep.IndexState;
import com.google.cloud.datastore.core.rep.KindIndexGroupSubset;
import com.google.cloud.datastore.core.rep.PropertyPath;
import com.google.cloud.datastore.core.rep.Query;
import com.google.cloud.datastore.core.rep.SingleFieldIndex;
import com.google.cloud.datastore.core.rep.SingleFieldIndexingConfiguration;
import com.google.cloud.datastore.core.rep.WorkflowState;
import com.google.cloud.datastore.internal.StorageFormat;
import java.util.EnumMap;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;

@AutoValue
public abstract class KindIndexGroup {
    public static final KindIndexGroup EMPTY = KindIndexGroup.create(null, (ImmutableMultiset<Index>)ImmutableMultiset.of());
    @GuardedBy(value="this")
    private final Map<IndexSubsetSpec, ImmutableSetMultimap<PropertyPath, SingleFieldIndex.Mode>> compositeIndexPropertyPathToSinglePropertyIndexModesMemoMap = new EnumMap<IndexSubsetSpec, ImmutableSetMultimap<PropertyPath, SingleFieldIndex.Mode>>(IndexSubsetSpec.class);

    public static boolean workflowStateInSubsetSpec(IndexSubsetSpec subsetSpec, @Nullable WorkflowState state) {
        if (state == null) {
            return false;
        }
        switch (subsetSpec) {
            case READ: {
                return state == WorkflowState.SERVING;
            }
            case WRITE: {
                return state.write();
            }
            case REPORT: {
                return state != WorkflowState.DELETED;
            }
            case FULLY_APPLIED: {
                return state == WorkflowState.SERVING || state == WorkflowState.NON_SERVING;
            }
            case PARTIALLY_OR_FULLY_APPLIED: {
                return state.write() || state.finalizing();
            }
        }
        throw new IllegalArgumentException("Unknown IndexSubsetSpec.");
    }

    public static ImmutableMultiset<Index> extractScannerWriteIndexes(ImmutableCollection<Index> indexes) {
        ImmutableMultiset.Builder scannerWriteIndexesBuilder = ImmutableMultiset.builder();
        for (Index index : indexes) {
            IndexDef indexDef = index.definition();
            if (!index.writing() || indexDef.isBuiltinSingleProperty() || indexDef.isStbti()) continue;
            scannerWriteIndexesBuilder.add((Object)index);
        }
        return scannerWriteIndexesBuilder.build();
    }

    @Nullable
    public abstract String kind();

    public abstract ImmutableMultiset<Index> allCompositeIndexes();

    public abstract ImmutableMultiset<DatastoreBuiltinIndex> datastoreBuiltinIndexes();

    public abstract SingleFieldIndexingConfiguration singleFieldIndexing();

    protected abstract ImmutableMap<IndexSubsetSpec, KindIndexGroupSubset> subsets();

    public KindIndexGroupSubset subset(IndexSubsetSpec spec) {
        return (KindIndexGroupSubset)this.subsets().get((Object)spec);
    }

    public ImmutableMultiset<Index> firestoreScannerIndexes(IndexSubsetSpec spec) {
        return this.subset(spec).firestoreCompositeIndexes();
    }

    public ImmutableMultiset<Index> datastoreScannerIndexes(IndexSubsetSpec spec) {
        return this.subset(spec).datastoreCompositeIndexes();
    }

    public ImmutableMultiset<Index> scannerIndexes(IndexSubsetSpec subsetSpec) {
        return this.scannerIndexes(subsetSpec, (Set<DatastoreBuiltinIndex.Mode>)ImmutableSet.of());
    }

    private ImmutableMultiset<Index> scannerIndexes(IndexSubsetSpec subsetSpec, Set<DatastoreBuiltinIndex.Mode> builtinIndexes) {
        KindIndexGroupSubset subset = this.subset(subsetSpec);
        if (!builtinIndexes.contains((Object)DatastoreBuiltinIndex.Mode.KIND_SCATTER)) {
            return subset.compositeIndexes();
        }
        ImmutableMultiset.Builder result = ImmutableMultiset.builder();
        result.addAll(subset.compositeIndexes());
        result.add((Object)KindIndexGroup.makeMaterializedKindScatterIndex(this.kind()));
        return result.build();
    }

    public ImmutableMultiset<Index> scannerIndexesWithScatter(IndexSubsetSpec subsetSpec) {
        return this.scannerIndexes(subsetSpec, (Set<DatastoreBuiltinIndex.Mode>)this.datastoreBuiltins(IndexSubsetSpec.READ));
    }

    public ImmutableMultiset<Index> stbtiIndexes(IndexSubsetSpec subsetSpec) {
        return this.subset(subsetSpec).stbtiIndexes();
    }

    public ImmutableSet<DatastoreBuiltinIndex.Mode> datastoreBuiltins(IndexSubsetSpec spec) {
        return this.subset(spec).datastoreBuiltins();
    }

    @Nullable
    public Long lastUpdated() {
        if (this.singleFieldIndexing().lastUpdated() == null) {
            return null;
        }
        long maxUpdateTime = this.singleFieldIndexing().lastUpdated();
        for (Index index : this.allCompositeIndexes()) {
            if (index.updateTimeMicros() == null) {
                return null;
            }
            maxUpdateTime = Math.max(maxUpdateTime, index.updateTimeMicros());
        }
        for (DatastoreBuiltinIndex builtinIndex : this.datastoreBuiltinIndexes()) {
            if (builtinIndex.updateTimeMicros() == null) {
                return null;
            }
            maxUpdateTime = Math.max(maxUpdateTime, builtinIndex.updateTimeMicros());
        }
        return maxUpdateTime;
    }

    @Nullable
    public ImmutableMap<PropertyPath, ImmutableMap<SingleFieldIndex.Mode, IndexState>> predeterminedPropertyPathToSinglePropertyIndexModes(IndexSubsetSpec indexSubsetSpec) {
        return null;
    }

    public synchronized ImmutableSetMultimap<PropertyPath, SingleFieldIndex.Mode> compositeIndexPropertyPathToSinglePropertyIndexModes(IndexSubsetSpec indexSubsetSpec) {
        ImmutableSetMultimap result = this.compositeIndexPropertyPathToSinglePropertyIndexModesMemoMap.get((Object)indexSubsetSpec);
        if (result != null) {
            return result;
        }
        ImmutableSetMultimap.Builder multimapBuilder = ImmutableSetMultimap.builder();
        for (Index index : this.scannerIndexes(indexSubsetSpec)) {
            if (index.id() < 0L) continue;
            block4: for (IndexDef.PropertyDef indexPropertyDef : index.definition().propertyDefs()) {
                if (indexPropertyDef.mode() != IndexDef.PropertyDef.Mode.ORDERED) continue;
                PropertyPath propertyPath = indexPropertyDef.path();
                switch (propertyPath.special()) {
                    case KEY: 
                    case KIND: {
                        continue block4;
                    }
                }
                if (propertyPath.isArrayElements()) {
                    PropertyPath effectivePropertyPath = propertyPath.dropLastPathSegment();
                    multimapBuilder.put((Object)effectivePropertyPath, (Object)SingleFieldIndex.Mode.COLLECTION_CONTAINS);
                    continue;
                }
                multimapBuilder.put((Object)propertyPath, (Object)SingleFieldIndex.Mode.COLLECTION_ASC);
                multimapBuilder.put((Object)propertyPath, (Object)SingleFieldIndex.Mode.COLLECTION_DESC);
            }
        }
        result = multimapBuilder.build();
        this.compositeIndexPropertyPathToSinglePropertyIndexModesMemoMap.put(indexSubsetSpec, (ImmutableSetMultimap<PropertyPath, SingleFieldIndex.Mode>)result);
        return result;
    }

    private static Index makeMaterializedKindScatterIndex(String kind) {
        IndexDef indexDef = IndexDef.create(Query.Semantics.DATASTORE, kind, IndexDef.IndexAncestor.NONE, (ImmutableList<IndexDef.PropertyDef>)ImmutableList.of((Object)IndexDef.PropertyDef.ascending(PropertyPath.SCATTER)));
        return Index.builder().id(0L).builtinIndexId((Optional<StorageFormat.BuiltinIndexId>)Optional.of((Object)StorageFormat.BuiltinIndexId.KIND_SCATTER)).workflowState(WorkflowState.SERVING, false).definition(indexDef).storageVersion(Index.StorageVersion.V1).build();
    }

    public static KindIndexGroup create(@Nullable String kind, ImmutableMultiset<Index> compositeIndexes) {
        return KindIndexGroup.create(kind, compositeIndexes, (ImmutableMultiset<DatastoreBuiltinIndex>)ImmutableMultiset.of(), SingleFieldIndexingConfiguration.EMPTY);
    }

    public static KindIndexGroup create(@Nullable String kind, ImmutableMultiset<Index> compositeIndexes, ImmutableMultiset<DatastoreBuiltinIndex> datastoreBuiltins, SingleFieldIndexingConfiguration singleFieldIndexing) {
        ImmutableMap.Builder subspecViews = ImmutableMap.builder();
        for (IndexSubsetSpec subsetSpec : IndexSubsetSpec.values()) {
            subspecViews.put((Object)subsetSpec, (Object)KindIndexGroupSubset.precompute(kind, subsetSpec, singleFieldIndexing, datastoreBuiltins, compositeIndexes));
        }
        return new AutoValue_KindIndexGroup(kind, compositeIndexes, datastoreBuiltins, singleFieldIndexing, (ImmutableMap<IndexSubsetSpec, KindIndexGroupSubset>)subspecViews.build());
    }

    public static enum IndexSubsetSpec {
        REPORT,
        WRITE,
        READ,
        FULLY_APPLIED,
        PARTIALLY_OR_FULLY_APPLIED;

    }
}

