/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.core.rep;

import com.google.appengine.repackaged.com.google.common.base.Predicates;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableCollection;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableMap;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableMultiset;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableSet;
import com.google.auto.value.AutoValue;
import com.google.cloud.datastore.core.rep.AutoValue_KindIndexGroupSubset;
import com.google.cloud.datastore.core.rep.AutoValue_KindIndexGroupSubset_TrieNode;
import com.google.cloud.datastore.core.rep.DatastoreBuiltinIndex;
import com.google.cloud.datastore.core.rep.Index;
import com.google.cloud.datastore.core.rep.KindIndexGroup;
import com.google.cloud.datastore.core.rep.PropertyPath;
import com.google.cloud.datastore.core.rep.PropertyPathSegment;
import com.google.cloud.datastore.core.rep.Query;
import com.google.cloud.datastore.core.rep.SingleFieldIndex;
import com.google.cloud.datastore.core.rep.SingleFieldIndexingConfiguration;
import com.google.cloud.datastore.core.rep.SingleFieldIndexingRule;
import com.google.cloud.datastore.core.rep.SingleFieldRef;
import com.google.cloud.datastore.core.rep.WorkflowState;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.Nullable;

@AutoValue
public abstract class KindIndexGroupSubset {
    @Nullable
    public abstract String kind();

    public abstract ImmutableMultiset<SingleFieldIndexingRule> singleFieldIndexingRules();

    abstract TrieNode singleFieldIndexingTrie();

    public abstract Iterable<PropertyPath> indexedSubtrees();

    public abstract ImmutableSet<PropertyPath> unindexedSubtrees();

    public abstract ImmutableSet<DatastoreBuiltinIndex.Mode> datastoreBuiltins();

    public abstract ImmutableMultiset<Index> compositeIndexes();

    public ImmutableMultiset<Index> firestoreCompositeIndexes() {
        return KindIndexGroupSubset.filterCompositeIndexes(this.compositeIndexes(), Query.Semantics.FIRESTORE);
    }

    public ImmutableMultiset<Index> datastoreCompositeIndexes() {
        return KindIndexGroupSubset.filterCompositeIndexes(this.compositeIndexes(), Query.Semantics.DATASTORE);
    }

    public ImmutableMultiset<Index> stbtiIndexes() {
        return KindIndexGroupSubset.filterStbtiIndexes(this.compositeIndexes());
    }

    public ImmutableSet<SingleFieldIndex.Mode> modes(@Nullable PropertyPath propertyPath) {
        return this.singleFieldIndexingTrie().modes(propertyPath);
    }

    private static KindIndexGroupSubset create(String kind, ImmutableMultiset<SingleFieldIndexingRule> filteredSingleFieldIndexingRules, ImmutableSet<DatastoreBuiltinIndex.Mode> filteredDatastoreBuiltins, ImmutableMultiset<Index> filteredCompositeIndexes) {
        TrieNode trie = KindIndexGroupSubset.buildSingleFieldIndexingTrie(filteredSingleFieldIndexingRules);
        HashSet<PropertyPath> indexedSubtrees = new HashSet<PropertyPath>();
        ImmutableSet.Builder unindexedSubtrees = ImmutableSet.builder();
        KindIndexGroupSubset.classifySubtrees(filteredSingleFieldIndexingRules, trie, indexedSubtrees, (ImmutableSet.Builder<PropertyPath>)unindexedSubtrees);
        return new AutoValue_KindIndexGroupSubset(kind, filteredSingleFieldIndexingRules, trie, Collections.unmodifiableSet(indexedSubtrees), (ImmutableSet<PropertyPath>)unindexedSubtrees.build(), filteredDatastoreBuiltins, filteredCompositeIndexes);
    }

    static KindIndexGroupSubset precompute(String kind, KindIndexGroup.IndexSubsetSpec subsetSpec, SingleFieldIndexingConfiguration singleFieldIndexing, ImmutableMultiset<DatastoreBuiltinIndex> datastoreBuiltins, ImmutableMultiset<Index> compositeIndexes) {
        ImmutableMultiset<SingleFieldIndexingRule> rules = KindIndexGroupSubset.resolvedSingleFieldIndexingRules(kind, singleFieldIndexing, subsetSpec);
        WorkflowStateFilter statePredicate = new WorkflowStateFilter(subsetSpec);
        return KindIndexGroupSubset.create(kind, rules, KindIndexGroupSubset.filterDatastoreBuiltins(datastoreBuiltins, statePredicate), KindIndexGroupSubset.filterCompositeIndexes(compositeIndexes, statePredicate));
    }

    public static KindIndexGroupSubset fromAppliedIndexes(String kind, ImmutableMultiset<SingleFieldIndexingRule> singleFieldIndexingRules, ImmutableSet<DatastoreBuiltinIndex.Mode> datastoreBuiltins, ImmutableMultiset<Index> compositeIndexes) {
        return KindIndexGroupSubset.create(kind, singleFieldIndexingRules, datastoreBuiltins, compositeIndexes);
    }

    private static ImmutableMultiset<SingleFieldIndexingRule> resolvedSingleFieldIndexingRules(String kind, SingleFieldIndexingConfiguration config, KindIndexGroup.IndexSubsetSpec subsetSpec) {
        ImmutableMultiset.Builder rules = ImmutableMultiset.builder();
        rules.add((Object)KindIndexGroupSubset.resolveSingleFieldIndexingRule(subsetSpec, config, config.databaseDefaults()));
        for (SingleFieldIndexingRule sfiRule : config.kindRules().get((Object)kind)) {
            SingleFieldIndexingRule resolved = KindIndexGroupSubset.resolveSingleFieldIndexingRule(subsetSpec, config, sfiRule);
            if (resolved == null) continue;
            rules.add((Object)resolved);
        }
        return rules.build();
    }

    @Nullable
    private static SingleFieldIndexingRule resolveSingleFieldIndexingRule(KindIndexGroup.IndexSubsetSpec subsetSpec, SingleFieldIndexingConfiguration config, SingleFieldIndexingRule rule) {
        switch (subsetSpec) {
            case READ: {
                if (rule.state() == WorkflowState.DELETED) {
                    return null;
                }
                if (KindIndexGroup.workflowStateInSubsetSpec(subsetSpec, rule.state())) {
                    return KindIndexGroupSubset.filterSingleFieldIndexes(rule, new WorkflowStateFilter(subsetSpec));
                }
                SingleFieldIndexingRule parent = KindIndexGroupSubset.resolveSingleFieldIndexingRule(subsetSpec, config, config.generatingRule(rule.ref().parent()));
                return KindIndexGroupSubset.filterSingleFieldIndexes(rule, new WorkflowStateFilter(subsetSpec), (Predicate<SingleFieldIndex.Mode>)Predicates.in((Collection)parent.indexes().keySet()));
            }
            case REPORT: {
                if (!rule.state().up()) {
                    return null;
                }
                return KindIndexGroupSubset.filterSingleFieldIndexes(rule, new WorkflowStateUpFilter());
            }
            case WRITE: 
            case FULLY_APPLIED: 
            case PARTIALLY_OR_FULLY_APPLIED: {
                if (!KindIndexGroup.workflowStateInSubsetSpec(subsetSpec, rule.state())) {
                    return null;
                }
                return KindIndexGroupSubset.filterSingleFieldIndexes(rule, new WorkflowStateFilter(subsetSpec));
            }
        }
        throw new AssertionError((Object)"unreachable");
    }

    private static SingleFieldIndexingRule filterSingleFieldIndexes(SingleFieldIndexingRule rule, Predicate<WorkflowState> predicate) {
        return KindIndexGroupSubset.filterSingleFieldIndexes(rule, predicate, (Predicate<SingleFieldIndex.Mode>)Predicates.alwaysTrue());
    }

    private static SingleFieldIndexingRule filterSingleFieldIndexes(SingleFieldIndexingRule rule, Predicate<WorkflowState> statePredicate, Predicate<SingleFieldIndex.Mode> modePredicate) {
        ImmutableMap<SingleFieldIndex.Mode, WorkflowState> indexes = rule.indexStates();
        if (indexes.keySet().stream().allMatch(modePredicate) && indexes.values().stream().allMatch(statePredicate)) {
            return rule;
        }
        ImmutableMap.Builder result = ImmutableMap.builder();
        for (Map.Entry entry : rule.indexes().entrySet()) {
            SingleFieldIndex.Mode mode = (SingleFieldIndex.Mode)((Object)entry.getKey());
            SingleFieldIndex index = (SingleFieldIndex)entry.getValue();
            if (!statePredicate.test(index.workflowState()) || !modePredicate.test(mode)) continue;
            result.put((Object)mode, (Object)index);
        }
        return rule.withIndexes((ImmutableMap<SingleFieldIndex.Mode, SingleFieldIndex>)result.build());
    }

    private static TrieNode buildSingleFieldIndexingTrie(Iterable<SingleFieldIndexingRule> rules) {
        TrieNode.Builder rootBuilder = TrieNode.builder();
        SingleFieldIndexingRule defaultRule = null;
        for (SingleFieldIndexingRule rule : rules) {
            SingleFieldRef ref = rule.ref();
            if (ref.isDatabase() && defaultRule == null) {
                defaultRule = rule;
                continue;
            }
            if (ref.isKind()) {
                defaultRule = rule;
                continue;
            }
            TrieNode.Builder node = rootBuilder.child(ref.propertyPath());
            node.modes((ImmutableSet<SingleFieldIndex.Mode>)rule.indexes().keySet());
        }
        if (defaultRule != null) {
            rootBuilder.modes((ImmutableSet<SingleFieldIndex.Mode>)defaultRule.indexes().keySet());
        }
        return rootBuilder.build();
    }

    private static void classifySubtrees(Iterable<SingleFieldIndexingRule> rules, TrieNode trie, Set<PropertyPath> indexedSubtrees, ImmutableSet.Builder<PropertyPath> unindexedSubtrees) {
        for (SingleFieldIndexingRule rule : rules) {
            PropertyPath path = rule.ref().propertyPath();
            if (rule.indexes().isEmpty()) {
                if (path == null) continue;
                unindexedSubtrees.add((Object)path);
                continue;
            }
            if (path != null && !trie.modes(path.dropLastPathSegment()).isEmpty()) continue;
            indexedSubtrees.add(path);
        }
    }

    private static ImmutableSet<DatastoreBuiltinIndex.Mode> filterDatastoreBuiltins(ImmutableMultiset<DatastoreBuiltinIndex> datastoreBuiltinIndexes, Predicate<WorkflowState> statePredicate) {
        ImmutableSet.Builder builtins = ImmutableSet.builder();
        for (DatastoreBuiltinIndex builtin : datastoreBuiltinIndexes) {
            if (!statePredicate.test(builtin.workflowState())) continue;
            builtins.add((Object)builtin.mode());
        }
        return builtins.build();
    }

    private static ImmutableMultiset<Index> filterCompositeIndexes(ImmutableMultiset<Index> compositeIndexes, Predicate<WorkflowState> statePredicate) {
        ImmutableMultiset.Builder indexes = ImmutableMultiset.builder();
        for (Index index : compositeIndexes) {
            if (!statePredicate.test(index.workflowState()) || index.definition().isBuiltinSingleProperty()) continue;
            indexes.add((Object)index);
        }
        return indexes.build();
    }

    private static ImmutableMultiset<Index> filterCompositeIndexes(ImmutableMultiset<Index> compositeIndexes, Query.Semantics semantics) {
        ImmutableMultiset.Builder indexes = ImmutableMultiset.builder();
        for (Index index : compositeIndexes) {
            if (!semantics.equals((Object)index.definition().semantics()) || index.definition().isStbti()) continue;
            indexes.add((Object)index);
        }
        return KindIndexGroupSubset.reuseSuperCollectionWhenSame(indexes.build(), compositeIndexes);
    }

    private static ImmutableMultiset<Index> filterStbtiIndexes(ImmutableMultiset<Index> compositeIndexes) {
        ImmutableMultiset.Builder indexes = ImmutableMultiset.builder();
        for (Index index : compositeIndexes) {
            if (!index.definition().isStbti()) continue;
            indexes.add((Object)index);
        }
        return KindIndexGroupSubset.reuseSuperCollectionWhenSame(indexes.build(), compositeIndexes);
    }

    private static <E, C extends ImmutableCollection<E>> C reuseSuperCollectionWhenSame(C subCollection, C superCollection) {
        if (subCollection.size() == superCollection.size()) {
            return superCollection;
        }
        return subCollection;
    }

    private static class WorkflowStateUpFilter
    implements Predicate<WorkflowState> {
        private WorkflowStateUpFilter() {
        }

        @Override
        public boolean test(WorkflowState input) {
            return input.up();
        }
    }

    private static class WorkflowStateFilter
    implements Predicate<WorkflowState> {
        private final KindIndexGroup.IndexSubsetSpec subsetSpec;

        WorkflowStateFilter(KindIndexGroup.IndexSubsetSpec subsetSpec) {
            this.subsetSpec = subsetSpec;
        }

        @Override
        public boolean test(WorkflowState input) {
            return KindIndexGroup.workflowStateInSubsetSpec(this.subsetSpec, input);
        }
    }

    @AutoValue
    static abstract class TrieNode {
        TrieNode() {
        }

        @Nullable
        protected abstract ImmutableSet<SingleFieldIndex.Mode> modes();

        ImmutableSet<SingleFieldIndex.Mode> modes(@Nullable PropertyPath path) {
            TrieNode current = this;
            ImmutableSet<SingleFieldIndex.Mode> currentModes = current.modes();
            while (path != null && current.children().containsKey((Object)path.segment())) {
                current = (TrieNode)current.children().get((Object)path.segment());
                path = path.next();
                currentModes = current.modes() != null ? current.modes() : currentModes;
            }
            return currentModes;
        }

        protected abstract ImmutableMap<PropertyPathSegment, TrieNode> children();

        static Builder builder() {
            return new Builder();
        }

        static class Builder {
            private ImmutableSet<SingleFieldIndex.Mode> modes;
            private final Map<PropertyPathSegment, Builder> children = new HashMap<PropertyPathSegment, Builder>();

            Builder() {
            }

            void modes(ImmutableSet<SingleFieldIndex.Mode> modes) {
                this.modes = modes;
            }

            Builder child(PropertyPathSegment segment) {
                Builder child = this.children.computeIfAbsent(segment, k -> new Builder());
                return child;
            }

            Builder child(@Nullable PropertyPath path) {
                Builder current = this;
                while (path != null) {
                    current = current.child(path.segment());
                    path = path.next();
                }
                return current;
            }

            TrieNode build() {
                ImmutableMap.Builder finalChildren = ImmutableMap.builder();
                for (Map.Entry<PropertyPathSegment, Builder> entry : this.children.entrySet()) {
                    finalChildren.put((Object)entry.getKey(), (Object)entry.getValue().build());
                }
                return new AutoValue_KindIndexGroupSubset_TrieNode(this.modes, (ImmutableMap<PropertyPathSegment, TrieNode>)finalChildren.build());
            }
        }
    }
}

