/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.core.rep;

import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableList;
import com.google.auto.value.AutoValue;
import com.google.cloud.datastore.core.rep.$AutoValue_Mutation;
import com.google.cloud.datastore.core.rep.EntityMetadata;
import com.google.cloud.datastore.core.rep.EntityTransformation;
import com.google.cloud.datastore.core.rep.PropertyMask;
import com.google.cloud.datastore.core.rep.V3Paths;
import com.google.storage.onestore.v3.OnestoreEntity;
import java.util.List;
import javax.annotation.Nullable;

@AutoValue
public abstract class Mutation {
    private boolean autoIdInserted = false;

    public abstract boolean allocateKey();

    public abstract Op op();

    protected abstract ImmutableList<Mutation> subMutationsInternal();

    public List<Mutation> subMutations() {
        if (this.subMutationsInternal().isEmpty()) {
            return ImmutableList.of((Object)this);
        }
        return this.subMutationsInternal();
    }

    @Nullable
    public abstract OnestoreEntity.EntityProto entity();

    @Nullable
    public abstract EntityMetadata entityMetadata();

    @Nullable
    public abstract PropertyMask writePropertyMask();

    @Nullable
    public abstract PropertyMask readPropertyMask();

    @Nullable
    public abstract EntityTransformation transformation();

    public abstract boolean transformationOnly();

    public abstract OnestoreEntity.Reference key();

    public boolean ignoresExistingEntityData() {
        PropertyMask mask = this.writePropertyMask();
        return (mask == null || mask.equals(PropertyMask.FULL)) && this.transformation() == null;
    }

    @Nullable
    public abstract Long baseVersion();

    @Nullable
    public abstract ConflictResolutionStrategy conflictResolutionStrategy();

    public abstract boolean recreateEntity();

    public abstract long sequenceNumber();

    public void setAutoIdInserted() {
        this.autoIdInserted = true;
    }

    public boolean autoIdInserted() {
        return this.autoIdInserted;
    }

    public boolean isDelete() {
        return this.op().isDelete();
    }

    public boolean isVerify() {
        return this.op().isVerify();
    }

    public boolean hasConflictDetection() {
        return this.baseVersion() != null;
    }

    public boolean conflictsWith(long serverVersion) {
        return this.baseVersion() != null && this.baseVersion() != serverVersion;
    }

    abstract Builder toBuilder();

    public static Builder builder() {
        return new $AutoValue_Mutation.Builder().allocateKey(false).recreateEntity(false).transformationOnly(false).sequenceNumber(0L).subMutationsInternal((List<Mutation>)ImmutableList.of());
    }

    public static Builder insert(OnestoreEntity.EntityProto entity) {
        return Mutation.builder().op(Op.INSERT).entityAndFullMask(entity);
    }

    public static Builder update(OnestoreEntity.EntityProto entity) {
        return Mutation.builder().op(Op.UPDATE).entityAndFullMask(entity);
    }

    public static Builder upsert(OnestoreEntity.EntityProto entity) {
        return Mutation.builder().op(Op.UPSERT).entityAndFullMask(entity);
    }

    public static Builder delete(OnestoreEntity.Reference key) {
        return Mutation.builder().op(Op.DELETE).key(key);
    }

    @AutoValue.Builder
    public static abstract class Builder {
        abstract Builder allocateKey(boolean var1);

        public abstract Builder op(Op var1);

        public abstract Builder subMutationsInternal(List<Mutation> var1);

        public abstract Builder entity(@Nullable OnestoreEntity.EntityProto var1);

        public abstract Builder entityMetadata(EntityMetadata var1);

        public abstract Builder writePropertyMask(@Nullable PropertyMask var1);

        public abstract Builder readPropertyMask(@Nullable PropertyMask var1);

        public abstract Builder transformationOnly(boolean var1);

        public abstract Builder transformation(@Nullable EntityTransformation var1);

        public abstract Builder key(OnestoreEntity.Reference var1);

        public abstract Builder baseVersion(@Nullable Long var1);

        public abstract Builder conflictResolutionStrategy(@Nullable ConflictResolutionStrategy var1);

        public abstract Builder recreateEntity(boolean var1);

        public abstract Builder sequenceNumber(long var1);

        public Builder entityAndFullMask(OnestoreEntity.EntityProto entity) {
            return this.key(entity.getKey()).entity(entity).writePropertyMask(PropertyMask.FULL);
        }

        abstract Mutation autoBuild();

        public Mutation build() {
            Mutation mutation = this.autoBuild();
            if (mutation.op().isDelete() || mutation.op().isVerify()) {
                Preconditions.checkArgument((mutation.entity() == null ? 1 : 0) != 0, (String)"Entity cannot be set for %s", (Object)((Object)mutation.op()));
                Preconditions.checkArgument((mutation.entityMetadata() == null ? 1 : 0) != 0, (String)"EntityMetadata cannot be set for %s", (Object)((Object)mutation.op()));
                Preconditions.checkArgument((mutation.readPropertyMask() == null ? 1 : 0) != 0, (String)"Read property mask cannot be set for %s", (Object)((Object)mutation.op()));
                Preconditions.checkArgument((!mutation.recreateEntity() ? 1 : 0) != 0, (String)"Cannot recreate entity for %s", (Object)((Object)mutation.op()));
                Preconditions.checkArgument((mutation.transformation() == null ? 1 : 0) != 0, (String)"Transformation cannot be set for %s", (Object)((Object)mutation.op()));
                Preconditions.checkArgument((mutation.writePropertyMask() == null ? 1 : 0) != 0, (String)"Write property mask cannot be set for %s", (Object)((Object)mutation.op()));
            } else {
                Preconditions.checkArgument((mutation.entity() != null ? 1 : 0) != 0, (String)"Entity must be set for %s", (Object)((Object)mutation.op()));
                Preconditions.checkArgument((boolean)mutation.key().equals(mutation.entity().getKey()), (String)"Entity must match key for %s", (Object)((Object)mutation.op()));
            }
            Preconditions.checkArgument((mutation.baseVersion() == null == (mutation.conflictResolutionStrategy() == null) ? 1 : 0) != 0, (Object)"ConflictResolutionStrategy should be set IFF baseVersion is set.");
            Preconditions.checkArgument((mutation.entityMetadata() == null || mutation.baseVersion() == null ? 1 : 0) != 0, (Object)"Base version cannot be used together with entityMetadata.");
            if (mutation.entity() != null) {
                Preconditions.checkArgument((mutation.writePropertyMask() != null ? 1 : 0) != 0, (Object)"Write property mask must be set if entity is set.");
                if (V3Paths.hasIncompleteLastElement(mutation.key())) {
                    Preconditions.checkArgument((mutation.op() != Op.UPDATE ? 1 : 0) != 0, (Object)"Key cannot have incomplete last element path for update.");
                    mutation = mutation.toBuilder().op(Op.INSERT).allocateKey(true).autoBuild();
                }
                if (!PropertyMask.FULL.equals(mutation.writePropertyMask())) {
                    mutation = mutation.toBuilder().entity(mutation.writePropertyMask().mask(mutation.entity())).autoBuild();
                }
            }
            Preconditions.checkArgument((mutation.sequenceNumber() >= 0L ? 1 : 0) != 0, (Object)"Sequence number cannot be negative.");
            return mutation;
        }
    }

    public static enum ConflictResolutionStrategy {
        SERVER_VALUE,
        CLIENT_VALUE,
        FAIL;

    }

    public static enum Op {
        INSERT(Operation.WRITE, ExistencePrecondition.MUST_NOT_EXIST),
        UPDATE(Operation.WRITE, ExistencePrecondition.MUST_EXIST),
        UPSERT(Operation.WRITE, ExistencePrecondition.NONE),
        DELETE_MUST_NOT_EXIST(Operation.DELETE, ExistencePrecondition.MUST_NOT_EXIST),
        DELETE_MUST_EXIST(Operation.DELETE, ExistencePrecondition.MUST_EXIST),
        DELETE(Operation.DELETE, ExistencePrecondition.NONE),
        VERIFY_MUST_NOT_EXIST(Operation.VERIFY, ExistencePrecondition.MUST_NOT_EXIST),
        VERIFY_MUST_EXIST(Operation.VERIFY, ExistencePrecondition.MUST_EXIST);

        public final Operation operation;
        public final ExistencePrecondition existence;

        private Op(Operation operation, ExistencePrecondition existence) {
            this.operation = operation;
            this.existence = existence;
        }

        public static Op from(Operation operation, ExistencePrecondition existence) {
            for (Op op : Op.values()) {
                if (!op.operation.equals((Object)operation) || !op.existence.equals((Object)existence)) continue;
                return op;
            }
            throw new IllegalArgumentException("verify with unknown existence precondition is illegal.");
        }

        public boolean isDelete() {
            return this.operation.equals((Object)Operation.DELETE);
        }

        public boolean isVerify() {
            return this.operation.equals((Object)Operation.VERIFY);
        }
    }

    public static enum ExistencePrecondition {
        NONE,
        MUST_EXIST,
        MUST_NOT_EXIST;

    }

    public static enum Operation {
        WRITE,
        DELETE,
        VERIFY;

    }
}

