/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.core.rep;

import com.google.appengine.repackaged.com.google.common.base.MoreObjects;
import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableMap;
import com.google.appengine.repackaged.com.google.common.collect.Sets;
import com.google.appengine.repackaged.com.google.protobuf.InvalidProtocolBufferException;
import com.google.auto.value.AutoValue;
import com.google.cloud.datastore.core.rep.AutoValue_PropertyMask_EntityProperty;
import com.google.cloud.datastore.core.rep.Entity;
import com.google.cloud.datastore.core.rep.EntityRef;
import com.google.cloud.datastore.core.rep.PropertyName;
import com.google.cloud.datastore.core.rep.Value;
import com.google.storage.onestore.v3.OnestoreEntity;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;

public class PropertyMask {
    public static final PropertyMask FULL = new PropertyMask((Map)ImmutableMap.of()){

        @Override
        public String toString() {
            return "*";
        }

        @Override
        public OnestoreEntity.EntityProto mask(OnestoreEntity.EntityProto entity) {
            return entity;
        }

        @Override
        public OnestoreEntity.EntityProto maskInto(OnestoreEntity.EntityProto srcEntity, OnestoreEntity.EntityProto oldEntity) {
            return srcEntity;
        }

        @Override
        public PropertyMask merge(PropertyMask other) {
            return this;
        }

        @Override
        public PropertyMask nestedMask(PropertyName name) {
            return FULL;
        }
    };
    public static final PropertyMask EMPTY = new PropertyMask((Map<PropertyName, PropertyMask>)ImmutableMap.of());
    private static final ImmutableMap<String, Value> EMPTY_STRING_VALUE_MAP = ImmutableMap.of();
    private final ImmutableMap<PropertyName, PropertyMask> properties;

    public PropertyMask(Map<PropertyName, PropertyMask> properties) {
        this.properties = ImmutableMap.copyOf(properties);
    }

    public Set<PropertyName> propertyNames() {
        return this.properties.keySet();
    }

    public PropertyMask nestedMask(PropertyName name) {
        Preconditions.checkArgument((boolean)this.properties.containsKey((Object)name));
        return (PropertyMask)this.properties.get((Object)name);
    }

    public PropertyMask merge(PropertyMask other) {
        if (FULL.equals(other)) {
            return other;
        }
        HashMap<PropertyName, PropertyMask> merged = new HashMap<PropertyName, PropertyMask>();
        for (PropertyName name : Sets.union((Set)this.properties.keySet(), (Set)other.properties.keySet())) {
            PropertyMask thisNestedMask = (PropertyMask)this.properties.get((Object)name);
            PropertyMask otherNestedMask = (PropertyMask)other.properties.get((Object)name);
            if (thisNestedMask == null) {
                merged.put(name, otherNestedMask);
                continue;
            }
            if (otherNestedMask == null) {
                merged.put(name, thisNestedMask);
                continue;
            }
            merged.put(name, thisNestedMask.merge(otherNestedMask));
        }
        return new PropertyMask(merged);
    }

    Entity entityMaskCopy(Entity entity) {
        if (this.equals(FULL)) {
            return entity;
        }
        ImmutableMap maskedMap = this.mapMaskCopy(entity.propertyMap());
        if (maskedMap == null) {
            maskedMap = ImmutableMap.of();
        }
        return Entity.create(entity.ref(), (ImmutableMap<String, Value>)maskedMap);
    }

    @Nullable
    private ImmutableMap<String, Value> mapMaskCopy(ImmutableMap<String, Value> map) {
        boolean isMapEmpty = true;
        ImmutableMap.Builder mapBuilder = ImmutableMap.builder();
        for (Map.Entry entry : this.properties.entrySet()) {
            Value maskCopyValue;
            PropertyName propertyName = (PropertyName)entry.getKey();
            PropertyMask subMask = (PropertyMask)entry.getValue();
            String name = propertyName.string();
            Value value = (Value)map.get((Object)name);
            if (value == null || (maskCopyValue = subMask.equals(FULL) ? value : subMask.valueMaskCopy(value)) == null) continue;
            mapBuilder.put((Object)name, (Object)maskCopyValue);
            isMapEmpty = false;
        }
        if (isMapEmpty) {
            return null;
        }
        return mapBuilder.build();
    }

    @Nullable
    private Value valueMaskCopy(Value value) {
        switch (value.type()) {
            case MAP: {
                return this.mapMaskCopyAndWrapInValue(value.asMap());
            }
            case ENTITY: {
                return this.mapMaskCopyAndWrapInValue(value.asEntity().propertyMap());
            }
        }
        return null;
    }

    @Nullable
    private Value mapMaskCopyAndWrapInValue(ImmutableMap<String, Value> map) {
        ImmutableMap<String, Value> maskedMap = this.mapMaskCopy(map);
        if (maskedMap == null) {
            return null;
        }
        return Value.createMap(maskedMap);
    }

    Entity entityCopyAndMaskReplace(Entity entity, Entity maskedOtherEntity) {
        ImmutableMap<String, Value> maskedOtherEntityPropertyMap = maskedOtherEntity.propertyMap();
        ImmutableMap<String, Value> resultPropertyMap = this.equals(FULL) ? maskedOtherEntityPropertyMap : this.mapCopyAndMaskReplace(entity.propertyMap(), maskedOtherEntityPropertyMap);
        return Entity.create(entity.ref(), resultPropertyMap);
    }

    private ImmutableMap<String, Value> mapCopyAndMaskReplace(ImmutableMap<String, Value> map, ImmutableMap<String, Value> maskedOtherMap) {
        if (map.isEmpty() && maskedOtherMap.isEmpty()) {
            return EMPTY_STRING_VALUE_MAP;
        }
        ImmutableMap.Builder mapBuilder = ImmutableMap.builder();
        for (Map.Entry entry : map.entrySet()) {
            String name = (String)entry.getKey();
            Value value = (Value)entry.getValue();
            if (this.properties.containsKey((Object)PropertyName.create(name))) continue;
            mapBuilder.put((Object)name, (Object)value);
        }
        for (Map.Entry entry : this.properties.entrySet()) {
            PropertyName propertyName = (PropertyName)entry.getKey();
            PropertyMask subMask = (PropertyMask)entry.getValue();
            String name = propertyName.string();
            Value value = (Value)map.get((Object)name);
            Value maskedOtherValue = (Value)maskedOtherMap.get((Object)name);
            Value copyAndMaskReplacedValue = subMask.equals(FULL) ? maskedOtherValue : subMask.valueCopyAndMaskReplace(value, maskedOtherValue);
            if (copyAndMaskReplacedValue == null) continue;
            mapBuilder.put((Object)name, (Object)copyAndMaskReplacedValue);
        }
        return mapBuilder.build();
    }

    @Nullable
    private Value valueCopyAndMaskReplace(@Nullable Value value, @Nullable Value maskedOtherValue) {
        boolean disallowEmptyResultMapValue = false;
        boolean mergeInExistingMapOrEntity = false;
        EntityRef resultRef = null;
        ImmutableMap<String, Value> valuePropertyMap = EMPTY_STRING_VALUE_MAP;
        if (value == null) {
            disallowEmptyResultMapValue = true;
        } else {
            Value.Type valueType = value.type();
            if (valueType == Value.Type.ENTITY) {
                Entity valueEntity = value.asEntity();
                resultRef = valueEntity.ref();
                valuePropertyMap = valueEntity.propertyMap();
                mergeInExistingMapOrEntity = true;
            } else if (valueType == Value.Type.MAP) {
                valuePropertyMap = value.asMap();
                mergeInExistingMapOrEntity = true;
            } else {
                disallowEmptyResultMapValue = true;
            }
        }
        ImmutableMap<String, Value> maskedOtherValuePropertyMap = EMPTY_STRING_VALUE_MAP;
        if (maskedOtherValue == null) {
            if (disallowEmptyResultMapValue) {
                return value;
            }
            disallowEmptyResultMapValue = true;
        } else {
            Value.Type maskedOtherValueType = maskedOtherValue.type();
            if (maskedOtherValueType == Value.Type.ENTITY) {
                Entity maskedOtherValueEntity = maskedOtherValue.asEntity();
                maskedOtherValuePropertyMap = maskedOtherValueEntity.propertyMap();
            } else if (maskedOtherValueType == Value.Type.MAP) {
                maskedOtherValuePropertyMap = maskedOtherValue.asMap();
            } else {
                return value;
            }
        }
        ImmutableMap<String, Value> resultValuePropertyMap = this.mapCopyAndMaskReplace(valuePropertyMap, maskedOtherValuePropertyMap);
        if (resultRef == null && resultValuePropertyMap.isEmpty() && disallowEmptyResultMapValue) {
            return value;
        }
        Value mergedValue = resultRef != null ? Value.createEntity(Entity.create(resultRef, resultValuePropertyMap)) : Value.createMap(resultValuePropertyMap);
        if (mergeInExistingMapOrEntity) {
            mergedValue = mergedValue.withDatastoreIndexing(value.datastoreIndexing());
        }
        return mergedValue;
    }

    public OnestoreEntity.EntityProto mask(OnestoreEntity.EntityProto entity) {
        OnestoreEntity.EntityProto dst = new OnestoreEntity.EntityProto();
        PropertyMask.copyKeyInto(entity, dst);
        return this.maskInto(entity, dst);
    }

    public OnestoreEntity.EntityProto maskInto(OnestoreEntity.EntityProto srcEntity, OnestoreEntity.EntityProto dstEntity) {
        OnestoreEntity.EntityProto result = new OnestoreEntity.EntityProto();
        PropertyMask.copyKeyInto(dstEntity, result);
        HashMap<PropertyName, EntityProperty> srcMerges = new HashMap<PropertyName, EntityProperty>();
        for (EntityProperty srcProperty : this.allProperties(srcEntity)) {
            PropertyMask nestedMask = (PropertyMask)this.properties.get((Object)srcProperty.name());
            if (FULL.equals(nestedMask)) {
                srcProperty.addTo(result);
                continue;
            }
            if (nestedMask == null || !srcProperty.isNestedEntity()) continue;
            srcMerges.put(srcProperty.name(), srcProperty);
        }
        HashMap<PropertyName, EntityProperty> dstMerges = new HashMap<PropertyName, EntityProperty>();
        List<EntityProperty> dstProperties = this.allProperties(dstEntity);
        for (EntityProperty dstProperty : dstProperties) {
            PropertyMask nestedMask = (PropertyMask)this.properties.get((Object)dstProperty.name());
            if (nestedMask == null) {
                dstProperty.addTo(result);
                continue;
            }
            if (nestedMask.equals(FULL) || !dstProperty.isNestedEntity()) continue;
            dstMerges.put(dstProperty.name(), dstProperty);
        }
        HashSet<PropertyName> mergedPropertyNames = new HashSet<PropertyName>();
        for (PropertyName mergePropertyName : Sets.union(srcMerges.keySet(), dstMerges.keySet())) {
            EntityProperty dstProperty = (EntityProperty)dstMerges.get(mergePropertyName);
            EntityProperty srcProperty = (EntityProperty)srcMerges.get(mergePropertyName);
            EntityProperty targetProperty = (EntityProperty)MoreObjects.firstNonNull((Object)dstProperty, (Object)srcProperty);
            OnestoreEntity.EntityProto dstNested = dstProperty != null ? dstProperty.nestedEntity() : new OnestoreEntity.EntityProto();
            OnestoreEntity.EntityProto srcNested = srcProperty != null ? srcProperty.nestedEntity() : new OnestoreEntity.EntityProto();
            PropertyMask nestedMask = (PropertyMask)this.properties.get((Object)mergePropertyName);
            OnestoreEntity.EntityProto merged = nestedMask.maskInto(srcNested, dstNested);
            if (dstProperty == null && merged.propertySize() <= 0 && merged.rawPropertySize() <= 0) continue;
            targetProperty.withNestedEntity(merged).addTo(result);
            mergedPropertyNames.add(mergePropertyName);
        }
        for (EntityProperty dstProperty : dstProperties) {
            PropertyMask nestedMask = (PropertyMask)this.properties.get((Object)dstProperty.name());
            if (nestedMask == null || nestedMask.equals(FULL) || mergedPropertyNames.contains(dstProperty.name())) continue;
            dstProperty.addTo(result);
        }
        return result;
    }

    private List<EntityProperty> allProperties(OnestoreEntity.EntityProto entity) {
        ArrayList<EntityProperty> entityProperties = new ArrayList<EntityProperty>();
        for (OnestoreEntity.Property property : entity.propertys()) {
            entityProperties.add(EntityProperty.fromIndexed(property));
        }
        for (OnestoreEntity.Property property : entity.rawPropertys()) {
            entityProperties.add(EntityProperty.fromUnindexed(property));
        }
        return entityProperties;
    }

    private static void copyKeyInto(OnestoreEntity.EntityProto src, OnestoreEntity.EntityProto dst) {
        if (src.hasKey()) {
            dst.setKey(src.getKey());
        } else {
            dst.clearKey();
        }
        if (src.hasEntityGroup()) {
            dst.setEntityGroup(src.getEntityGroup());
        } else {
            dst.clearEntityGroup();
        }
        if (src.hasKind()) {
            dst.setKind(src.getKind());
        } else {
            dst.clearKind();
        }
        if (src.hasKindUri()) {
            dst.setKindUri(src.getKindUri());
        } else {
            dst.clearKindUri();
        }
    }

    public int hashCode() {
        return Objects.hashCode(this.properties);
    }

    public boolean equals(Object obj) {
        if (this == FULL || obj == FULL) {
            return obj == this;
        }
        if (obj instanceof PropertyMask) {
            PropertyMask that = (PropertyMask)obj;
            return this.properties.equals(that.properties);
        }
        return false;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("properties", this.properties).toString();
    }

    @AutoValue
    static abstract class EntityProperty {
        EntityProperty() {
        }

        abstract PropertyName name();

        abstract OnestoreEntity.Property property();

        abstract boolean indexed();

        @Nullable
        OnestoreEntity.EntityProto nestedEntity() {
            if (this.property().isMultiple() || this.property().getMeaningEnum() != OnestoreEntity.Property.Meaning.ENTITY_PROTO) {
                return null;
            }
            try {
                return (OnestoreEntity.EntityProto)OnestoreEntity.EntityProto.parser().parsePartialFrom(this.property().getValue().getStringValueAsBytes());
            }
            catch (InvalidProtocolBufferException e) {
                return null;
            }
        }

        boolean isNestedEntity() {
            return this.nestedEntity() != null;
        }

        void addTo(OnestoreEntity.EntityProto entity) {
            if (this.indexed()) {
                entity.addProperty(this.property());
            } else {
                entity.addRawProperty(this.property());
            }
        }

        static EntityProperty fromIndexed(OnestoreEntity.Property property) {
            return new AutoValue_PropertyMask_EntityProperty(PropertyName.create(property.getName()), property, true);
        }

        static EntityProperty fromUnindexed(OnestoreEntity.Property property) {
            return new AutoValue_PropertyMask_EntityProperty(PropertyName.create(property.getName()), property, false);
        }

        EntityProperty withNestedEntity(OnestoreEntity.EntityProto nestedEntity) {
            Preconditions.checkState((boolean)this.isNestedEntity());
            OnestoreEntity.Property property = (OnestoreEntity.Property)this.property().clone();
            property.getMutableValue().setStringValueAsBytes(nestedEntity.toByteArray());
            return new AutoValue_PropertyMask_EntityProperty(this.name(), property, this.indexed());
        }
    }
}

