/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.core.rep;

import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.auto.value.AutoValue;
import com.google.cloud.datastore.core.rep.$AutoValue_SingleFieldIndex;
import com.google.cloud.datastore.core.rep.AutoValue_SingleFieldIndex_Def;
import com.google.cloud.datastore.core.rep.SingleFieldRef;
import com.google.cloud.datastore.core.rep.WorkflowState;
import javax.annotation.Nullable;

@AutoValue
public abstract class SingleFieldIndex {
    @Nullable
    public abstract Long id();

    public abstract SingleFieldRef ref();

    public abstract Mode mode();

    public Def def() {
        return Def.create(this.ref(), this.mode());
    }

    public abstract WorkflowState workflowState();

    @Nullable
    public abstract Long updateTimeMicros();

    public abstract boolean error();

    public static SingleFieldIndex create(@Nullable Long id, SingleFieldRef ref, Mode mode, WorkflowState workflowState, @Nullable Long updateTimeMicros) {
        return SingleFieldIndex.builder().setId(id).setRef(ref).setMode(mode).setWorkflowState(workflowState).setUpdateTimeMicros(updateTimeMicros).build();
    }

    public static SingleFieldIndex create(@Nullable Long id, SingleFieldRef ref, Mode mode, WorkflowState workflowState, boolean error, @Nullable Long updateTimeMicros) {
        return SingleFieldIndex.builder().setId(id).setRef(ref).setMode(mode).setWorkflowState(workflowState).setUpdateTimeMicros(updateTimeMicros).setError(error).build();
    }

    public static SingleFieldIndex createDatabaseIndex(Mode mode, WorkflowState workflowState, @Nullable Long updateTimeMicros) {
        return SingleFieldIndex.create(mode.idWhenDatabaseDefault, SingleFieldRef.database(), mode, workflowState, updateTimeMicros);
    }

    public abstract Builder toBuilder();

    public static Builder builder() {
        return new $AutoValue_SingleFieldIndex.Builder().setError(false);
    }

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder setId(@Nullable Long var1);

        public abstract Builder setRef(SingleFieldRef var1);

        public abstract Builder setMode(Mode var1);

        public abstract Builder setWorkflowState(WorkflowState var1);

        public abstract Builder setUpdateTimeMicros(@Nullable Long var1);

        public abstract Builder setError(boolean var1);

        abstract SingleFieldIndex autoBuild();

        public SingleFieldIndex build() {
            SingleFieldIndex instance = this.autoBuild();
            Preconditions.checkArgument((!instance.error() || instance.workflowState().finalizing() ? 1 : 0) != 0, (Object)"indexes must not have errors unless they are in a finalizing state");
            return instance;
        }
    }

    @AutoValue
    public static abstract class Def {
        public abstract SingleFieldRef ref();

        public abstract Mode mode();

        public static Def create(SingleFieldRef ref, Mode mode) {
            return new AutoValue_SingleFieldIndex_Def(ref, mode);
        }
    }

    public static enum Mode {
        COLLECTION_ASC(-6L),
        COLLECTION_DESC(-7L),
        COLLECTION_CONTAINS(-11L),
        COLLECTION_GROUP_ASC(-12L),
        COLLECTION_GROUP_DESC(-13L),
        COLLECTION_GROUP_CONTAINS(-14L);

        final long idWhenDatabaseDefault;

        private Mode(long appliedIndexIdWhenDatabaseDefault) {
            Preconditions.checkArgument((appliedIndexIdWhenDatabaseDefault < 0L ? 1 : 0) != 0);
            this.idWhenDatabaseDefault = appliedIndexIdWhenDatabaseDefault;
        }

        public long appliedIndexIdWhenDatabaseDefault() {
            return this.idWhenDatabaseDefault;
        }

        public boolean isContains() {
            switch (this) {
                case COLLECTION_CONTAINS: 
                case COLLECTION_GROUP_CONTAINS: {
                    return true;
                }
                case COLLECTION_ASC: 
                case COLLECTION_DESC: 
                case COLLECTION_GROUP_ASC: 
                case COLLECTION_GROUP_DESC: {
                    return false;
                }
            }
            throw new AssertionError((Object)"unreachable");
        }
    }
}

