/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.core.rep;

import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.auto.value.AutoValue;
import com.google.cloud.datastore.core.rep.AutoValue_UnifiedIndexValue;
import com.google.cloud.datastore.core.rep.DatastoreValue;
import com.google.cloud.datastore.core.rep.IndexValue;
import com.google.storage.onestore.v3.OnestoreEntity;
import javax.annotation.Nullable;

@AutoValue
public abstract class UnifiedIndexValue {
    public static UnifiedIndexValue create(IndexValue indexValue) {
        return new AutoValue_UnifiedIndexValue(indexValue, null);
    }

    public static UnifiedIndexValue create(OnestoreEntity.PropertyValue appEngV3Value) {
        return new AutoValue_UnifiedIndexValue(null, DatastoreValue.create(appEngV3Value));
    }

    public boolean isAppEngV3() {
        return this.internalAppEngV3Value() != null;
    }

    public IndexValue indexValue() {
        Preconditions.checkState((!this.isAppEngV3() ? 1 : 0) != 0);
        return this.internalIndexValue();
    }

    public OnestoreEntity.PropertyValue appEngV3IndexValue() {
        Preconditions.checkState((boolean)this.isAppEngV3());
        return this.internalAppEngV3Value().v3Value();
    }

    @Nullable
    protected abstract IndexValue internalIndexValue();

    @Nullable
    protected abstract DatastoreValue internalAppEngV3Value();

    public final String toString() {
        return (this.isAppEngV3() ? this.appEngV3IndexValue() : this.indexValue()).toString();
    }
}

