/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.core.rep;

import com.google.appengine.repackaged.com.google.common.collect.ImmutableList;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableMap;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableMultiset;
import com.google.appengine.repackaged.com.google.common.collect.Multiset;
import com.google.auto.value.AutoValue;
import com.google.cloud.datastore.core.rep.$AutoValue_Write;
import com.google.cloud.datastore.core.rep.IdAllocationPolicy;
import com.google.cloud.datastore.core.rep.Mutation;
import com.google.cloud.datastore.core.rep.WriteStreamContext;
import com.google.storage.onestore.v3.OnestoreEntity;
import java.util.Map;
import javax.annotation.Nullable;

@AutoValue
public abstract class Write {
    @Nullable
    public abstract WriteStreamContext writeStreamContext();

    public abstract ImmutableList<Mutation> mutations();

    @Nullable
    public abstract int[] originalMutationsMap();

    @Nullable
    public abstract ImmutableMap<Integer, Integer> originalTransformations();

    public Multiset<OnestoreEntity.Reference> transformationCounts() {
        if (this.originalTransformations() == null) {
            return ImmutableMultiset.of();
        }
        ImmutableMultiset.Builder counts = ImmutableMultiset.builder();
        for (Map.Entry entry : this.originalTransformations().entrySet()) {
            int index = (Integer)entry.getKey();
            int count = (Integer)entry.getValue();
            int mutationIndex = this.originalMutationsMap() == null ? index : this.originalMutationsMap()[index];
            OnestoreEntity.Reference key = ((Mutation)this.mutations().get(mutationIndex)).key();
            counts.addCopies((Object)key, count);
        }
        return counts.build();
    }

    public abstract boolean isTrusted();

    public abstract boolean markChanges();

    @Nullable
    public abstract IdAllocationPolicy idPolicy();

    public static Builder builder() {
        return new $AutoValue_Write.Builder().isTrusted(false).markChanges(false);
    }

    public abstract Builder toBuilder();

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder writeStreamContext(@Nullable WriteStreamContext var1);

        public abstract Builder mutations(Iterable<Mutation> var1);

        public abstract ImmutableList<Mutation> mutations();

        public abstract Builder isTrusted(boolean var1);

        public abstract Builder markChanges(boolean var1);

        public abstract Builder idPolicy(@Nullable IdAllocationPolicy var1);

        public abstract Builder originalMutationsMap(int[] var1);

        public abstract Builder originalTransformations(ImmutableMap<Integer, Integer> var1);

        protected abstract Write autoBuild();

        public Write build() {
            Write write = this.autoBuild();
            return write;
        }
    }
}

