/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.core.rep;

import com.google.appengine.repackaged.com.google.common.collect.ImmutableList;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableMap;
import com.google.appengine.repackaged.com.google.common.collect.UnmodifiableIterator;
import com.google.auto.value.AutoValue;
import com.google.cloud.datastore.core.rep.$AutoValue_WriteResult;
import com.google.cloud.datastore.core.rep.MutationResult;
import com.google.cloud.datastore.core.rep.WriteStats;
import javax.annotation.Nullable;

@AutoValue
public abstract class WriteResult {
    public static final WriteResult EMPTY = WriteResult.builder().build();

    public abstract long commitTimestamp();

    public abstract ImmutableList<MutationResult> collapsedMutationResults();

    public abstract ImmutableList<Integer> originalMutationsIndexes();

    @Nullable
    public abstract ImmutableMap<Integer, Integer> originalTransformations();

    public ImmutableList<MutationResult> mutationResults() {
        if (this.collapsed()) {
            ImmutableList.Builder inOrder = ImmutableList.builder();
            UnmodifiableIterator unmodifiableIterator = this.originalMutationsIndexes().iterator();
            while (unmodifiableIterator.hasNext()) {
                int idx = (Integer)unmodifiableIterator.next();
                inOrder.add((Object)((MutationResult)this.collapsedMutationResults().get(idx)));
            }
            return inOrder.build();
        }
        return this.collapsedMutationResults();
    }

    public boolean collapsed() {
        return !this.originalMutationsIndexes().isEmpty();
    }

    public abstract WriteStats stats();

    public static Builder builder() {
        return new $AutoValue_WriteResult.Builder().commitTimestamp(0L).stats(WriteStats.EMPTY).collapsedMutationResults((Iterable<MutationResult>)ImmutableList.of()).originalMutationsIndexes((Iterable<Integer>)ImmutableList.of());
    }

    public abstract Builder toBuilder();

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder commitTimestamp(long var1);

        public abstract Builder collapsedMutationResults(Iterable<MutationResult> var1);

        public abstract Builder originalMutationsIndexes(@Nullable Iterable<Integer> var1);

        public abstract Builder originalTransformations(@Nullable ImmutableMap<Integer, Integer> var1);

        public abstract Builder stats(WriteStats var1);

        public abstract WriteResult build();
    }
}

