/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.core.rep.converter;

import com.google.cloud.datastore.core.exception.InvalidConversionException;

public interface UserIdObfuscator {
    public static final UserIdObfuscator IDENTITY = new UserIdObfuscator(){

        @Override
        public String obfuscate(long internalId) {
            return Long.toString(internalId);
        }

        @Override
        public long unobfuscate(String externalId) {
            try {
                return Long.parseLong(externalId);
            }
            catch (NumberFormatException e) {
                return 1L;
            }
        }
    };

    public String obfuscate(long var1);

    public long unobfuscate(String var1) throws InvalidConversionException;
}

