/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.core.rep.validator;

import com.google.appengine.repackaged.com.google.common.base.Utf8;
import com.google.appengine.repackaged.com.google.common.primitives.Booleans;
import com.google.apphosting.datastore.shared.Config;
import com.google.cloud.datastore.core.exception.InvalidConversionException;
import com.google.cloud.datastore.core.exception.ProblemCode;
import com.google.cloud.datastore.core.exception.ValidationException;
import com.google.cloud.datastore.core.names.ProjectIds;
import com.google.cloud.datastore.core.rep.EntitySize;
import com.google.cloud.datastore.core.rep.V3Paths;
import com.google.cloud.datastore.core.rep.converter.UserIdObfuscator;
import com.google.cloud.datastore.core.rep.validator.BaseDatastoreValidator;
import com.google.cloud.datastore.core.rep.validator.ValidationConstraint;
import com.google.storage.onestore.v3.OnestoreEntity;
import java.util.List;

public class IndexValueValidator
extends BaseDatastoreValidator {
    private final UserIdObfuscator obfuscator;

    public IndexValueValidator(Config.DatastoreConfig config, UserIdObfuscator obfuscator) {
        super(config);
        this.obfuscator = obfuscator;
    }

    public void validateDatastoreIndexValue(ValidationConstraint constraint, OnestoreEntity.PropertyValue indexValue, String propertyName) throws ValidationException {
        this.validateV3PropertyValueUnion(indexValue, propertyName);
        if (indexValue.hasReferenceValue()) {
            this.validateReferenceValue(constraint, indexValue.getReferenceValue());
        } else if (indexValue.hasPointValue()) {
            if (constraint.getCustomizableConfig(this.config).getEnableAppEngV3ValidateGeoPoint()) {
                this.validateGeoPoint(indexValue.getPointValue().getX(), indexValue.getPointValue().getY());
            }
        } else if (indexValue.hasUserValue()) {
            this.validateUserValue(indexValue.getUserValue());
        } else if (indexValue.hasStringValue()) {
            this.validateLength(indexValue.getStringValue(), this.config.getMaxIndexedValueBytes(), new StringBuilder(20 + String.valueOf(propertyName).length()).append("value of property \"").append(propertyName).append("\"").toString());
        }
    }

    private void validateKey(ValidationConstraint constraint, OnestoreEntity.PropertyValue.ReferenceValue key) throws ValidationException {
        int keySizeLimit;
        boolean finalElementComplete;
        List path;
        int numKeyPathElements;
        this.validateAppId(constraint, key.getApp());
        if (key.hasNameSpace()) {
            this.validateNonDefaultNamespace(constraint, key.getNameSpace());
        }
        if (!this.config.getAllowDatabases()) {
            ValidationException.validateAssertion(key.getDatabaseId().isEmpty(), ProblemCode.NO_DB_SUPPORT, "Database support is not enabled.", new Object[0]);
        }
        if (key.hasDatabaseId()) {
            this.validateDatabase(constraint, key.getDatabaseId());
        }
        ValidationException.validateAssertion((numKeyPathElements = (path = key.pathElements()).size()) != 0, "Key path is empty.", new Object[0]);
        ValidationException.validateAssertion(numKeyPathElements <= 100, "Key path is too long. Cannot exceed %d elements.", 100);
        int numIncompleteElements = 0;
        for (int pathIndex = 0; pathIndex < numKeyPathElements; ++pathIndex) {
            OnestoreEntity.PropertyValue.ReferenceValuePathElement element = (OnestoreEntity.PropertyValue.ReferenceValuePathElement)path.get(pathIndex);
            this.validateKeyPathKindWithBytes(constraint, element.getTypeAsBytes(), element.getType());
            boolean elementHasName = element.hasName();
            if (element.hasId()) {
                ValidationException.validateAssertion(!elementHasName, "Key path element has both id (%d) and name (\"%s\").", element.getId(), element.getName());
                if (pathIndex < numKeyPathElements - 1) {
                    ValidationException.validateAssertion(element.getId() != 0L, "Key path element id is invalid. Must not be zero.", new Object[0]);
                    continue;
                }
                if (element.getId() != 0L) continue;
                ++numIncompleteElements;
                continue;
            }
            if (elementHasName) {
                this.validateKeyPathNameWithBytes(constraint, element.getNameAsBytes(), element.getName());
                continue;
            }
            ++numIncompleteElements;
        }
        OnestoreEntity.PropertyValue.ReferenceValuePathElement finalElement = (OnestoreEntity.PropertyValue.ReferenceValuePathElement)path.get(numKeyPathElements - 1);
        boolean bl = finalElementComplete = finalElement.hasId() && finalElement.getId() != 0L || finalElement.hasName();
        if (!constraint.allowCompleteKey()) {
            String string = String.valueOf(V3Paths.toPathString(key));
            ValidationException.validateAssertion(!finalElementComplete, string.length() != 0 ? "Key path element must not be complete: ".concat(string) : new String("Key path element must not be complete: "), new Object[0]);
        }
        if (!constraint.allowIncompleteKey(this.config.getAllowIncompleteKeyPathsInQueryFilters())) {
            String string = String.valueOf(V3Paths.toPathString(key));
            ValidationException.validateAssertion(finalElementComplete, ProblemCode.INCOMPLETE_KEY_PATHS_IN_QUERY_FILTERS, string.length() != 0 ? "Key path element must not be incomplete: ".concat(string) : new String("Key path element must not be incomplete: "), new Object[0]);
        }
        String string = String.valueOf(V3Paths.toPathString(key));
        ValidationException.validateAssertion(numIncompleteElements == (finalElementComplete ? 0 : 1), string.length() != 0 ? "Key path element must not be incomplete: ".concat(string) : new String("Key path element must not be incomplete: "), new Object[0]);
        if (constraint.getCustomizableConfig(this.config).getEnableAppEngV3ValidateEntityRefIntraPartition()) {
            String constraintPartitionId = constraint.partitionId();
            String keyPartitionId = ProjectIds.parseAppId(key.getApp()).partitionId();
            ValidationException.validateAssertion(constraintPartitionId == null || constraintPartitionId.equals(keyPartitionId), ProblemCode.CROSS_PARTITION_ENTITY_REF, "Entity key's app id's partition id '%s' does not match containing entity's '%s'.", keyPartitionId, constraintPartitionId);
        }
        if ((keySizeLimit = constraint.getCustomizableConfig(this.config).getMaxEntityKeySizeBytes()) > 0) {
            this.validateLength(EntitySize.keyValueSize(key), keySizeLimit, ProblemCode.KEY_SIZE_OVER_LIMIT, "entity key");
        }
    }

    private void validateReferenceValue(ValidationConstraint constraint, OnestoreEntity.PropertyValue.ReferenceValue ref) throws ValidationException {
        this.validateKey(constraint.withContext(ValidationConstraint.Context.IN_KEY_VALUE), ref);
    }

    private void validateUserValue(OnestoreEntity.PropertyValue.UserValue v3UserValue) throws ValidationException {
        ValidationException.validateAssertion(!v3UserValue.hasNickname(), "nickname is not supported yet", new Object[0]);
        try {
            if (v3UserValue.hasObfuscatedGaiaid()) {
                this.obfuscator.unobfuscate(v3UserValue.getObfuscatedGaiaid());
            }
        }
        catch (InvalidConversionException e) {
            throw new ValidationException("Invalid user id in user value.", e);
        }
        this.validateUserFieldBytesAreValidUtf8("OnestoreEntity.PropertyValue.UserValue.email", v3UserValue.getEmailAsBytes());
        this.validateUserFieldBytesAreValidUtf8("OnestoreEntity.PropertyValue.UserValue.authDomain", v3UserValue.getAuthDomainAsBytes());
        if (v3UserValue.hasFederatedIdentity()) {
            this.validateUserFieldBytesAreValidUtf8("OnestoreEntity.PropertyValue.UserValue.federatedIdentity", v3UserValue.getFederatedIdentityAsBytes());
        }
        if (v3UserValue.hasFederatedProvider()) {
            this.validateUserFieldBytesAreValidUtf8("OnestoreEntity.PropertyValue.UserValue.federatedProvider", v3UserValue.getFederatedProviderAsBytes());
        }
    }

    private void validateUserFieldBytesAreValidUtf8(String fieldName, byte[] bytes) throws ValidationException {
        if (!this.config.getEnableAppEngV3ValidateUserFieldValuesUtf8()) {
            return;
        }
        ValidationException.validateAssertion(Utf8.isWellFormed((byte[])bytes), ProblemCode.USER_FIELD_VALUE_NOT_UTF8, "Non-UTF-8 bytes in user field %s.", fieldName);
    }

    private void validateV3PropertyValueUnion(OnestoreEntity.PropertyValue value, String propertyName) throws ValidationException {
        int numValues = Booleans.countTrue((boolean[])new boolean[]{value.hasInt64Value(), value.hasStringValue(), value.hasBooleanValue(), value.hasDoubleValue(), value.hasPointValue(), value.hasUserValue(), value.hasReferenceValue()});
        ValidationException.validateAssertion(numValues <= 1, "The value \"%s\" has multiple types set.", propertyName);
    }
}

