/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.core.rep.validator;

import com.google.appengine.repackaged.com.google.common.annotations.VisibleForTesting;
import com.google.appengine.repackaged.com.google.common.base.MoreObjects;
import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.repackaged.com.google.common.base.Predicate;
import com.google.appengine.repackaged.com.google.common.base.Predicates;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableSet;
import com.google.appengine.repackaged.com.google.common.collect.Interner;
import com.google.appengine.repackaged.com.google.common.collect.Interners;
import com.google.appengine.repackaged.com.google.common.collect.Sets;
import com.google.apphosting.datastore.shared.Config;
import com.google.cloud.datastore.core.config.DatastoreCustomizableConfigUtils;
import com.google.cloud.datastore.core.config.proto1api.DatastoreCustomizableConfigPb;
import com.google.cloud.datastore.core.rep.PropertyName;
import com.google.cloud.datastore.core.rep.ReservedName;
import java.util.EnumSet;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;

public final class ValidationConstraint {
    private static final Interner<ValidationConstraint> CONSTRAINT_INTERNER = Interners.newStrongInterner();
    public static final ValidationConstraint LOOKUP = ValidationConstraint.forOperation(Operation.LOOKUP);
    public static final ValidationConstraint INSERT = ValidationConstraint.forOperation(Operation.INSERT);
    public static final ValidationConstraint UPSERT = ValidationConstraint.forOperation(Operation.UPSERT);
    public static final ValidationConstraint UPDATE = ValidationConstraint.forOperation(Operation.UPDATE);
    public static final ValidationConstraint DELETE = ValidationConstraint.forOperation(Operation.DELETE);
    public static final ValidationConstraint QUERY = ValidationConstraint.forOperation(Operation.QUERY);
    public static final ValidationConstraint ALLOCATE_ID = ValidationConstraint.forOperation(Operation.ALLOCATE_ID);
    public static final ValidationConstraint ALLOCATE_ID_RANGE = ValidationConstraint.forOperation(Operation.ALLOCATE_ID_RANGE);
    public static final ValidationConstraint RESERVE_ID = ValidationConstraint.forOperation(Operation.RESERVE_ID);
    public static final ValidationConstraint CREATE_INDEX = ValidationConstraint.forOperation(Operation.CREATE_INDEX);
    private static final ImmutableSet<PropertyName> WHITELISTED_IN_INDEX_RESERVED_PROPERTY_NAMES = ImmutableSet.of((Object)ReservedName.KIND.asPropertyName(), (Object)ReservedName.SCATTER.asPropertyName());
    private static final ImmutableSet<PropertyName> LEGACY_WHITELISTED_IN_INDEX_RESERVED_PROPERTY_NAMES = ImmutableSet.of((Object)ReservedName.NAME.asPropertyName(), (Object)ReservedName.WHITELISTED_ANCESTOR_1.asPropertyName(), (Object)ReservedName.WHITELISTED_ANCESTOR_2.asPropertyName(), (Object)ReservedName.WHITELISTED_ANCESTOR_3.asPropertyName(), (Object)ReservedName.WHITELISTED_CATEGORY.asPropertyName(), (Object)ReservedName.WHITELISTED_COURSE_KEY.asPropertyName(), (Object[])new PropertyName[]{ReservedName.WHITELISTED_CREATED_AT.asPropertyName(), ReservedName.WHITELISTED_CREATED.asPropertyName(), ReservedName.WHITELISTED_DATE.asPropertyName(), ReservedName.WHITELISTED_EMAIL.asPropertyName(), ReservedName.WHITELISTED_EMPTY_IN_LIST.asPropertyName(), ReservedName.WHITELISTED_ENCODED_KEY.asPropertyName(), ReservedName.WHITELISTED_ID_1.asPropertyName(), ReservedName.WHITELISTED_ID_2.asPropertyName(), ReservedName.WHITELISTED_KEY_1.asPropertyName(), ReservedName.WHITELISTED_KEY_2.asPropertyName(), ReservedName.WHITELISTED_KEY_3.asPropertyName(), ReservedName.WHITELISTED_KEY_4.asPropertyName(), ReservedName.WHITELISTED_KEY_5.asPropertyName(), ReservedName.WHITELISTED_KEY_NAME.asPropertyName(), ReservedName.WHITELISTED_KEYNAME.asPropertyName(), ReservedName.WHITELISTED_KEYNAMEASD.asPropertyName(), ReservedName.WHITELISTED_KDSFEY.asPropertyName(), ReservedName.WHITELISTED_LOGINID.asPropertyName(), ReservedName.WHITELISTED_MESSAGE.asPropertyName(), ReservedName.WHITELISTED_NOTHING.asPropertyName(), ReservedName.WHITELISTED_PARENT.asPropertyName(), ReservedName.WHITELISTED_RECORDSET.asPropertyName(), ReservedName.WHITELISTED_SEVERITY.asPropertyName(), ReservedName.WHITELISTED_USERID.asPropertyName()});
    private final Operation operation;
    private final EnumSet<Context> contexts;
    @Nullable
    private final String partitionId;
    @Nullable
    private final DatastoreCustomizableConfigPb.DatastoreCustomizableConfig configOverrides;

    @VisibleForTesting
    static ImmutableSet<ValidationConstraint> getAllForTesting() {
        ImmutableSet.Builder all = ImmutableSet.builder();
        Set contexts = Sets.powerSet(EnumSet.allOf(Context.class));
        for (Operation op : Operation.values()) {
            for (Set context : contexts) {
                if (context.isEmpty()) {
                    all.add((Object)ValidationConstraint.create(op, EnumSet.noneOf(Context.class), null));
                    continue;
                }
                all.add((Object)ValidationConstraint.create(op, EnumSet.copyOf(context), null));
            }
        }
        return all.build();
    }

    private ValidationConstraint(Operation operation, EnumSet<Context> contexts, @Nullable String partitionId, @Nullable DatastoreCustomizableConfigPb.DatastoreCustomizableConfig configOverrides) {
        this.operation = operation;
        this.contexts = contexts;
        this.partitionId = partitionId;
        this.configOverrides = configOverrides;
    }

    private static ValidationConstraint create(Operation operation, EnumSet<Context> contexts, @Nullable String partitionId) {
        return (ValidationConstraint)CONSTRAINT_INTERNER.intern((Object)new ValidationConstraint(operation, contexts, partitionId, null));
    }

    private static ValidationConstraint forOperation(Operation operation) {
        return ValidationConstraint.create(operation, EnumSet.noneOf(Context.class), null);
    }

    public ValidationConstraint withContext(Context ... context) {
        Set additionalContexts = Sets.filter((Set)Sets.newHashSet((Object[])context), (Predicate)Predicates.notNull());
        if (this.contexts.containsAll(additionalContexts)) {
            return this;
        }
        EnumSet<Context> newContexts = EnumSet.copyOf(Sets.union(this.contexts, (Set)additionalContexts));
        return ValidationConstraint.create(this.operation, newContexts, this.partitionId);
    }

    public ValidationConstraint withContext(boolean isTrusted, Context ... context) {
        if (isTrusted) {
            if (!this.contexts.contains((Object)Context.TRUSTED)) {
                return this.withContext(Context.TRUSTED).withContext(context);
            }
        } else {
            Preconditions.checkState((!this.contexts.contains((Object)Context.TRUSTED) ? 1 : 0) != 0);
        }
        return this.withContext(context);
    }

    public ValidationConstraint withPartitionId(String partitionId) {
        return ValidationConstraint.create(this.operation, EnumSet.copyOf(this.contexts), partitionId);
    }

    public ValidationConstraint withConfigOverrides(@Nullable DatastoreCustomizableConfigPb.DatastoreCustomizableConfig configOverrides) {
        Preconditions.checkState((this.configOverrides == null || this.configOverrides.equals(configOverrides) ? 1 : 0) != 0, (Object)"Constraint is already using a different configuration override.");
        if (configOverrides == null) {
            return this;
        }
        return new ValidationConstraint(this.operation, this.contexts, this.partitionId, configOverrides);
    }

    public DatastoreCustomizableConfigPb.DatastoreCustomizableConfig getCustomizableConfig(Config.DatastoreConfig config) {
        return DatastoreCustomizableConfigUtils.getCustomizableConfig(config, this.configOverrides);
    }

    @Nullable
    public String partitionId() {
        return this.partitionId;
    }

    @Nullable
    public DatastoreCustomizableConfigPb.DatastoreCustomizableConfig configOverrides() {
        return this.configOverrides;
    }

    public boolean allowMissingKey() {
        return this.contexts.contains((Object)Context.IN_ENTITY_VALUE);
    }

    public boolean allowCompleteKey() {
        if (this.contexts.contains((Object)Context.IN_ENTITY_VALUE) || this.contexts.contains((Object)Context.IN_KEY_VALUE)) {
            return true;
        }
        return this.operation != Operation.ALLOCATE_ID;
    }

    public boolean allowIncompleteKey(boolean getAllowIncompleteKeyPathsInQueryFilters) {
        if (this.contexts.contains((Object)Context.IN_FILTER_ON_ENTITY_VALUE_KEY)) {
            return getAllowIncompleteKeyPathsInQueryFilters;
        }
        if (this.contexts.contains((Object)Context.IN_KEY_VALUE)) {
            return false;
        }
        if (this.contexts.contains((Object)Context.IN_ENTITY_VALUE)) {
            return true;
        }
        switch (this.operation) {
            case INSERT: 
            case UPSERT: 
            case ALLOCATE_ID: 
            case ALLOCATE_ID_RANGE: {
                return true;
            }
        }
        return false;
    }

    public boolean allowPartitionMissingProjectId() {
        return this.contexts.contains((Object)Context.PRENORMALIZATION);
    }

    public boolean allowMissingPartionId() {
        return this.contexts.contains((Object)Context.PRENORMALIZATION);
    }

    public boolean allowReservedKey() {
        return this.contexts.contains((Object)Context.IN_KEY_VALUE) || this.contexts.contains((Object)Context.IN_ENTITY_VALUE) || this.operation.equals((Object)Operation.CREATE_INDEX) || this.allowReservedName();
    }

    public boolean allowReservedName() {
        switch (this.operation) {
            case LOOKUP: 
            case QUERY: {
                return !this.contexts.contains((Object)Context.FIRESTORE);
            }
        }
        return this.contexts.contains((Object)Context.TRUSTED) || this.contexts.contains((Object)Context.METADATA_ACCESS_ALLOWED);
    }

    public boolean allowReservedName(Config.DatastoreConfig config, PropertyName name, boolean firstSegment, boolean lastSegment) {
        return this.allowReservedName(config.getRejectLegacyWhitelistedIndexReservedPropertyNames(), name, firstSegment, lastSegment);
    }

    public boolean allowReservedName(boolean rejectLegacyWhitelistedIndexReservedPropertyNames, PropertyName name, boolean firstSegment, boolean lastSegment) {
        if (name.isKey()) {
            if (!lastSegment) {
                return false;
            }
            if (this.contexts.contains((Object)Context.IN_PROPERTY_MASK)) {
                return false;
            }
            switch (this.operation) {
                case LOOKUP: 
                case QUERY: 
                case CREATE_INDEX: {
                    return !this.contexts.contains((Object)Context.FIRESTORE) || firstSegment;
                }
            }
            return !this.contexts.contains((Object)Context.FIRESTORE) && this.contexts.contains((Object)Context.TRUSTED);
        }
        if (this.contexts.contains((Object)Context.FIRESTORE)) {
            switch (this.operation) {
                case LOOKUP: 
                case QUERY: 
                case CREATE_INDEX: {
                    return name.equals(ReservedName.TYPE.asPropertyName()) && !firstSegment && lastSegment && !this.contexts.contains((Object)Context.IN_PROPERTY_MASK);
                }
            }
            return false;
        }
        if (this.operation == Operation.CREATE_INDEX) {
            if (!firstSegment || !lastSegment) {
                return false;
            }
            if (WHITELISTED_IN_INDEX_RESERVED_PROPERTY_NAMES.contains((Object)name)) {
                return true;
            }
            if (rejectLegacyWhitelistedIndexReservedPropertyNames) {
                return false;
            }
            return LEGACY_WHITELISTED_IN_INDEX_RESERVED_PROPERTY_NAMES.contains((Object)name);
        }
        return this.allowReservedName();
    }

    public boolean allowMetadataAccess() {
        return this.contexts.contains((Object)Context.METADATA_ACCESS_ALLOWED) && !this.contexts.contains((Object)Context.IN_KEY_VALUE) && !this.contexts.contains((Object)Context.IN_ENTITY_VALUE);
    }

    public boolean allowMultisegmentPath() {
        return this.contexts.contains((Object)Context.FIRESTORE) || this.contexts.contains((Object)Context.IN_PROPERTY_MASK) || this.contexts.contains((Object)Context.IN_TRANSFORM);
    }

    public boolean allowAllArrayElements() {
        switch (this.operation) {
            case CREATE_INDEX: {
                return this.contexts.contains((Object)Context.FIRESTORE);
            }
            case QUERY: {
                return this.contexts.contains((Object)Context.FIRESTORE) && !this.contexts.contains((Object)Context.IN_PROPERTY_MASK);
            }
        }
        return false;
    }

    public boolean allowIndexOnlyMeaning() {
        return this.operation == Operation.LOOKUP || this.operation == Operation.QUERY;
    }

    public boolean allowCompoundValues() {
        return this.operation != Operation.QUERY;
    }

    public boolean allowUnindexableValue() {
        return this.contexts.contains((Object)Context.IN_UNINDEXED_VALUE);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ValidationConstraint)) {
            return false;
        }
        ValidationConstraint otherConstraint = (ValidationConstraint)other;
        return this.operation == otherConstraint.operation && this.contexts.equals(otherConstraint.contexts) && Objects.equals(this.partitionId, otherConstraint.partitionId) && Objects.equals(this.configOverrides, otherConstraint.configOverrides);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.operation, this.contexts, this.partitionId, this.configOverrides});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("operation", (Object)this.operation).add("contexts", this.contexts).add("partition", (Object)this.partitionId).add("hasConfigOverrides", this.configOverrides != null).toString();
    }

    private static enum Operation {
        LOOKUP,
        INSERT,
        UPSERT,
        UPDATE,
        DELETE,
        QUERY,
        ALLOCATE_ID,
        ALLOCATE_ID_RANGE,
        RESERVE_ID,
        CREATE_INDEX;

    }

    public static enum Context {
        IN_KEY_VALUE,
        IN_ENTITY_VALUE,
        TRUSTED,
        PRENORMALIZATION,
        IN_FILTER_ON_ENTITY_VALUE_KEY,
        IN_PROPERTY_MASK,
        IN_TRANSFORM,
        FIRESTORE,
        METADATA_ACCESS_ALLOWED,
        IN_UNINDEXED_VALUE;

    }
}

