/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.core.rep;

import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableList;
import com.google.auto.value.AutoValue;
import com.google.cloud.datastore.core.rep.AutoValue_EntityTransformation;
import com.google.cloud.datastore.core.rep.AutoValue_EntityTransformation_PropertyTransformation;
import com.google.cloud.datastore.core.rep.AutoValue_EntityTransformation_PropertyTransformationResult;
import com.google.cloud.datastore.core.rep.AutoValue_EntityTransformation_TransformationResult;
import com.google.cloud.datastore.core.rep.Entity;
import com.google.cloud.datastore.core.rep.EntityUpdater;
import com.google.cloud.datastore.core.rep.PropertyPath;
import com.google.cloud.datastore.core.rep.Value;
import java.util.function.Function;
import javax.annotation.Nullable;

@AutoValue
public abstract class EntityTransformation {
    public abstract ImmutableList<PropertyTransformation> propertyTransformations();

    public static EntityTransformation create(ImmutableList<PropertyTransformation> propertyTransformations) {
        Preconditions.checkArgument((!propertyTransformations.isEmpty() ? 1 : 0) != 0);
        return new AutoValue_EntityTransformation(propertyTransformations);
    }

    public TransformationResult transform(Entity entity) {
        EntityUpdater updater = EntityUpdater.create(entity);
        ImmutableList<Value> results = this.transform(updater);
        return TransformationResult.create(updater.toEntity(), results);
    }

    public ImmutableList<Value> transform(EntityUpdater updater) {
        ImmutableList.Builder results = ImmutableList.builder();
        for (PropertyTransformation propertyTransformation : this.propertyTransformations()) {
            results.add((Object)updater.apply(propertyTransformation));
        }
        return results.build();
    }

    @AutoValue
    public static abstract class TransformationResult {
        public abstract Entity transformedEntity();

        public abstract ImmutableList<Value> transformedValues();

        public static TransformationResult create(Entity entity, ImmutableList<Value> values) {
            return new AutoValue_EntityTransformation_TransformationResult(entity, values);
        }
    }

    @AutoValue
    public static abstract class PropertyTransformation {
        public abstract PropertyPath propertyPath();

        abstract Function<Value, PropertyTransformationResult> function();

        public PropertyTransformationResult apply(@Nullable Value originalPropertyValue) {
            return this.function().apply(originalPropertyValue);
        }

        public static PropertyTransformation create(PropertyPath propertyPath, Function<Value, PropertyTransformationResult> function) {
            return new AutoValue_EntityTransformation_PropertyTransformation((PropertyPath)Preconditions.checkNotNull((Object)propertyPath), (Function)Preconditions.checkNotNull(function));
        }
    }

    @AutoValue
    public static abstract class PropertyTransformationResult {
        public abstract Value newPropertyValue();

        abstract Value writeResultValue();

        public static PropertyTransformationResult create(@Nullable Value newPropertyValue, @Nullable Value writeResultValue) {
            return new AutoValue_EntityTransformation_PropertyTransformationResult(newPropertyValue, writeResultValue);
        }

        public static PropertyTransformationResult create(@Nullable Value newPropertyValue) {
            return new AutoValue_EntityTransformation_PropertyTransformationResult(newPropertyValue, newPropertyValue);
        }
    }
}

