/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.core.exception;

import com.google.apphosting.api.DatastorePb;
import com.google.cloud.datastore.core.exception.DatastoreException;
import com.google.cloud.datastore.logs.ProblemCode;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;

public class DatastoreExceptionHelper {
    private DatastoreExceptionHelper() {
    }

    public static void checkRequest(boolean expression, String messageFormat, Object ... messageArgs) throws DatastoreException {
        if (!expression) {
            throw DatastoreExceptionHelper.badRequest(messageFormat, messageArgs);
        }
    }

    @CheckReturnValue
    public static DatastoreException badRequest(String messageFormat, Object ... messageArgs) {
        return DatastoreExceptionHelper.badRequest(null, messageFormat, messageArgs);
    }

    @CheckReturnValue
    public static DatastoreException badRequest(Throwable cause) {
        return DatastoreExceptionHelper.badRequest(cause, "%s", cause.getMessage());
    }

    @CheckReturnValue
    public static DatastoreException badRequest(@Nullable Throwable cause, String messageFormat, Object ... messageArgs) {
        String formattedMessage = String.format(messageFormat, messageArgs);
        return new DatastoreException(formattedMessage, DatastorePb.Error.ErrorCode.BAD_REQUEST, cause);
    }

    @CheckReturnValue
    public static DatastoreException failedPrecondition(ProblemCode problemCode, String message, @Nullable Throwable cause) {
        return new DatastoreException(problemCode, message, DatastorePb.Error.ErrorCode.FAILED_PRECONDITION, cause);
    }

    @CheckReturnValue
    public static DatastoreException failedPrecondition(String message, @Nullable Throwable cause) {
        return new DatastoreException(message, DatastorePb.Error.ErrorCode.FAILED_PRECONDITION, cause);
    }

    @CheckReturnValue
    public static DatastoreException failedPrecondition(String messageFormat, Object ... messageArgs) {
        String message = String.format(messageFormat, messageArgs);
        return new DatastoreException(message, DatastorePb.Error.ErrorCode.FAILED_PRECONDITION, null);
    }

    public static void checkPrecondition(boolean precondition, String messageFormat, Object ... messageArgs) throws DatastoreException {
        if (!precondition) {
            throw DatastoreExceptionHelper.failedPrecondition(messageFormat, messageArgs);
        }
    }

    @CheckReturnValue
    public static DatastoreException aborted(String message, @Nullable Throwable cause) {
        return new DatastoreException(message, DatastorePb.Error.ErrorCode.ABORTED, cause);
    }

    @CheckReturnValue
    public static DatastoreException aborted(String messageFormat, Object ... messageArgs) {
        String message = String.format(messageFormat, messageArgs);
        return new DatastoreException(message, DatastorePb.Error.ErrorCode.ABORTED, null);
    }

    @CheckReturnValue
    public static DatastoreException alreadyExists(String messageFormat, Object ... messageArgs) {
        String formattedMessage = String.format(messageFormat, messageArgs);
        return new DatastoreException(formattedMessage, DatastorePb.Error.ErrorCode.ALREADY_EXISTS, null);
    }

    @CheckReturnValue
    public static DatastoreException indexAlreadyExists() {
        return DatastoreException.builder().message("index already exists").errorCode(DatastorePb.Error.ErrorCode.BAD_REQUEST).problemCode(ProblemCode.INDEX_ALREADY_EXISTS).build();
    }

    @CheckReturnValue
    public static DatastoreException notFound(String messageFormat, Object ... messageArgs) {
        String formattedMessage = String.format(messageFormat, messageArgs);
        return new DatastoreException(formattedMessage, DatastorePb.Error.ErrorCode.NOT_FOUND, null);
    }

    public static void checkFound(boolean found, String messageFormat, Object ... messageArgs) throws DatastoreException {
        if (!found) {
            throw DatastoreExceptionHelper.notFound(messageFormat, messageArgs);
        }
    }

    @CheckReturnValue
    public static DatastoreException permissionDenied(@Nullable Throwable cause) {
        return new DatastoreException("Missing or insufficient permissions.", DatastorePb.Error.ErrorCode.PERMISSION_DENIED, cause);
    }

    @CheckReturnValue
    public static DatastoreException permissionDenied(ProblemCode problemCode, @Nullable Throwable cause) {
        return new DatastoreException(problemCode, "Missing or insufficient permissions.", DatastorePb.Error.ErrorCode.PERMISSION_DENIED, cause);
    }

    @CheckReturnValue
    public static DatastoreException permissionDenied() {
        return DatastoreExceptionHelper.permissionDenied(null);
    }

    @CheckReturnValue
    public static DatastoreException unauthenticated(@Nullable Throwable cause) {
        return new DatastoreException("Missing or invalid authentication.", DatastorePb.Error.ErrorCode.UNAUTHENTICATED, cause);
    }

    @CheckReturnValue
    public static DatastoreException unauthenticated(ProblemCode problemCode, @Nullable Throwable cause) {
        return new DatastoreException(problemCode, "Missing or invalid authentication.", DatastorePb.Error.ErrorCode.UNAUTHENTICATED, cause);
    }

    @CheckReturnValue
    public static DatastoreException internalError(@Nullable Throwable cause) {
        return DatastoreExceptionHelper.internalError("internal error.", cause);
    }

    @CheckReturnValue
    public static DatastoreException internalError(String message, @Nullable Throwable cause) {
        return new DatastoreException(message, DatastorePb.Error.ErrorCode.INTERNAL_ERROR, cause);
    }

    @CheckReturnValue
    public static DatastoreException notImplemented() {
        return DatastoreExceptionHelper.internalError("unimplemented", null);
    }

    @CheckReturnValue
    public static DatastoreException concurrencyErrorNoRetries(String message, @Nullable Throwable cause) {
        return DatastoreException.builder().message(message).cause(cause).errorCode(DatastorePb.Error.ErrorCode.CONCURRENT_TRANSACTION).problemCode(ProblemCode.TRANSACTION_CONCURRENCY_ERROR).forceNonRetryable().build();
    }

    @CheckReturnValue
    public static DatastoreException concurrencyErrorRetriesAllowed(String message, @Nullable Throwable cause) {
        return DatastoreException.builder().message(message).cause(cause).errorCode(DatastorePb.Error.ErrorCode.CONCURRENT_TRANSACTION).problemCode(ProblemCode.TRANSACTION_CONCURRENCY_ERROR).build();
    }

    @CheckReturnValue
    public static DatastoreException internalLimitExceededError(String message, Throwable cause) {
        return new DatastoreException(message, DatastorePb.Error.ErrorCode.NEED_INDEX, cause);
    }

    @CheckReturnValue
    public static DatastoreException timeoutError(String message, @Nullable Throwable cause) {
        return new DatastoreException(message, DatastorePb.Error.ErrorCode.TIMEOUT, cause);
    }

    @CheckReturnValue
    public static DatastoreException timeoutError(@Nullable Throwable cause) {
        return DatastoreExceptionHelper.timeoutError("The datastore operation timed out, or the data was temporarily unavailable.", cause);
    }

    @CheckReturnValue
    public static DatastoreException writesDisabledError(@Nullable Throwable cause) {
        return new DatastoreException("Datastore writes are temporarily unavailable.", DatastorePb.Error.ErrorCode.CAPABILITY_DISABLED, cause);
    }

    @CheckReturnValue
    public static DatastoreException unavailable(ProblemCode problemCode, @Nullable Throwable cause) {
        return DatastoreException.builder().cause(cause).problemCode(problemCode).errorCode(DatastorePb.Error.ErrorCode.INTERNAL_ERROR).message("The service is temporarily unavailable. Please retry with exponential backoff.").build();
    }

    @CheckReturnValue
    public static DatastoreException resourceExhausted(ProblemCode problemCode, String message, @Nullable Throwable cause) {
        return DatastoreException.builder().cause(cause).problemCode(problemCode).errorCode(DatastorePb.Error.ErrorCode.RESOURCE_EXHAUSTED).message(message).forceNonRetryable().build();
    }
}

